!
!  Software name : CIAO (Code for Investigating Atomic Orbitals)
!  Function(s)   : fn_factorial
!  Author(s)     : Masakuni Okamoto (August 25, 2003)
!
!
!  Contact address :  Phase System Consortium
!                     E-mail: phase_system@nims.go.jp URL https://azuma.nims.go.jp
!
!
!  The license of the code and contact address :
!  See the files, COPYRIGHT and LICENSE (or LICENSE_J.pdf)
!
!=====================================================================
   function fn_factorial(n)
!=====================================================================
!
!  Calculates factorial of n
!
!  M. Okamoto
!
!---------------------------------------------------------------------
   implicit none
   integer(8) :: fn_factorial
   integer,intent(in) :: n
   integer :: i
   select case (n)
   case (:-1)
      fn_factorial = 0
   case (0)
      fn_factorial = 1
   case (1:)
      fn_factorial = 1
      do i = 1,n
         fn_factorial = fn_factorial * i
      end do
   case default
   end select
   end function fn_factorial


