#!/usr/bin/perl -w
#
#  Copyright (C) 2004, 2005 Masakuni Okamoto.
#
#  This perl script was written by Masakuni Okamoto.
#
#  2004.04.09  M. Okamoto  dvipdfm has been used to generate .pdf
#  2004.04.19  M. Okamoto  PCC variables were debugged.
#  2004.06.28  M. Okamoto  $use_ps2pdf switch has been added.
#  2004.11.29  M. Okamoto  input format of Z, Zc, Zv has been changed.
#  2005.01.22  M. Okamoto  Plot range for potentials has been limitted.
#
#  Last update: January 22, 2005.
#
$use_ps2pdf = 0;
################################################################################
#//////////////////////////////////// CIAOPP ///////////////////////////////////

$have_atomic_label             = 0;
$have_atomic_charge            = 0;
$have_xc_potential             = 0;
$have_rmesh                    = 0;
$have_gmesh                    = 0;
$have_cutoff_wf                = 0;
$have_ae_scr_potential         = 0;
$have_bhs_potential            = 0;
$have_scr_local_potential      = 0;
$have_ion_local_potential      = 0;
$have_valence_charge_rrnv      = 0;
$have_core_charge_rrnc         = 0;
$have_pcc_charge_rrnpcc        = 0;
$have_ae_wave_function_rpsi    = 0;
$have_pp_wave_function_rphi    = 0;
$have_separable_potential      = 0;
$have_projector_rbeta          = 0;
$have_deficit_charge_rrq       = 0;
$have_dipole                   = 0;
$have_logderi                  = 0;
$have_valence_charge_ggnv      = 0;
$have_core_charge_ggnc         = 0;
$have_pcc_charge_ggnpcc        = 0;
$have_ae_wave_function_gpsi    = 0;
$have_pp_wave_function_gphi    = 0;
$have_projector_gbeta          = 0;
$have_deficit_charge_ggq       = 0;

$is_input_rmax = 0;
$is_input_gmax = 0;

################################################################################
#  Read data from a command-line

if(@ARGV<1|| $ARGV[0]=~/-h/ || $ARGV[0]=~/--help/) {
  print "Usage: makefig_ciaopp.pl CiaoppData\n";
  print "                [--help]                [-h]\n";
  print "                [--formatted]           [-f]\n";
  print "                [--rmax]                [-rm]\n";
  print "                [--gmax]                [-gm]\n";
  exit(0);
} else {
  $is_formatted = 0;
  foreach $s (@ARGV) {
    if($s =~/--formatted/ || $s =~/-f/) {
      $is_formatted = 1;
    } elsif($s =~/--rmax/ || $s =~/-rm/) {
      ($dummy,$rmax_in) = split('=',$s);
      $is_input_rmax = 1;
    } elsif($s =~/--gmax/ || $s =~/-gm/) {
      ($dummy,$gmax_in) = split('=',$s);
      $is_input_gmax = 1;
    }
  }
}

################################################################################
#  Read data from CIAOPP

print "*** CIAOPP ***\n";
print "@ARGV\n";
@line = split('\.',$ARGV[0]);
$title = "ciaopp" . "_$line[0]";
print "title --> $title\n";
if(@line == 1) {
  $infile = "$line[0]" . ".ciaopp";
} else {
  $infile = "$ARGV[0]";
}
print "<IN> = $infile\n";
if(! -e "$infile") {
  print "#############################################################\n";
  print "##   File not exists  -->  $infile\n";
  print "##   Please prepare the missing file.\n";
  print "#############################################################\n";
  exit(1);
} else {
  print "File exists --> $infile\n";
}
open(IN,"<$infile");
while($line = <IN>) {
  @line = split(' ',$line);
  if(@line == 0) {next;}
  if($line[0] =~/\#/ || $line[0] =~/\*/) {
    next;
  } elsif($line[0] =~/atomic_label/) {
  ### atomic_label
    $have_atomic_label = 1;
    $atom_label = "$line[1]";
    $atom_name  = "$line[2]";
    print "atomic_label --> $atom_label  $atom_name\n";
  } elsif($line[0] =~/atomic_charge/) {
  ### atomic_charge
    $have_atomic_charge = 1;
    $zatom = $line[1];
    $fatom = $line[2];
    $fcore = $line[3];
    $fval  = $line[4];
    @line = split(' ',<IN>);
    $felec      = $line[0];
    $felec_core = $line[1];
    $felec_val  = $line[2];
    print "atomic_charge --> Z=$zatom  Z=$fatom  Zc=$fcore  Zv=$fval\n";
    print "                  (Na=$felec  Nc=$felec_core  Nv=$felec_val)\n";
  } elsif($line[0] =~/xc_potential/) {
  ### xc_potential
    $have_xc_potential = 1;
    $xc_type   = "$line[1]";
    $xc_approx = "$line[2]";
    print "xc_potential --> $xc_type  $xc_approx\n";
  } elsif($line[0] =~/rmesh/) {
  ### rmesh
    $have_rmesh = 1;
    $rmesh_type = "$line[1]";
    @line = split(' ',<IN>);
    $nmesh = $line[0];
    $rmin = $line[1];
    $rmax = $line[2];
    $nline = int(($nmesh-1)/3+0.001);
    $nres  = $nmesh - $nline*3;
    print "rmesh --> Nmesh=$nmesh  $rmesh_type  ($nline, $nres)\n";
    $ratio = $rmax/$rmin;
    for($ir=0;$ir<$nmesh;$ir++) {
      $xx = $ir/($nmesh-1);
      $rpos[$ir] = $rmin * $ratio**$xx;
    }
  } elsif($line[0] =~/gmesh/) {
  ### gmesh
    $have_gmesh = 1;
    $gmesh_type = "$line[1]";
    @line = split(' ',<IN>);
    $ng_mesh = $line[0];
    $gmin = $line[1];
    $gmax = $line[2];
    $ng_line = int(($ng_mesh-1)/6+0.001);
    $ng_res  = $ng_mesh - $ng_line*6;
    print "gmesh --> Nmesh=$ng_mesh  $gmesh_type  ($ng_line, $ng_res)\n";
    $ratio = $rmax/$rmin;
    for($ig=0;$ig<$ng_mesh;$ig++) {
      $gpos[$ig] = $gmin + ($gmax-$gmin)*$ig/($ng_mesh-1);
    }
  } elsif($line[0] =~/cutoff_wf/) {
  ### cutoff_wf
    $have_cutoff_wf = 1;
    @line = split(' ',<IN>);
    $nps = $line[0];
    print "cutoff_wf --> Nps=$nps\n";
    for($ips=0;$ips<$nps;$ips++) {
      @line = split(' ',<IN>);
      $val_label_ps[$ips] = $line[0];
      $val_type_ps[$ips]  = $line[1];
      $nref_ps[$ips]      = $line[2];
      print "  $val_label_ps[$ips]  $val_type_ps[$ips]  $nref_ps[$ips]\n";
      for($tt=1;$tt<=$nref_ps[$ips];$tt++) {
        @line = split(' ',<IN>);
        $rcut_phi_ps[$ips][$tt] = $line[0];
        $deref_ps[$ips][$tt]    = $line[1];
        print "    $rcut_phi_ps[$ips][$tt]  $deref_ps[$ips][$tt]\n";
      }
    }
  } elsif($line[0] =~/ae_scr_potential/) {
  ### ae_scr_potential
    $have_ae_scr_potential = 1;
    print "ae_scr_potential --> Nmesh=$nmesh\n";
    $counts = 0;
    for($i=0;$i<$nline;$i++) {
      @line = split(' ',<IN>);
      $ir = $i*3;
      for($j=0;$j<3;$j++) { $veff[$ir+$j] = $line[$j]; $counts++;}
    }
    @line = split(' ',<IN>);
    $ir = $nline*3;
    for($j=0;$j<$nres;$j++) { $veff[$ir+$j] = $line[$j]; $counts++;}
    print "    ... $counts points have been read.\n";
  } elsif($line[0] =~/bhs_potential/) {
  ### bhs_potential
    $have_bhs_potential = 1;
    @line = split(' ',<IN>);
    $cc_a1 = $line[0];
    $cc_a2 = $line[1];
    $cc_c1 = $line[2];
    $cc_c2 = 1 - $cc_c1;
    print "bhs_potential --> a1=$cc_a1  a2=$cc_a2  c1=$cc_c1  c2=$cc_c2\n";
  } elsif($line[0] =~/scr_local_potential/) {
  ### scr_local_potential
    $have_scr_local_potential = 1;
    @line = split(' ',<IN>);
    $nrcut_max = $line[0];
    print "scr_local_potential --> NR=$nrcut_max\n";
    $counts = 0;
    $nline_tmp = int($nrcut_max/3+0.001);
    $nres_tmp  = $nrcut_max - $nline_tmp*3;
    for($i=0;$i<$nline_tmp;$i++) {
      @line = split(' ',<IN>);
      $ir = $i*3;
      for($j=0;$j<3;$j++) { $vloc_scr[$ir+$j] = $line[$j]; $counts++;}
    }
    @line = split(' ',<IN>);
    $ir = $nline_tmp*3;
    for($j=0;$j<$nres_tmp;$j++) { $vloc_scr[$ir+$j] = $line[$j]; $counts++;}
    print "    ... $counts points have been read.\n";
    for($ir=$nrcut_max;$ir<$nmesh;$ir++) {
      $vloc_scr[$ir] = $veff[$ir];
    }
  } elsif($line[0] =~/ion_local_potential/) {
  ### ion_local_potential
    $have_ion_local_potential = 1;
    $vloc_type  = $line[1];
    $vloc_type2 = $line[2];
    print "ion_local_potential --> Nmesh=$nmesh  $vloc_type  $vloc_type2\n";
    $counts = 0;
    for($i=0;$i<$nline;$i++) {
      @line = split(' ',<IN>);
      $ir = $i*3;
      for($j=0;$j<3;$j++) { $vloc_ion[$ir+$j] = $line[$j]; $counts++;}
    }
    @line = split(' ',<IN>);
    $ir = $nline*3;
    for($j=0;$j<$nres;$j++) { $vloc_ion[$ir+$j] = $line[$j]; $counts++;}
    print "    ... $counts points have been read.\n";
  } elsif($line[0] =~/valence_charge_rrnv/) {
  ### valence_charge_rrnv
    $have_valence_charge_rrnv = 1;
    print "valence_charge_rrnv --> Nmesh=$nmesh\n";
    $counts = 0;
    for($i=0;$i<$nline;$i++) {
      @line = split(' ',<IN>);
      $ir = $i*3;
      for($j=0;$j<3;$j++) { $rr_nv[$ir+$j] = $line[$j]; $counts++;}
    }
    @line = split(' ',<IN>);
    $ir = $nline*3;
    for($j=0;$j<$nres;$j++) { $rr_nv[$ir+$j] = $line[$j]; $counts++;}
    print "    ... $counts points have been read.\n";
  } elsif($line[0] =~/core_charge_rrnc/) {
  ### core_charge_rrnc
    $have_core_charge_rrnc = 1;
    print "core_charge_rrnc --> Nmesh=$nmesh\n";
    $counts = 0;
    for($i=0;$i<$nline;$i++) {
      @line = split(' ',<IN>);
      $ir = $i*3;
      for($j=0;$j<3;$j++) { $rr_nc[$ir+$j] = $line[$j]; $counts++;}
    }
    @line = split(' ',<IN>);
    $ir = $nline*3;
    for($j=0;$j<$nres;$j++) { $rr_nc[$ir+$j] = $line[$j]; $counts++;}
    print "    ... $counts points have been read.\n";
  } elsif($line[0] =~/pcc_charge_rrnpcc/) {
  ### pcc_charge_rrnpcc
    $have_pcc_charge_rrnpcc = 1;
    $pcc_type = "$line[1]";
    print "pcc_charge_rrnpcc --> $pcc_type\n";
    @line = split(' ',<IN>);
    $rho_sum_pcc = $line[0];
    $nrcut_pcc   = $line[1];
    $ncoeff_pcc  = $line[2];
    $rcut_pcc    = $rpos[$nrcut_pcc];
    print "  npcc_sum=$rho_sum_pcc  Nrpcc=$nrcut_pcc  Ncoeff=$ncoeff_pcc\n";
    $counts = 0;
    $nline_tmp = int($ncoeff_pcc/3+0.001);
    $nres_tmp  = $ncoeff_pcc + 1 - $nline_tmp*3;
    for($i=0;$i<$nline_tmp;$i++) {
      @line = split(' ',<IN>);
      $icoeff = $i*3;
      for($j=0;$j<3;$j++) { $coeff_pcc[$icoeff+$j] = $line[$j]; $counts++;}
    }
    @line = split(' ',<IN>);
    $icoeff = $nline_tmp*3;
    for($j=0;$j<$nres_tmp;$j++) { $coeff_pcc[$icoeff+$j] = $line[$j]; $counts++;}
    print "    ... $counts coefficients have been read.\n";
    for($ir=0;$ir<$nrcut_pcc;$ir++) {
      $ncoeff = $ncoeff_pcc;
      $npcc_tmp = 0;
      for($icoeff=0;$icoeff<=$ncoeff;$icoeff++) {
        $npcc_tmp += $rpos[$ir]**(2+$icoeff*2) * $coeff_pcc[$icoeff];
      }
      $rr_npcc[$ir] = $npcc_tmp;
    }
    for($ir=$nrcut_pcc;$ir<$nmesh;$ir++) {
      $rr_npcc[$ir] = $rr_nc[$ir];
    }
  } elsif($line[0] =~/ae_wave_function_rpsi/) {
  ### ae_wave_function_rpsi
    $have_ae_wave_function_rpsi = 1;
    @line = split(' ',<IN>);
    $num_lt = $line[0];
    print "ae_wave_function_rpsi --> Nlt=$num_lt\n"; <IN>;
    print "  n  l  t ln tn              Eref[n]\n";
    $lmax = -1;
    for($lt=0;$lt<$num_lt;$lt++) {
      @line = split(' ',<IN>);
      $n_lt[$lt]  = $line[0];
      $l_lt[$lt]  = $line[1];
      $t_lt[$lt]  = $line[2];
      $ln_lt[$lt] = $line[3];
      $tn_lt[$lt] = $line[4];
      $dummy      = "$line[5]";
      $eref[$lt]  = $line[6];
      $lt_n[$ln_lt[$lt]][$tn_lt[$lt]] = $lt;
      printf "%3d%3d%3d%3d%3d  $dummy%15.10f\n",
        $n_lt[$lt],$l_lt[$lt],$t_lt[$lt],$ln_lt[$lt],$tn_lt[$lt],
        $eref[$lt];
      if($ln_lt[$lt] > $lmax) {$lmax = $ln_lt[$lt];}
    }
    for($lt=0;$lt<$num_lt;$lt++) {
      $dummy = <IN>;
      print "$dummy"; <IN>;
      $counts = 0;
      for($i=0;$i<$nline;$i++) {
        @line = split(' ',<IN>);
        $ir = $i*3;
        for($j=0;$j<3;$j++) { $rpsi[$ir+$j][$lt] = $line[$j]; $counts++;}
      }
      @line = split(' ',<IN>);
      $ir = $nline*3;
      for($j=0;$j<$nres;$j++) { $rpsi[$ir+$j][$lt] = $line[$j]; $counts++;}
      print "    ... $counts points have been read.\n";
    }
    for($ll=0;$ll<=$lmax;$ll++) {$nref[$ll] = 0;}
    for($lt=0;$lt<$num_lt;$lt++) {$nref[$ln_lt[$lt]]++;}
  } elsif($line[0] =~/pp_wave_function_rphi/) {
  ### pp_wave_function_rphi
    $have_pp_wave_function_rphi = 1;
    @line = split(' ',<IN>);
    $num_lt = $line[0];
    print "pp_wave_function_rphi --> Nlt=$num_lt\n"; <IN>;
    print "  n  l  t ln tn                  Eref[n]        rc[n]            nrc\n";
    for($lt=0;$lt<$num_lt;$lt++) {
      @line = split(' ',<IN>);
      $n_lt[$lt]      = $line[0];
      $l_lt[$lt]      = $line[1];
      $t_lt[$lt]      = $line[2];
      $ln_lt[$lt]     = $line[3];
      $tn_lt[$lt]     = $line[4];
      $dummy          = "$line[5]";
      $val_type[$lt]  = $line[6];
      $eref[$lt]      = $line[7];
      $rcut_phi[$lt]  = $line[8];
      $nrcut_phi[$lt] = $line[9];
      printf "%3d%3d%3d%3d%3d  $dummy  $val_type[$lt]%15.10f%15.10f%10d\n",
        $n_lt[$lt],$l_lt[$lt],$t_lt[$lt],$ln_lt[$lt],$tn_lt[$lt],
        $eref[$lt],$rcut_phi[$lt],$nrcut_phi[$lt];
    }
    for($lt=0;$lt<$num_lt;$lt++) {
      $dummy = <IN>;
      print "$dummy";
      $counts = 0;
      @line = split(' ',<IN>);
      $ncoeff_phi[$lt] = $line[7];
      $nline_tmp = int($ncoeff_phi[$lt]/3+0.001);
      $nres_tmp  = $ncoeff_phi[$lt] + 1 - $nline_tmp*3;
      for($i=0;$i<$nline_tmp;$i++) {
        @line = split(' ',<IN>);
        $icoeff = $i*3;
        for($j=0;$j<3;$j++) { $coeff_phi[$icoeff+$j][$lt] = $line[$j]; $counts++;}
      }
      @line = split(' ',<IN>);
      $icoeff = $nline_tmp*3;
      for($j=0;$j<$nres_tmp;$j++) { $coeff_phi[$icoeff+$j][$lt] = $line[$j]; $counts++;}
      print "    ... $counts coefficients have been read.\n";
    }
    for($lt=0;$lt<$num_lt;$lt++) {
      $ncoeff = $ncoeff_phi[$lt];
      $nrcut = $nrcut_phi[$lt];
      $ln = $ln_lt[$lt];
      if($val_type[$lt] eq 'US') {
        for($ir=0;$ir<$nrcut;$ir++) {
          $rphi_tmp = 0;
          for($icoeff=0;$icoeff<=$ncoeff;$icoeff++) {
            $rphi_tmp += $rpos[$ir]**($ln+1+$icoeff*2) * $coeff_phi[$icoeff][$lt];
          }
          $rphi[$ir][$lt] = $rphi_tmp;
        }
      } else {
        for($ir=0;$ir<$nrcut;$ir++) {
          $rphi_tmp = 0;
          for($icoeff=0;$icoeff<=$ncoeff;$icoeff++) {
            $rphi_tmp += $rpos[$ir]**($icoeff*2) * $coeff_phi[$icoeff][$lt];
          }
          $rphi[$ir][$lt] = $rpos[$ir]**($ln+1) * exp($rphi_tmp);
        }
      }
      for($ir=$nrcut;$ir<$nmesh;$ir++) { $rphi[$ir][$lt] = $rpsi[$ir][$lt]; }
    }
  } elsif($line[0] =~/separable_potential/) {
  ### separable_potential
    $have_separable_potential = 1;
    @line = split(' ',<IN>);
    $num_ltt = $line[0];
    print "separable_potential --> Nltt=$num_ltt\n"; <IN>;
    print "  l tn tm     q[nm]          Dion[nm]\n";
    for($ltt=0;$ltt<$num_ltt;$ltt++) {
      @line = split(' ',<IN>);
      $l_ltt[$ltt]  = $line[0];
      $tn_ltt[$ltt] = $line[1];
      $tm_ltt[$ltt] = $line[2];
      $qnm[$ltt]    = $line[3];
      $dion[$ltt]   = $line[4];
      printf "%3d%3d%3d%15.10f%15.10f\n",
        $l_ltt[$ltt],$tn_ltt[$ltt],$tm_ltt[$ltt],
        $qnm[$ltt],$dion[$ltt];
    }
    <IN>;
    print "  l tn tm     B[nm]          D[nm]\n";
    for($ltt=0;$ltt<$num_ltt;$ltt++) {
      @line = split(' ',<IN>);
      $l_ltt[$ltt]   = $line[0];
      $tn_ltt[$ltt]  = $line[1];
      $tm_ltt[$ltt]  = $line[2];
      $bnm[$ltt]     = $line[3];
      $dnm[$ltt]     = $line[4];
      printf "%3d%3d%3d%15.10f%15.10f\n",
        $l_ltt[$ltt],$tn_ltt[$ltt],$tm_ltt[$ltt],
        $bnm[$ltt],$dnm[$ltt];
    }
    <IN>;
    print "  l tn tm  <Vloc|Qps[nm]>\n";
    for($ltt=0;$ltt<$num_ltt;$ltt++) {
      @line = split(' ',<IN>);
      $l_ltt[$ltt]   = $line[0];
      $tn_ltt[$ltt]  = $line[1];
      $tm_ltt[$ltt]  = $line[2];
      $vlocqps[$ltt] = $line[3];
      printf "%3d%3d%3d%15.10f\n",
        $l_ltt[$ltt],$tn_ltt[$ltt],$tm_ltt[$ltt],
        $vlocqps[$ltt];
    }
  } elsif($line[0] =~/projector_rbeta/) {
  ### projector_rbeta
    $have_projector_rbeta = 1;
    @line = split(' ',<IN>);
    $num_lt = $line[0];
    print "projector_rbeta --> Nlt=$num_lt\n"; <IN>;
    print "  n  l  t ln tn                   Eref[n]\n";
    for($lt=0;$lt<$num_lt;$lt++) {
      @line = split(' ',<IN>);
      $n_lt[$lt]      = $line[0];
      $l_lt[$lt]      = $line[1];
      $t_lt[$lt]      = $line[2];
      $ln_lt[$lt]     = $line[3];
      $tn_lt[$lt]     = $line[4];
      $dummy          = "$line[5]";
      $val_type[$lt]  = "$line[6]";
      $eref[$lt]      = $line[7];
      printf "%3d%3d%3d%3d%3d  $dummy  $val_type[$lt]%15.10f\n",
        $n_lt[$lt],$l_lt[$lt],$t_lt[$lt],$ln_lt[$lt],$tn_lt[$lt],
        $eref[$lt];
    }
    for($lt=0;$lt<$num_lt;$lt++) {
      $dummy = <IN>;
      print "$dummy"; <IN>;
      $counts = 0;
      for($i=0;$i<$nline;$i++) {
        @line = split(' ',<IN>);
        $ir = $i*3;
        for($j=0;$j<3;$j++) { $rbeta[$ir+$j][$lt] = $line[$j]; $counts++;}
      }
      @line = split(' ',<IN>);
      $ir = $nline*3;
      for($j=0;$j<$nres;$j++) { $rbeta[$ir+$j][$lt] = $line[$j]; $counts++;}
      print "    ... $counts points have been read.\n";
    }
  } elsif($line[0] =~/deficit_charge_rrq/) {
  ### deficit_charge_rrq
    $have_deficit_charge_rrq = 1;
    $qps_type = "$line[1]";
    @line = split(' ',<IN>);
    $num_ltltl = $line[0];
    print "deficit_charge_rrq --> Nltltl=$num_ltltl  $qps_type\n"; <IN>;
    print " ln tn lm tm  L                   rin[n]          nrin\n";
    for($ltltl=0;$ltltl<$num_ltltl;$ltltl++) {
      @line = split(' ',<IN>);
      $ln_ltltl[$ltltl]  = $line[0];
      $tn_ltltl[$ltltl]  = $line[1];
      $lm_ltltl[$ltltl]  = $line[2];
      $tm_ltltl[$ltltl]  = $line[3];
      $l3_ltltl[$ltltl]  = $line[4];
      $dummy             = "$line[5]";
      $rcut_qps[$ltltl]  = $line[6];
      $nrcut_qps[$ltltl] = $line[7];
      printf "%3d%3d%3d%3d%3d  $dummy%15.10f%10d\n",
        $ln_ltltl[$ltltl],$tn_ltltl[$ltltl],$lm_ltltl[$ltltl],
        $tm_ltltl[$ltltl],$l3_ltltl[$ltltl],
        $rcut_qps[$ltltl],$nrcut_qps[$ltltl];
    }
    for($ltltl=0;$ltltl<$num_ltltl;$ltltl++) {
      $dummy = <IN>;
      print "$dummy";
      $count1 = 0;
      @line = split(' ',<IN>);
      $ncoeff_qps[$ltltl] = $line[6];
      $nline_tmp = int($ncoeff_qps[$ltltl]/3+0.001);
      $nres_tmp  = $ncoeff_qps[$ltltl] + 1 - $nline_tmp*3;
      for($i=0;$i<$nline_tmp;$i++) {
        @line = split(' ',<IN>);
        $icoeff = $i*3;
        for($j=0;$j<3;$j++) { $coeff_qps[$icoeff+$j][$ltltl] = $line[$j]; $count1++;}
      }
      @line = split(' ',<IN>);
      $icoeff = $nline_tmp*3;
      for($j=0;$j<$nres_tmp;$j++) { $coeff_qps[$icoeff+$j][$ltltl] = $line[$j]; $count1++;}
      for($ir=0;$ir<$nrcut_qps[$ltltl];$ir++) {
         $l3 = $l3_ltltl[$ltltl];
         $ncoeff = $ncoeff_qps[$ltltl];
         $qps_tmp = 0;
         for($icoeff=0;$icoeff<=$ncoeff;$icoeff++) {
           $qps_tmp += $rpos[$ir]**($l3+2+$icoeff*2) * $coeff_qps[$icoeff][$ltltl];
         }
         $rr_qps[$ir][$ltltl] = $qps_tmp;
      }
      $count2 = 0;
      $nmesh_tmp = $nmesh - $nrcut_qps[$ltltl];
      $nline_tmp = int(($nmesh_tmp-1)/3+0.001);
      $nres_tmp  = $nmesh_tmp - $nline_tmp*3;
      for($i=0;$i<$nline_tmp;$i++) {
        @line = split(' ',<IN>);
        $ir = $nrcut_qps[$ltltl] + $i*3;
        for($j=0;$j<3;$j++) { $rr_qps[$ir+$j][$ltltl] = $line[$j]; $count2++;}
      }
      @line = split(' ',<IN>);
      $ir = $nrcut_qps[$ltltl] + $nline_tmp*3;
      for($j=0;$j<$nres_tmp;$j++) { $rr_qps[$ir+$j][$ltltl] = $line[$j]; $count2++;}
      print "    ... $count1 coefficients and $count2 points have been read.\n";
    }
    for($ln=0;$ln<4;$ln++) {
      for($tn=1;$tn<=3;$tn++) {
        for($lm=0;$lm<4;$lm++) {
          for($tm=1;$tm<=3;$tm++) {
            $num_l3_nm[$ln][$tn][$lm][$tm] = 0;
          }
        }
      }
    }
    $ltlt = -1;
    for($ltltl=0;$ltltl<$num_ltltl;$ltltl++) {
      $ln = $ln_ltltl[$ltltl];
      $tn = $tn_ltltl[$ltltl];
      $lm = $lm_ltltl[$ltltl];
      $tm = $tm_ltltl[$ltltl];
      $l3 = $l3_ltltl[$ltltl];
      if($num_l3_nm[$ln][$tn][$lm][$tm] == 0) {
        $ltlt++;
        $num_l3_nm[$ln][$tn][$lm][$tm]++;
        $ln_ltlt[$ltlt] = $ln;
        $tn_ltlt[$ltlt] = $tn;
        $lm_ltlt[$ltlt] = $lm;
        $tm_ltlt[$ltlt] = $tm;
        #$ltlt_nm[$ln][$tn][$lm][$tm] = $ltlt;
        $l3idx = $num_l3_nm[$ln][$tn][$lm][$tm] - 1;
        $ltltl_ltlt_l3[$ltlt][$l3idx] = $ltltl;
      } else {
        $num_l3_nm[$ln][$tn][$lm][$tm]++;
        $l3idx = $num_l3_nm[$ln][$tn][$lm][$tm] - 1;
        $ltltl_ltlt_l3[$ltlt][$l3idx] = $ltltl;
      }
    }
    $num_ltlt = $ltlt + 1;
    for($ltlt=0;$ltlt<$num_ltlt;$ltlt++) {
      $ln = $ln_ltlt[$ltlt];
      $tn = $tn_ltlt[$ltlt];
      $lm = $lm_ltlt[$ltlt];
      $tm = $tm_ltlt[$ltlt];
      $num_l3_ltlt[$ltlt] = $num_l3_nm[$ln][$tn][$lm][$tm];
    }
    for($ltlt=0;$ltlt<$num_ltlt;$ltlt++) {
      $ln = $ln_ltlt[$ltlt];
      $tn = $tn_ltlt[$ltlt];
      $lm = $lm_ltlt[$ltlt];
      $tm = $tm_ltlt[$ltlt];
      $ltn = $lt_n[$ln][$tn];
      $ltm = $lt_n[$lm][$tm];
      for($ir=0;$ir<$nmesh;$ir++) {
        $rr_qnm[$ir][$ltlt] = 
          $rpsi[$ir][$ltn] * $rpsi[$ir][$ltm] - $rphi[$ir][$ltn] * $rphi[$ir][$ltm];
      }
    }
  } elsif($line[0] =~/dipole/) {
  ### dipole
    $have_dipole = 1;
    @line = split(' ',<IN>);
    $num_dipole = $line[0];
    print "dipole --> Ndipole=$num_dipole\n"; <IN>;
    print " n1 l1 t1 m1 n2 l2 t2 m2     [n|d/dx|m]     [n|d/dy|m]     [n|d/dz|m] y1 y2\n";
    for($idipole=0;$idipole<$num_dipole;$idipole++) {
      @line = split(' ',<IN>);
      $n1_dipole[$idipole] = $line[0];
      $l1_dipole[$idipole] = $line[1];
      $t1_dipole[$idipole] = $line[2];
      $m1_dipole[$idipole] = $line[3];
      $n2_dipole[$idipole] = $line[4];
      $l2_dipole[$idipole] = $line[5];
      $t2_dipole[$idipole] = $line[6];
      $m2_dipole[$idipole] = $line[7];
      $dipole_dx[$idipole] = $line[8];
      $dipole_dy[$idipole] = $line[9];
      $dipole_dz[$idipole] = $line[10];
      $phase_y1[$idipole]  = $line[11];
      $phase_y2[$idipole]  = $line[12];
      printf "%3d%3d%3d%3d%3d%3d%3d%3d%15.10f%15.10f%15.10f%3d%3d\n",
        $n1_dipole[$idipole],$l1_dipole[$idipole],
        $t1_dipole[$idipole],$m1_dipole[$idipole],
        $n2_dipole[$idipole],$l2_dipole[$idipole],
        $t2_dipole[$idipole],$m2_dipole[$idipole],
        $dipole_dx[$idipole],$dipole_dy[$idipole],$dipole_dz[$idipole],
        $phase_y1[$idipole],$phase_y2[$idipole];
    }
  } elsif($line[0] =~/logderi/) {
  ### logderi
    $have_logderi = 1;
    @line = split(' ',<IN>);
    $ne_logderi = $line[0];
    $emin = $line[1];
    $emax = $line[2];
    @line = split(' ',<IN>);
    $num_logderi = $line[0]; <IN>;
    print "logderi --> Nldr=$num_logderi  Ne=$ne_logderi ($emin,$emax)\n";
    print "  l     Rldr           nRldr\n";
    for($i=0;$i<$num_logderi;$i++) {
      @line = split(' ',<IN>);
      $l_logderi_ae[$i]     = $line[0];
      $rcut_logderi_ae[$i]  = $line[1];
      $nrcut_logderi_ae[$i] = $line[2];
      $dummy                = "$line[3]";
      printf "%3d%15.10f%10d  $dummy\n",
        $l_logderi_ae[$i],$rcut_logderi_ae[$i],$nrcut_logderi_ae[$i];
      @line = split(' ',<IN>);
      $l_logderi_pp[$i]     = $line[0];
      $rcut_logderi_pp[$i]  = $line[1];
      $nrcut_logderi_pp[$i] = $line[2];
      $dummy                = "$line[3]";
      printf "%3d%15.10f%10d  $dummy\n",
        $l_logderi_pp[$i],$rcut_logderi_pp[$i],$nrcut_logderi_pp[$i];
    }
    for($ll=0;$ll<$num_logderi;$ll++) {
      $dummy = <IN>;
      print "$dummy";
      $counts = 0;
      $nline_tmp = int(($ne_logderi-1)/6+0.001);
      $nres_tmp  = $ne_logderi - $nline_tmp*6;
      for($i=0;$i<$nline_tmp;$i++) {
        @line = split(' ',<IN>);
        $ie = $i*6;
        for($j=0;$j<6;$j++) { $logderi_ae[$ie+$j][$ll] = $line[$j]; $counts++}
      }
      @line = split(' ',<IN>);
      $ie = $nline_tmp*6;
      for($j=0;$j<$nres_tmp;$j++) { $logderi_ae[$ie+$j][$ll] = $line[$j]; $counts++}
      print "    ... $counts points have been read.\n";
      $dummy = <IN>;
      print "$dummy";
      $counts = 0;
      $nline_tmp = int(($ne_logderi-1)/6+0.001);
      $nres_tmp  = $ne_logderi - $nline_tmp*6;
      for($i=0;$i<$nline_tmp;$i++) {
        @line = split(' ',<IN>);
        $ie = $i*6;
        for($j=0;$j<6;$j++) { $logderi_pp[$ie+$j][$ll] = $line[$j]; $counts++;}
      }
      @line = split(' ',<IN>);
      $ie = $nline_tmp*6;
      for($j=0;$j<$nres_tmp;$j++) { $logderi_pp[$ie+$j][$ll] = $line[$j]; $counts++;}
      print "    ... $counts points have been read.\n";
    }
    for($ie=0;$ie<$ne_logderi;$ie++) {
      $epos[$ie] = $emin + ($emax-$emin)*$ie/($ne_logderi-1);
    }
  } elsif($line[0] =~/ae_wave_function_gpsi/) {
  ### ae_wave_function_gpsi
    $have_ae_wave_function_gpsi = 1;
    @line = split(' ',<IN>);
    $num_lt = $line[0];
    print "ae_wave_function_gpsi --> Nlt=$num_lt\n"; <IN>;
    print "  n  l  t ln tn                   Eref[n]\n";
    for($lt=0;$lt<$num_lt;$lt++) {
      @line = split(' ',<IN>);
      $n_lt[$lt]      = $line[0];
      $l_lt[$lt]      = $line[1];
      $t_lt[$lt]      = $line[2];
      $ln_lt[$lt]     = $line[3];
      $tn_lt[$lt]     = $line[4];
      $dummy          = "$line[5]";
      $val_type[$lt]  = "$line[6]";
      $eref[$lt]      = $line[7];
      printf "%3d%3d%3d%3d%3d  $dummy  $val_type[$lt]%15.10f\n",
        $n_lt[$lt],$l_lt[$lt],$t_lt[$lt],$ln_lt[$lt],$tn_lt[$lt],
        $eref[$lt];
    }
    for($lt=0;$lt<$num_lt;$lt++) {
      $dummy = <IN>;
      print "$dummy"; <IN>;
      $counts = 0;
      for($i=0;$i<$ng_line;$i++) {
        @line = split(' ',<IN>);
        $ig = $i*6;
        for($j=0;$j<6;$j++) { $gpsi[$ig+$j][$lt] = $line[$j]; $counts++;}
      }
      @line = split(' ',<IN>);
      $ig = $ng_line*6;
      for($j=0;$j<$ng_res;$j++) { $gpsi[$ig+$j][$lt] = $line[$j]; $counts++;}
      print "    ... $counts points have been read.\n";
    }
  } elsif($line[0] =~/pp_wave_function_gphi/) {
  ### pp_wave_function_gphi
    $have_pp_wave_function_gphi = 1;
    @line = split(' ',<IN>);
    $num_lt = $line[0];
    print "pp_wave_function_gphi --> Nlt=$num_lt\n"; <IN>;
    print "  n  l  t ln tn                   Eref[n]\n";
    for($lt=0;$lt<$num_lt;$lt++) {
      @line = split(' ',<IN>);
      $n_lt[$lt]      = $line[0];
      $l_lt[$lt]      = $line[1];
      $t_lt[$lt]      = $line[2];
      $ln_lt[$lt]     = $line[3];
      $tn_lt[$lt]     = $line[4];
      $dummy          = "$line[5]";
      $val_type[$lt]  = "$line[6]";
      $eref[$lt]      = $line[7];
      printf "%3d%3d%3d%3d%3d  $dummy  $val_type[$lt]%15.10f\n",
        $n_lt[$lt],$l_lt[$lt],$t_lt[$lt],$ln_lt[$lt],$tn_lt[$lt],
        $eref[$lt];
    }
    for($lt=0;$lt<$num_lt;$lt++) {
      $dummy = <IN>;
      print "$dummy"; <IN>;
      $counts = 0;
      for($i=0;$i<$ng_line;$i++) {
        @line = split(' ',<IN>);
        $ig = $i*6;
        for($j=0;$j<6;$j++) { $gphi[$ig+$j][$lt] = $line[$j]; $counts++;}
      }
      @line = split(' ',<IN>);
      $ig = $ng_line*6;
      for($j=0;$j<$ng_res;$j++) { $gphi[$ig+$j][$lt] = $line[$j]; $counts++;}
      print "    ... $counts points have been read.\n";
    }
  } elsif($line[0] =~/projector_gbeta/) {
  ### projector_gbeta
    $have_projector_gbeta = 1;
    @line = split(' ',<IN>);
    $num_lt = $line[0];
    print "projector_gbeta --> Nlt=$num_lt\n"; <IN>;
    print "  n  l  t ln tn                   Eref[n]\n";
    for($lt=0;$lt<$num_lt;$lt++) {
      @line = split(' ',<IN>);
      $n_lt[$lt]      = $line[0];
      $l_lt[$lt]      = $line[1];
      $t_lt[$lt]      = $line[2];
      $ln_lt[$lt]     = $line[3];
      $tn_lt[$lt]     = $line[4];
      $dummy          = "$line[5]";
      $val_type[$lt]  = "$line[6]";
      $eref[$lt]      = $line[7];
      printf "%3d%3d%3d%3d%3d  $dummy  $val_type[$lt]%15.10f\n",
        $n_lt[$lt],$l_lt[$lt],$t_lt[$lt],$ln_lt[$lt],$tn_lt[$lt],
        $eref[$lt];
    }
    for($lt=0;$lt<$num_lt;$lt++) {
      $dummy = <IN>;
      print "$dummy"; <IN>;
      $counts = 0;
      for($i=0;$i<$ng_line;$i++) {
        @line = split(' ',<IN>);
        $ig = $i*6;
        for($j=0;$j<6;$j++) { $gbeta[$ig+$j][$lt] = $line[$j]; $counts++;}
      }
      @line = split(' ',<IN>);
      $ig = $ng_line*6;
      for($j=0;$j<$ng_res;$j++) { $gbeta[$ig+$j][$lt] = $line[$j]; $counts++;}
      print "    ... $counts points have been read.\n";
    }
  } elsif($line[0] =~/deficit_charge_ggq/) {
  ### deficit_charge_ggq
    $have_deficit_charge_ggq = 1;
    @line = split(' ',<IN>);
    $num_ltlt_in = $line[0];
    if($num_ltlt_in != $num_ltlt) {
      print "### ERROR ### num_ltlt_in != num_ltlt (in deficit_charge_ggq)\n";
      exit(-1);
    }
    print "deficit_charge_ggq --> Nltlt=$num_ltlt\n"; <IN>;
    print " ln tn lm tm  L\n";
    for($ltlt=0;$ltlt<$num_ltlt;$ltlt++) {
      @line = split(' ',<IN>);
      $ln = $line[0];
      $tn = $line[1];
      $lm = $line[2];
      $tm = $line[3];
      $dummy = "$line[4]";
      printf "%3d%3d%3d%3d     $dummy\n",$ln,$tn,$lm,$tm;
      for($l3idx=0;$l3idx<$num_l3_ltlt[$ltlt];$l3idx++) {
        @line = split(' ',<IN>);
        $ln = $line[0];
        $tn = $line[1];
        $lm = $line[2];
        $tm = $line[3];
        $l3 = $line[4];
        $dummy = "$line[5]";
        printf "%3d%3d%3d%3d%3d  $dummy\n",$ln,$tn,$lm,$tm,$l3;
      }
    }
    for($ltlt=0;$ltlt<$num_ltlt;$ltlt++) {
      $dummy = <IN>;
      print "$dummy";
      $dummy = <IN>;
      $counts = 0;
      for($i=0;$i<$ng_line;$i++) {
        @line = split(' ',<IN>);
        $ig = $i*6;
        for($j=0;$j<6;$j++) { $gg_qnm[$ig+$j][$ltlt] = $line[$j]; $counts++;}
      }
      @line = split(' ',<IN>);
      $ig = $ng_line*6;
      for($j=0;$j<$ng_res;$j++) { $gg_qnm[$ig+$j][$ltlt] = $line[$j]; $counts++;}
      print "    ... $counts points have been read.\n";
      for($l3idx=0;$l3idx<$num_l3_ltlt[$ltlt];$l3idx++) {
        $ltltl = $ltltl_ltlt_l3[$ltlt][$l3idx];
        $l3 = $l3_ltltl[$ltltl];
        $dummy = <IN>;
        print "$dummy";
        @line = split(" ",<IN>);
        $l3_in = $line[4];
        if($l3_in != $l3) {
          print "### ERROR ### l3_in != l3 (in deficit_charge_ggq)\n";
          exit(-1);
        }
        $counts = 0;
        for($i=0;$i<$ng_line;$i++) {
          @line = split(' ',<IN>);
          $ig = $i*6;
          for($j=0;$j<6;$j++) { $gg_qps[$ig+$j][$ltltl] = $line[$j]; $counts++;}
        }
        @line = split(' ',<IN>);
        $ig = $ng_line*6;
        for($j=0;$j<$ng_res;$j++) { $gg_qps[$ig+$j][$ltltl] = $line[$j]; $counts++;}
        print "    ... $counts points have been read.\n";
      }
    }
  }
}
close(IN);

print "--------------------------------------\n";
print " \$have_atomic_label             --> $have_atomic_label\n";
print " \$have_atomic_charge            --> $have_atomic_charge\n";
print " \$have_xc_potential             --> $have_xc_potential\n";
print " \$have_rmesh                    --> $have_rmesh\n";
print " \$have_cutoff_wf                --> $have_cutoff_wf\n";
print " \$have_ae_scr_potential         --> $have_ae_scr_potential\n";
print " \$have_bhs_potential            --> $have_bhs_potential\n";
print " \$have_scr_local_potential      --> $have_scr_local_potential\n";
print " \$have_ion_local_potential      --> $have_ion_local_potential\n";
print " \$have_valence_charge_rrnv      --> $have_valence_charge_rrnv\n";
print " \$have_core_charge_rrnc         --> $have_core_charge_rrnc\n";
print " \$have_pcc_charge_rrnpcc        --> $have_pcc_charge_rrnpcc\n";
print " \$have_ae_wave_function_rpsi    --> $have_ae_wave_function_rpsi\n";
print " \$have_pp_wave_function_rphi    --> $have_pp_wave_function_rphi\n";
print " \$have_separable_potential      --> $have_separable_potential\n";
print " \$have_projector_rbeta          --> $have_projector_rbeta\n";
print " \$have_deficit_charge_rrq       --> $have_deficit_charge_rrq\n";
print " \$have_dipole                   --> $have_dipole\n";
print " \$have_logderi                  --> $have_logderi\n";
print " \$have_valence_charge_ggnv      --> $have_valence_charge_ggnv\n";
print " \$have_core_charge_ggnc         --> $have_core_charge_ggnc\n";
print " \$have_pcc_charge_ggnpcc        --> $have_pcc_charge_ggnpcc\n";
print " \$have_ae_wave_function_gpsi    --> $have_ae_wave_function_gpsi\n";
print " \$have_pp_wave_function_gphi    --> $have_pp_wave_function_gphi\n";
print " \$have_projector_gbeta          --> $have_projector_gbeta\n";
print " \$have_deficit_charge_ggq       --> $have_deficit_charge_ggq\n";
print "--------------------------------------\n";

################################################################################
#  gnuplot

@spdf = ('s','p','d','f','g','h','i');
@spdf_capital = ('S','P','D','F','G','H','I');
@ntic = (0.01,0.02,0.05,0.1,0.2,0.5,1,2,5,10,20,50,100,200,500,
         1000,2000,5000,10000,20000,50000,100000,200000,500000,
         1000000,2000000,5000000);

$is_generated_rho     = 0;
$is_generated_vloc    = 0;
$is_generated_rphi    = 0;
$is_generated_gphi    = 0;
$is_generated_rbeta   = 0;
$is_generated_gbeta   = 0;
$is_generated_ldr     = 0;
$is_generated_ldr_std = 0;
$is_generated_rrq     = 0;
$is_generated_ggq     = 0;

################################################################################
#////////////////////////// Charge density & Potential//////////////////////////
#
#  OUTPUT: ciaopp_rho.eps & ciaopp_vloc.eps
#

$rmin = 0;
$rmax = 5;
if($is_input_rmax == 1) {$rmax = $rmax_in;}

$nc_min = 0;
$nc_max = 0;
$nv_min = 0;
$nv_max = 0;
$npcc_min = 0;
$npcc_max = 0;
$vpp_min = +1.0e3;
$vpp_max = -1.0e3;

$ifound0 = 0;
$ifound1 = 0;
$r0 = -1.0e3;
$r1 = -1.0e3;
$pcc0 = 0;
$pcc1 = 0;

if($have_valence_charge_rrnv == 1 &&
   $have_core_charge_rrnc == 1) {
print "*** Charge density & Potential ***\n";

$file0 = "rho" . "_vloc" . "_$atom_label" . ".dat";
open(OUT,">$file0");
  for($ir=0;$ir<$nmesh;$ir++) {
    $r = $rpos[$ir];
    $rho_core = $rr_nc[$ir]/$r**2;
    $rho_val  = $rr_nv[$ir]/$r**2;
    $rho_tot  = $rho_core + $rho_val;
    $vae_scr  = $veff[$ir];
    $vpp_scr  = $vloc_scr[$ir];
    $vpp_ion  = $vloc_ion[$ir];
    if($rho_core > $nc_max) {$nc_max = $rho_core;}
    if($rho_core < $nc_min) {$nc_min = $rho_core;}
    if($rho_val > $nv_max) {$nv_max = $rho_val;}
    if($rho_val < $nv_min) {$nv_min = $rho_val;}
    if($vpp_scr > $vpp_max) {$vpp_max = $vpp_scr;}
    if($vpp_scr < $vpp_min) {$vpp_min = $vpp_scr;}
    if($vpp_ion > $vpp_max) {$vpp_max = $vpp_ion;}
    if($vpp_ion < $vpp_min) {$vpp_min = $vpp_ion;}
    if($have_pcc_charge_rrnpcc == 1) {
      $rho_pcc = $rr_npcc[$ir]/$r**2;
      if($rho_pcc > $npcc_max) {$npcc_max = $rho_pcc;}
      if($rho_pcc < $npcc_min) {$npcc_min = $rho_pcc;}
      if($r < $rcut_pcc && $ifound0 == 0) 
        {$r0 = $r; $pcc0 = $rho_pcc;} else {$ifound0 = 1;}
      if($ifound0 == 1 && $ifound1 == 0) 
        {$r1 = $r; $pcc1 = $rho_pcc; $ifound1 = 1;}
      print OUT "$r $rho_tot $rho_core $rho_val $vae_scr $vpp_scr $vpp_ion $rho_pcc\n";
    } else {
      print OUT "$r $rho_tot $rho_core $rho_val $vae_scr $vpp_scr $vpp_ion\n";
    }
  }
close(OUT);

$nv_max = $nv_max*2;

if($have_pcc_charge_rrnpcc == 1) {
  print "(npcc_min, npcc_max) --> ($npcc_min, $npcc_max)\n";
}

### Parameters
$ndiv_max = 5;

##### Electron density n(r) #####
open(OUT,">$$.gpi");
$rho_file = "$title" . "_rho" . ".eps";
print OUT "set terminal postscript eps enhanced color solid \"Helvetica\" 12\n";
print OUT "set output \"$rho_file\"\n";
print OUT "set xzeroaxis\n";
print OUT "set border 31 lw 1\n";

print OUT "set size 0.5,0.5\n";
print OUT "set key right top\n";
#print OUT "set nokey\n";
print OUT "set xtics 1\n";
print OUT "set mxtics 1\n";
if($have_pcc_charge_rrnpcc == 1) {
for($i=0;int(($npcc_max*2-$npcc_min)/$ntic[$i]) > $ndiv_max;$i++) {next;}
$ytics_guess = $ntic[$i];
$mytics_guess = 1;
$nv_max_guess = int($npcc_max*2/$ntic[$i])*$ntic[$i]+$ntic[$i];
$nv_min_guess = int($npcc_min/$ntic[$i])*$ntic[$i]-$ntic[$i];
} else {
for($i=0;int(($nv_max-$nv_min)/$ntic[$i]) > $ndiv_max;$i++) {next;}
$ytics_guess = $ntic[$i];
$mytics_guess = 1;
$nv_max_guess = int($nv_max/$ntic[$i])*$ntic[$i]+$ntic[$i]+$ntic[$i];
$nv_min_guess = int($nv_min/$ntic[$i])*$ntic[$i]-$ntic[$i];
}
print OUT "set ytics $ytics_guess\n";
print OUT "set mytics $mytics_guess\n";
print OUT "set format x \"%1.0f\"\n";
if($ytics_guess < 0.1) {
print OUT "set format y \"%4.2f\"\n";
} elsif($ytics_guess < 1) {
print OUT "set format y \"%3.1f\"\n";
} elsif($ytics_guess < 10) {
print OUT "set format y \"%2.0f\"\n";
} elsif($ytics_guess < 100) {
print OUT "set format y \"%3.0f\"\n";
} else {
print OUT "set format y \"%4.0f\"\n";
}
print OUT "set xlabel \"r\"\n";
print OUT "set ylabel \"n(r)\"\n";

print OUT "set label \"$atom_label\" center at graph 0.11,0.86 font \"Helvetica-Bold,36\"\n";

if($have_pcc_charge_rrnpcc == 1) {
$arrow_length = abs($nv_max_guess-$nv_min_guess)/10;
$arrow_offset = abs($nv_max_guess-$nv_min_guess)/60;
print OUT "set arrow from $r0,$pcc0-$arrow_length to $r0,$pcc0-$arrow_offset lt 3 lw 1\n";
if($is_formatted == 1) {
  print OUT "set label \"Rc=%8.5f\",$rcut_pcc \\\n";
} else {
  $tmp = int($rcut_pcc*1.0e5)*1.0e-5;
  print OUT "set label \"Rc=$tmp\" \\\n";
}
print OUT "at graph 0.68,0.1 font \"Courier,9\"\n";
}

print OUT "plot [$rmin:$rmax][$nv_min_guess:$nv_max_guess] \\\n";
print OUT "\'$file0\' u 1:3 t \'Core\'    w l lt 1 lw 4, \\\n";
print OUT "\'$file0\' u 1:4 t \'Valence\' w l lt 2 lw 4, \\\n";
if($have_pcc_charge_rrnpcc == 1) {
print OUT "\'$file0\' u 1:8 t \'PCC\'     w l lt 3 lw 4, \\\n";
}
print OUT "\'$file0\' u 1:2 t \'Total\'   w l lt 0 lw 1";
print OUT "\n";
close(OUT);

`gnuplot $$.gpi`;
`\\rm $$.gpi`;

##### Potential V(r) #####
open(OUT,">$$.gpi");
$vloc_file = "$title" . "_vloc" . ".eps";
print OUT "set terminal postscript eps enhanced color solid \"Helvetica\" 12\n";
print OUT "set output \"$vloc_file\"\n";
print OUT "set xzeroaxis\n";
print OUT "set border 31 lw 1\n";

print OUT "set size 0.5,0.5\n";
print OUT "set key right top\n";
#print OUT "set nokey\n";
print OUT "set xtics 1\n";
print OUT "set mxtics 1\n";
if($vpp_max > 20) {$vpp_max = 20;}
if($vpp_min < -20) {$vpp_min = -20;}
for($i=0;int(($vpp_max-$vpp_min)/$ntic[$i]) > $ndiv_max;$i++) {next;}
$ytics_guess = $ntic[$i];
$mytics_guess = 1;
$vpp_max_guess = int($vpp_max/$ntic[$i])*$ntic[$i]+$ntic[$i]+$ntic[$i];
$vpp_min_guess = int($vpp_min/$ntic[$i])*$ntic[$i]-$ntic[$i];
print OUT "set ytics $ytics_guess\n";
print OUT "set mytics $mytics_guess\n";
print OUT "set format x \"%1.0f\"\n";
#print OUT "set format y \"%2.0f\"\n";       
if($ytics_guess < 0.1) {
print OUT "set format y \"%4.2f\"\n";
} elsif($ytics_guess < 1) {
print OUT "set format y \"%3.1f\"\n";
} elsif($ytics_guess < 10) {
print OUT "set format y \"%2.0f\"\n";
} elsif($ytics_guess < 100) {
print OUT "set format y \"%3.0f\"\n";
} else {
print OUT "set format y \"%4.0f\"\n";
}
print OUT "set xlabel \"r\"\n";
print OUT "set ylabel \"V(r)\"\n";
#print OUT "set label \"$element\" center at graph 0.11,0.86 font \"Helvetica-Bold,36\"\n";

print OUT "plot [$rmin:$rmax][$vpp_min_guess:$vpp_max_guess] \\\n";
print OUT "\'$file0\' u 1:7 t \'V_{loc}[ion]\' w l lt 1 lw 4, \\\n";
print OUT "\'$file0\' u 1:6 t \'V_{loc}[scr]\' w l lt 2 lw 4, \\\n";
print OUT "\'$file0\' u 1:5 t \'V_{AE}[scr]\'  w l lt 0 lw 1";
print OUT "\n";
close(OUT);

`gnuplot $$.gpi`;
`\\rm $$.gpi`;

`\\rm $file0`;

print "    output ... $rho_file\n";  $is_generated_rho  = 1;
print "    output ... $vloc_file\n"; $is_generated_vloc = 1;
}

################################################################################
#////////////////////////////// Wave functions (R) /////////////////////////////
#
#  OUTPUT: ciaopp_rphi.eps & ciaopp_rbeta.eps
#

if($have_ae_wave_function_rpsi == 1 && 
   $have_pp_wave_function_rphi == 1 &&
   $have_projector_rbeta == 1) {
print "*** Wavefunctions (R) ***\n";

$rmax_phi  =  5;
$rmin_phi  =  0;
if($is_input_rmax == 1) {$rmax_phi = $rmax_in;}

$rmax_beta =  5;
$rmin_beta =  0;
if($is_input_rmax == 1) {$rmax_beta = $rmax_in;}

$rphi_max_plot =  3;
$rphi_min_plot = -2;

$rphi_max  = -1.0e3;
$rphi_min  = +1.0e3;
$rbeta_max = -1.0e3;
$rbeta_min = +1.0e3;

for($lt=0;$lt<$num_lt;$lt++) {
  $ll = $ln_lt[$lt];
  $tn = $tn_lt[$lt];
  $file[$lt] = "rphi" . "_$spdf[$ll]$tn" . ".dat";
  $have_zero[$lt] = 0;
  $r0[$lt]      = -1.0e3;
  $r1[$lt]      = -1.0e3;
  $ifound0[$lt] = 0;
  $ifound1[$lt] = 0;
  $rpsi0[$lt]   = 0;
  $rpsi1[$lt]   = 0;
  open(OUT,">$file[$lt]");
  $ic = 0;
  for($ir=0;$ir<$nmesh;$ir++) {
    $rpos_tmp  = $rpos[$ir];
    $rpsi_tmp  = $rpsi[$ir][$lt];
    $rphi_tmp  = $rphi[$ir][$lt];
    $rbeta_tmp = $rbeta[$ir][$lt];
    if($rpsi_tmp > $rphi_max) {$rphi_max = $rpsi_tmp;}
    if($rpsi_tmp < $rphi_min) {$rphi_min = $rpsi_tmp;}
    if($rphi_tmp > $rphi_max) {$rphi_max = $rphi_tmp;}
    if($rphi_tmp < $rphi_min) {$rphi_min = $rphi_tmp;}
    if($rbeta_tmp > $rbeta_max) {$rbeta_max = $rbeta_tmp;}
    if($rbeta_tmp < $rbeta_min) {$rbeta_min = $rbeta_tmp;}
    if($rpos_tmp < $rcut_phi[$lt] && $ifound0[$lt] == 0) 
      {$r0[$lt] = $rpos_tmp; $rpsi0[$lt] = $rpsi_tmp;} else {$ifound0[$lt] = 1;}
    if($ifound0[$lt] == 1 && $ifound1[$lt] == 0) 
      {$r1[$lt] = $rpos_tmp; $rpsi1[$lt] = $rpsi_tmp; $ifound1[$lt] = 1;}
    if(abs($rpsi_tmp) < 1.0e-10 && $rpos_tmp > 0.1 && $rpos_tmp < 8 || ($rpos_tmp > 8 && $ic > 10))
      {$rpsi_tmp = 'zero';}
    if(abs($rphi_tmp) < 1.0e-10 && $rpos_tmp > 0.1 && $rpos_tmp < 8  || ($rpos_tmp > 8 && $ic > 10))
      {$rphi_tmp = 'zero'; $have_zero[$lt] = 1; $ic++;}
    print OUT "$rpos_tmp $rpsi_tmp $rphi_tmp $rbeta_tmp\n";
  }
  close(OUT);
}

### Parameters
$ndiv_max = 5;

##### r*phi(r) #####
open(OUT,">$$.gpi");
$rphi_file = "$title" . "_rphi" . ".eps";
print OUT "set terminal postscript eps enhanced color solid \"Helvetica\" 12\n";
print OUT "set output \"$rphi_file\"\n";
print OUT "set xzeroaxis\n";
print OUT "set border 31 lw 1\n";
print OUT "set missing \"zero\"\n";

print OUT "set size 0.5,0.5\n";
print OUT "set key right top\n";
#print OUT "set nokey\n";
print OUT "set xtics 1\n";
print OUT "set mxtics 1\n";
if($rphi_max > $rphi_max_plot) {$rphi_max = $rphi_max_plot;}
if($rphi_min < $rphi_min_plot) {$rphi_min = $rphi_min_plot;}
for($i=0;int(($rphi_max-$rphi_min)/$ntic[$i]) > $ndiv_max;$i++) {next;}
$ytics_guess = $ntic[$i];
$rphi_max_guess = int($rphi_max/$ntic[$i])*$ntic[$i]+$ntic[$i];
$rphi_min_guess = int($rphi_min/$ntic[$i])*$ntic[$i]-$ntic[$i];
print OUT "set ytics $ytics_guess\n";
print OUT "set mytics 1\n";
print OUT "set format x \"%1.0f\"\n";
#print OUT "set format y \"%2.0f\"\n";
if($ytics_guess < 0.1) {
print OUT "set format y \"%4.2f\"\n";
} elsif($ytics_guess < 1) {
print OUT "set format y \"%3.1f\"\n";
} else {
print OUT "set format y \"%2.0f\"\n";
}
print OUT "set xlabel \"r\"\n";
print OUT "set ylabel \"r{/Symbol y}_{/Times-Italic n}(r)\"\n";
print OUT "set label \"$atom_label\" center at graph 0.11,0.86 font \"Helvetica-Bold,36\"\n";

for($lt=0;$lt<$num_lt;$lt++) {
  print OUT "set arrow from $r0[$lt],$rpsi0[$lt]-0.3 to $r0[$lt],$rpsi0[$lt]-0.03 lt $ln_lt[$lt]+1 lw 1\n";
}

print OUT "plot [$rmin_phi:$rmax_phi][$rphi_min_guess:$rphi_max_guess] \\\n";
$ic = 0;
for($lt=0;$lt<$num_lt;$lt++) {
  if($ic != 0) {print OUT ", \\\n";}
  $line_type = $ln_lt[$lt]+1;
  print OUT "\"$file[$lt]\" u 1:2 notitle                     w l lt $line_type lw 1, \\\n";
  print OUT "\"$file[$lt]\" u 1:3 t \"$spdf[$ln_lt[$lt]]$tn_lt[$lt]\" w l lt $line_type lw 4";
  $ic++;
}
print OUT "\n";
close(OUT);

`gnuplot $$.gpi`;
`\\rm $$.gpi`;

##### r*beta(r) #####
open(OUT,">$$.gpi");
$rbeta_file = "$title" . "_rbeta" . ".eps";
print OUT "set terminal postscript eps enhanced color solid \"Helvetica\" 12\n";
print OUT "set output \"$rbeta_file\"\n";
print OUT "set xzeroaxis\n";
print OUT "set border 31 lw 1\n";
print OUT "set missing \"zero\"\n";

print OUT "set size 0.5,0.5\n";
#print OUT "set key right top\n";
print OUT "set nokey\n";
print OUT "set xtics 1\n";
for($i=0;int(($rbeta_max-$rbeta_min)/$ntic[$i]) > $ndiv_max;$i++) {next;}
$ytics_guess = $ntic[$i];
$rbeta_max_guess = int($rbeta_max/$ntic[$i])*$ntic[$i]+$ntic[$i];
$rbeta_min_guess = int($rbeta_min/$ntic[$i])*$ntic[$i]-$ntic[$i];
print OUT "set ytics $ytics_guess\n";
print OUT "set mytics 1\n";
print OUT "set format x \"%1.0f\"\n";
print OUT "set format y \"%2.0f\"\n";
print OUT "set xlabel \"r\"\n";
print OUT "set ylabel \"r{/Symbol b}_{/Times-Italic n}(r)\"\n";

$ic = 0;
for($lt=0;$lt<$num_lt;$lt++) {
  if($is_formatted == 1) {
    print OUT "set label \"Rc($spdf[$ln_lt[$lt]]$tn_lt[$lt])=%8.5f\",$rcut_phi[$lt] \\\n";
  } else {
    $tmp = int($rcut_phi[$lt]*1.0e5)*1.0e-5;
    print OUT "set label \"Rc($spdf[$ln_lt[$lt]]$tn_lt[$lt])=$tmp\" \\\n";
  }
  print OUT "at graph 0.68,0.9-$ic*0.05 font \"Courier,9\"\n";
  $ic++;
}

print OUT "plot [$rmin_beta:$rmax_beta][$rbeta_min_guess:$rbeta_max_guess] \\\n";
$ic = 0;
for($lt=0;$lt<$num_lt;$lt++) {
  if($ic != 0) {print OUT ", \\\n";}
  $line_type = $ln_lt[$lt]+1;
  #print OUT "\"$file[$lt]\" u 1:4 t \"{/Symbol c}: $spdf[$ln_lt[$lt]]$tn_lt[$lt]\" w l lt $line_type lw 1, \\\n";
  print OUT "\"$file[$lt]\" u 1:4 t \"{/Symbol b}: $spdf[$ln_lt[$lt]]$tn_lt[$lt]\" w l lt $line_type lw 4";
  $ic++;
}
print OUT "\n";
close(OUT);

`gnuplot $$.gpi`;
`\\rm $$.gpi`;

for($lt=0;$lt<$num_lt;$lt++) {`\\rm $file[$lt]`;}

print "    output ... $rphi_file\n";  $is_generated_rphi  = 1;
print "    output ... $rbeta_file\n"; $is_generated_rbeta = 1;
}

################################################################################
#////////////////////////////// Wave functions (G) /////////////////////////////
#
#  OUTPUT: ciaopp_gphi.eps & ciaopp_gbeta.eps
#

if($have_ae_wave_function_gpsi == 1 && 
   $have_pp_wave_function_gphi == 1 &&
   $have_projector_gbeta == 1) {
print "*** Wavefunctions (G) ***\n";

$gmax_phi  = 10;
$gmin_phi  =  0;
if($is_input_gmax == 1) {$gmax_phi = $gmax_in;}

$gmax_beta = 20;
$gmin_beta =  0;
if($is_input_gmax == 1) {$gmax_beta = $gmax_in;}

$gphi_max_plot =  3;
$gphi_min_plot = -2;

$gphi_max  = -1.0e3;
$gphi_min  = +1.0e3;
$gbeta_max = -1.0e3;
$gbeta_min = +1.0e3;

for($lt=0;$lt<$num_lt;$lt++) {
  $ll = $ln_lt[$lt];
  $tn = $tn_lt[$lt];
  $file[$lt] = "gphi" . "_$spdf[$ll]$tn" . ".dat";
  open(OUT,">$file[$lt]");
  for($ig=0;$ig<$ng_mesh;$ig++) {
    $gpos_tmp  = $gpos[$ig];
    $gpsi_tmp  = $gpsi[$ig][$lt];
    $gphi_tmp  = $gphi[$ig][$lt];
    $gbeta_tmp = $gbeta[$ig][$lt];
    if($gpsi_tmp > $gphi_max) {$gphi_max = $gpsi_tmp;}
    if($gpsi_tmp < $gphi_min) {$gphi_min = $gpsi_tmp;}
    if($gphi_tmp > $gphi_max) {$gphi_max = $gphi_tmp;}
    if($gphi_tmp < $gphi_min) {$gphi_min = $gphi_tmp;}
    if($gbeta_tmp > $gbeta_max) {$gbeta_max = $gbeta_tmp;}
    if($gbeta_tmp < $gbeta_min) {$gbeta_min = $gbeta_tmp;}
    print OUT "$gpos_tmp $gpsi_tmp $gphi_tmp $gbeta_tmp\n";
  }
  close(OUT);
}

### Parameters
$ndiv_max = 5;

##### g*phi(g) #####
open(OUT,">$$.gpi");
$gphi_file = "$title" . "_gphi" . ".eps";
print OUT "set terminal postscript eps enhanced color solid \"Helvetica\" 12\n";
print OUT "set output \"$gphi_file\"\n";
print OUT "set xzeroaxis\n";
print OUT "set border 31 lw 1\n";
print OUT "set missing \"zero\"\n";

print OUT "set size 0.5,0.5\n";
#print OUT "set key right top\n";
print OUT "set nokey\n";
print OUT "set xtics 1\n";
print OUT "set mxtics 1\n";
if($gphi_max > $gphi_max_plot) {$gphi_max = $gphi_max_plot;}
if($gphi_min < $gphi_min_plot) {$gphi_min = $gphi_min_plot;}
for($i=0;int(($gphi_max-$gphi_min)/$ntic[$i]) > $ndiv_max;$i++) {next;}
$ytics_guess = $ntic[$i];
$gphi_max_guess = int($gphi_max/$ntic[$i])*$ntic[$i]+$ntic[$i];
$gphi_min_guess = int($gphi_min/$ntic[$i])*$ntic[$i]-$ntic[$i];
print OUT "set ytics $ytics_guess\n";
print OUT "set mytics 1\n";
print OUT "set format x \"%1.0f\"\n";
#print OUT "set format y \"%2.0f\"\n";
if($ytics_guess < 0.1) {
print OUT "set format y \"%4.2f\"\n";
} elsif($ytics_guess < 1) {
print OUT "set format y \"%3.1f\"\n";
} else {
print OUT "set format y \"%2.0f\"\n";
}
print OUT "set xlabel \"q\"\n";
print OUT "set ylabel \"q{/Symbol y}_{/Times-Italic n}(q)\"\n";
#print OUT "set label \"$atom_label\" center at graph 0.11,0.86 font \"Helvetica-Bold,36\"\n";

print OUT "plot [$gmin_phi:$gmax_phi][$gphi_min_guess:$gphi_max_guess] \\\n";
$ic = 0;
for($lt=0;$lt<$num_lt;$lt++) {
  if($have_zero[$lt] == 1) {next;}
  if($ic != 0) {print OUT ", \\\n";}
  $line_type = $ln_lt[$lt]+1;
  print OUT "\"$file[$lt]\" u 1:2 notitle                     w l lt $line_type lw 1, \\\n";
  print OUT "\"$file[$lt]\" u 1:3 t \"$spdf[$ln_lt[$lt]]$tn_lt[$lt]\" w l lt $line_type lw 4";
  $ic++;
}
print OUT "\n";
close(OUT);

`gnuplot $$.gpi`;
`\\rm $$.gpi`;

##### g*beta(g) #####
open(OUT,">$$.gpi");
$gbeta_file = "$title" . "_gbeta" . ".eps";
print OUT "set terminal postscript eps enhanced color solid \"Helvetica\" 12\n";
print OUT "set output \"$gbeta_file\"\n";
print OUT "set xzeroaxis\n";
print OUT "set border 31 lw 1\n";
print OUT "set missing \"zero\"\n";

print OUT "set size 0.5,0.5\n";
#print OUT "set key right top\n";
print OUT "set nokey\n";
print OUT "set xtics 5\n";
print OUT "set mxtics 5\n";
for($i=0;int(($gbeta_max-$gbeta_min)/$ntic[$i]) > $ndiv_max;$i++) {next;}
$ytics_guess = $ntic[$i];
$gbeta_max_guess = int($gbeta_max/$ntic[$i])*$ntic[$i]+$ntic[$i];
$gbeta_min_guess = int($gbeta_min/$ntic[$i])*$ntic[$i]-$ntic[$i];
print OUT "set ytics $ytics_guess\n";
print OUT "set mytics 1\n";
print OUT "set format x \"%1.0f\"\n";
print OUT "set format y \"%2.0f\"\n";
print OUT "set xlabel \"q\"\n";
print OUT "set ylabel \"q{/Symbol b}_{/Times-Italic n}(q)\"\n";
print OUT "plot [$gmin_beta:$gmax_beta][$gbeta_min_guess:$gbeta_max_guess] \\\n";
$ic = 0;
for($lt=0;$lt<$num_lt;$lt++) {
  if($ic != 0) {print OUT ", \\\n";}
  $line_type = $ln_lt[$lt]+1;
  #print OUT "\"$file[$lt]\" u 1:4 t \"{/Symbol c}: $spdf[$ln_lt[$lt]]$tn_lt[$lt]\" w l lt $line_type lw 1, \\\n";
  print OUT "\"$file[$lt]\" u 1:4 t \"{/Symbol b}: $spdf[$ln_lt[$lt]]$tn_lt[$lt]\" w l lt $line_type lw 4";
  $ic++;
}
print OUT "\n";
close(OUT);

`gnuplot $$.gpi`;
`\\rm $$.gpi`;

for($lt=0;$lt<$num_lt;$lt++) {`\\rm $file[$lt]`;}

print "    output ... $gphi_file\n";  $is_generated_gphi  = 1;
print "    output ... $gbeta_file\n"; $is_generated_gbeta = 1;
}

################################################################################
#/////////////////////////// Logarithmic derivatives ///////////////////////////
#
#  OUTPUT: ciaopp_ldr.eps & ciaopp_ldr_std.eps
#

if($have_logderi == 1) {
print "*** Logarithmic derivatives ***\n";

$ldrmax_plot =  20.0;
$ldrmin_plot = -20.0;

$ldrmin = $ldrmin_plot;
$ldrmax = $ldrmax_plot;
$arrow_offset = abs($ldrmax_plot-$ldrmin_plot)/60;
$arrow_length = abs($ldrmax_plot-$ldrmin_plot)/10;

for($ll=0;$ll<$num_logderi;$ll++) {
  $file[$ll] = "ldr" . "_$spdf[$ll]" . ".dat";
  open(OUT,">$file[$ll]");
  for($ie=0;$ie<$ne_logderi;$ie++) {
    print OUT "$epos[$ie] $logderi_ae[$ie][$ll] $logderi_pp[$ie][$ll]\n";
  }
  close(OUT);
}

for($ll=0;$ll<$num_logderi;$ll++) {
  for($tt=1;$tt<=$nref[$ll];$tt++) {
    $e0[$ll][$tt] = -1.0e3;
    $e1[$ll][$tt] = -1.0e3;
    $ifound0[$ll][$tt] = 0;
    $ifound1[$ll][$tt] = 0;
    $ldr_ae0[$ll][$tt] = 0;
    $ldr_ae1[$ll][$tt] = 0;
  }
  for($ie=0;$ie<$ne_logderi;$ie++) {
    $e = $epos[$ie];
    $ldr_ae = $logderi_ae[$ie][$ll];
    #$ldr_pp = $logderi_pp[$ie][$ll];
    for($tt=1;$tt<=$nref[$ll];$tt++) {
      $lt = $lt_n[$ll][$tt];
      if($e < $eref[$lt] && $ifound0[$ll][$tt] == 0) 
        {$e0[$ll][$tt] = $e; $ldr_ae0[$ll][$tt] = $ldr_ae;} else {$ifound0[$ll][$tt] = 1;}
      if($ifound0[$ll][$tt] == 1 && $ifound1[$ll][$tt] == 0) 
        {$e1[$ll][$tt] = $e; $ldr_ae1[$ll][$tt] = $ldr_ae; $ifound1[$ll][$tt] = 1;}
    }
  }
}

### Parameters
$ndiv_max = 5;

##### check_ldr.eps #####
$emin   = $epos[0];
$emax   = $epos[$ne_logderi-1];
open(OUT,">$$.gpi");
$ldr_file = "$title" . "_ldr" . ".eps";
print OUT "set terminal postscript eps enhanced color solid \"Helvetica\" 12\n";
print OUT "set output \"$ldr_file\"\n";
print OUT "set xzeroaxis\n";
print OUT "set border 31 lw 1\n";

print OUT "set size 0.5,0.5\n";
#print OUT "set key left top\n";
print OUT "set nokey\n";
for($i=0;($emax-$emin)/$ntic[$i] > $ndiv_max;$i++) {next;}
$xtics_guess = $ntic[$i];
print OUT "set xtics $xtics_guess\n";
print OUT "set mxtics 1\n";
for($i=0;($ldrmax-$ldrmin)/$ntic[$i] > $ndiv_max;$i++) {next;}
$ytics_guess = $ntic[$i];
print OUT "set ytics $ytics_guess\n";
print OUT "set mytics 1\n";
print OUT "set format x \"%2.0f\"\n";
print OUT "set format y \"%2.0f\"\n";
print OUT "set xlabel \"E\"\n";
print OUT "set ylabel \"dlog(r{/Symbol y}_{/Times-Italic l}(r,E))/dr\"\n";
print OUT "set label \"$atom_label\" center at graph 0.11,0.86 font \"Helvetica-Bold,36\"\n";

$ic = -1;
if($is_formatted == 1) {
  print OUT "set label \"Rc   =%8.5f\",$rcut_logderi_pp[0] \\\n";
} else {
  $tmp = int($rcut_logderi_pp[0]*1.0e5)*1.0e-5;
  print OUT "set label \"Rc   = $tmp\" \\\n";
}
print OUT "at graph 0.05,0.3-$ic*0.05 font \"Courier,9\"\n";
$ic++;
for($ll=0;$ll<=$lmax;$ll++) {
  for($tt=1;$tt<=$nref[$ll];$tt++) {
    $lt = $lt_n[$ll][$tt];
    if($is_formatted == 1) {
      print OUT "set label \"E($spdf[$ll]$tt)=%8.5f\",$eref[$lt] \\\n";
    } else {
      $tmp = int($eref[$lt]*1.0e5)*1.0e-5;
      print OUT "set label \"E($spdf[$ll]$tt)=$tmp\" \\\n";
    }
    print OUT "at graph 0.05,0.3-$ic*0.05 font \"Courier,9\"\n";
    $ic++;
  }
}

for($ll=0;$ll<=$lmax;$ll++) {
  for($tt=1;$tt<=$nref[$ll];$tt++) {
    print OUT "set arrow from $e0[$ll][$tt],$ldr_ae0[$ll][$tt]-$arrow_length to $e0[$ll][$tt],$ldr_ae0[$ll][$tt]-$arrow_offset lt $ll+1 lw 1\n";
  }
}

print OUT "plot [$emin:$emax][$ldrmin_plot:$ldrmax_plot] \\\n";
$ic = 0;
for($ll=0;$ll<$num_logderi;$ll++) {
  if($ic != 0) {print OUT ", \\\n";}
  $line_type = $ll+1;
  print OUT "\'$file[$ll]\' u 1:2 notitle          w l lt $line_type lw 1, \\\n";
  print OUT "\'$file[$ll]\' u 1:3 t \'$spdf[$ll]\' w l lt $line_type lw 4";
  $ic++;
}
print OUT "\n";
close(OUT);

`gnuplot $$.gpi`;
`\\rm $$.gpi`;

##### check_ldr_std.eps #####
$emin   = -2;
$emax   =  1;
open(OUT,">$$.gpi");
$ldr_std_file = "$title" . "_ldr" . "_std" . ".eps";
print OUT "set terminal postscript eps enhanced color solid \"Helvetica\" 12\n";
print OUT "set output \"$ldr_std_file\"\n";
print OUT "set xzeroaxis\n";
print OUT "set border 31 lw 1\n";

print OUT "set size 0.5,0.5\n";
print OUT "set key left top\n";
#print OUT "set nokey\n";
for($i=0;($emax-$emin)/$ntic[$i] > $ndiv_max;$i++) {next;}
$xtics_guess = $ntic[$i];
print OUT "set xtics $xtics_guess\n";
print OUT "set mxtics 1\n";
for($i=0;($ldrmax-$ldrmin)/$ntic[$i] > $ndiv_max;$i++) {next;}
$ytics_guess = $ntic[$i];
print OUT "set ytics $ytics_guess\n";
print OUT "set mytics 1\n";
print OUT "set format x \"%2.0f\"\n";
print OUT "set format y \"%2.0f\"\n";
print OUT "set xlabel \"E\"\n";
print OUT "set ylabel \"dlog(r{/Symbol y}_{/Times-Italic l}(r,E))/dr\"\n";
#print OUT "set label \"$atom_label\" center at graph 0.11,0.86 font \"Helvetica-Bold,36\"\n";

$ic = 0;
for($ll=0;$ll<=$lmax;$ll++) {
  for($tt=1;$tt<=$nref[$ll];$tt++) {
    $lt = $lt_n[$ll][$tt];
    if($is_formatted == 1) {
      print OUT "set label \"E($spdf[$ll]$tt)=%8.5f\",$eref[$lt] \\\n";
    } else {
      $tmp = int($eref[$lt]*1.0e5)*1.0e-5;
      print OUT "set label \"E($spdf[$ll]$tt)=$tmp\" \\\n";
    }
    print OUT "at graph 0.05,0.3-$ic*0.05 font \"Courier,9\"\n";
    $ic++;
  }
}

for($ll=0;$ll<=$lmax;$ll++) {
  for($tt=1;$tt<=$nref[$ll];$tt++) {
    print OUT "set arrow from $e0[$ll][$tt],$ldr_ae0[$ll][$tt]-$arrow_length to $e0[$ll][$tt],$ldr_ae0[$ll][$tt]-$arrow_offset lt $ll+1 lw 1\n";
  }
}

print OUT "plot [$emin:$emax][$ldrmin_plot:$ldrmax_plot] \\\n";
$ic = 0;
for($ll=0;$ll<$num_logderi;$ll++) {
  if($ic != 0) {print OUT ", \\\n";}
  $line_type = $ll+1;
  print OUT "\'$file[$ll]\' u 1:2 notitle          w l lt $line_type lw 1, \\\n";
  print OUT "\'$file[$ll]\' u 1:3 t \'$spdf[$ll]\' w l lt $line_type lw 4";
  $ic++;
}
print OUT "\n";
close(OUT);

`gnuplot $$.gpi`;
`\\rm $$.gpi`;

for($ll=0;$ll<$num_logderi;$ll++) {`\\rm $file[$ll]`;}

print "    output ... $ldr_file\n";     $is_generated_ldr     = 1;
print "    output ... $ldr_std_file\n"; $is_generated_ldr_std = 1;
}

################################################################################
#//////////////////////////// Deficit charges (R) //////////////////////////////

if($have_deficit_charge_rrq == 1) {
print "*** Deficit charges (R) ***\n";

$rmax =  5;
$rmin =  0;
if($is_input_rmax == 1) {$rmax = $rmax_in;}

for($ltlt=0;$ltlt<$num_ltlt;$ltlt++) {
  $rrq_max[$ltlt] = -1.0e3;
  $rrq_min[$ltlt] = +1.0e3;
}
for($ltlt=0;$ltlt<$num_ltlt;$ltlt++) {
  $ln = $ln_ltlt[$ltlt];
  $tn = $tn_ltlt[$ltlt];
  $lm = $lm_ltlt[$ltlt];
  $tm = $tm_ltlt[$ltlt];
  $qnmfile[$ltlt] = "qnm" . "_$spdf[$ln]$tn$spdf[$lm]$tm" . ".dat";
  open(OUT,">$qnmfile[$ltlt]");
  for($ir=0;$ir<$nmesh;$ir++) {
    $r = $rpos[$ir];
    $rrq = $rr_qnm[$ir][$ltlt];
    if($rrq > $rrq_max[$ltlt]) {$rrq_max[$ltlt] = $rrq;}
    if($rrq < $rrq_min[$ltlt]) {$rrq_min[$ltlt] = $rrq;}
    print OUT "$r $rrq\n";
  }
  close(OUT);
  for($l3idx=0;$l3idx<$num_l3_ltlt[$ltlt];$l3idx++) {
    $ltltl = $ltltl_ltlt_l3[$ltlt][$l3idx];
    $l3 = $l3_ltltl[$ltltl];
    $qpsfile[$ltltl] = "qps" . "_$spdf[$ln]$tn$spdf[$lm]$tm$spdf_capital[$l3]" . ".dat";
    open(OUT,">$qpsfile[$ltltl]");
    for($ir=0;$ir<$nmesh;$ir++) {
      $r = $rpos[$ir];
      $rrq = $rr_qps[$ir][$ltltl];
      if($rrq > $rrq_max[$ltlt]) {$rrq_max[$ltlt] = $rrq;}
      if($rrq < $rrq_min[$ltlt]) {$rrq_min[$ltlt] = $rrq;}
      print OUT "$r $rrq\n";
    }
    close(OUT);
  }
}

### Parameters
$ndiv_max = 5;

##### Deficit charge Q[nm](r) & Qps[nmL](r) #####
for($ltlt=0;$ltlt<$num_ltlt;$ltlt++) {
  $ln = $ln_ltlt[$ltlt];
  $tn = $tn_ltlt[$ltlt];
  $lm = $lm_ltlt[$ltlt];
  $tm = $tm_ltlt[$ltlt];
  $num_l3 = $num_l3_ltlt[$ltlt];
  open(OUT,">plot_qps");
  $rrq_file[$ltlt] = "$title" . "_rrq" . "_$spdf[$ln]$tn$spdf[$lm]$tm" . ".eps";
  print OUT "set output \"$rrq_file[$ltlt]\"\n";
  print OUT "set terminal postscript eps enhanced color solid \"Helvetica\" 12\n";
  print OUT "set xzeroaxis\n";
  print OUT "set border 31 lw 1\n";
  
  print OUT "set size 0.5,0.5\n";
  print OUT "set xtics 1\n";
  print OUT "set mxtics 1\n";
  for($j=0;($rrq_max[$ltlt]-$rrq_min[$ltlt])/$ntic[$j] > $ndiv_max;$j++) {next;}
  $ytics_guess = $ntic[$j];
  print OUT "set ytics $ytics_guess\n";
  print OUT "set mytics 2\n";
  print OUT "set format x \"%1.0f\"\n";
  #print OUT "set format y \"%2.0f\"\n";
  if($ytics_guess < 0.1) {
    print OUT "set format y \"%4.2f\"\n";
  } elsif($ytics_guess < 1) {
    print OUT "set format y \"%3.1f\"\n";
  } else {
    print OUT "set format y \"%2.0f\"\n";
  }
  print OUT "set xlabel \"r\"\n";
  print OUT "set ylabel \"r^{2}Q_{/Times-Italic nm}(r)\"\n";
  print OUT "plot [$rmin:$rmax] \\\n";
  print OUT "\"$qnmfile[$ltlt]\" u 1:2 t \"$spdf[$ln]$tn-$spdf[$lm]$tm\" w l lw 1, \\\n";
  for($l3idx=0;$l3idx<$num_l3;$l3idx++) {
    $ltltl = $ltltl_ltlt_l3[$ltlt][$l3idx];
    $l3 = $l3_ltltl[$ltltl];
    print OUT "\"$qpsfile[$ltltl]\" u 1:2 t \"L = $spdf[$l3]\" w l lw 4";
    if($l3idx<$num_l3-1) {
      print OUT ", \\\n";
    } else {
      print OUT "\n";
    }
  }
  `gnuplot plot_qps`;
  `\\rm plot_qps`;
  close(OUT);
  print "    outout ... $rrq_file[$ltlt]\n";
}

for($ltlt=0;$ltlt<$num_ltlt;$ltlt++) { `\\rm $qnmfile[$ltlt]`; }
for($ltltl=0;$ltltl<$num_ltltl;$ltltl++) { `\\rm $qpsfile[$ltltl]`; }

$is_generated_rrq = 1;
}

################################################################################
#//////////////////////////// Deficit charges (G) //////////////////////////////

if($have_deficit_charge_ggq == 1) {
print "*** Deficit charges (G) ***\n";

$gmax = 20;
$gmin =  0;
if($is_input_gmax == 1) {$gmax = $gmax_in;}

for($ltlt=0;$ltlt<$num_ltlt;$ltlt++) {
  $ggq_max[$ltlt] = -1.0e3;
  $ggq_min[$ltlt] = +1.0e3;
}
for($ltlt=0;$ltlt<$num_ltlt;$ltlt++) {
  $ln = $ln_ltlt[$ltlt];
  $tn = $tn_ltlt[$ltlt];
  $lm = $lm_ltlt[$ltlt];
  $tm = $tm_ltlt[$ltlt];
  $num_l3_ltlt[$ltlt] = $num_l3_nm[$ln][$tn][$lm][$tm];
  $qnmfile[$ltlt] = "qnm" . "_$spdf[$ln]$tn$spdf[$lm]$tm" . ".dat";
  open(OUT,">$qnmfile[$ltlt]");
  for($ig=0;$ig<$ng_mesh;$ig++) {
    $g = $gpos[$ig];
    $ggq = $gg_qnm[$ig][$ltlt];
    if($ggq > $ggq_max[$ltlt]) {$ggq_max[$ltlt] = $ggq;}
    if($ggq < $ggq_min[$ltlt]) {$ggq_min[$ltlt] = $ggq;}
    print OUT "$g $ggq\n";
  }
  close(OUT);
  for($l3idx=0;$l3idx<$num_l3_ltlt[$ltlt];$l3idx++) {
    $ltltl = $ltltl_ltlt_l3[$ltlt][$l3idx];
    $l3 = $l3_ltltl[$ltltl];
    $qpsfile[$ltltl] = "qps" . "_$spdf[$ln]$tn$spdf[$lm]$tm$spdf_capital[$l3]" . ".dat";
    open(OUT,">$qpsfile[$ltltl]");
    for($ig=0;$ig<$ng_mesh;$ig++) {
      $g = $gpos[$ig];
      $ggq = $gg_qps[$ig][$ltltl];
      if($ggq > $ggq_max[$ltlt]) {$ggq_max[$ltlt] = $ggq;}
      if($ggq < $ggq_min[$ltlt]) {$ggq_min[$ltlt] = $ggq;}
      print OUT "$g $ggq\n";
    }
    close(OUT);
  }
}

### Parameters
$ndiv_max = 5;

##### Deficit charge Q[nm](g) & Qps[nmL](g) #####
for($ltlt=0;$ltlt<$num_ltlt;$ltlt++) {
  $ln = $ln_ltlt[$ltlt];
  $tn = $tn_ltlt[$ltlt];
  $lm = $lm_ltlt[$ltlt];
  $tm = $tm_ltlt[$ltlt];
  $num_l3 = $num_l3_ltlt[$ltlt];
  open(OUT,">plot_qps");
  $ggq_file[$ltlt] = "$title" . "_ggq" . "_$spdf[$ln]$tn$spdf[$lm]$tm" . ".eps";
  print OUT "set output \"$ggq_file[$ltlt]\"\n";
  print OUT "set terminal postscript eps enhanced color solid \"Helvetica\" 12\n";
  print OUT "set xzeroaxis\n";
  print OUT "set border 31 lw 1\n";
  
  print OUT "set size 0.5,0.5\n";
  print OUT "set xtics 5\n";
  print OUT "set mxtics 5\n";
  for($j=0;($ggq_max[$ltlt]-$ggq_min[$ltlt])/$ntic[$j] > $ndiv_max;$j++) {next;}
  $ytics_guess = $ntic[$j];
  print OUT "set ytics $ytics_guess\n";
  print OUT "set mytics 2\n";
  print OUT "set format x \"%1.0f\"\n";
  #print OUT "set format y \"%2.0f\"\n";
  if($ytics_guess < 0.1) {
    print OUT "set format y \"%4.2f\"\n";
  } elsif($ytics_guess < 1) {
    print OUT "set format y \"%3.1f\"\n";
  } else {
    print OUT "set format y \"%2.0f\"\n";
  }
  print OUT "set xlabel \"q\"\n";
  print OUT "set ylabel \"q^{2}Q_{/Times-Italic nm}(q)\"\n";
  print OUT "plot [$gmin:$gmax] \\\n";
  print OUT "\"$qnmfile[$ltlt]\" u 1:2 t \"$spdf[$ln]$tn-$spdf[$lm]$tm\" w l lw 1, \\\n";
  for($l3idx=0;$l3idx<$num_l3;$l3idx++) {
    $ltltl = $ltltl_ltlt_l3[$ltlt][$l3idx];
    $l3 = $l3_ltltl[$ltltl];
    print OUT "\"$qpsfile[$ltltl]\" u 1:2 t \"L = $spdf[$l3]\" w l lw 4";
    if($l3idx<$num_l3-1) {
      print OUT ", \\\n";
    } else {
      print OUT "\n";
    }
  }
  `gnuplot plot_qps`;
  `\\rm plot_qps`;
  close(OUT);
  print "    outout ... $ggq_file[$ltlt]\n";
}

for($ltlt=0;$ltlt<$num_ltlt;$ltlt++) { `\\rm $qnmfile[$ltlt]`; }
for($ltltl=0;$ltltl<$num_ltltl;$ltltl++) { `\\rm $qpsfile[$ltltl]`; }

$is_generated_ggq = 1;
}

print "-----------------------------\n";
print " \$is_generated_rho     --> $is_generated_rho\n";
print " \$is_generated_vloc    --> $is_generated_vloc\n";
print " \$is_generated_rphi    --> $is_generated_rphi\n";
print " \$is_generated_gphi    --> $is_generated_gphi\n";
print " \$is_generated_rbeta   --> $is_generated_rbeta\n";
print " \$is_generated_gbeta   --> $is_generated_gbeta\n";
print " \$is_generated_ldr     --> $is_generated_ldr\n";
print " \$is_generated_ldr_std --> $is_generated_ldr_std\n";
print " \$is_generated_rrq     --> $is_generated_rrq\n";
print " \$is_generated_ggq     --> $is_generated_ggq\n";
print "-----------------------------\n";

################################################################################
#///////////////////////////////////////////////////////////////////////////////
#  generate a tex file

open(OUT,">layout.tex");
print OUT "\\documentclass[landscape,a4paper]{article}\n";
print OUT "\\usepackage{graphicx}\n";
print OUT "\\topmargin     = -25mm   \\headsep        =  15mm\n";
print OUT "\\oddsidemargin =   0mm   \\evensidemargin =   0mm\n";
print OUT "\\textwidth     = 235mm   \\textheight     = 170mm\n";
print OUT "\\unitlength    =   1mm\n";
print OUT "\\begin{document}\n";
print OUT "\\pagestyle{empty}\n";
### rphi, gphi, rbeta, gbeta
if($is_generated_rphi == 1 || $is_generated_gphi == 1 ||
   $is_generated_rbeta == 1 || $is_generated_gbeta == 1) {
print OUT "\\begin{figure}\n";
print OUT "  \\begin{center}\n";
print OUT "    \\begin{tabular}{cc}\n";
if($is_generated_rphi == 1 && $is_generated_gphi == 1) {
print OUT "      \\resizebox{120mm}{!}{\\includegraphics{$rphi_file}} &\n";
print OUT "      \\resizebox{120mm}{!}{\\includegraphics{$gphi_file}} \\\\\n";
} elsif($is_generated_rphi == 1) {
print OUT "      \\resizebox{120mm}{!}{\\includegraphics{$rphi_file}} & \\\\\n";
}
if($is_generated_rbeta == 1 && $is_generated_gbeta == 1) {
print OUT "      \\resizebox{120mm}{!}{\\includegraphics{$rbeta_file}} &\n";
print OUT "      \\resizebox{120mm}{!}{\\includegraphics{$gbeta_file}} \\\\\n";
} elsif($is_generated_rbeta == 1) {
print OUT "      \\resizebox{120mm}{!}{\\includegraphics{$rbeta_file}} & \\\\\n";
}
print OUT "    \\end{tabular}\n";
print OUT "  \\end{center}\n";
print OUT "\\end{figure}\n";
}
### ldr
if($is_generated_ldr == 1 || $is_generated_ldr_std == 1) {
print OUT "\\clearpage\n";
print OUT "\\begin{figure}\n";
print OUT "  \\begin{center}\n";
print OUT "    \\begin{tabular}{cc}\n";
if($is_generated_ldr == 1 && $is_generated_ldr_std == 1) {
print OUT "      \\resizebox{120mm}{!}{\\includegraphics{$ldr_file}} &\n";
print OUT "      \\resizebox{120mm}{!}{\\includegraphics{$ldr_std_file}} \\\\\n";
}
print OUT "    \\end{tabular}\n";
print OUT "  \\end{center}\n";
print OUT "\\end{figure}\n";
}
### rho_tot, rho_core, rho_val, rho_pcc, vloc
if($is_generated_rho == 1 || $is_generated_vloc == 1) {
print OUT "\\clearpage\n";
print OUT "\\begin{figure}\n";
print OUT "  \\begin{center}\n";
print OUT "    \\begin{tabular}{cc}\n";
if($is_generated_rho == 1 && $is_generated_vloc == 1) {
print OUT "      \\resizebox{120mm}{!}{\\includegraphics{$rho_file}} &\n";
print OUT "      \\resizebox{120mm}{!}{\\includegraphics{$vloc_file}} \\\\\n";
}
print OUT "    \\end{tabular}\n";
print OUT "  \\end{center}\n";
print OUT "\\end{figure}\n";
}
### rrq, ggq
if($is_generated_rrq == 1 || $is_generated_ggq == 1) {
for($i=0;$i<=int(($num_ltlt-1)/2);$i++) { $ltlt = 2*$i;
  print OUT "\\clearpage\n";
  print OUT "\\begin{figure}\n";
  print OUT "  \\begin{center}\n";
  print OUT "    \\begin{tabular}{cc}\n";
  if($is_generated_rrq == 1 && $is_generated_ggq == 1) {
    print OUT "      \\resizebox{120mm}{!}{\\includegraphics{$rrq_file[$ltlt]}} &\n";
    print OUT "      \\resizebox{120mm}{!}{\\includegraphics{$ggq_file[$ltlt]}} \\\\\n";
  } elsif($is_generated_rrq == 1) {
    print OUT "      \\resizebox{120mm}{!}{\\includegraphics{$rrq_file[$ltlt]}} & \\\\\n";
  }
  if($i < int(($num_ltlt-1)/2) || $num_ltlt - 2*int($num_ltlt/2) == 0) {
    if($is_generated_rrq == 1 && $is_generated_ggq == 1) {
      print OUT "      \\resizebox{120mm}{!}{\\includegraphics{$rrq_file[$ltlt+1]}} & \n";
      print OUT "      \\resizebox{120mm}{!}{\\includegraphics{$ggq_file[$ltlt+1]}} \\\\\n";
    } elsif($is_generated_rrq == 1) {
      print OUT "      \\resizebox{120mm}{!}{\\includegraphics{$rrq_file[$ltlt+1]}} & \\\\\n";
    }
  }
  print OUT "    \\end{tabular}\n";
  print OUT "  \\end{center}\n";
  print OUT "\\end{figure}\n";
}}
print OUT "\\end{document}\n";

################################################################################
#  Compile "layout.tex" to get "ciaopp_fig.pdf"

  print `latex layout`;
if($use_ps2pdf == 0) {
  print `dvipdfm -p a4 -l -o $title.pdf layout.dvi`;
} else {
  print `dvips layout.dvi -t landscape -o $title.ps`;
  print `ps2pdf $title.ps $title.pdf`;
  print `\\rm *.ps`;
}
print `\\rm layout*`;
