!
!  Software name : CIAO (Code for Investigating Atomic Orbitals)
!  Subroutine(s) : set_atom_label_name, set_cc_param, set_cc_core
!  Author(s)     : Masakuni Okamoto (August 25, 2003)
!
!
!  Contact address :  Phase System Consortium
!                     E-mail: phase_system@nims.go.jp URL https://azuma.nims.go.jp
!
!
!  The license of the code and contact address :
!  See the files, COPYRIGHT and LICENSE (or LICENSE_J.pdf)
!
!=====================================================================
   subroutine set_atom_label_name( &
      NATOM,is_core,zatom,atom_label,atom_name)
!=====================================================================
!
!  M. Okamoto
!
!---------------------------------------------------------------------
   implicit none
   integer,intent(in)        :: NATOM, is_core, zatom
   character(2),intent(out)  :: atom_label(NATOM)
   character(30),intent(out) :: atom_name(NATOM)
 if (is_core == 2) then
   if (zatom < 10) then
      write(atom_label(zatom),'(a1,i1)') 'P',zatom
   else
      write(atom_label(zatom),'(a1,a1)') 'P','X'
   end if
   atom_name(zatom) = 'Pseudo-atom'
 else
   atom_label( 1) = 'H ' ; atom_name( 1) = 'Hydrogen'
   atom_label( 2) = 'He' ; atom_name( 2) = 'Helium'
   atom_label( 3) = 'Li' ; atom_name( 3) = 'Lithium'
   atom_label( 4) = 'Be' ; atom_name( 4) = 'Beryllium'
   atom_label( 5) = 'B ' ; atom_name( 5) = 'Boron'
   atom_label( 6) = 'C ' ; atom_name( 6) = 'Carbon'
   atom_label( 7) = 'N ' ; atom_name( 7) = 'Nitrogen'
   atom_label( 8) = 'O ' ; atom_name( 8) = 'Oxygen'
   atom_label( 9) = 'F ' ; atom_name( 9) = 'Fluorine'
   atom_label(10) = 'Ne' ; atom_name(10) = 'Neon'
   atom_label(11) = 'Na' ; atom_name(11) = 'Sodium'
   atom_label(12) = 'Mg' ; atom_name(12) = 'Magnesium'
   atom_label(13) = 'Al' ; atom_name(13) = 'Aluminum'
   atom_label(14) = 'Si' ; atom_name(14) = 'Silicon'
   atom_label(15) = 'P ' ; atom_name(15) = 'Phosphorus'
   atom_label(16) = 'S ' ; atom_name(16) = 'Sulfur'
   atom_label(17) = 'Cl' ; atom_name(17) = 'Chlorine'
   atom_label(18) = 'Ar' ; atom_name(18) = 'Argon'
   atom_label(19) = 'K ' ; atom_name(19) = 'Potassium'
   atom_label(20) = 'Ca' ; atom_name(20) = 'Calcium'
   atom_label(21) = 'Sc' ; atom_name(21) = 'Scandium'
   atom_label(22) = 'Ti' ; atom_name(22) = 'Titanium'
   atom_label(23) = 'V ' ; atom_name(23) = 'Vanadium'
   atom_label(24) = 'Cr' ; atom_name(24) = 'Chromium'
   atom_label(25) = 'Mn' ; atom_name(25) = 'Manganese'
   atom_label(26) = 'Fe' ; atom_name(26) = 'Iron'
   atom_label(27) = 'Co' ; atom_name(27) = 'Cobalt'
   atom_label(28) = 'Ni' ; atom_name(28) = 'Nickel'
   atom_label(29) = 'Cu' ; atom_name(29) = 'Copper'
   atom_label(30) = 'Zn' ; atom_name(30) = 'Zinc'
   atom_label(31) = 'Ga' ; atom_name(31) = 'Gallium'
   atom_label(32) = 'Ge' ; atom_name(32) = 'Germanium'
   atom_label(33) = 'As' ; atom_name(33) = 'Arsenic'
   atom_label(34) = 'Se' ; atom_name(34) = 'Selenium'
   atom_label(35) = 'Br' ; atom_name(35) = 'Bromine'
   atom_label(36) = 'Kr' ; atom_name(36) = 'Krypton'
   atom_label(37) = 'Rb' ; atom_name(37) = 'Rubidium'
   atom_label(38) = 'Sr' ; atom_name(38) = 'Strontium'
   atom_label(39) = 'Y ' ; atom_name(39) = 'Yttrium'
   atom_label(40) = 'Zr' ; atom_name(40) = 'Zirconium'
   atom_label(41) = 'Nb' ; atom_name(41) = 'Niobium (Colombium)'
   atom_label(42) = 'Mo' ; atom_name(42) = 'Molybdenum'
   atom_label(43) = 'Tc' ; atom_name(43) = 'Technetium'
   atom_label(44) = 'Ru' ; atom_name(44) = 'Ruthenium'
   atom_label(45) = 'Rh' ; atom_name(45) = 'Rhodium'
   atom_label(46) = 'Pd' ; atom_name(46) = 'Palladium'
   atom_label(47) = 'Ag' ; atom_name(47) = 'Silver'
   atom_label(48) = 'Cd' ; atom_name(48) = 'Cadmium'
   atom_label(49) = 'In' ; atom_name(49) = 'Indium'
   atom_label(50) = 'Sn' ; atom_name(50) = 'Tin'
   atom_label(51) = 'Sb' ; atom_name(51) = 'Antimony'
   atom_label(52) = 'Te' ; atom_name(52) = 'Tellurium'
   atom_label(53) = 'I ' ; atom_name(53) = 'Iodine'
   atom_label(54) = 'Xe' ; atom_name(54) = 'Xenon'
   atom_label(55) = 'Cs' ; atom_name(55) = 'Caesium'
   atom_label(56) = 'Ba' ; atom_name(56) = 'Barium'
   atom_label(57) = 'La' ; atom_name(57) = 'Lanthanum'
   atom_label(58) = 'Ce' ; atom_name(58) = 'Cerium'
   atom_label(59) = 'Pr' ; atom_name(59) = 'Praseodymium'
   atom_label(60) = 'Nd' ; atom_name(60) = 'Neodymium'
   atom_label(61) = 'Pm' ; atom_name(61) = 'Promethium'
   atom_label(62) = 'Sm' ; atom_name(62) = 'Samarium'
   atom_label(63) = 'Eu' ; atom_name(63) = 'Europium'
   atom_label(64) = 'Gd' ; atom_name(64) = 'Gadolinium'
   atom_label(65) = 'Tb' ; atom_name(65) = 'Terbium'
   atom_label(66) = 'Dy' ; atom_name(66) = 'Dysprosium'
   atom_label(67) = 'Ho' ; atom_name(67) = 'Holmium'
   atom_label(68) = 'Er' ; atom_name(68) = 'Erbium'
   atom_label(69) = 'Tm' ; atom_name(69) = 'Thullium'
   atom_label(70) = 'Yb' ; atom_name(70) = 'Ytterbium'
   atom_label(71) = 'Lu' ; atom_name(71) = 'Lutetium'
   atom_label(72) = 'Hf' ; atom_name(72) = 'Hafnium'
   atom_label(73) = 'Ta' ; atom_name(73) = 'Tantalum'
   atom_label(74) = 'W ' ; atom_name(74) = 'Tungsten (Wolfram)'
   atom_label(75) = 'Re' ; atom_name(75) = 'Rhenium'
   atom_label(76) = 'Os' ; atom_name(76) = 'Osmium'
   atom_label(77) = 'Ir' ; atom_name(77) = 'Iridium'
   atom_label(78) = 'Pt' ; atom_name(78) = 'Platinum'
   atom_label(79) = 'Au' ; atom_name(79) = 'Gold'
   atom_label(80) = 'Hg' ; atom_name(80) = 'Mercury'
   atom_label(81) = 'Tl' ; atom_name(81) = 'Thallium'
   atom_label(82) = 'Pb' ; atom_name(82) = 'Lead'
   atom_label(83) = 'Bi' ; atom_name(83) = 'Bismuth'
   atom_label(84) = 'Po' ; atom_name(84) = 'Polonium'
   atom_label(85) = 'At' ; atom_name(85) = 'Astatine'
   atom_label(86) = 'Rn' ; atom_name(86) = 'Radon'
   atom_label(87) = 'Fr' ; atom_name(87) = 'Francium'
   atom_label(88) = 'Ra' ; atom_name(88) = 'Radium'
   atom_label(89) = 'Ac' ; atom_name(89) = 'Actinium'
   atom_label(90) = 'Th' ; atom_name(90) = 'Thorium'
   atom_label(91) = 'Pa' ; atom_name(91) = 'Protactinium'
   atom_label(92) = 'U ' ; atom_name(92) = 'Uranium'
   atom_label(93) = 'Np' ; atom_name(93) = 'Neptunium'
   atom_label(94) = 'Pu' ; atom_name(94) = 'Plutonium'
   atom_label(95) = 'Am' ; atom_name(95) = 'Americium'
   atom_label(96) = 'Cm' ; atom_name(96) = 'Curium'
   atom_label(97) = 'Bk' ; atom_name(97) = 'Berkelium'
   atom_label(98) = 'Cf' ; atom_name(98) = 'Californium'
   atom_label(99) = 'Es' ; atom_name(99) = 'Einsteinium'
   atom_label(100)= 'Fm' ; atom_name(100)= 'Fermium'
   atom_label(101)= 'Md' ; atom_name(101)= 'Mendelevium'
   atom_label(102)= 'No' ; atom_name(102)= 'Nobelium'
   atom_label(103)= 'Lr' ; atom_name(103)= 'Lawrencium'
   atom_label(104)= 'Rf' ; atom_name(104)= 'Rutherfordium'
   atom_label(105)= 'Db' ; atom_name(105)= 'Dubnium'
   atom_label(106)= 'Sg' ; atom_name(106)= 'Seaborgium'
   atom_label(107)= 'Bh' ; atom_name(107)= 'Bohrium'
   atom_label(108)= 'Hs' ; atom_name(108)= 'Hassium'
   atom_label(109)= 'Mt' ; atom_name(109)= 'Meitnerium'
   atom_label(110)= 'Ds' ; atom_name(110)= 'Darmstadtium'
   atom_label(111)= 'Rg' ; atom_name(111)= 'Roentgenium'
   atom_label(112)= 'ub' ; atom_name(112)= 'Ununbium'
   atom_label(113)= 'ut' ; atom_name(113)= 'Ununtrium'
   atom_label(114)= 'uq' ; atom_name(114)= 'Ununquadium'
   atom_label(115)= 'up' ; atom_name(115)= 'Ununpentium'
   atom_label(116)= 'uh' ; atom_name(116)= 'Ununhexium'
   atom_label(117)= 'us' ; atom_name(117)= 'Ununseptium'
   atom_label(118)= 'uo' ; atom_name(118)= 'Ununoctium'
   atom_label(119)= '  ' ; atom_name(119)= ''
   atom_label(120)= '  ' ; atom_name(120)= ''
 end if
   end subroutine set_atom_label_name

!=====================================================================
   subroutine set_cc_param(NATOM,cc_param)
!=====================================================================
!
!  M. Okamoto
!
!---------------------------------------------------------------------
   implicit none
   integer,intent(in)  :: NATOM
   real(8),intent(out) :: cc_param(NATOM,0:3)
   integer :: iatom
   cc_param(:,:) = 0.d0
   do iatom=1,2
      cc_param(iatom,0)= 3.0
      cc_param(iatom,1)= 3.6
      cc_param(iatom,2)= 3.6
   end do
   do iatom=3,3
      cc_param(iatom,0)= 2.0
      cc_param(iatom,1)= 3.0
      cc_param(iatom,2)= 3.5
   end do
   do iatom=4,10
      cc_param(iatom,0)= 1.8
      cc_param(iatom,1)= 3.0
      cc_param(iatom,2)= 3.5
   end do
   do iatom=11,11
      cc_param(iatom,0)= 2.0
      cc_param(iatom,1)= 1.8
      cc_param(iatom,2)= 3.5
   end do
   do iatom=12,18
      cc_param(iatom,0)= 1.8
      cc_param(iatom,1)= 1.45
      cc_param(iatom,2)= 2.2
   end do
   do iatom=19,30
      cc_param(iatom,0)= 1.8
      cc_param(iatom,1)= 1.6
      cc_param(iatom,2)= 3.0
   end do
   do iatom=31,36
      cc_param(iatom,0)= 1.8
      cc_param(iatom,1)= 1.7
      cc_param(iatom,2)= 2.0
   end do
   do iatom=37,48
      cc_param(iatom,0)= 1.8
      cc_param(iatom,1)= 1.7
      cc_param(iatom,2)= 1.6
   end do
   do iatom=49,54
      cc_param(iatom,0)= 1.6
      cc_param(iatom,1)= 1.7
      cc_param(iatom,2)= 2.0
   end do
   do iatom=55,55
      cc_param(iatom,0)= 1.8
      cc_param(iatom,1)= 1.7
      cc_param(iatom,2)= 1.45
      cc_param(iatom,3)= 4.5
   end do
   do iatom=56,56
      cc_param(iatom,0)= 1.8
      cc_param(iatom,1)= 1.7
      cc_param(iatom,2)= 1.45
      cc_param(iatom,3)= 3.0
   end do
   do iatom=57,71
      cc_param(iatom,0)= 1.45
      cc_param(iatom,1)= 1.6
      cc_param(iatom,2)= 1.45
      cc_param(iatom,3)= 3.0
   end do
   do iatom=72,80
      cc_param(iatom,0)= 1.6
      cc_param(iatom,1)= 1.6
      cc_param(iatom,2)= 1.45
      cc_param(iatom,3)= 3.0
   end do
!--- Au --- modified
   iatom=79
      cc_param(iatom,0)= 1.6
      cc_param(iatom,1)= 1.6
      cc_param(iatom,2)= 1.45
      cc_param(iatom,3)= 3.0
!---
   do iatom=81,86
      cc_param(iatom,0)= 1.6
      cc_param(iatom,1)= 1.7
      cc_param(iatom,2)= 2.2
      cc_param(iatom,3)= 3.0
   end do
   do iatom=87,87
      cc_param(iatom,0)= 1.6
      cc_param(iatom,1)= 1.6
      cc_param(iatom,2)= 1.45
      cc_param(iatom,3)= 4.5
   end do
   do iatom=88,94
      cc_param(iatom,0)= 1.6
      cc_param(iatom,1)= 1.6
      cc_param(iatom,2)= 1.45
      cc_param(iatom,3)= 2.0
   end do
   end subroutine set_cc_param

!=====================================================================
   subroutine set_cc_core(NATOM,cc_a1,cc_a2,cc_c1)
!=====================================================================
!
!  M. Okamoto
!
!---------------------------------------------------------------------
   implicit none
   integer,intent(in)  :: NATOM
   real(8),intent(out) :: cc_a1(NATOM), cc_a2(NATOM), cc_c1(NATOM)
   integer :: iatom
!--- Default
   do iatom = 1,NATOM
      cc_a1(iatom) = 0.d0
      cc_a2(iatom) = 0.d0
      cc_c1(iatom) = 0.5d0
   end do
!--- H
   iatom = 1
      cc_a1(iatom) = 16.2200d0
      cc_a2(iatom) =  5.5500d0
      cc_c1(iatom) =  1.1924d0
!--- He
   iatom = 2
      cc_a1(iatom) = 56.2300d0
      cc_a2(iatom) = 19.2400d0
      cc_c1(iatom) =  1.1998d0
!--- Li
   iatom = 3
      cc_a1(iatom) =  1.8400d0
      cc_a2(iatom) =  0.7300d0
      cc_c1(iatom) =  2.9081d0
!--- Be
   iatom = 4
      cc_a1(iatom) =  2.6100d0
      cc_a2(iatom) =  1.0000d0
      cc_c1(iatom) =  1.5280d0
!--- B
   iatom = 5
      cc_a1(iatom) =  6.2100d0
      cc_a2(iatom) =  2.4700d0
      cc_c1(iatom) =  1.6546d0
!--- C
   iatom = 6
      cc_a1(iatom) =  9.2800d0
      cc_a2(iatom) =  3.6900d0
      cc_c1(iatom) =  1.5222d0
!--- N
   iatom = 7
      cc_a1(iatom) = 12.8700d0
      cc_a2(iatom) =  5.1200d0
      cc_c1(iatom) =  1.4504d0
!--- O
   iatom = 8
      cc_a1(iatom) = 18.0900d0
      cc_a2(iatom) =  7.1900d0
      cc_c1(iatom) =  1.4224d0
!--- F
   iatom = 9
      cc_a1(iatom) = 23.7800d0
      cc_a2(iatom) =  9.4500d0
      cc_c1(iatom) =  1.3974d0
!--- Ne
   iatom = 10
      cc_a1(iatom) = 29.1300d0
      cc_a2(iatom) = 11.5800d0
      cc_c1(iatom) =  1.3711d0
!--- Na
   iatom = 11
      cc_a1(iatom) =  1.7100d0
      cc_a2(iatom) =  0.5000d0
      cc_c1(iatom) =  5.1815d0
!--- Mg
   iatom = 12
      cc_a1(iatom) =  2.0400d0
      cc_a2(iatom) =  0.8100d0
      cc_c1(iatom) =  3.5602d0
!--- Al
   iatom = 13
      cc_a1(iatom) =  1.7700d0
      cc_a2(iatom) =  0.7000d0
      cc_c1(iatom) =  1.7905d0
!--- Si
   iatom = 14
      cc_a1(iatom) =  2.1600d0
      cc_a2(iatom) =  0.8600d0
      cc_c1(iatom) =  1.6054d0
!--- P
   iatom = 15
      cc_a1(iatom) =  2.5900d0
      cc_a2(iatom) =  1.0300d0
      cc_c1(iatom) =  1.4995d0
!--- S
   iatom = 16
      cc_a1(iatom) =  2.9900d0
      cc_a2(iatom) =  1.1900d0
      cc_c1(iatom) =  1.4261d0
!--- Cl
   iatom = 17
      cc_a1(iatom) =  3.4800d0
      cc_a2(iatom) =  1.3800d0
      cc_c1(iatom) =  1.3860d0
!--- Ar
   iatom = 18
      cc_a1(iatom) =  3.9900d0
      cc_a2(iatom) =  1.5900d0
      cc_c1(iatom) =  1.3622d0
!--- K
   iatom = 19
      cc_a1(iatom) =  3.9900d0
      cc_a2(iatom) =  1.5900d0
      cc_c1(iatom) =  1.3622d0
!--- Ca
   iatom = 20
      cc_a1(iatom) =  1.6100d0
      cc_a2(iatom) =  0.4500d0
      cc_c1(iatom) =  4.8360d0
!--- Sc
   iatom = 21
      cc_a1(iatom) =  3.9600d0
      cc_a2(iatom) =  0.6900d0
      cc_c1(iatom) =  3.7703d0
!--- Ti
   iatom = 22
      cc_a1(iatom) =  4.6800d0
      cc_a2(iatom) =  0.9400d0
      cc_c1(iatom) =  3.3889d0
!--- V
   iatom = 23
      cc_a1(iatom) =  5.1400d0
      cc_a2(iatom) =  1.1100d0
      cc_c1(iatom) =  2.9680d0
!--- Cr
   iatom = 24
      cc_a1(iatom) =  5.1900d0
      cc_a2(iatom) =  1.3700d0
      cc_c1(iatom) =  2.8897d0
!--- Mn
   iatom = 25
      cc_a1(iatom) =  6.0300d0
      cc_a2(iatom) =  1.6300d0
      cc_c1(iatom) =  2.7024d0
!--- Fe
   iatom = 26
      cc_a1(iatom) =  6.5100d0
      cc_a2(iatom) =  1.9100d0
      cc_c1(iatom) =  2.6179d0
!--- Co
   iatom = 27
      cc_a1(iatom) =  6.9500d0
      cc_a2(iatom) =  2.3800d0
      cc_c1(iatom) =  2.7407d0
!--- Ni
   iatom = 28
      cc_a1(iatom) =  7.6000d0
      cc_a2(iatom) =  2.7400d0
      cc_c1(iatom) =  2.6949d0
!--- Cu
   iatom = 29
      cc_a1(iatom) =  7.5900d0
      cc_a2(iatom) =  3.0200d0
      cc_c1(iatom) =  2.6959d0
!--- Zn
   iatom = 30
      cc_a1(iatom) =  8.7800d0
      cc_a2(iatom) =  3.4900d0
      cc_c1(iatom) =  2.6313d0
!--- Ga
   iatom = 31
      cc_a1(iatom) =  2.0100d0
      cc_a2(iatom) =  0.8000d0
      cc_c1(iatom) =  4.0433d0
!--- Ge
   iatom = 32
      cc_a1(iatom) =  2.2800d0
      cc_a2(iatom) =  0.9100d0
      cc_c1(iatom) =  3.1110d0
!--- As
   iatom = 33
      cc_a1(iatom) =  2.6000d0
      cc_a2(iatom) =  1.0300d0
      cc_c1(iatom) =  2.6218d0
!--- Se
   iatom = 34
      cc_a1(iatom) =  2.8800d0
      cc_a2(iatom) =  1.1400d0
      cc_c1(iatom) =  2.2934d0
!--- Br
   iatom = 35
      cc_a1(iatom) =  3.2000d0
      cc_a2(iatom) =  1.2700d0
      cc_c1(iatom) =  2.1007d0
!--- Kr
   iatom = 36
      cc_a1(iatom) =  3.4900d0
      cc_a2(iatom) =  1.3900d0
      cc_c1(iatom) =  1.9478d0
!--- Rb
   iatom = 37
      cc_a1(iatom) =  1.3700d0
      cc_a2(iatom) =  0.2100d0
      cc_c1(iatom) =  6.8301d0
!--- Sr
   iatom = 38
      cc_a1(iatom) =  1.5200d0
      cc_a2(iatom) =  0.3300d0
      cc_c1(iatom) =  4.8514d0
!--- Y
   iatom = 39
      cc_a1(iatom) =  2.0600d0
      cc_a2(iatom) =  0.4900d0
      cc_c1(iatom) =  4.1719d0
!--- Zr
   iatom = 40
      cc_a1(iatom) =  2.2800d0
      cc_a2(iatom) =  0.6600d0
      cc_c1(iatom) =  3.9162d0
!--- Nb
   iatom = 41
      cc_a1(iatom) =  2.4100d0
      cc_a2(iatom) =  0.8200d0
      cc_c1(iatom) =  3.7419d0
!--- Mo
   iatom = 42
      cc_a1(iatom) =  2.5700d0
      cc_a2(iatom) =  1.0200d0
      cc_c1(iatom) =  3.8044d0
!--- Tc
   iatom = 43
      cc_a1(iatom) =  2.8200d0
      cc_a2(iatom) =  1.1200d0
      cc_c1(iatom) =  3.3669d0
!--- Ru
   iatom = 44
      cc_a1(iatom) =  3.0000d0
      cc_a2(iatom) =  1.1900d0
      cc_c1(iatom) =  3.0213d0
!--- Rh
   iatom = 45
      cc_a1(iatom) =  3.2100d0
      cc_a2(iatom) =  1.2800d0
      cc_c1(iatom) =  2.7857d0
!--- Pd
   iatom = 46
      cc_a1(iatom) =  3.3100d0
      cc_a2(iatom) =  1.3200d0
      cc_c1(iatom) =  2.5256d0
!--- Ag
   iatom = 47
      cc_a1(iatom) =  3.5300d0
      cc_a2(iatom) =  1.4100d0
      cc_c1(iatom) =  2.3857d0
!--- Cd
   iatom = 48
      cc_a1(iatom) =  3.9100d0
      cc_a2(iatom) =  1.5600d0
      cc_c1(iatom) =  2.3128d0
!--- In
   iatom = 49
      cc_a1(iatom) =  1.7900d0
      cc_a2(iatom) =  0.7100d0
      cc_c1(iatom) =  6.7251d0
!--- Sn
   iatom = 50
      cc_a1(iatom) =  1.9700d0
      cc_a2(iatom) =  0.7800d0
      cc_c1(iatom) =  5.0086d0
!--- Sb
   iatom = 51
      cc_a1(iatom) =  2.1200d0
      cc_a2(iatom) =  0.8500d0
      cc_c1(iatom) =  4.0534d0
!--- Te
   iatom = 52
      cc_a1(iatom) =  2.3700d0
      cc_a2(iatom) =  0.9500d0
      cc_c1(iatom) =  3.5696d0
!--- I
   iatom = 53
      cc_a1(iatom) =  2.5200d0
      cc_a2(iatom) =  1.0100d0
      cc_c1(iatom) =  3.0856d0
!--- Xe
   iatom = 54
      cc_a1(iatom) =  2.6300d0
      cc_a2(iatom) =  1.0500d0
      cc_c1(iatom) =  2.6837d0
!--- Cs
   iatom = 55
      cc_a1(iatom) =  2.6300d0
      cc_a2(iatom) =  1.0500d0
      cc_c1(iatom) =  2.6837d0
!--- Ba
   iatom = 56
      cc_a1(iatom) =  1.3400d0
      cc_a2(iatom) =  0.2500d0
      cc_c1(iatom) =  5.3338d0
!--- La
   iatom = 57
      cc_a1(iatom) =  5.0000d0
      cc_a2(iatom) =  2.0000d0
      cc_c1(iatom) =  3.2494d0
!--- Ce
   iatom = 58
      cc_a1(iatom) =  5.3200d0
      cc_a2(iatom) =  2.1300d0
      cc_c1(iatom) =  3.0538d0
!--- Pr
   iatom = 59
      cc_a1(iatom) =  5.5300d0
      cc_a2(iatom) =  2.2100d0
      cc_c1(iatom) =  2.8422d0
!--- Nd
   iatom = 60
      cc_a1(iatom) =  5.6900d0
      cc_a2(iatom) =  2.2800d0
      cc_c1(iatom) =  2.8422d0
!--- Pm
   iatom = 61
      cc_a1(iatom) =  5.9100d0
      cc_a2(iatom) =  2.3600d0
      cc_c1(iatom) =  2.5202d0
!--- Sm
   iatom = 62
      cc_a1(iatom) =  6.0700d0
      cc_a2(iatom) =  2.4300d0
      cc_c1(iatom) =  2.3958d0
!--- Eu
   iatom = 63
      cc_a1(iatom) =  6.2400d0
      cc_a2(iatom) =  2.5000d0
      cc_c1(iatom) =  2.2886d0
!--- Gd
   iatom = 64
      cc_a1(iatom) =  6.4700d0
      cc_a2(iatom) =  2.5900d0
      cc_c1(iatom) =  2.2076d0
!--- Tb
   iatom = 65
      cc_a1(iatom) =  7.1500d0
      cc_a2(iatom) =  2.8600d0
      cc_c1(iatom) =  2.2267d0
!--- Dy
   iatom = 66
      cc_a1(iatom) =  7.3400d0
      cc_a2(iatom) =  2.9400d0
      cc_c1(iatom) =  2.1510d0
!--- Ho
   iatom = 67
      cc_a1(iatom) =  7.6100d0
      cc_a2(iatom) =  3.0400d0
      cc_c1(iatom) =  2.0909d0
!--- Er
   iatom = 68
      cc_a1(iatom) =  7.8100d0
      cc_a2(iatom) =  3.1200d0
      cc_c1(iatom) =  2.0304d0
!--- Tm
   iatom = 69
      cc_a1(iatom) =  8.0000d0
      cc_a2(iatom) =  3.2000d0
      cc_c1(iatom) =  1.9772d0
!--- Yb
   iatom = 70
      cc_a1(iatom) =  8.2100d0
      cc_a2(iatom) =  3.2800d0
      cc_c1(iatom) =  1.9271d0
!--- Lu
   iatom = 71
      cc_a1(iatom) =  8.5000d0
      cc_a2(iatom) =  3.4000d0
      cc_c1(iatom) =  1.8919d0
!--- Hf
   iatom = 72
      cc_a1(iatom) =  2.0200d0
      cc_a2(iatom) =  0.8000d0
      cc_c1(iatom) =  5.8921d0
!--- Ta
   iatom = 73
      cc_a1(iatom) =  2.1600d0
      cc_a2(iatom) =  0.8600d0
      cc_c1(iatom) =  4.7264d0
!--- W
   iatom = 74
      cc_a1(iatom) =  2.2600d0
      cc_a2(iatom) =  0.9000d0
      cc_c1(iatom) =  3.9028d0
!--- Re
   iatom = 75
      cc_a1(iatom) =  2.4400d0
      cc_a2(iatom) =  0.9800d0
      cc_c1(iatom) =  3.5075d0
!--- Os
   iatom = 76
      cc_a1(iatom) =  2.4700d0
      cc_a2(iatom) =  0.9900d0
      cc_c1(iatom) =  2.9996d0
!--- Ir
   iatom = 77
      cc_a1(iatom) =  2.6700d0
      cc_a2(iatom) =  1.0700d0
      cc_c1(iatom) =  2.8089d0
!--- Pt
   iatom = 78
      cc_a1(iatom) =  2.7100d0
      cc_a2(iatom) =  1.0800d0
      cc_c1(iatom) =  2.5166d0
!--- Au
   iatom = 79
      cc_a1(iatom) =  2.8500d0
      cc_a2(iatom) =  1.1400d0
      cc_c1(iatom) =  2.3778d0
!--- Hg
   iatom = 80
      cc_a1(iatom) =  2.9900d0
      cc_a2(iatom) =  1.2000d0
      cc_c1(iatom) =  2.2533d0
!--- Tl
   iatom = 81
      cc_a1(iatom) =  1.7700d0
      cc_a2(iatom) =  0.5900d0
      cc_c1(iatom) =  6.7158d0
!--- Pb
   iatom = 82
      cc_a1(iatom) =  1.9200d0
      cc_a2(iatom) =  0.7600d0
      cc_c1(iatom) =  6.5444d0
!--- Bi
   iatom = 83
      cc_a1(iatom) =  2.0300d0
      cc_a2(iatom) =  0.8100d0
      cc_c1(iatom) =  5.2104d0
!--- Po
   iatom = 84
      cc_a1(iatom) =  2.1700d0
      cc_a2(iatom) =  0.8700d0
      cc_c1(iatom) =  4.4190d0
!--- At
   iatom = 85
      cc_a1(iatom) =  2.2900d0
      cc_a2(iatom) =  0.9200d0
      cc_c1(iatom) =  3.8179d0
!--- Rn
   iatom = 86
      cc_a1(iatom) =  2.4500d0
      cc_a2(iatom) =  0.9800d0
      cc_c1(iatom) =  3.4235d0
!--- Fr
   iatom = 87
      cc_a1(iatom) =  1.2300d0
      cc_a2(iatom) =  0.1600d0
      cc_c1(iatom) =  8.4416d0
!--- Ra
   iatom = 88
      cc_a1(iatom) =  0.9900d0
      cc_a2(iatom) =  0.2400d0
      cc_c1(iatom) =  6.1114d0
!--- Ac
   iatom = 89
      cc_a1(iatom) =  1.4900d0
      cc_a2(iatom) =  0.3100d0
      cc_c1(iatom) =  4.7270d0
!--- Th
   iatom = 90
      cc_a1(iatom) =  1.5900d0
      cc_a2(iatom) =  0.4000d0
      cc_c1(iatom) =  4.3902d0
!--- Pa
   iatom = 91
      cc_a1(iatom) =  2.0600d0
      cc_a2(iatom) =  0.4500d0
      cc_c1(iatom) =  3.8349d0
!--- U
   iatom = 92
      cc_a1(iatom) =  2.0800d0
      cc_a2(iatom) =  0.5000d0
      cc_c1(iatom) =  3.5183d0
!--- Np
   iatom = 93
      cc_a1(iatom) =  2.7200d0
      cc_a2(iatom) =  0.6000d0
      cc_c1(iatom) =  3.5099d0
!--- Pu
   iatom = 94
      cc_a1(iatom) =  2.7600d0
      cc_a2(iatom) =  0.6200d0
      cc_c1(iatom) =  3.1671d0
   end subroutine set_cc_core

!=====================================================================
   subroutine set_dist_nn_ang(NATOM,dist_nn_ang)
!=====================================================================
!
!  M. Okamoto
!
!---------------------------------------------------------------------
   implicit none
   integer,intent(in)  :: NATOM
   real(8),intent(out) :: dist_nn_ang(NATOM)
   integer :: iatom
!--- Default
   do iatom = 1,NATOM
      dist_nn_ang(iatom) = 8.d0
   end do
!--- H (H2 --> 0.74085)
   iatom = 1
      dist_nn_ang(iatom) = 0.74085d0
!--- He
   iatom = 2
      dist_nn_ang(iatom) = 0.d0
!--- Li (Li2 --> 2.6723)
   iatom = 3
      dist_nn_ang(iatom) = 3.023d0
!--- Be (Be2 --> 2.4924)
   iatom = 4
      dist_nn_ang(iatom) = 2.22d0
!--- B (B2 --> 1.6087)
   iatom = 5
      dist_nn_ang(iatom) = 1.6087d0
!--- C (C2 --> 1.2436)
   iatom = 6
      dist_nn_ang(iatom) = 1.54d0
!--- N (N2 --> 1.0954)
   iatom = 7
      dist_nn_ang(iatom) = 1.0954d0
!--- O (O2 --> 1.2065)
   iatom = 8
      dist_nn_ang(iatom) = 1.2065d0
!--- F (F2 --> 1.4182)
   iatom = 9
      dist_nn_ang(iatom) = 1.44d0
!--- Ne
   iatom = 10
      dist_nn_ang(iatom) = 3.16d0
!--- Na (Na2 --> 3.0798)
   iatom = 11
      dist_nn_ang(iatom) = 3.659d0
!--- Mg
   iatom = 12
      dist_nn_ang(iatom) = 3.20d0
!--- Al (Al2 --> 2.4660)
   iatom = 13
      dist_nn_ang(iatom) = 2.86d0
!--- Si (Si2 --> 2.2437)
   iatom = 14
      dist_nn_ang(iatom) = 2.35d0
!--- P (P2 --> 1.8945)
   iatom = 15
      dist_nn_ang(iatom) = 1.8945d0
!--- S (S2 --> 1.8892)
   iatom = 16
      dist_nn_ang(iatom) = 1.8892d0
!--- Cl (Cl2 --> 1.9897)
   iatom = 17
      dist_nn_ang(iatom) = 2.02d0
!--- Ar
   iatom = 18
      dist_nn_ang(iatom) = 3.76d0
!--- K
   iatom = 19
      dist_nn_ang(iatom) = 4.525d0
!--- Ca
   iatom = 20
      dist_nn_ang(iatom) = 3.95d0
!--- Sc
   iatom = 21
      dist_nn_ang(iatom) = 3.25d0
!--- Ti
   iatom = 22
      dist_nn_ang(iatom) = 2.89d0
!--- V
   iatom = 23
      dist_nn_ang(iatom) = 2.62d0
!--- Cr (Cr2 --> 1.6775)
   iatom = 24
      dist_nn_ang(iatom) = 2.50d0
!--- Mn
   iatom = 25
      dist_nn_ang(iatom) = 2.24d0
!--- Fe
   iatom = 26
      dist_nn_ang(iatom) = 2.48d0
!--- Co
   iatom = 27
      dist_nn_ang(iatom) = 2.50d0
!--- Ni
   iatom = 28
      dist_nn_ang(iatom) = 2.49d0
!--- Cu (Cu2 --> 2.2225)
   iatom = 29
      dist_nn_ang(iatom) = 2.56d0
!--- Zn
   iatom = 30
      dist_nn_ang(iatom) = 2.66d0
!--- Ga
   iatom = 31
      dist_nn_ang(iatom) = 2.44d0
!--- Ge
   iatom = 32
      dist_nn_ang(iatom) = 2.45d0
!--- As
   iatom = 33
      dist_nn_ang(iatom) = 3.16d0
!--- Se
   iatom = 34
      dist_nn_ang(iatom) = 2.32d0
!--- Br
   iatom = 35
      dist_nn_ang(iatom) = 0.d0
!--- Kr
   iatom = 36
      dist_nn_ang(iatom) = 4.00d0
!--- Rb
   iatom = 37
      dist_nn_ang(iatom) = 4.837d0
!--- Sr
   iatom = 38
      dist_nn_ang(iatom) = 4.30d0
!--- Y
   iatom = 39
      dist_nn_ang(iatom) = 3.55d0
!--- Zr
   iatom = 40
      dist_nn_ang(iatom) = 3.17d0
!--- Nb
   iatom = 41
      dist_nn_ang(iatom) = 2.86d0
!--- Mo (Mo2 --> 1.9315)
   iatom = 42
      dist_nn_ang(iatom) = 2.72d0
!--- Tc
   iatom = 43
      dist_nn_ang(iatom) = 2.71d0
!--- Ru
   iatom = 44
      dist_nn_ang(iatom) = 2.65d0
!--- Rh
   iatom = 45
      dist_nn_ang(iatom) = 2.69d0
!--- Pd
   iatom = 46
      dist_nn_ang(iatom) = 2.75d0
!--- Ag
   iatom = 47
      dist_nn_ang(iatom) = 2.89d0
!--- Cd
   iatom = 48
      dist_nn_ang(iatom) = 2.98d0
!--- In
   iatom = 49
      dist_nn_ang(iatom) = 3.25d0
!--- Sn
   iatom = 50
      dist_nn_ang(iatom) = 2.81d0
!--- Sb
   iatom = 51
      dist_nn_ang(iatom) = 2.91d0
!--- Te
   iatom = 52
      dist_nn_ang(iatom) = 2.86d0
!--- I
   iatom = 53
      dist_nn_ang(iatom) = 3.54d0
!--- Xe
   iatom = 54
      dist_nn_ang(iatom) = 4.34d0
!--- Cs
   iatom = 55
      dist_nn_ang(iatom) = 5.235d0
!--- Ba
   iatom = 56
      dist_nn_ang(iatom) = 4.35d0
!--- La
   iatom = 57
      dist_nn_ang(iatom) = 3.73d0
!--- Ce
   iatom = 58
      dist_nn_ang(iatom) = 3.65d0
!--- Pr
   iatom = 59
      dist_nn_ang(iatom) = 3.63d0
!--- Nd
   iatom = 60
      dist_nn_ang(iatom) = 3.66d0
!--- Pm
   iatom = 61
      dist_nn_ang(iatom) = 0.d0
!--- Sm
   iatom = 62
      dist_nn_ang(iatom) = 3.59d0
!--- Eu
   iatom = 63
      dist_nn_ang(iatom) = 3.96d0
!--- Gd
   iatom = 64
      dist_nn_ang(iatom) = 3.58d0
!--- Tb
   iatom = 65
      dist_nn_ang(iatom) = 3.52d0
!--- Dy
   iatom = 66
      dist_nn_ang(iatom) = 3.51d0
!--- Ho
   iatom = 67
      dist_nn_ang(iatom) = 3.49d0
!--- Er
   iatom = 68
      dist_nn_ang(iatom) = 3.47d0
!--- Tm
   iatom = 69
      dist_nn_ang(iatom) = 3.54d0
!--- Yb
   iatom = 70
      dist_nn_ang(iatom) = 3.88d0
!--- Lu
   iatom = 71
      dist_nn_ang(iatom) = 3.43d0
!--- Hf
   iatom = 72
      dist_nn_ang(iatom) = 3.13d0
!--- Ta
   iatom = 73
      dist_nn_ang(iatom) = 2.86d0
!--- W
   iatom = 74
      dist_nn_ang(iatom) = 2.74d0
!--- Re
   iatom = 75
      dist_nn_ang(iatom) = 2.74d0
!--- Os
   iatom = 76
      dist_nn_ang(iatom) = 2.68d0
!--- Ir
   iatom = 77
      dist_nn_ang(iatom) = 2.71d0
!--- Pt
   iatom = 78
      dist_nn_ang(iatom) = 2.77d0
!--- Au
   iatom = 79
      dist_nn_ang(iatom) = 2.88d0
!--- Hg
   iatom = 80
      dist_nn_ang(iatom) = 3.01d0
!--- Tl
   iatom = 81
      dist_nn_ang(iatom) = 3.46d0
!--- Pb
   iatom = 82
      dist_nn_ang(iatom) = 3.50d0
!--- Bi
   iatom = 83
      dist_nn_ang(iatom) = 3.07d0
!--- Po
   iatom = 84
      dist_nn_ang(iatom) = 3.34d0
!--- At
   iatom = 85
      dist_nn_ang(iatom) = 0.d0
!--- Rn
   iatom = 86
      dist_nn_ang(iatom) = 0.d0
!--- Fr
   iatom = 87
      dist_nn_ang(iatom) = 0.d0
!--- Ra
   iatom = 88
      dist_nn_ang(iatom) = 0.d0
!--- Ac
   iatom = 89
      dist_nn_ang(iatom) = 3.76d0
!--- Th
   iatom = 90
      dist_nn_ang(iatom) = 3.60d0
!--- Pa
   iatom = 91
      dist_nn_ang(iatom) = 3.21d0
!--- U
   iatom = 92
      dist_nn_ang(iatom) = 2.75d0
!--- Np
   iatom = 93
      dist_nn_ang(iatom) = 2.62d0
!--- Pu
   iatom = 94
      dist_nn_ang(iatom) = 3.1d0
!--- Am
   iatom = 95
      dist_nn_ang(iatom) = 3.61d0
!--- Cm
   iatom = 96
      dist_nn_ang(iatom) = 0.d0
!--- Bk
   iatom = 97
      dist_nn_ang(iatom) = 0.d0
!--- Cf
   iatom = 98
      dist_nn_ang(iatom) = 0.d0
!--- Es
   iatom = 99
      dist_nn_ang(iatom) = 0.d0
!--- Fm
   iatom = 100
      dist_nn_ang(iatom) = 0.d0
!--- Md
   iatom = 101
      dist_nn_ang(iatom) = 0.d0
!--- No
   iatom = 102
      dist_nn_ang(iatom) = 0.d0
!--- Lr
   iatom = 103
      dist_nn_ang(iatom) = 0.d0
!--- Rf
   iatom = 104
      dist_nn_ang(iatom) = 0.d0
!--- Db
   iatom = 105
      dist_nn_ang(iatom) = 0.d0
!--- Sg
   iatom = 106
      dist_nn_ang(iatom) = 0.d0
!--- Bh
   iatom = 107
      dist_nn_ang(iatom) = 0.d0
!--- Hs
   iatom = 108
      dist_nn_ang(iatom) = 0.d0
!--- Mt
   iatom = 109
      dist_nn_ang(iatom) = 0.d0
!--- Ds
   iatom = 110
      dist_nn_ang(iatom) = 0.d0
!--- Rg
   iatom = 111
      dist_nn_ang(iatom) = 0.d0
!--- Uub
   iatom = 112
      dist_nn_ang(iatom) = 0.d0
!--- Uut
   iatom = 113
      dist_nn_ang(iatom) = 0.d0
!--- Uuq
   iatom = 114
      dist_nn_ang(iatom) = 0.d0
!--- Uup
   iatom = 115
      dist_nn_ang(iatom) = 0.d0
!--- Uuh
   iatom = 116
      dist_nn_ang(iatom) = 0.d0
!--- Uus
   iatom = 117
      dist_nn_ang(iatom) = 0.d0
!--- Uuo
   iatom = 118
      dist_nn_ang(iatom) = 0.d0
   end subroutine set_dist_nn_ang
