#!/usr/bin/perl
#
#  Copyright (C) 2003-2005 Masakuni Okamoto.
#
#  This script was written by Masakuni Okamoto.
#
#  Last update: January 22, 2005.
#
################################################################################
#/////////////////////////// Solved eigen-functions ////////////////////////////

$rmin = 0;
$rmax = 5;

@lang = ('s','p','d','f');
@ntic = (0.01,0.02,0.05,0.1,0.2,0.5,1,2,5,10,20,50,100,200,500,1000);

$nc_min = 0;
$nc_max = 0;
$nv_min = 0;
$nv_max = 0;
$vloc_min = +1.0e3;
$vloc_max = -1.0e3;
$rphi_min = +1.0e3;
$rphi_max = -1.0e3;

################################################################################
#  Read data from a command-line

if(@ARGV<1) {
  print "Usage: print_eps_sol FileTitle [--formatted]\n";
  exit(0);
} else {
  $is_formatted = 0;
  foreach $s (@ARGV) {
    if($s =~/--formatted/ || $s =~/-f/) {
      $is_formatted = 1;
    }
  }
}

################################################################################
#  Read data from a file

print "*** Solved eigen-functions ***\n";
print "@ARGV\n";
$infile = "$ARGV[0]" . ".sol";
print "<IN> = $infile\n";
if(! -e "$infile") {
  print "#############################################################\n";
  print "##   File not exists  -->  $infile\n";
  print "##   Please prepare the missing file.\n";
  print "#############################################################\n";
  exit(1);
} else {
  print "File exists --> $infile\n";
}
open(IN,"<$infile");
while($line = <IN>) {
  if($line =~/Element/) {
    ($element) = split(' ',$line);
    print "$element\n";
  } elsif($line =~/nmesh/) {
    ($nmesh) = split(':',$line);
    print "$nmesh\n";
    last;
  }
}
while($line = <IN>) {
  if($line =~/rpos/) {
    $file0 = "rho" . "_sol" . "_$element" . ".dat";
    print "   file = $file0\n";
    open(OUT,">$file0");
    for($i=0;$i<$nmesh-1;$i++) {
      ($rpos,$rho_ae,$rho_sol,$vloc_ion,$vh_sol,$vxc_sol) = split(' ',<IN>);
      $rho_core = $rho_ae - $rho_sol;
      $vloc_scr = $vloc_ion + $vh_sol + $vxc_sol;
      if($rho_core > $nc_max) {$nc_max = $rho_core;}
      if($rho_core < $nc_min) {$nc_min = $rho_core;}
      if($rho_sol > $nv_max) {$nv_max = $rho_sol;}
      if($rho_sol < $nv_min) {$nv_min = $rho_sol;}
      if($vloc_scr > $vloc_max) {$vloc_max = $vloc_scr;}
      if($vloc_scr < $vloc_min) {$vloc_min = $vloc_scr;}
      if($vloc_ion > $vloc_max) {$vloc_max = $vloc_ion;}
      if($vloc_ion < $vloc_min) {$vloc_min = $vloc_ion;}
      if($vh_sol > $vloc_max) {$vloc_max = $vh_sol;}
      if($vh_sol < $vloc_min) {$vloc_min = $vh_sol;}
      if($vxc_sol > $vloc_max) {$vloc_max = $vxc_sol;}
      if($vxc_sol < $vloc_min) {$vloc_min = $vxc_sol;}
      print OUT "$rpos $rho_ae $rho_core $rho_sol $vloc_scr $vloc_ion $vh_sol $vxc_sol\n";
    }
    close(OUT);
    last;
  }
}
$m=0;
while($line = <IN>) {
  if($line =~/n, l, 2/) {
    ($n,$l,$j2,$s) = split(' ',$line);
    $nn[$m] = $n;
    $ll[$m] = $l;
    print "$n$lang[$l], $j2, $s\n";
  } elsif($line =~/elevel/) {
    ($elevel[$m]) = split(':',$line);
    print "   Eigenvalue: $elevel[$m]\n";
  } elsif($line =~/rpos/) {
    $file[$m] = "phi" . "_sol" . "_$element" . "_$n$lang[$l]" . ".dat";
    print "   file = $file[$m]\n";
    open(OUT,">$file[$m]");
    for($i=0;$i<$nmesh-1;$i++) {
      ($rpos,$rphi_sol) = split(' ',<IN>);
      if($rphi_sol > $rphi_max) {$rphi_max = $rphi_sol;}
      if($rphi_sol < $rphi_min) {$rphi_min = $rphi_sol;}
      print OUT "$rpos $rphi_sol\n";
    }
    close(OUT);
    $m++;
  }
}
close(IN);

$nv_max = $nv_max*2;
$rphi_max = $rphi_max*1.5;

################################################################################
#  gnuplot

### Parameters
$ndiv_max = 5;

### rho_ae, rho_sol
##### Electron density n(r) #####
open(OUT,">$$.gpi");
$rho_file = "$ARGV[0]" . "_sol" . "_rho" . ".eps";
print OUT "set terminal postscript eps enhanced color solid \"Helvetica\" 12\n";
print OUT "set output \"$rho_file\"\n";
print OUT "set xzeroaxis\n";
print OUT "set border 31 lw 1\n";

print OUT "set size 0.5,0.5\n";
print OUT "set key right top\n";
#print OUT "set nokey\n";
print OUT "set xtics 1\n";
print OUT "set mxtics 1\n";
for($i=0;int(($nv_max-$nv_min)/$ntic[$i]) > $ndiv_max;$i++) {next;}
$ytics_guess = $ntic[$i];
$mytics_guess = 1;
$nv_max_guess = int($nv_max/$ntic[$i])*$ntic[$i]+$ntic[$i]+$ntic[$i];
$nv_min_guess = int($nv_min/$ntic[$i])*$ntic[$i]-$ntic[$i];
print OUT "set ytics $ytics_guess\n";
print OUT "set mytics $mytics_guess\n";
print OUT "set format x \"%1.0f\"\n";
if($ytics_guess < 0.1) {
print OUT "set format y \"%4.2f\"\n";
} elsif($ytics_guess < 1) {
print OUT "set format y \"%3.1f\"\n";
} elsif($ytics_guess < 10) {
print OUT "set format y \"%2.0f\"\n";
} elsif($ytics_guess < 100) {
print OUT "set format y \"%3.0f\"\n";
} else {
print OUT "set format y \"%4.0f\"\n";
}
print OUT "set xlabel \"r\"\n";
print OUT "set ylabel \"n(r)\"\n";

print OUT "set label \"$element\" center at graph 0.11,0.86 font \"Helvetica-Bold,36\"\n";

print OUT "plot [$rmin:$rmax][$nv_min_guess:$nv_max_guess] \\\n";
print OUT "\'$file0\' u 1:3 t \'Core\'    w l lt 1 lw 4, \\\n";
print OUT "\'$file0\' u 1:4 t \'Valence\' w l lt 2 lw 4, \\\n";
print OUT "\'$file0\' u 1:2 t \'Total\'   w l lt 0 lw 1";
print OUT "\n";
close(OUT);

`gnuplot $$.gpi`;
`rm $$.gpi`;

### vloc_ion, vh_sol, vxc_sol
##### Potential V(r) #####
open(OUT,">$$.gpi");
$vloc_sol_file = "$ARGV[0]" . "_sol" . "_vloc" . ".eps";
print OUT "set terminal postscript eps enhanced color solid \"Helvetica\" 12\n";
print OUT "set output \"$vloc_sol_file\"\n";
print OUT "set xzeroaxis\n";
print OUT "set border 31 lw 1\n";

print OUT "set size 0.5,0.5\n";
print OUT "set key right top\n";
#print OUT "set nokey\n";
print OUT "set xtics 1\n";
print OUT "set mxtics 1\n";
if($vloc_max > 20) {$vloc_max = 20;}
if($vloc_min < -20) {$vloc_min = -20;}
for($i=0;int(($vloc_max-$vloc_min)/$ntic[$i]) > $ndiv_max;$i++) {next;}
$ytics_guess = $ntic[$i];
$mytics_guess = 1;
$vloc_max_guess = int($vloc_max/$ntic[$i])*$ntic[$i]+$ntic[$i]+$ntic[$i];
$vloc_min_guess = int($vloc_min/$ntic[$i])*$ntic[$i]-$ntic[$i];
print OUT "set ytics $ytics_guess\n";
print OUT "set mytics $mytics_guess\n";
print OUT "set format x \"%1.0f\"\n";
#print OUT "set format y \"%2.0f\"\n";       
if($ytics_guess < 0.1) {
print OUT "set format y \"%4.2f\"\n";
} elsif($ytics_guess < 1) {
print OUT "set format y \"%3.1f\"\n";
} elsif($ytics_guess < 10) {
print OUT "set format y \"%2.0f\"\n";
} elsif($ytics_guess < 100) {
print OUT "set format y \"%3.0f\"\n";
} else {
print OUT "set format y \"%4.0f\"\n";
}
print OUT "set xlabel \"r\"\n";
print OUT "set ylabel \"V(r)\"\n";
#print OUT "set label \"$element\" center at graph 0.11,0.86 font \"Helvetica-Bold,36\"\n";

print OUT "plot [$rmin:$rmax][$vloc_min_guess:$vloc_max_guess] \\\n";
print OUT "\'$file0\' u 1:6 t \'V_{loc}[ion]\' w l lt 1 lw 4, \\\n";
print OUT "\'$file0\' u 1:7 t \'V_{H}\'        w l lt 2 lw 4, \\\n";
print OUT "\'$file0\' u 1:8 t \'V_{XC}\'       w l lt 3 lw 4, \\\n";
print OUT "\'$file0\' u 1:5 t \'V_{loc}[scr]\' w l lt 0 lw 1";
print OUT "\n";
close(OUT);

`gnuplot $$.gpi`;
`rm $$.gpi`;

### rphi_sol
##### Wavefunctions r*phi[n](r) #####
open(OUT,">$$.gpi");
$rphi_sol_file = "$ARGV[0]" . "_sol" . "_rphi" . ".eps";
print OUT "set terminal postscript eps enhanced color solid \"Helvetica\" 12\n";
print OUT "set output \"$rphi_sol_file\"\n";
print OUT "set xzeroaxis\n";
print OUT "set border 31 lw 1\n";

print OUT "set size 0.5,0.5\n";
print OUT "set key right top\n";
#print OUT "set nokey\n";
print OUT "set xtics 1\n";
print OUT "set mxtics 1\n";
for($i=0;int(($rphi_max-$rphi_min)/$ntic[$i]) > $ndiv_max;$i++) {next;}
$ytics_guess = $ntic[$i];
#$rphi_max_guess = int($rphi_max/$ntic[$i])*$ntic[$i]+$ntic[$i]+$ntic[$i];
$rphi_max_guess = int($rphi_max/$ntic[$i])*$ntic[$i]+$ntic[$i];
$rphi_min_guess = int($rphi_min/$ntic[$i])*$ntic[$i]-$ntic[$i];
print OUT "set ytics $ytics_guess\n";
print OUT "set mytics 1\n";
print OUT "set format x \"%1.0f\"\n";
#print OUT "set format y \"%2.0f\"\n";       
if($ytics_guess < 0.1) {
print OUT "set format y \"%4.2f\"\n";
} elsif($ytics_guess < 1) {
print OUT "set format y \"%3.1f\"\n";
} elsif($ytics_guess < 10) {
print OUT "set format y \"%2.0f\"\n";
} elsif($ytics_guess < 100) {
print OUT "set format y \"%3.0f\"\n";
} else {
print OUT "set format y \"%4.0f\"\n";
}
print OUT "set xlabel \"r\"\n";
print OUT "set ylabel \"r{/Symbol y}_{/Times-Italic l}(r)\"\n";
#print OUT "set label \"$element\" center at graph 0.11,0.86 font \"Helvetica-Bold,36\"\n";

$ic = 0;
  print OUT "set label \"[Solved]\" \\\n";
  print OUT "at graph 0.05,0.95-$ic*0.05 font \"Courier,9\"\n";
  $ic++;
for($i=0;$i<$m;$i++) {
  if($is_formatted == 1) {
    print OUT "set label \" E($nn[$i]$lang[$ll[$i]])=%8.5f\",$elevel[$i] \\\n";
  } else {
    $tmp = int($elevel[$i]*1.0e5)*1.0e-5;
    print OUT "set label \" E($nn[$i]$lang[$ll[$i]])=$tmp\" \\\n";
  }
  print OUT "at graph 0.05,0.95-$ic*0.05 font \"Courier,9\"\n";
  $ic++;
}

print OUT "plot [$rmin:$rmax][$rphi_min_guess:$rphi_max_guess] \\\n";
$ic = 0;
for($i=0;$i<$m;$i++) {
  if($ic != 0) {print OUT ", \\\n";}
  $line_type = $ll[$i]+1;
  print OUT "\'$file[$i]\' u 1:2 t \'$nn[$i]$lang[$ll[$i]]\' w l lt $line_type lw 4";
  $ic++;
}
print OUT "\n";
close(OUT);

`gnuplot $$.gpi`;
`rm $$.gpi`;

`rm $file0`;
for($i=0;$i<$m;$i++) {`rm $file[$i]`;}
