#!/usr/bin/perl
#
#  Copyright (C) 2003-2005 Takenori Yamamoto and Masakuni Okamoto.
#
#  This perl script was originally written by Takenori Yamamoto.
#  The script was modified by Masakuni Okamoto.
#
#  Last update: January 22, 2005.
#
################################################################################
#/////////////////////////////// Pseudopotentials //////////////////////////////

$rmin = 0;
$rmax = 5;

@lang = ('s','p','d','f');
@ntic = (0.01,0.02,0.05,0.1,0.2,0.5,1,2,5,10,20,50,100,200,500,
         1000,2000,5000,10000,20000,50000,100000,200000,500000,
         1000000,2000000,5000000);

$pmin = +1.0e3;
$pmax = -1.0e3;
$vmin = +1.0e3;
$vmax = -1.0e3;

$nvmin = 0;
$nvmax = 0;
$ncmin = 0;
$ncmax = 0;

################################################################################
#  Read data from a command-line

if(@ARGV<1) {
  print "Usage: print_eps_pp FileTitle [--formatted]\n";
  exit(0);
} else {
  $is_formatted = 0;
  foreach $s (@ARGV) {
    if($s =~/--formatted/ || $s =~/-f/) {
      $is_formatted = 1;
    }
  }
}

################################################################################
#  Read data from a file

print "*** Pseudopotentials ***\n";
print "@ARGV\n";
$infile = "$ARGV[0]" . ".pp";
print "<IN> = $infile\n";
if(! -e "$infile") {
  print "#############################################################\n";
  print "##   File not exists  -->  $infile\n";
  print "##   Please prepare the missing file.\n";
  print "#############################################################\n";
  exit(1);
} else {
  print "File exists --> $infile\n";
}
open(IN,"<$infile");
while($line = <IN>) {
  if($line =~/Element/) {
    ($element) = split(' ',$line);
    print "$element\n";
  } elsif($line =~/nmesh/) {
    ($nmesh) = split(':',$line);
    print "$nmesh\n";
    last;
  }
}
while($line = <IN>) {
  if($line =~/rpos/) {
    $file0 = "rho" . "_$element" . ".dat";
    print "   file = $file0\n";
    open(OUT,">$file0");
    for($i=0;$i<$nmesh-1;$i++) {
      ($rpos,$rho,$rho_ps,$vh,$vh_ps,$vxc_ps,$vloc_ion) = split(' ',<IN>);
      $rho_core = $rho-$rho_ps;
      if($rho_ps > $nvmax) {$nvmax = $rho_ps;}
      if($rho_core > $ncmax) {$ncmax = $rho_core;}
      print OUT "$rpos $rho $rho_core $rho_ps $vh $vh_ps $vxc_ps $vloc_ion\n";
    }
    close(OUT);
    last;
  }
}
$m=0;
while($line = <IN>) {
  if($line =~/n, l, 2/) {
    ($n,$l,$j2,$s) = split(' ',$line);
    $nn[$m] = $n;
    $ll[$m] = $l;
    print "$n$lang[$l], $j2, $s\n";
  } elsif($line =~/elevel/) {
    ($elevel[$m]) = split(':',$line);
    print "   Eref: $elevel[$m]\n";
  } elsif($line =~/rcut/) {
    ($rcut[$m]) = split(':',$line);
    print "   Rc  : $rcut[$m]\n";
    $r0[$m]      = -1.0e3;
    $r1[$m]      = -1.0e3;
    $ifound0[$m] = 0;
    $ifound1[$m] = 0;
    $chi0[$m]    = 0;
    $chi1[$m]    = 0;
  } elsif($line =~/rpos/) {
    $file[$m] = "phi" . "_$element" . "_$n$lang[$l]" . ".dat";
    print "   file = $file[$m]\n";
    open(OUT,">$file[$m]");
    for($i=0;$i<$nmesh-1;$i++) {
      ($rpos,$chi,$chi_ps,$veff,$veff_ps,$vion,$vion_ps) = split(' ',<IN>);
      if($rpos < $rcut[$m] && $ifound0[$m] == 0) 
        {$r0[$m] = $rpos; $chi0[$m] = $chi;} else {$ifound0[$m] = 1;}
      if($ifound0[$m] == 1 && $ifound1[$m] == 0) 
        {$r1[$m] = $rpos; $chi1[$m] = $chi; $ifound1[$m] = 1;}
      if(abs($chi) < 1e-10 && $rpos > 0.1) {$chi = 'zero';}
      if(abs($chi_ps) < 1e-10 && $rpos > 0.1) {$chi_ps = 'zero';}
      if($chi > $pmax) {$pmax = $chi;}
      if($chi < $pmin) {$pmin = $chi;}
      if($chi_ps > $pmax) {$pmax = $chi_ps;}
      if($chi_ps < $pmin) {$pmin = $chi_ps;}
      if($vion_ps > $vmax) {$vmax = $vion_ps;}
      if($vion_ps < $vmin) {$vmin = $vion_ps;}
      print OUT "$rpos $chi $chi_ps $veff $veff_ps $vion $vion_ps\n";
    }
    close(OUT);
    $m++;
  }
}
close(IN);
$vmax_plot = $vmax > 0 ? $vmax : 0;
#$vmax_plot = $vmax+0.5 > 0 ? $vmax+0.5 : 0;

################################################################################
#  gnuplot

### Parameters
$ndiv_max = 5;

##### Electron density n(r) #####
open(OUT,">$$.gpi");
$rho_file = "$ARGV[0]" . "_pp" . "_rho" . ".eps";
print OUT "set terminal postscript eps enhanced color solid \"Helvetica\" 12\n";
print OUT "set output \"$rho_file\"\n";
print OUT "set xzeroaxis\n";
print OUT "set border 31 lw 1\n";
print OUT "set missing \"zero\"\n";

print OUT "set size 0.5,0.5\n";
print OUT "set key right top\n";
print OUT "set xtics 1\n";
for($i=0;int(($nvmax*2-$nvmin)/$ntic[$i]) > $ndiv_max;$i++) {next;}
$ytics_guess = $ntic[$i];
$mytics_guess = 1;
$nvmax_guess = int($nvmax/$ntic[$i])*$ntic[$i]+$ntic[$i]+$ntic[$i];
$nvmin_guess = int($nvmin/$ntic[$i])*$ntic[$i]-$ntic[$i];
print OUT "set ytics $ytics_guess\n";
print OUT "set mytics $mytics_guess\n";
print OUT "set format x \"%1.0f\"\n";
if($ytics_guess < 0.1) {
print OUT "set format y \"%4.2f\"\n";
} elsif($ytics_guess < 1) {
print OUT "set format y \"%3.1f\"\n";
} elsif($ytics_guess < 10) {
print OUT "set format y \"%2.0f\"\n";
} elsif($ytics_guess < 100) {
print OUT "set format y \"%3.0f\"\n";
} else {
print OUT "set format y \"%4.0f\"\n";
}
print OUT "set xlabel \"r\"\n";
print OUT "set ylabel \"n(r)\"\n";

print OUT "set label \"$element\" center at graph 0.11,0.86 font \"Helvetica-Bold,36\"\n";

print OUT "plot [$rmin:$rmax][$nvmin_guess:$nvmax_guess] \\\n";
print OUT "\'$file0\' u 1:3 t \'Core\'    w l lt 1 lw 4, \\\n";
print OUT "\'$file0\' u 1:4 t \'Valence\' w l lt 2 lw 4, \\\n";
print OUT "\'$file0\' u 1:2 t \'Total\'   w l lt 0 lw 1";
print OUT "\n";
close(OUT);

`gnuplot $$.gpi`;
`rm $$.gpi`;

##### Wavefunctions ps[l](r) #####
open(OUT,">$$.gpi");
$phi_file = "$ARGV[0]" . "_pp" . "_rphi" . ".eps";
print OUT "set terminal postscript eps enhanced color solid \"Helvetica\" 12\n";
print OUT "set output \"$phi_file\"\n";
print OUT "set xzeroaxis\n";
print OUT "set border 31 lw 1\n";
print OUT "set missing \"zero\"\n";

print OUT "set size 0.5,0.5\n";
print OUT "set key right top\n";
print OUT "set xtics 1\n";
print OUT "set ytics 1\n";                
for($i=0;int(($pmax-$pmin)/$ntic[$i]) > $ndiv_max;$i++) {next;}
$ytics_guess = $ntic[$i];
$mytics_guess = 1;
#$pmax_guess = int($pmax/$ntic[$i])*$ntic[$i]+$ntic[$i]+$ntic[$i];
$pmax_guess = int($pmax/$ntic[$i])*$ntic[$i]+$ntic[$i];
$pmin_guess = int($pmin/$ntic[$i])*$ntic[$i]-$ntic[$i];
print OUT "set ytics $ytics_guess\n";
print OUT "set mytics $mytics_guess\n";
print OUT "set format x \"%1.0f\"\n";
#print OUT "set format y \"%2.0f\"\n";
if($ytics_guess < 0.1) {
print OUT "set format y \"%4.2f\"\n";
} elsif($ytics_guess < 1) {
print OUT "set format y \"%3.1f\"\n";
} elsif($ytics_guess < 10) {
print OUT "set format y \"%2.0f\"\n";
} elsif($ytics_guess < 100) {
print OUT "set format y \"%3.0f\"\n";
} else {
print OUT "set format y \"%4.0f\"\n";
}
print OUT "set xlabel \"r\"\n";
print OUT "set ylabel \"r{/Symbol y}_{/Times-Italic l}(r)\"\n";
print OUT "set label \"$element\" center at graph 0.11,0.86 font \"Helvetica-Bold,36\"\n";

for($i=0;$i<$m;$i++) {
  print OUT "set arrow from $r0[$i],$chi0[$i]-0.3 to $r0[$i],$chi0[$i]-0.03 lt $ll[$i]+1 lw 1\n";
}

print OUT "plot [$rmin:$rmax][$pmin_guess:$pmax_guess] \\\n";
$ic = 0;
for($i=0;$i<$m;$i++) {
  if($ic != 0) {print OUT ", \\\n";}
  $line_type = $ll[$i]+1;
  print OUT "\'$file[$i]\' u 1:2 notitle                     w l lt $line_type lw 1, \\\n";
  print OUT "\'$file[$i]\' u 1:3 t \'$nn[$i]$lang[$ll[$i]]\' w l lt $line_type lw 4";
  $ic++;
}
print OUT "\n";
close(OUT);

`gnuplot $$.gpi`;
`rm $$.gpi`;

##### Potential V[l](r) #####
open(OUT,">$$.gpi");
$vps_file = "$ARGV[0]" . "_pp" . "_vps" . ".eps";
print OUT "set terminal postscript eps enhanced color solid \"Helvetica\" 12\n";
print OUT "set output \"$vps_file\"\n";
print OUT "set xzeroaxis\n";
print OUT "set border 31 lw 1\n";

print OUT "set size 0.5,0.5\n";
print OUT "set key right bottom\n";
#print OUT "set nokey\n";
print OUT "set xtics 1\n";
if($vmax > 20) {$vmax = 20;}
if($vmin < -20) {$vmin = -20;}
for($i=0;int(($vmax-$vmin)/$ntic[$i]) > $ndiv_max;$i++) {next;}
$ytics_guess = $ntic[$i];
$mytics_guess = 1;
$vmax_guess = int($vmax/$ntic[$i])*$ntic[$i]+$ntic[$i];
$vmin_guess = int($vmin/$ntic[$i])*$ntic[$i]-$ntic[$i];
print OUT "set ytics $ytics_guess\n";
print OUT "set mytics $mytics_guess\n";
print OUT "set format x \"%1.0f\"\n";
#print OUT "set format y \"%2.0f\"\n";
if($ytics_guess < 0.1) {
print OUT "set format y \"%4.2f\"\n";
} elsif($ytics_guess < 1) {
print OUT "set format y \"%3.1f\"\n";
} elsif($ytics_guess < 10) {
print OUT "set format y \"%2.0f\"\n";
} elsif($ytics_guess < 100) {
print OUT "set format y \"%3.0f\"\n";
} else {
print OUT "set format y \"%4.0f\"\n";
}
print OUT "set xlabel \"r\"\n";
print OUT "set ylabel \"V_{/Times-Italic l}(r)\"\n";

$ic = 0;
for($i=0;$i<$m;$i++) {
  if($is_formatted == 1) {
    print OUT "set label \"Rc($nn[$i]$lang[$ll[$i]])=%8.5f\",$rcut[$i] \\\n";
  } else {
    $tmp = int($rcut[$i]*1.0e5)*1.0e-5;
    print OUT "set label \"Rc($nn[$i]$lang[$ll[$i]])=$tmp\" \\\n";
  }
  print OUT "at graph 0.68,0.3-$ic*0.05 font \"Courier,9\"\n";
  $ic++;
}

print OUT "plot [$rmin:$rmax][$vmin_guess:$vmax_guess] \\\n";
$ic = 0;
for($i=0;$i<$m;$i++) {
  if($ic != 0) {print OUT ", \\\n";}
  $line_type = $ll[$i]+1;
  #print OUT "\'$file[$i]\' u 1:7 t \'$nn[$i]$lang[$ll[$i]]\' w l lt $line_type lw 4";
  print OUT "\'$file[$i]\' u 1:7 notitle w l lt $line_type lw 4";
  $ic++;
}
if($ic != 0) {print OUT ", \\\n";}
$line_type = 0;
print OUT "\'$file0\' u 1:8 t \'local\' w l lt $line_type lw 1";
print OUT "\n";
close(OUT);

`gnuplot $$.gpi`;
`rm $$.gpi`;

`rm $file0`;
for($i=0;$i<$m;$i++) {`rm $file[$i]`;}

################################################################################
#///////////////////////////////////////////////////////////////////////////////
#  Generate a tex file

$infile = "$ARGV[0]" . ".pp";
if(-e "$infile") {$with_pp = 1;} 
else {$with_pp = 0; print "### CAUTION ### Not found --> $infile\n";}
$infile = "$ARGV[0]" . ".pcc";
if(-e "$infile") {$with_pcc = 1;} 
else {$with_pcc = 0; print "### CAUTION ### Not found --> $infile\n";}
$infile = "$ARGV[0]" . ".us";
if(-e "$infile") {$with_us = 1;} 
else {$with_us = 0; print "### CAUTION ### Not found --> $infile\n";}
$infile = "$ARGV[0]" . ".ldr";
if(-e "$infile") {$with_ldr = 1;} 
else {$with_ldr = 0; print "### CAUTION ### Not found --> $infile\n";}
$infile = "$ARGV[0]" . ".sol";
if(-e "$infile") {$with_sol = 1;} 
else {$with_sol = 0; print "### CAUTION ### Not found --> $infile\n";}
$infile = "$ARGV[0]" . ".ft";
if(-e "$infile") {$with_ft = 1;} 
else {$with_ft = 0; print "### CAUTION ### Not found --> $infile\n";}

open(OUT,">layout_nc.tex");
print OUT "\\documentclass[landscape,a4paper]{article}\n";
print OUT "\\usepackage{graphicx}\n";
print OUT "\\topmargin     = -25mm   \\headsep        =  15mm\n";
print OUT "\\oddsidemargin =   0mm   \\evensidemargin =   0mm\n";
print OUT "\\textwidth     = 235mm   \\textheight     = 170mm\n";
print OUT "\\unitlength    =   1mm\n";
print OUT "\\begin{document}\n";
print OUT "\\pagestyle{empty}\n";
### rphi, vps, ft
if($with_pp == 1 || $with_sol == 1 || $with_ft == 1) {
print OUT "\\begin{figure}\n";
print OUT "  \\begin{center}\n";
print OUT "    \\begin{tabular}{cc}\n";
if($with_pp == 1) {
print OUT "      \\resizebox{120mm}{!}{\\includegraphics{$ARGV[0]_pp_rphi.eps}} &\n";
print OUT "      \\resizebox{120mm}{!}{\\includegraphics{$ARGV[0]_pp_vps.eps}} \\\\\n";
}
if($with_sol == 1) {
print OUT "      \\resizebox{120mm}{!}{\\includegraphics{$ARGV[0]_sol_rphi.eps}} &\n";
print OUT "      \\resizebox{120mm}{!}{\\includegraphics{$ARGV[0]_ft.eps}} \\\\\n";
} elsif ($with_ft == 1) {
print OUT "      &\\resizebox{120mm}{!}{\\includegraphics{$ARGV[0]_ft.eps}} \\\\\n";
}
print OUT "    \\end{tabular}\n";
print OUT "  \\end{center}\n";
print OUT "\\end{figure}\n";
}
### ldr, rho
if($with_ldr == 1) {
print OUT "\\clearpage\n";
print OUT "\\begin{figure}\n";
print OUT "  \\begin{center}\n";
print OUT "    \\begin{tabular}{cc}\n";
if($with_ldr == 1) {
print OUT "      \\resizebox{120mm}{!}{\\includegraphics{$ARGV[0]_ldr.eps}} &\n";
print OUT "      \\resizebox{120mm}{!}{\\includegraphics{$ARGV[0]_ldr_std.eps}} \\\\\n";
}
print OUT "    \\end{tabular}\n";
print OUT "  \\end{center}\n";
print OUT "\\end{figure}\n";
}
### rho_ae, rho_sol, vloc, rho_pcc, ggrho_pcc
if($with_sol == 1 || $with_pcc == 1) {
print OUT "\\clearpage\n";
print OUT "\\begin{figure}\n";
print OUT "  \\begin{center}\n";
print OUT "    \\begin{tabular}{cc}\n";
if($with_sol == 1) {
print OUT "      \\resizebox{120mm}{!}{\\includegraphics{$ARGV[0]_sol_rho.eps}} &\n";
print OUT "      \\resizebox{120mm}{!}{\\includegraphics{$ARGV[0]_sol_vloc.eps}} \\\\\n";
}
if($with_pcc == 1) {
print OUT "      \\resizebox{120mm}{!}{\\includegraphics{$ARGV[0]_pcc_rho.eps}} &\n";
print OUT "      \\resizebox{120mm}{!}{\\includegraphics{$ARGV[0]_pcc_ggrho.eps}} \\\\\n";
}
print OUT "    \\end{tabular}\n";
print OUT "  \\end{center}\n";
print OUT "\\end{figure}\n";
}
### rphi, gphi, rbeta, gbeta
if($with_us == 1) {
print OUT "\\clearpage\n";
print OUT "\\begin{figure}\n";
print OUT "  \\begin{center}\n";
print OUT "    \\begin{tabular}{cc}\n";
print OUT "      \\resizebox{120mm}{!}{\\includegraphics{$ARGV[0]_us_rphi.eps}} &\n";
print OUT "      \\resizebox{120mm}{!}{\\includegraphics{$ARGV[0]_us_gphi.eps}} \\\\\n";
print OUT "      \\resizebox{120mm}{!}{\\includegraphics{$ARGV[0]_us_rbeta.eps}} &\n";
print OUT "      \\resizebox{120mm}{!}{\\includegraphics{$ARGV[0]_us_gbeta.eps}} \\\\\n";
print OUT "    \\end{tabular}\n";
print OUT "  \\end{center}\n";
print OUT "\\end{figure}\n";
}
print OUT "\\end{document}\n";
