! ************************************************************* 
!
!   This is a software package CIAO
!
!     developed as a part of the national project "Research and 
!     Development of Innovative Simulation software",which is   
!     supported by the next-generation IT program of MEXT of Japan
!
!   Version history: 
!
!     4.0:  2013/03/01
!           codes for spin-polarized pseudopotential generation are added
!     4.1:  2013/11/22 - 
!           Info of core wfns and energy contributions can be added to gncpp2
!     4.2:  2014/07/23 - 
!           gncpp2 can be geregated even when nmesh /= 1501
!
! ************************************************************* 
!
!  Software name : CIAO (Code for Investigating Atomic Orbitals)
!  Subroutine(s) : set_version, write_title, write_version
!  Author(s)     : Masakuni Okamoto (August 25, 2003)
!
!
!  Contact address :  Phase System Consortium
!                     E-mail: phase_system@nims.go.jp URL https://azuma.nims.go.jp
!
!
!  The license of the code and contact address :
!  See the files, COPYRIGHT and LICENSE (or LICENSE_J.pdf)
!
!=====================================================================
   subroutine set_version
!=====================================================================
!
!  M. Okamoto
!
!---------------------------------------------------------------------
   use parameters
   implicit none

! ===== 
! version number should not exceed 4-characters.
! date should not exceed 11-characters.  
! ====

   version = '3.00';   vdate = '2011-FEB-28'

! ==================================== modified by K. T. ========== 4.0
!   version = '4.00';  vdate = '2013-Mar-01'
! ================================================================= 4.0

! ============================ KT_add ===================== 4.1-
   version = '4.10';  vdate = '2013-Nov-22'
   version = '4.11';  vdate = '2014-Jan-01'
! ========================================================= 4.1-

! ============================ KT_add ===================== 4.2-
   version = '4.20';  vdate = '2014-Jul-23'
   version = '4.21';  vdate = '2014-Aug-01'
   version = '4.22';  vdate = '2014-Dec-08'
! ========================================================= 4.2-
   end subroutine set_version

!=====================================================================
   subroutine write_title(ifile,day_in)
!=====================================================================
!
!  M. Okamoto
!
!---------------------------------------------------------------------
   use parameters
   implicit none
   integer,intent(in)       :: ifile
   character(20),intent(in) :: day_in
   write(ifile,*)
   write(ifile,'(a)')  '********************************'
   write(ifile,'(5a)') '***   CIAO   version ',version,'    ***','    ',day_in
   write(ifile,'(3a)') '***          ',vdate,'     ***'
   write(ifile,'(a)')  '********************************'
   end subroutine write_title

!=====================================================================
   subroutine write_version(ifile)
!=====================================================================
!
!  M. Okamoto
!
!---------------------------------------------------------------------
   use parameters
   implicit none
   integer,intent(in) :: ifile
   write(ifile,*)
   write(ifile,'(a)')  '********************************'
   write(ifile,'(3a)') '***   CIAO   version ',version,'    ***'
   write(ifile,'(3a)') '***          ',vdate,'     ***'
   write(ifile,'(a)')  '********************************'
   end subroutine write_version

