! ************************************************************* 
!
!   This is a software package CIAO
!
!     developed as a part of the national project "Research and 
!     Development of Innovative Simulation software",which is   
!     supported by the next-generation IT program of MEXT of Japan
!
!   Version history: 
!
!     4.0:  2013/03/01
!           codes for spin-polarized pseudopotential generation are added
!     4.1:  2013/11/22 - 
!           Info of core wfns and energy contributions can be added to gncpp2
!     4.2:  2014/07/23 - 
!           gncpp2 can be geregated even when nmesh /= 1501
!
! ************************************************************* 
!
!  Software name : CIAO (Code for Investigating Atomic Orbitals)
!  Module(s)     : parameters
!  Author(s)     : Masakuni Okamoto (August 25, 2003)
!
!
!  Contact address :  Phase System Consortium
!                     E-mail: phase_system@nims.go.jp URL https://azuma.nims.go.jp
!
!
!  The license of the code and contact address :
!  See the files, COPYRIGHT and LICENSE (or LICENSE_J.pdf)
!
!=====================================================================
   module parameters
!=====================================================================
!
!  Parameters and variables
!
!  M. Okamoto
!
!---------------------------------------------------------------------
   implicit none
   integer,parameter :: NATOM = 120
   integer,parameter :: &
      NO = 0, YES = 1, NONE = 0, NONREL = 1, SREL = 2, REL = 3, &
      RESTRICTED = 1, POLARIZED = 2, AUTOMATIC = 1, MANUAL = 2, &
      UD_SPECIFIED = MANUAL, SPIN_SPECIFIED = 3, NREL = NONREL, &
      NORMAL = 1, PATOM = 2, OZAKI_KINO = 3, &
      LDAPZ81 = 1, LDAPW92_MOMO = 2, LDAPW92_MOMO2 = 3,           &
      LDAPW92_GNCPP = 4, GGAPW91_MOMO = 5, GGAPW91_MOMO2 = 6,     &
      GGAPW91_F90 = 7, GGAPW91_F77 = 8, GGAPBE96_MOMO = 9,        &
      GGAPBE96_MOMO2 = 10, GGAPBE96_GNCPP = 11,                   &
      GGAPBE96_KATO = 12, REVPBE = 13, XLDA = 14, XGGA = 15,      &
      LDA = 1, GGA = 2,                                           &
      BHS82 = 1, TM91 = 2, US90 = 3, GENERAL_PP = 4, PAW = 5,     &
      TM91SO = 6,                                                 &
      NC = 100, US = 101, SEMILOCAL = 100, SEPARABLE = 101,       &
      PCC = 1, FCC = 2, POLYNOMIAL = 1, SBESSEL = 2, BHSPCC = 3,  &
      ANGULAR = 3, NOOPT = 4,                                     &
      PCC_RATIO = 1, PCC_RC = 2, ITERATIVE = 1, FREDHOLM = 2,     &
      CORE_POTENTIAL_CONFINEMENT = 1, OZAKI_KINO_CONFINEMENT = 2, &
      JRCAT = 3, EXTENDED = 1

   character(4)  :: version
   character(11) :: vdate
   integer :: narg, have_args, have_infile
   character(50) :: argv(15)

   real(8),parameter :: ARGMAX = 150.d0

   character(50) :: &
      calc_type, spin_type, spin_state_type, xc_type, xc_approx,   &
      mesh_type, weight_type, core_type, calc_type_explained,      &
      spin_type_explained, spin_state_type_explained,              &
      xc_type_explained, xc_approx_explained, mesh_type_explained, &
      weight_type_explained, core_type_explained

   character(50),allocatable :: &
      state(:), spin_label(:), state_in(:)

   integer :: &
      zatom, nshell, nspin, nmesh, ng_mesh, loop_conv, lmax_core,     &
      iord_pc, iord_diff, iord_nec, iord_coeff, is_calc, is_spin,     &
      is_spin_state, is_xc, is_mesh, is_weight, is_core, is_xc_class, &
      is_write_rho, is_write_rm, is_debug, nshell_in, nsave_dee,      &
      nrcut_ok, is_write_orbital

   integer,allocatable :: & 
      is_solve(:), is_valence(:), list_shell(:), n_qnum(:), &
      l_qnum(:), k_qnum(:), j2_qnum(:), spin(:), nocc(:),   &
      nrm_pos(:), nrt_pos(:), nmm_pos(:), is_solve_in(:),   &
      is_valence_in(:), n_qnum_in(:), l_qnum_in(:)

! ======================================== added by K. T. =============== 4.0
   integer, allocatable :: spin_index_ps(:)
! ======================================================================= 4.0

   real(8) :: &
      rmin, rmax, xmin, xmax, dx, xh, gmin, gmax, fatom, felec, &
      felec1, felec2, fspin, felec_old, felec1_old, felec2_old, &
      mix1, mix2, foccnl(10,0:4,2), foccnl_tmp(10,0:4,2),       &
      foccnls(10,0:4,2), foccnls_tmp(10,0:4,2),                 &
      dee_conv, efermi, ekin_sum, ekin_sum1, ekin_sum2, &
      eloc_ion_sum, enl_ion_sum, eion_sum, vlocqps_sum, eh_sum, &
      ex_sum, ec_sum, exc_sum, etot_sum1, etot_sum2, etot_sum,  &
      etot_old, vx_sum, vc_sum, vxc_sum, eband_sum, veff_sum,   &
      expc_sum, ecpc_sum, excpc_sum,    &
      vxpc_sum, vcpc_sum, vxcpc_sum,   &
      eps_check, eps_de, h_ok, drcl_ok, rcut_ok, rl_ok

   real(8),allocatable :: &
      focc(:), rcut_tm(:), rcut_core(:), vcut_core(:), rpos(:),      &
      xpos(:), wr(:), wt(:), gpos(:), wg(:), vion(:,:), vh(:),       &
      ex(:), ec(:), vx(:,:), vc(:,:), vcoeff(:,:,:), veff(:,:,:),    &
      veff_old(:,:,:), rho(:,:), rho_old(:,:), rho_zeta(:), engy(:), &
      engy_old(:), chi_g(:,:), chi_gl(:), chi_gr(:), chi_f(:,:),     &
      chi_fl(:), chi_fr(:), dxchi_g(:,:), dxchi_gl(:), dxchi_gr(:),  &
      dxchi_f(:,:), dxchi_fl(:), dxchi_fr(:), focc_in(:,:),          &
      dee_save(:)

   real(8),allocatable :: &
      rho1_rad(:), rho2_rad(:), drho1_rad(:), drho2_rad(:), &
      drho_rad(:),                                          &
      fx_rad(:), fc_rad(:), dfx_rad(:,:), dfc_rad(:,:),     &
      dfxda_rad(:,:), dfcda_rad(:), vx_rad(:,:), vc_rad(:,:)

   real(8),allocatable :: &
      dvx(:,:), dvc(:,:), ddvx(:,:), ddvc(:,:), &
      dveff(:,:,:), ddveff(:,:,:), de_srel(:), ee_srel(:)

   character(50),allocatable :: &
      state_so(:), spin_label_so(:)

   integer :: nshell_so

   integer,allocatable :: & 
      is_solve_so(:), is_valence_so(:), list_shell_so(:),      &
      n_qnum_so(:), l_qnum_so(:), k_qnum_so(:), j2_qnum_so(:), &
      spin_so(:), nocc_so(:), nrm_pos_so(:), nrt_pos_so(:),    &
      nmm_pos_so(:)

   real(8) :: &
      felec_so, ekin_sum_so, eion_sum_so, eh_sum_so, exc_sum_so, &
      ex_sum_so, ec_sum_so, vx_sum_so, vc_sum_so, vxc_sum_so,    &
      eband_sum_so, etot_sum_so

   real(8),allocatable :: &
      focc_so(:), engy_so(:)

   character(50) :: pp_type, pp_type_explained

   integer :: &
      is_pp, is_pp_calc_class, is_pp_out_class, is_write_gncpp, &
      is_write_psvpp, is_write_gncpp2, is_write_ciaopp,         &
      is_with_core, is_with_ae, is_with_so, is_write_pp,        &
      is_pp_generated, is_semilocal_mode, is_paw,               &
      nps, lloc, lmax, ips_loc, ncoeff_phi_tm

! ================= KT_add ================= 4.1
   logical :: is_paw_is_read
! ========================================== 4.1

   integer,allocatable :: &
      ishell_ps(:,:), num_so_ps(:), is_gen_ps(:,:)

   real(8) :: &
      felec_core, felec_val, r_core, rmax_ps, rcut_loc_bhs,      &
      vcut_loc_bhs, lambda_loc_bhs, rcut_loc_poly, vcut_loc_poly

   real(8),allocatable :: &
      vscr_bhs(:,:), vion_bhs(:,:), vso_bhs(:,:),                   &
      vscr_tmso(:,:), vion_tmso(:,:), vso_tmso(:,:),                &
! ================================================ modified by K. T. ======= 4.0
!      rho_ps(:), &
      rho_ps(:,:), &
! ========================================================================== 4.0
      chi_ps(:,:,:), veff_ps(:,:,:), veff_ps_old(:,:,:), &
      vion_ps(:,:,:), vh_ps(:), &
! =============================================== modified by K. T. ======= 4.0
!      vloc_ps(:), vx_ps(:), vc_ps(:),     &
      vloc_ps(:,:), vx_ps(:,:), vc_ps(:,:),     &
! ========================================================================== 4.0
      ex_ps(:), ec_ps(:), &
      coeff_tm(:,:,:), vcoeff_ps(:,:,:),        &
      rho_core(:), vxpc_ps(:), vcpc_ps(:), expc_ps(:), ecpc_ps(:),  &
      coeff_phi_tm(:,:,:)

   character(50) :: local_type_us, local_name_us
   character(50),allocatable :: val_label_ps(:), val_type_ps(:)

   integer :: &
      is_write_us, is_write_qps, num_ltlt_us, num_ltltx_us,          &
      num_ltt_us, num_lttx_us, num_lt_us, num_lt_loc_us, num_ltx_us, &
      nref_max_ps, nref_max_us, l3_max_us, nrcut_max_us,             &
      nrcut_maxx_us, nrcut_phi_max_us, nrcut_loc_us, ng_phi_us,      &
      ng_qps_us, ncoeff_max_us, ncoeff_phi_us, ncoeff_qps_us,        &
      is_deficit_type, is_projector_type

   integer,allocatable :: &
      l_val_label_ps(:), n_val_label_ps(:), is_val_type_ps(:),       &
      is_val_type_us(:), nref_ps(:), nref_us(:), lt_n_us(:,:),       &
      ips_lt_us(:), n_lt_us(:), l_lt_us(:), t_lt_us(:), ln_lt_us(:), &
      tn_lt_us(:), nrcut_phi_us(:), nodes_phi_us(:), is_bound_us(:), &
      is_bound_ps(:), ltt_nm_us(:,:,:), ips1_ltt_us(:),              &
      ips2_ltt_us(:), n1_ltt_us(:), n2_ltt_us(:), l_ltt_us(:),       &
      t1_ltt_us(:), t2_ltt_us(:), tn_ltt_us(:), tm_ltt_us(:),        &
      ltlt_nm_us(:,:,:,:), ips1_ltlt_us(:), n1_ltlt_us(:),           &
      l1_ltlt_us(:), t1_ltlt_us(:), ln_ltlt_us(:), tn_ltlt_us(:),    &
      ips2_ltlt_us(:), n2_ltlt_us(:), l2_ltlt_us(:), t2_ltlt_us(:),  &
      lm_ltlt_us(:), tm_ltlt_us(:), nrcut_qps_us(:,:)

! ============================ added by K. T. ====================== 4.0
   integer, allocatable :: spin_index_lt_us(:)
   integer, allocatable :: spin1_index_ltt_us(:)
   integer, allocatable :: spin2_index_ltt_us(:)
   integer, allocatable :: spin1_index_ltlt_us(:)
   integer, allocatable :: spin2_index_ltlt_us(:)
! ================================================================== 4.0

   real(8) :: &
      deref_max_ps, gmin_phi_us, gmax_phi_us, gmin_qps_us,         &
      gmax_qps_us, gmin_pcc_us, gmax_pcc_us, rcut_max_us,          &
      rcut_loc_us, rcut_phi_max_us, eband_sum_us, eloc_ion_sum_us, &
      eloc_scr_sum_us, ex_sum_us, ec_sum_us, exc_sum_us,           &
      vx_sum_us, vc_sum_us, vxc_sum_us, eh_sum_us, etot_sum_us

   real(8),allocatable :: &
      deref_ps(:,:), rcut_phi_ps(:,:), rin_qps_ps(:,:),              &

! ========================================= modiifed by K. T. ============= 4.0
!      vloc_scr_us(:), vloc_ion_us(:), &
      vloc_scr_us(:,:), vloc_ion_us(:,:), &
! ========================================================================= 4.0
      norm_psi_ps(:),                &
      norm_psi_us(:), norm_phi_us(:), eref_us(:), veff_us(:,:),      &
      rpsi_us(:,:), rphi_us(:,:), drpsi_us(:,:), drphi_us(:,:),      &
      ddrphi_us(:,:), rchi_us(:,:), rbeta_us(:,:),                   &
      coeff_phi_us(:,:), q_sum_us(:), qps_sum_us(:), vlocqps_us(:),  &
      bmat_us(:), dmat_us(:), dion_us(:), q_us(:,:), qps_us(:,:,:),  &
      coeff_qps_us(:,:,:), rcut_qps_us(:,:), psi_g_us(:,:),          &
      phi_g_us(:,:), chi_g_us(:,:), beta_g_us(:,:), qps_g_us(:,:,:), &
      q_g_us(:,:)

   integer :: is_write_sol
   integer,allocatable :: list_sol(:)

   real(8) :: felec_sol, etot_sol, &
      ekin_sum1_sol, ekin_sum2_sol, ekin_sum_sol, eloc_ion_sum_sol, &
      enl_ion_sum_sol, vlocqps_sum_sol, eion_sum_sol, eh_sum_sol,   &
      ex_sum_sol, ec_sum_sol, exc_sum_sol, etot_sum1_sol,           &
      etot_sum2_sol, etot_sum_sol, vx_sum_sol, vc_sum_sol,          &
      vxc_sum_sol, eband_sum_sol, veff_sum_sol,                     &
      expc_sum_sol, ecpc_sum_sol, excpc_sum_sol,                    &
      vxpc_sum_sol, vcpc_sum_sol, vxcpc_sum_sol

! ==================================== modified by K. T. =================== 4.0
!   real(8),allocatable :: &
!      focc_sol(:), engy_sol(:), rphi_sol(:,:), rho_sol(:),           &
!      beta_phi_sol(:,:), vh_sol(:), ex_sol(:), ec_sol(:), vx_sol(:), &
!      vc_sol(:), vloc_scr_sol(:), vloc_ion_sol(:), drho_sol(:),      &
!      ddrho_sol(:), expc_sol(:), ecpc_sol(:), vxpc_sol(:), vcpc_sol(:)

   real(8),allocatable :: &
      focc_sol(:), engy_sol(:), rphi_sol(:,:), rho_sol(:,:),           &
      beta_phi_sol(:,:), vh_sol(:), ex_sol(:), ec_sol(:), vx_sol(:,:), &
      vc_sol(:,:), vloc_scr_sol(:,:), vloc_ion_sol(:,:), drho_sol(:,:),      &
      ddrho_sol(:,:), expc_sol(:), ecpc_sol(:), vxpc_sol(:), vcpc_sol(:)
! ============================================================================ 4.0

   character(50) :: &
      solve_pp_spin_type, solve_pp_spin_type_explained,         &
      spin_type_ss, spin_type_ss_explained, spin_state_type_ss, &
      spin_state_type_ss_explained

   character(50),allocatable :: val_label_ss(:)
   character(1),allocatable :: spin_label_ss(:)

   integer :: &
      is_spin_ss, is_spin_state_ss, is_solve_pp_spin, nspin_ss, nss

   integer,allocatable :: &
      n_val_label_ss(:), l_val_label_ss(:), spin_ss(:),        &
      ishell_ss(:), is_solve_ss(:), nrm_pos_ss(:), nocc_ss(:), &
      list_ss(:)             

   real(8) :: &
      felec1_ss, felec2_ss, felec_ss, fspin_ss, mix_ss, efermi_ss, &
      etot_ss, etot_ss_old, felec1_ss_old, felec2_ss_old, felec_ss_old, &
      ekin_sum1_ss, ekin_sum2_ss, ekin_sum_ss, eloc_ion_sum_ss,     &
      enl_ion_sum_ss, vlocqps_sum_ss, eion_sum_ss, eh_sum_ss,       &
      ex_sum_ss, ec_sum_ss, exc_sum_ss, etot_sum1_ss, etot_sum2_ss, &
      etot_sum_ss, vx_sum_ss, vc_sum_ss, vxc_sum_ss, eband_sum_ss,  &
      veff_sum_ss, expc_sum_ss, ecpc_sum_ss, excpc_sum_ss,          &
      vxpc_sum_ss, vcpc_sum_ss, vxcpc_sum_ss           

   real(8),allocatable :: &
      focc_ss(:), vloc_scr_ss(:,:), engy_ss(:), rphi_ss(:,:),       &
      beta_phi_ss(:,:), rho_ss(:,:), drho_ss(:,:), ddrho_ss(:,:),   &
      vh_ss(:), dmat_ss(:,:), vlocqps_ss(:,:), ex_ss(:), ec_ss(:),  &
      vx_ss(:,:), vc_ss(:,:), expc_ss(:), ecpc_ss(:), vxpc_ss(:,:), &
      vcpc_ss(:,:), engy_ss_old(:), rho_ss_old(:,:),                &
      vloc_scr_ss_old(:,:)

   character(50) :: &
      pao_type, pao_type_explained
   character(12) :: pao_formula

   integer :: is_calc_pao, is_pao_type, num_l_pao, num_pao
   integer,allocatable :: &
      lnum_pao(:), nnum_pao(:), l_pao(:), n_pao(:)

   real(8),allocatable :: &
      engy_pao(:), rphi_pao(:,:), drphi_pao(:,:), beta_phi_pao(:,:), &
      vloc_pao(:)

   character(50) :: &
      core_state_type, core_state_type_explained

   integer :: zcore, zval, num_core
   real(8) :: fcore, fval
   integer :: is_core_hole_unscreened, num_core_hole

   real(8) :: ftot_core_hole
   character(50),allocatable :: label_core_hole(:)

   integer,allocatable :: &
      n_val_label_core_hole(:), l_val_label_core_hole(:), &
      ishell_core_hole(:)
   real(8),allocatable :: &
      focc_core_hole(:)

   character(50) :: &
      qps_type, qps_type_explained, &
      projector_type, projector_type_explained

   integer :: is_qps_type, lmax_qps, nrcut_beta
   real(8) :: rcut_beta, kappa_beta

   real(8),allocatable :: rcl_qps(:)

   character(50) :: &
      pcc_type, pcc_type_explained, pcc_method, &
      pcc_method_explained, pcc_rad, pcc_rad_explained

   integer :: &
      is_pcc, is_pcc_method, is_write_pcc, is_pcc_rad, nr0_pcc, &
      ng_pcc, ncoeff_pcc, nk_pcc

   real(8) :: r0_pcc, a_pcc, b_pcc, gmin_pcc, gmax_pcc, &
      a_bhspcc, b_bhspcc

   real(8),allocatable :: &
      rho_pcore(:), coeff_pcc(:), rho_core0_pcc(:), gg_rho_core(:), &
      gg_rho_pcore(:), gg_rho_val(:)

   real(8),allocatable :: &
      drho(:,:), ddrho(:,:), &
! ========================================== modified by K. T. =========== 4.0
!      drho_ps(:), ddrho_ps(:), &
      drho_ps(:,:), ddrho_ps(:,:), &
! ========================================================================= 4.0
      drho_core(:), &
      ddrho_core(:), drho_pcore(:), ddrho_pcore(:)                 

   integer :: n_anderson, istart_anderson

   real(8),allocatable :: &
      rho_p(:,:,:), rho_old_p(:,:,:), mat_p(:,:), vec_p(:,:), &
      coeff_p(:)    

   integer :: is_calc_hubbard
   real(8) :: hubbard_b(0:3,-3:3,0:6)
   real(8),allocatable :: hubbard_i(:,:,:), hubbard_u(:,:,:,:)

   integer :: &
      is_with_dipole, num_dipole_l_us, num_dipole_lm_us, &
      num_dipole_l_ps, num_dipole_lm_ps

   integer,allocatable :: phase_ylm(:,:), &
      n1_dipole_l_us(:), l1_dipole_l_us(:), t1_dipole_l_us(:),       &
      lt1_dipole_l_us(:), n2_dipole_l_us(:), l2_dipole_l_us(:),      &
      t2_dipole_l_us(:), lt2_dipole_l_us(:), n1_dipole_lm_us(:),     &
      l1_dipole_lm_us(:), t1_dipole_lm_us(:), m1_dipole_lm_us(:),    &
      n2_dipole_lm_us(:), l2_dipole_lm_us(:), t2_dipole_lm_us(:),    &
      m2_dipole_lm_us(:), ltlt_dipole_lm_us(:),                      &
      ltmltm_dipole_us(:,:,:), n1_dipole_l_ps(:), l1_dipole_l_ps(:), &
      ips1_dipole_l_ps(:), n2_dipole_l_ps(:), l2_dipole_l_ps(:),     &
      ips2_dipole_l_ps(:), n1_dipole_lm_ps(:), l1_dipole_lm_ps(:),   &
      m1_dipole_lm_ps(:), n2_dipole_lm_ps(:), l2_dipole_lm_ps(:),    &
      m2_dipole_lm_ps(:), nlnl_dipole_lm_ps(:),                      &
      nlmnlm_dipole_ps(:,:,:)

! =============================== added by K. T. ========================= 4.0
   integer,allocatable :: spin1_index_dipole_l_ps(:), &
        &                 spin1_index_dipole_lm_ps(:), &
        &                 spin1_index_dipole_l_us(:), &
        &                 spin1_index_dipole_lm_us(:)
! ========================================================================= 4.0

   real(8),allocatable :: pxyz(:,:,:), &
      dipole_r_us(:), dipole_ri_us(:), dipole_pr_us(:),  &
      dipole_x_us(:), dipole_y_us(:), dipole_z_us(:),    &
      dipole_dx_us(:), dipole_dy_us(:), dipole_dz_us(:), &
      dipole_r_ae(:), dipole_ri_ae(:), dipole_pr_ae(:),  &
      dipole_x_ae(:), dipole_y_ae(:), dipole_z_ae(:),    &
      dipole_dx_ae(:), dipole_dy_ae(:), dipole_dz_ae(:), &
      dipole_r_pp(:), dipole_ri_pp(:), dipole_pr_pp(:),  &
      dipole_x_pp(:), dipole_y_pp(:), dipole_z_pp(:),    &
      dipole_dx_pp(:), dipole_dy_pp(:), dipole_dz_pp(:), &
      dipole_x_ss(:), dipole_y_ss(:), dipole_z_ss(:),    &
      dipole_dx_ss(:), dipole_dy_ss(:), dipole_dz_ss(:), &
      rpsi_ps(:,:), drpsi_ps(:,:), rphi_ps(:,:), drphi_ps(:,:)

! ============ KT_add =========================================== 4.1
   integer :: is_with_dipole_cor2val, num_core_states, lmax_core_states, &
        &     num_dipole_cor2val_l_us, num_dipole_cor2val_lm_us

   integer, allocatable :: &
        &     n1_dipole_cor2val_l_us(:), n2_dipole_cor2val_l_us(:), &
        &     l1_dipole_cor2val_l_us(:), l2_dipole_cor2val_l_us(:), &
        &     t1_dipole_cor2val_l_us(:), t2_dipole_cor2val_l_us(:), &
        &     lt1_dipole_cor2val_l_us(:), lt2_dipole_cor2val_l_us(:), &
!
        &     n1_dipole_cor2val_lm_us(:), n2_dipole_cor2val_lm_us(:), &
        &     l1_dipole_cor2val_lm_us(:), l2_dipole_cor2val_lm_us(:), &
        &     t1_dipole_cor2val_lm_us(:), t2_dipole_cor2val_lm_us(:), &
        &     m1_dipole_cor2val_lm_us(:), m2_dipole_cor2val_lm_us(:), &
!
        &     ltlt_dipole_cor2val_lm_us(:), ltmltm_dipole_cor2val_us(:,:,:)

   integer,allocatable :: spin1_indx_dipole_cor2val_l_us(:), &
        &                 spin1_indx_dipole_cor2val_lm_us(:), &
        &                 is_core_states(:)

   real(8),allocatable :: &
        &  dipole_cor2val_r_us(:),  dipole_cor2val_ri_us(:), dipole_cor2val_pr_us(:),  &
        &  dipole_cor2val_x_us(:),  dipole_cor2val_y_us(:),  dipole_cor2val_z_us(:),  &
        &  dipole_cor2val_dx_us(:), dipole_cor2val_dy_us(:), dipole_cor2val_dz_us(:)
! =============================================================== 4.1

! ===== KT_add === 4.2
   integer :: is_write_orbital_index
   integer :: is_write_soc_valence
   integer :: is_write_soc_core
! ================ 4.2

   integer :: ne_kb, have_ghost_kb
   integer,allocatable :: is_solved_kb(:,:), is_ghost_kb(:)
   real(8),allocatable :: &
      engy_kb(:,:), vrms_kb(:,:), cos_kb(:,:), ee_local_kb(:,:)

   character(50) :: &
      logderi_type, logderi_type_explained, logderi_method, &
      logderi_method_explained, logderi_nonlocal,           &
      logderi_nonlocal_explained

   integer :: &
      is_logderi, ne_logderi, is_write_logderi, nrcut_logderi, &
      is_logderi_method, is_logderi_nonlocal
   real(8) :: emax_logderi, emin_logderi, rcut_logderi

   real(8),allocatable :: &
      logderi(:,:), logderi_ps(:,:), ee_logderi(:), &
! ================================================ modified by K. T. =========== 4.0
!      logderi_ae(:,:), logderi_us(:,:)
      logderi_ae(:,:,:), logderi_us(:,:,:)
! ============================================================================== 4.0

   character(50) :: fourier_type, fourier_type_explained
   integer :: is_fourier, ng_fourier, is_write_fourier
   real(8) :: gmin_fourier, gmax_fourier

   real(8),allocatable :: &
      gpos_ft(:), gg_vion_ft(:,:), gg_vion_ps_ft(:,:), &

! ================================================ modified by K. T. ========== 4.0
!      gg_vloc_ion_ft(:)
      gg_vloc_ion_ft(:,:)
! ============================================================================= 4.0

   real(8),allocatable :: &
      gr_wk(:), js_wk(:)
  !--- MO-100526
   integer :: ntkc
   real(8),allocatable :: tkc(:), dekin_tkc(:,:)
  !---
   character(50) :: &
      jobname, infile, logfile, sumfile, rhofile, pccfile, usfile, &
      qpsfile, ldrfile, ftfile, ppfile, gncppfile, gncpp2file,     &
      psvppfile, solfile, ciaoppfile, paofile, bhsppfile, tmsoppfile, &
      orbfile, infofile
   integer,parameter :: &
      IFIN    = 21, IFLOG   = 22, IFSUM    = 23, &
      IFRHO   = 24, IFPCC   = 25, IFUS     = 26, &
      IFQPS   = 27, IFLDR   = 28, IFFT     = 29, &
      IFPP    = 30, IFGNCPP = 31, IFGNCPP2 = 32, &
      IFPSVPP = 33, IFSOL   = 34, IFCIAOPP = 35, &
      IFPAO   = 36, IFBHSPP = 37, IFTMSOPP = 38, &
      IFORB   = 39

! ===================== KT_add ===================== 4.1
   character(50) :: file_cor2val
   integer :: IFCOR2VAL = 50
! ================================================== 4.1

   character(3) :: ch_loop,ch_dr,ch_drr,ch_de,ch_dee

   character(2),allocatable  :: atom_label(:)
   character(30),allocatable :: atom_name(:) 
   real(8),allocatable :: &
      cc_param(:,:), cc_a1(:), cc_a2(:), cc_c1(:), dist_nn(:)

   character(20) :: day_start, day_end, day_now
   integer       :: icount0

   real          :: time, total_time

   real(8),parameter :: &
      PI = 3.1415926535897932384626433832795028d0, &
      CLIGHT   =   2.99792458d8,         &
      C_AU     = 137.03599911d0,         &
      MU0      =   4.d-7 * PI,           &
      EPS0     =   1.d0/(MU0*CLIGHT**2), &
      GNEWTON  =   6.6742d-11,           &
      HBAR     =   1.05457168d-34,       &
      HPLANCK  =   6.6260693d-34,        &
      ELEC     =   1.60217653d-19,       &
      PHIMAG0  =   2.06783372d-15,       &
      GCOND0   =   7.748091733d-5,       &
      MASSE    =   9.1093826d-31,        &
      MASSP    =   1.67262171d-27,       &
      MASSR    =   1836.15267261d0,      &
      ALPHA    =   1.d0/C_AU,            &
      RINF     =   10973731.568525d0,    &
      AVOGADRO =   6.0221415d23,         &
      FARADAY  =   96485.3383d0,         &
      RGAS     =   8.314472d0,           &
      KBOLTZ   =   1.3806505d-23          
   real(8),parameter :: &
      RYDBERG  =  13.6056923d0,          &
      HARTREE  =  27.2113845d0,          &
      BOHR     =   0.5291772108d0         
   end module parameters
