! ************************************************************* 
!
!   This is a software package CIAO
!
!     developed as a part of the national project "Research and 
!     Development of Innovative Simulation software",which is   
!     supported by the next-generation IT program of MEXT of Japan
!
!   Version history: 
!
!     4.0:  2013/03/01
!           codes for spin-polarized pseudopotential generation are added
!     4.1:  2013/11/22 - 
!           Info of core wfns and energy contributions can be added to gncpp2
!     4.2:  2014/07/23 - 
!           gncpp2 can be geregated even when nmesh /= 1501
!
! ************************************************************* 
!
!  Software name : CIAO (Code for Investigating Atomic Orbitals)
!  Subroutine(s) : dgdx_dfdx_nonrel, dgdx_dfdx_srel, dgdx_dfdx_rel
!                : dgdx_dfdx_sol
!  Author(s)     : Masakuni Okamoto (August 25, 2003)
!
!
!  Contact address :  Phase System Consortium
!                     E-mail: phase_system@nims.go.jp URL https://azuma.nims.go.jp
!
!
!  The license of the code and contact address :
!  See the files, COPYRIGHT and LICENSE (or LICENSE_J.pdf)
!
!=====================================================================
   subroutine dgdx_dfdx_nonrel(r,g,f,dg,df,ll,ee,vv)
!=====================================================================
!
!  M. Okamoto
!
!---------------------------------------------------------------------  
   implicit none
   integer,intent(in)  :: ll
   real(8),intent(in)  :: r, g, f, ee, vv
   real(8),intent(out) :: dg, df
   dg = dble(ll+1)*g   + r*f
   df = 2.d0*r*(vv-ee)*g - dble(ll+1)*f
   end subroutine dgdx_dfdx_nonrel

!=====================================================================
   subroutine dgdx_dfdx_srel(r,g,f,dg,df,ll,ee,vv)
!=====================================================================
!
!  M. Okamoto
!
!---------------------------------------------------------------------  
   implicit none
   integer,intent(in)  :: ll
   real(8),intent(in)  :: r, g, f, ee, vv
   real(8),intent(out) :: dg, df
   real(8),parameter :: ALPHA = 1.d0/137.03599976d0
   real(8) :: mm, mmr
   mm  = 1.d0 + 0.5d0*ALPHA*ALPHA*(ee-vv)
   mmr = 2.d0*mm*r
   dg  = + g + mmr*f
   df  = - f + ( dble(ll*(ll+1))/mmr + r*(vv-ee) )*g
   end subroutine dgdx_dfdx_srel

!=====================================================================
   subroutine dgdx_dfdx_rel(r,g,f,dg,df,kk,ee,vv)
!=====================================================================
!
!  M. Okamoto
!
!---------------------------------------------------------------------  
   implicit none
   integer,intent(in)  :: kk
   real(8),intent(in)  :: r, g, f, ee, vv
   real(8),intent(out) :: dg, df
   real(8),parameter :: ALPHA = 1.d0/137.03599976d0
   real(8) :: mm
   mm  = 1.d0 + 0.5d0*ALPHA*ALPHA*(ee-vv)
   dg  = - dble(kk)*g + (2.d0/alpha)*mm*r*f
   df  = + dble(kk)*f - alpha*(ee-vv)*r*g
   end subroutine dgdx_dfdx_rel

!=====================================================================
   subroutine dgdx_dfdx_sol(r,g,f,dg,df,ll,ee,vv,bb)
!=====================================================================
!
!  M. Okamoto
!
!---------------------------------------------------------------------  
   implicit none
   integer,intent(in)  :: ll
   real(8),intent(in)  :: r, g, f, ee, vv, bb
   real(8),intent(out) :: dg, df
   dg = dble(ll+1)*g   + r*f
   df = 2.d0*r*(vv-ee)*g - dble(ll+1)*f + 2.d0*r*bb
   end subroutine dgdx_dfdx_sol

