#!/usr/bin/perl
#
#  Copyright (C) 2003, 2004 Masakuni Okamoto.
#
#  This script was written by Masakuni Okamoto.
#
#  2004.04.09  M. Okamoto  dvipdfm has been used to generate .pdf
#  2004.06.28  M. Okamoto  $use_ps2pdf switch has been added.
#
#  Last update: June 28, 2004.
#
$TOOLDIR = '../../../tools';
$use_ps2pdf = 0;
################################################################################
#  Show help message

if(@ARGV < 1 || $ARGV[0]=~/-h/ || $ARGV[0]=~/--help/) {
  print "Usage: makefig_nc.pl jobname\n";
  print "                    [--help]                [-h]\n";
  print "                    [--formatted]           [-f]\n";
  exit(0);
}

################################################################################
#  Generate eps files and "layout_nc.tex"

print `perl $TOOLDIR/print_eps_ldr.pl $ARGV[0] $ARGV[1]`;
print `perl $TOOLDIR/print_eps_ft.pl  $ARGV[0] $ARGV[1]`;
print `perl $TOOLDIR/print_eps_pcc.pl $ARGV[0] $ARGV[1]`;
print `perl $TOOLDIR/print_eps_pp.pl  $ARGV[0] $ARGV[1]`;
print `perl $TOOLDIR/print_eps_sol.pl $ARGV[0] $ARGV[1]`;
print `perl $TOOLDIR/print_eps_us.pl  $ARGV[0] 10.0 $ARGV[1]`;

################################################################################
#  Compile "layout_nc.tex" to get "jobname_fig.pdf"

  print `latex layout_nc`;
if($use_ps2pdf == 0) {
  print `dvipdfm -p a4 -l -o $ARGV[0]_fig.pdf layout_nc.dvi`;
} else {
  print `dvips layout_nc.dvi -t landscape -o $ARGV[0]_fig.ps`;
  print `ps2pdf $ARGV[0]_fig.ps $ARGV[0]_fig.pdf`;
  print `\\rm $ARGV[0]_fig.ps`;
}
print `\\rm layout_*`;
