! ************************************************************* 
!
!   This is a software package CIAO
!
!     developed as a part of the national project "Research and 
!     Development of Innovative Simulation software",which is   
!     supported by the next-generation IT program of MEXT of Japan
!
!   Version history: 
!
!     4.0:  2013/03/01
!           codes for spin-polarized pseudopotential generation are added
!     4.1:  2013/11/22 - 
!           Info of core wfns and energy contributions can be added to gncpp2
!     4.2:  2014/07/23 - 
!           gncpp2 can be geregated even when nmesh /= 1501
!
! ************************************************************* 
!
!  Software name : CIAO (Code for Investigating Atomic Orbitals)
!  Function(s)   : fn_factorial
!  Author(s)     : Masakuni Okamoto (August 25, 2003)
!
!
!  Contact address :  Phase System Consortium
!                     E-mail: phase_system@nims.go.jp URL https://azuma.nims.go.jp
!
!
!  The license of the code and contact address :
!  See the files, COPYRIGHT and LICENSE (or LICENSE_J.pdf)
!
!=====================================================================
   function fn_factorial(n)
!=====================================================================
!
!  Calculates factorial of n
!
!  M. Okamoto
!
!---------------------------------------------------------------------
   implicit none
   integer(8) :: fn_factorial
   integer,intent(in) :: n
   integer :: i
   select case (n)
   case (:-1)
      fn_factorial = 0
   case (0)
      fn_factorial = 1
   case (1:)
      fn_factorial = 1
      do i = 1,n
         fn_factorial = fn_factorial * i
      end do
   case default
   end select
   end function fn_factorial


