! ************************************************************* 
!
!   This is a software package CIAO
!
!     developed as a part of the national project "Research and 
!     Development of Innovative Simulation software",which is   
!     supported by the next-generation IT program of MEXT of Japan
!
!   Version history: 
!
!     4.0:  2013/03/01
!           codes for spin-polarized pseudopotential generation are added
!     4.1:  2013/11/22 - 
!           Info of core wfns and energy contributions can be added to gncpp2
!     4.2:  2014/07/23 - 
!           gncpp2 can be geregated even when nmesh /= 1501
!
! ************************************************************* 
!
!  Software name : CIAO (Code for Investigating Atomic Orbitals)
!  Subroutine(s) : set_infile, open_infile, set_filename, open_logfile
!  Author(s)     : Masakuni Okamoto (August 25, 2003)
!
!
!  Contact address :  Phase System Consortium
!                     E-mail: phase_system@nims.go.jp URL https://azuma.nims.go.jp
!
!
!  The license of the code and contact address :
!  See the files, COPYRIGHT and LICENSE (or LICENSE_J.pdf)
!
!=====================================================================
   subroutine set_infile
!=====================================================================
!
!  M. Okamoto
!
!---------------------------------------------------------------------
   use parameters
   implicit none
   if (have_infile == 0) then
      infile = 'input'
   end if
   end subroutine set_infile

!=====================================================================
   subroutine open_infile
!=====================================================================
!
!  M. Okamoto
!
!---------------------------------------------------------------------
   use parameters
   implicit none
   open(IFIN,file=infile,status='old',err=90) ; go to 10
90 write(*,*) '### ERROR ### infile was not found'
   write(*,*) '   infile ... ',infile
   stop
10 continue
   end subroutine open_infile

!=====================================================================
   subroutine set_filename
!=====================================================================
!
!  M. Okamoto
!
!---------------------------------------------------------------------
   use parameters
   implicit none
   logfile    = trim(jobname)//'.log'
   sumfile    = trim(jobname)//'.sum'
   orbfile    = trim(jobname)//'.orb'
   rhofile    = trim(jobname)//'.rho'
   pccfile    = trim(jobname)//'.pcc'
   usfile     = trim(jobname)//'.us'
   qpsfile    = trim(jobname)//'.qps'
   solfile    = trim(jobname)//'.sol'
   ldrfile    = trim(jobname)//'.ldr'
   ftfile     = trim(jobname)//'.ft'
   ppfile     = trim(jobname)//'.pp'
   gncppfile  = trim(jobname)//'.gncpp'
   gncpp2file = trim(jobname)//'.gncpp2'
   psvppfile  = trim(jobname)//'.psvpp'
   ciaoppfile = trim(jobname)//'.ciaopp'
   infofile   = trim(jobname)//'.info'
   paofile    = trim(jobname)//'.pao'

! ================== KT_add ================== 4.1
!
   file_cor2val = trim(jobname) // '.cor2val'
!
! ============================================ 4.1

   end subroutine set_filename

!=====================================================================
   subroutine open_logfile
!=====================================================================
!
!  M. Okamoto
!
!---------------------------------------------------------------------
   use parameters
   implicit none
   open(IFLOG,file=trim(logfile),status='unknown')
   open(IFSUM,file=trim(sumfile),status='unknown')
   rewind(IFLOG) ; rewind(IFSUM)
   end subroutine open_logfile
