! ************************************************************* 
!
!   This is a software package CIAO
!
!     developed as a part of the national project "Research and 
!     Development of Innovative Simulation software",which is   
!     supported by the next-generation IT program of MEXT of Japan
!
!   Version history: 
!
!     4.0:  2013/03/01
!           codes for spin-polarized pseudopotential generation are added
!     4.1:  2013/11/22 - 
!           Info of core wfns and energy contributions can be added to gncpp2
!     4.2:  2014/07/23 - 
!           gncpp2 can be geregated even when nmesh /= 1501
!
! ************************************************************* 
!
!  Software name : CIAO (Code for Investigating Atomic Orbitals)
!  Subroutine(s) : set_default_param, adjust_param
!  Author(s)     : Masakuni Okamoto (August 25, 2003)
!
!
!  Contact address :  Phase System Consortium
!                     E-mail: phase_system@nims.go.jp URL https://azuma.nims.go.jp
!
!
!  The license of the code and contact address :
!  See the files, COPYRIGHT and LICENSE (or LICENSE_J.pdf)
!
!=====================================================================
   subroutine set_default_param
!=====================================================================
!
!  Sets default parameters
!
!  M. Okamoto
!
!---------------------------------------------------------------------
   use parameters
   implicit none
!--- is_spin
   nspin = 1
!--- core_potential
   core_type_explained = '-Z/r'
   is_core = NORMAL
   h_ok = 1.0d2
   drcl_ok = 0.2d0
   rcut_ok = 0.0d0
!--- xc_potential
   xc_type_explained = 'LDA (PW92-MOMO)'
   is_xc = LDAPW92_MOMO
   is_xc_class = LDA
!--- pseudo_potential
   pp_type_explained = 'No calculation'
   is_pp = NONE
   lmax = 2
   lloc = lmax
!--- core_correction
   pcc_type_explained = 'No core correction'
   is_pcc = NONE
   pcc_method_explained = 'None'
   is_pcc_method = NONE
   r0_pcc = 2.d0
   ng_pcc = 400
   gmin_pcc = 10.d0
   gmax_pcc = 40.d0
!--- core_hole_unscreened
   is_core_hole_unscreened = NO
!--- projector
   is_projector_type = NONE
!--- deficit_charge
   is_deficit_type = POLYNOMIAL
!--- solve_pp_spin
   solve_pp_spin_type_explained = 'No calculation'
   is_solve_pp_spin = NO
!--- logderi
   logderi_type_explained = 'Manual range'
   is_logderi = MANUAL
   ne_logderi = 4001
   emin_logderi  = -15.d0
   emax_logderi  =  +5.d0
   rcut_logderi  =   0.d0
   nrcut_logderi = 0
   is_logderi_method = FREDHOLM
   logderi_method_explained = 'Fredholm method'
   is_logderi_nonlocal = SEPARABLE
   logderi_nonlocal_explained = 'Separable'
!--- fourier
   fourier_type_explained = 'Manual range'
   is_fourier = MANUAL
   ng_fourier = 300
   gmin_fourier = 0.05d0
   gmax_fourier = 15.d0
!--- rmesh
   mesh_type_explained   = 'Logarithmic (Standard)'
   weight_type_explained = 'Extended rule'
   is_mesh   = JRCAT
   is_weight = EXTENDED
   nmesh = 1501  ;  xh = 96.d0  ;  rmax = 60.d0
   rmin = rmax * exp(dble(1-nmesh)/xh)
   dx   = 1.d0/xh
!--- gmesh
   gmin =  0.d0
   gmax = 30.d0
   ng_mesh = 601
!--- mixing
   mix1 = 0.30d0 ; mix2 = 0.30d0
!--- anderson
   n_anderson = 0
!--- conv
   nsave_dee = 5
   loop_conv = 150
   dee_conv  = 1.d-08
!--- order of calculation
   iord_pc    = 5
   iord_diff  = 4
   iord_nec   = 2
   iord_coeff = 5
!--- switches
   is_write_rm        = 1
   is_calc_hubbard    = 0
   is_calc_pao        = 0
   is_write_orbital   = 1
   is_write_rho       = 1
   is_write_us        = 1
   is_write_qps       = 1
   is_write_pcc       = 1
   is_write_pp        = 1
   is_write_ciaopp    = 1
   is_write_gncpp     = 0
   is_write_gncpp2    = 1
   is_write_psvpp     = 0
   is_write_logderi   = 1
   is_write_sol       = 1
   is_write_fourier   = 1
   is_with_dipole     = 1
   is_with_core       = 1
   is_with_ae         = 1
   is_with_so         = 0
   is_paw             = 0
   is_debug           = 0
!--- epsilon
   eps_check = 1.d-10
   eps_de    = 1.d-10

! === KT_add === 4.1
   is_with_dipole_cor2val = 0
! ============== 4.1

! === KT_add === 4.2
   is_write_orbital_index = 0
   is_write_soc_valence = 0
   is_write_soc_core = 0
! ============== 4.2

   end subroutine set_default_param

!=====================================================================
   subroutine adjust_param
!=====================================================================
!
!  Sets default parameters
!
!  M. Okamoto
!
!---------------------------------------------------------------------
   use parameters
   implicit none
!--- is_paw
   if ((is_with_ae /= 0).and.(is_with_core /= 0)) then
      is_paw = 1
   end if
   if (is_paw /= 0) then
      is_with_ae   = 1
      is_with_core = 1
   end if
   end subroutine adjust_param

!=====================================================================
   subroutine adjust_param2
!=====================================================================
!
!  Sets default parameters again after read_input
!
!  T. Yamasaki
!
!---------------------------------------------------------------------
   use parameters
   implicit none
!--- is_paw
   if (is_paw_is_read) then
      if(is_paw == 1) then
         is_with_ae = 1
         is_with_core = 1
      else if(is_paw == 0) then
         is_with_ae = 0
      end if
   end if
 end subroutine adjust_param2
