! ************************************************************* 
!
!   This is a software package CIAO
!
!     developed as a part of the national project "Research and 
!     Development of Innovative Simulation software",which is   
!     supported by the next-generation IT program of MEXT of Japan
!
!   Version history: 
!
!     4.0:  2013/03/01
!           codes for spin-polarized pseudopotential generation are added
!     4.1:  2013/11/22 - 
!           Info of core wfns and energy contributions can be added to gncpp2
!     4.2:  2014/07/23 - 
!           gncpp2 can be geregated even when nmesh /= 1501
!
! ************************************************************* 
!
!  Software name : CIAO (Code for Investigating Atomic Orbitals)
!  Subroutine(s) : date_time, init_time, elapse_time, write_job_time
!                : write_etime, write_etimex, write_total_time
!  Author(s)     : Masakuni Okamoto (August 25, 2003)
!
!
!  Contact address :  Phase System Consortium
!                     E-mail: phase_system@nims.go.jp URL https://azuma.nims.go.jp
!
!
!  The license of the code and contact address :
!  See the files, COPYRIGHT and LICENSE (or LICENSE_J.pdf)
!
!=====================================================================
   subroutine date_time(day_now)
!=====================================================================
!
!  M. Okamoto
!
!---------------------------------------------------------------------
   implicit none
   character(20),intent(out) :: day_now
   integer       :: imonth,iday
   character(20) :: date,time
   character(8)  :: time_now
   character(3)  :: month(12)
   character(4)  :: year
   character(2)  :: day
   month(1) = 'Jan' ; month(2) = 'Feb' ; month(3) = 'Mar'
   month(4) = 'Apr' ; month(5) = 'May' ; month(6) = 'Jun'
   month(7) = 'Jul' ; month(8) = 'Aug' ; month(9) = 'Sep'
   month(10)= 'Oct' ; month(11)= 'Nov' ; month(12)= 'Dec'
   call date_and_time(date,time)
   year = date(1:4)
   read(date(5:6),*) imonth
   read(date(7:8),*) iday
   write(day,'(i2)') iday
   time_now = time(1:2)//':'//time(3:4)//':'//time(5:6)
   day_now  = month(imonth)//' '//day//' '//time_now//' '//year
   end subroutine date_time

!=====================================================================
   subroutine init_time(icount0)
!=====================================================================
!
!  M. Okamoto
!
!---------------------------------------------------------------------
   implicit none
   integer,intent(out) :: icount0
   integer :: icount_rate, icount_max
   icount_max = huge(icount0)
   call system_clock(icount0,icount_rate,icount_max)
   end subroutine init_time

!=====================================================================
   subroutine elapse_time(time_sec,icount0)
!=====================================================================
!
!  M. Okamoto
!
!---------------------------------------------------------------------
   implicit none
   integer,intent(in) :: icount0
   real,intent(out)   :: time_sec
   integer :: icount, icount_rate, icount_max
   icount_max = huge(icount)
   call system_clock(icount,icount_rate,icount_max)
   time_sec = dble(icount-icount0) / dble(icount_rate)
   end subroutine elapse_time

!=====================================================================
   subroutine write_job_time(ifile,day_start,day_end)
!=====================================================================
!
!  M. Okamoto
!
!---------------------------------------------------------------------
   implicit none
   integer,intent(in)       :: ifile
   character(20),intent(in) :: day_start, day_end
   write(ifile,*)
   write(ifile,*) 'Job started at ',day_start
   write(ifile,*) '    ended   at ',day_end
   end subroutine write_job_time

!=====================================================================
   subroutine write_etime(ifile,time)
!=====================================================================
!
!  M. Okamoto
!
!---------------------------------------------------------------------
   implicit none
   integer,intent(in) :: ifile
   real,intent(in)    :: time
   write(ifile,*)
   write(ifile,10) 'etime ---> ',time,' sec'
10 format(1x,a11,f15.6,a4)
   end subroutine write_etime

!=====================================================================
   subroutine write_etimex(ifile,time)
!=====================================================================
!
!  M. Okamoto
!
!---------------------------------------------------------------------
   implicit none
   integer,intent(in) :: ifile
   real,intent(in)    :: time
   write(ifile,10) 'etime ---> ',time,' sec'
10 format(1x,3x,a11,f20.10,a4)
   end subroutine write_etimex

!=====================================================================
   subroutine write_total_time(ifile,total_time)
!=====================================================================
!
!  M. Okamoto
!
!---------------------------------------------------------------------
   implicit none
   integer,intent(in) :: ifile
   real,intent(in)    :: total_time
   write(ifile,*)
   write(ifile,10) 'Total time ==========> ',total_time,' sec '
10 format(1x,a23,f15.6,a5)
   end subroutine write_total_time
