! ************************************************************* 
!
!   This is a software package CIAO
!
!     developed as a part of the national project "Research and 
!     Development of Innovative Simulation software",which is   
!     supported by the next-generation IT program of MEXT of Japan
!
!   Version history: 
!
!     4.0:  2013/03/01
!           codes for spin-polarized pseudopotential generation are added
!     4.1:  2013/11/22 - 
!           Info of core wfns and energy contributions can be added to gncpp2
!     4.2:  2014/07/23 - 
!           gncpp2 can be geregated even when nmesh /= 1501
!
! ************************************************************* 
!
!  Software name : CIAO (Code for Investigating Atomic Orbitals)
!  Subroutine(s) : calc_scf
!  Author(s)     : Masakuni Okamoto (August 25, 2003)
!
!
!  Contact address :  Phase System Consortium
!                     E-mail: phase_system@nims.go.jp URL https://azuma.nims.go.jp
!
!
!  The license of the code and contact address :
!  See the files, COPYRIGHT and LICENSE (or LICENSE_J.pdf)
!
!=====================================================================
   subroutine calc_scf(ier)
!=====================================================================
!
!  M. Okamoto
!
!---------------------------------------------------------------------  
   use parameters   
   implicit none
   integer,intent(out) :: ier
   integer :: loop_scf, is_conv
   ier = 0
   loop_scf = 0
   istart_anderson = loop_scf
SCF: do
   loop_scf = loop_scf + 1
   engy_old(:)     = engy(:)
   rho_old(:,:)    = rho(:,:)
   veff_old(:,:,:) = veff(:,:,:)
   etot_old        = etot_sum
   felec1_old      = felec1
   felec2_old      = felec2
   felec_old       = felec
   if (is_xc_class == GGA) then
   select case (is_xc)
   case (GGAPBE96_MOMO)
      call calc_drho_ddrho(ier)
      if (ier /= 0) then
         write(IFLOG,*) '### ERROR ### in calc_drho_ddrho' ; go to 99
      end if
   case default
      call calc_drho(ier)
      if (ier /= 0) then
         write(IFLOG,*) '### ERROR ### in calc_drho' ; go to 99
      end if
   end select
   end if
   call calc_veff(ier)
   if (ier /= 0) then
      write(IFLOG,*) '### ERROR ### in calc_veff(1)' ; go to 99
   end if
   call calc_bound_state(ier)
   if (ier /= 0) then
      write(IFLOG,*) '### ERROR ### in calc_bound_state' ; go to 99
   end if
   call sort_engy(ier)
   if (ier /= 0) then
      write(IFLOG,*) '### ERROR ### in sort_engy' ; go to 99
   end if
   call set_focc(ier)
   if (ier /= 0) then
      write(IFLOG,*) '### ERROR ### in set_focc' ; go to 99
   end if
   call calc_efermi(ier)
   if (ier /= 0) then
      write(IFLOG,*) '### ERROR ### in calc_efermi' ; go to 99
   end if
   call calc_rho(ier)
   if (ier /= 0) then
      write(IFLOG,*) '### ERROR ### in calc_rho' ; go to 99
   end if
   call calc_etot(ier)
   if (ier /= 0) then
      write(IFLOG,*) '### ERROR ### in calc_etot' ; go to 99
   end if
   call check_conv(ier,is_conv,loop_scf)
   if (ier /= 0) then
      write(IFLOG,*) '### ERROR ### in check_conv' ; go to 99
   end if
   if (is_conv == YES) then
      exit SCF
   end if
   call mix_rho(ier,loop_scf)
   if (ier /= 0) then
      write(IFLOG,*) '### ERROR ### in mix_rho' ; go to 99
   end if
end do SCF
   if (is_xc_class == GGA) then
   select case (is_xc)
   case (GGAPBE96_MOMO)
      call calc_drho_ddrho(ier)
      if (ier /= 0) then
         write(IFLOG,*) '### ERROR ### in calc_drho_ddrho' ; go to 99
      end if
   case default
      call calc_drho(ier)
      if (ier /= 0) then
         write(IFLOG,*) '### ERROR ### in calc_drho' ; go to 99
      end if
   end select
   end if
   call calc_veff(ier)
   if (ier /= 0) then
      write(IFLOG,*) '### ERROR ### in calc_veff(2)' ; go to 99
   end if
99 continue
   end subroutine calc_scf

