! ************************************************************* 
!
!   This is a software package CIAO
!
!     developed as a part of the national project "Research and 
!     Development of Innovative Simulation software",which is   
!     supported by the next-generation IT program of MEXT of Japan
!
!   latest version: 
!
!     4.0:  2013/01/17 
!           codes for spin-polarized pseudopotential generation are added
!
! ************************************************************* 
!
!  Software name : CIAO (Code for Investigating Atomic Orbitals)
!  Function(s)   : fn_number_of_words, fn_is_alphabet, fn_yes_no
!                : fn_label_orbital, fn_label_orbital_capital
!  Author(s)     : Masakuni Okamoto (August 25, 2003)
!
!  The license of the code and contact address :
!  See the files, COPYRIGHT and LICENSE (or LICENSE_J.pdf)
!
!=====================================================================
   function fn_number_of_words(string)
!=====================================================================
!
!  M. Okamoto
!
!---------------------------------------------------------------------
   implicit none
   integer :: fn_number_of_words
   character(*),intent(in) :: string
   integer        :: ipos, lpos
   character(256) :: tmp_string
   tmp_string = trim(adjustl(string))
   lpos       = len(tmp_string)
   fn_number_of_words = 0
   if (lpos == 0) then
      go to 99
   end if
   if (index(tmp_string,' ') == 1) then
      go to 99
   end if
   do while (index(tmp_string,' ') > 1)
      fn_number_of_words = fn_number_of_words + 1
      ipos               = index(tmp_string,' ')
      if (ipos == 0) then
         go to 99
      end if
      tmp_string = adjustl(tmp_string(ipos:lpos))
      tmp_string = adjustl(tmp_string)
   end do
99 continue
   end function fn_number_of_words

!=====================================================================
   function fn_is_alphabet(c)
!=====================================================================
!
!  M. Okamoto
!
!---------------------------------------------------------------------
   implicit none
   logical :: fn_is_alphabet
   character,intent(in) :: c

   if ((lge(c,'a').and.lle(c,'z')).or. &
       (lge(c,'A').and.lle(c,'Z'))) then
      fn_is_alphabet = .true.
   else
      fn_is_alphabet = .false.
   end if
   end function fn_is_alphabet

!=====================================================================
   function fn_yes_no(n)
!=====================================================================
!
!  M. Okamoto
!
!---------------------------------------------------------------------
   implicit none
   integer,intent(in) :: n
   character(3) :: fn_yes_no
   select case (n)
   case (0)
      fn_yes_no = ' no'
   case default
      fn_yes_no = 'yes'
   end select
   end function fn_yes_no

!=====================================================================
   function fn_label_orbital(ll)
!=====================================================================
!
!  M. Okamoto
!
!---------------------------------------------------------------------
   implicit none
   integer,intent(in) :: ll
   character(1) :: fn_label_orbital

   select case (ll)
   case (0)
      fn_label_orbital = 's'
   case (1)
      fn_label_orbital = 'p'
   case (2)
      fn_label_orbital = 'd'
   case (3)
      fn_label_orbital = 'f'
   case (4)
      fn_label_orbital = 'g'
   case (5)
      fn_label_orbital = 'h'
   case (6)
      fn_label_orbital = 'i'
   case (7)
      fn_label_orbital = 'j'
   case (8)
      fn_label_orbital = 'k'
   case (9)
      fn_label_orbital = 'l'
   case default
      fn_label_orbital = '?'
   end select
   end function fn_label_orbital

!=====================================================================
   function fn_label_orbital_capital(ll)
!=====================================================================
!
!  M. Okamoto
!
!---------------------------------------------------------------------
   implicit none
   integer,intent(in) :: ll
   character(1) :: fn_label_orbital, fn_label_orbital_capital

   select case (ll)
   case (0)
      fn_label_orbital = 'S'
   case (1)
      fn_label_orbital = 'P'
   case (2)
      fn_label_orbital = 'D'
   case (3)
      fn_label_orbital = 'F'
   case (4)
      fn_label_orbital = 'G'
   case (5)
      fn_label_orbital = 'H'
   case (6)
      fn_label_orbital = 'I'
   case (7)
      fn_label_orbital = 'J'
   case (8)
      fn_label_orbital = 'K'
   case (9)
      fn_label_orbital = 'L'
   case default
      fn_label_orbital = '?'
   end select
   fn_label_orbital_capital(1:1) = fn_label_orbital(1:1)
   end function fn_label_orbital_capital
