! ************************************************************* 
!
!   This is a software package CIAO
!
!     developed as a part of the national project "Research and 
!     Development of Innovative Simulation software",which is   
!     supported by the next-generation IT program of MEXT of Japan
!
!   latest version: 
!
!     4.0:  2013/01/17 
!           codes for spin-polarized pseudopotential generation are added
!
! ************************************************************* 
!
!  Software name : CIAO (Code for Investigating Atomic Orbitals)
!  Subroutine(s) : lda_x, gga_x
!  Author(s)     : Masakuni Okamoto (August 25, 2003)
!
!  The license of the code and contact address :
!  See the files, COPYRIGHT and LICENSE (or LICENSE_J.pdf)
!
!=====================================================================
   subroutine lda_x(rho1,rho2,ex,ec,vx,vc)
!=====================================================================
!
!  M. Okamoto
!
!---------------------------------------------------------------------
   implicit none
   real(8),intent(in)  :: rho1, rho2
   real(8),intent(out) :: ex, ec, vx(2), vc(2)
   integer :: ispin, spin(2)
   real(8) :: &
      rho, rs, zeta, h, dh, a
   real(8),parameter :: &
      pi = 3.1415926535897932384626433832795028d0, &
      rhomin = 1.d-25, &
      cc43 = 4.d0/3.d0, &
      cc13 = 1.d0/3.d0
   a = 0.45816529328314289347555448505170232d0
   spin(1) = +1 ; spin(2) = -1     
   rho  = rho1 + rho2
   if (rho < rhomin) then
      rho = rhomin
   end if
   rs    = (3.d0/4.d0/pi/rho)**cc13
   zeta  = (rho1 - rho2) / rho
   h  = (1.d0+zeta)**cc43 + (1.d0-zeta)**cc43
   dh = (1.d0+zeta)**cc13 - (1.d0-zeta)**cc13
   ex = -a/rs * (h * 0.5d0)
   ec = 0.d0
   do ispin = 1,2
      vx(ispin) = cc43 * ex &
                * (1.d0 - ( zeta - dble(spin(ispin)) ) * dh/h)
   end do
   do ispin = 1,2
      vc(ispin) = 0.d0
   end do
   end subroutine lda_x

!=====================================================================
   subroutine gga_x( &
                 r, rho1,rho2,drho1,drho2,ddrho1,ddrho2, &
                 ex_gga,ec_gga,vx_gga,vc_gga)
!=====================================================================
!
!  M. Okamoto
!
!---------------------------------------------------------------------
   implicit none
   real(8),intent(in)    :: r, rho1, rho2
   real(8),intent(out)   :: ex_gga, ec_gga, vx_gga(2), vc_gga(2)
   real(8),intent(inout) :: drho1, drho2, ddrho1, ddrho2
   integer :: ispin, spin(2)
   real(8) :: &
     rho, drho, ddrho, zeta, kf1, kf2, s1, s2, &
     fn_ex0, fn_fx_pbe96, fn_fx1_pbe96, fn_fx2_pbe96, &
     ex0, ex0_1, ex0_2, fx0_1, fx0_2, fx1_1, fx1_2, fx2_1, fx2_2, &
     tmp1, tmp2
   real(8),parameter :: &
      pi      = 3.1415926535897932384626433832795029d0,  &
      pipi    = 9.8696044010893586188344909998761511d0,  &
      frac1_3 = 0.33333333333333333333333333333333333d0, &
      frac4_3 = 1.33333333333333333333333333333333333d0, &
      rhomin  = 1.d-30
   real(8),parameter :: &
      kappa = 0.8040d0,              &
      beta  = 0.06672455060314922d0, &
      mu       = 0.21951497278705521609828723131160858d0, &
      mu_kappa = 0.27302857315259963733997193463227010d0
   spin(1) = +1 ; spin(2) = -1
   if (rho1 < rhomin) then
      drho1 = 0.d0 ; ddrho1 = 0.d0
   end if
   if (rho2 < rhomin) then
      drho2 = 0.d0 ; ddrho2 = 0.d0
   end if
   rho   = rho1   + rho2
   drho  = drho1  + drho2
   ddrho = ddrho1 + ddrho2
   if (abs(rho1-rho2) < rhomin) then
      zeta  = 0.d0
   else if (rho2 < rhomin) then
      zeta  = +1.d0
   else if (rho1 < rhomin) then
      zeta  = -1.d0
   else
      zeta  = (rho1 - rho2) / rho
   end if
   kf1   = (6.d0*pipi*rho1)**(frac1_3)
   kf2   = (6.d0*pipi*rho2)**(frac1_3)
   if (rho1 < rhomin) then
      s1 = 0.d0
   else
      s1 = abs(drho1) / (2.d0*kf1*rho1)
   end if
   if (rho2 < rhomin) then
      s2 = 0.d0
   else
      s2 = abs(drho2) / (2.d0*kf2*rho2)
   end if
   ex0   = fn_ex0      (     rho )
   ex0_1 = fn_ex0      (2.d0*rho1)
   ex0_2 = fn_ex0      (2.d0*rho2)
   fx0_1 = fn_fx_pbe96 (s1, kappa)
   fx0_2 = fn_fx_pbe96 (s2, kappa)
   fx1_1 = fn_fx1_pbe96(s1, kappa)
   fx1_2 = fn_fx1_pbe96(s2, kappa)
   fx2_1 = fn_fx2_pbe96(s1, kappa)
   fx2_2 = fn_fx2_pbe96(s2, kappa)
   ex_gga = ex0 * 0.5d0 &
           * ( (1.d0+zeta)**(frac4_3) * fx0_1 &
              +(1.d0-zeta)**(frac4_3) * fx0_2 )
   ec_gga = 0.d0
   if (rho1 < rhomin) then
      tmp1 = 0.d0
   else
      tmp1 = (1.d0 - 3.d0*s1*s1*mu_kappa) / (1.d0 + s1*s1*mu_kappa) &
              * (ddrho1/rho1) &
           + 2.d0/r * (drho1/rho1)
      tmp1 = tmp1 &
              * 2.d0*mu * (0.5d0/kf1)**2 / (1.d0 + s1*s1*mu_kappa)**2
   end if

   if (rho2 < rhomin) then
      tmp2 = 0.d0
   else
      tmp2 = (1.d0 - 3.d0*s2*s2*mu_kappa) / (1.d0 + s2*s2*mu_kappa) &
              * (ddrho2/rho2) &
           + 2.d0/r * (drho2/rho2)
      tmp2 = tmp2 &
              * 2.d0*mu * (0.5d0/kf2)**2 / (1.d0 + s2*s2*mu_kappa)**2
   end if
   vx_gga(1) = ex0_1 * ( + (frac4_3) * (fx0_1 - fx2_1) - tmp1 )
   vx_gga(2) = ex0_2 * ( + (frac4_3) * (fx0_2 - fx2_2) - tmp2 )
   do ispin = 1,2
      vc_gga(ispin) = 0.d0
   end do
   end subroutine gga_x
