! ************************************************************* 
!
!   This is a software package CIAO
!
!     developed as a part of the national project "Research and 
!     Development of Innovative Simulation software",which is   
!     supported by the next-generation IT program of MEXT of Japan
!
!   latest version: 
!
!     4.0:  2013/01/17 
!           codes for spin-polarized pseudopotential generation are added
!
! ************************************************************* 
!
!  Software name : CIAO (Code for Investigating Atomic Orbitals)
!  Subroutine(s) : get_args
!  Author(s)     : Masakuni Okamoto (August 25, 2003)
!
!  The license of the code and contact address :
!  See the files, COPYRIGHT and LICENSE (or LICENSE_J.pdf)
!
!=====================================================================
   subroutine get_args
!=====================================================================
!
!  M. Okamoto
!
!---------------------------------------------------------------------
   use parameters
   implicit none
   integer :: iargc
   integer :: iarg, sw_show_help
   sw_show_help = 0
   have_infile = 0
   narg = iargc()
   if (narg == 0) then
      have_args = 0
      sw_show_help = 1
   else
      have_args = 1
      do iarg = 1,narg
         call getarg(iarg,argv(iarg))
         select case (argv(iarg)(1:1))
         case ('-')
            select case (argv(iarg))
            case ('--help', '-h', &
                  '--version', '-v')
               sw_show_help = 1
            case default
               write(*,*) '### ERROR ### flags are not correct.'
               sw_show_help = 1
            end select
         case default
            have_infile = 1
            infile = argv(iarg)
         end select
      end do
   end if
   if (have_infile == 0) then
      sw_show_help = 1
   end if
   if (sw_show_help == 1) then
      call write_version(6)
      write(*,*) '+------------------------------------------------+'
      write(*,*) '|  Usage: ciao input_file [flags ... ]           |'
      write(*,*) '|                                                |'
      write(*,*) '|     input_file ... input-file name             |'
      write(*,*) '|      -help     ... show help message           |'
      write(*,*) '+------------------------------------------------+'
      stop
   end if
99 continue
   end subroutine get_args
