#!/usr/bin/perl
#
#  Copyright (C) 2003, 2004 Takenori Yamamoto and Masakuni Okamoto.
#
#  This perl script was originally written by Takenori Yamamoto.
#  The script was modified by Masakuni Okamoto.
#
#  Last update: March 1, 2004.
#
################################################################################
#///////////////////////////// Fourier transforms //////////////////////////////

$gmin =  0;
$gmax = 15;
@lang = ('s','p','d','f');
@ntic = (1,2,5,10,20,50,100);
$ggv_min = +1.0e3;
$ggv_max = -1.0e3;

################################################################################
#  Read data

print "*** Fourier transforms ***\n";
print "@ARGV\n";
$infile = "$ARGV[0]" . ".ft";
print "<IN> = $infile\n";
if(! -e "$infile") {
  print "#############################################################\n";
  print "##   File not exists  -->  $infile\n";
  print "##   Please prepare the missing file.\n";
  print "#############################################################\n";
  exit(1);
} else {
  print "File exists --> $infile\n";
}
open(IN,"<$infile");
while($line = <IN>) {
  if($line =~/Element/) {
    ($element) = split(' ',$line);
    print "$element\n";
  } elsif($line =~/ng_fourier/) {
    ($ng_fourier) = split(':',$line);
    print "$ng_fourier\n";
    last;
  }
}
$m=0;
while($line = <IN>) {
  if($line =~/n, l, 2/) {
    ($n,$l,$j2,$s) = split(' ',$line);
    $ll[$m] = $l;
    print "$n$lang[$l], $j2, $s\n";
  } elsif($line =~/elevel/) {
    ($elevel) = split(':',$line);
    print "   Eref: $elevel\n";
  } elsif($line =~/rcut/) {
    ($rcut) = split(':',$line);
    print "   Rc  : $rcut\n";
  } elsif($line =~/local/) {
    $file0 = "ft" . "_$element" . "_local" . ".dat";
    print "   file = $file0\n";
    open(OUT,">$file0");
    for($i=0;$i<$ng_fourier;$i++) {
      ($gpos,$gg_vionk_ps) = split(' ',<IN>);
      if($gg_vionk_ps > $ggv_max) {$ggv_max = $gg_vionk_ps;}
      if($gg_vionk_ps < $ggv_min) {$ggv_min = $gg_vionk_ps;}
       print OUT "$gpos $gg_vionk_ps\n";
    }
    close(OUT);
  } elsif($line =~/gpos/) {
    $file[$m] = "ft" . "_$element" . "_$n$lang[$l]" . ".dat";
    print "   file = $file[$m]\n";
    open(OUT,">$file[$m]");
    for($i=0;$i<$ng_fourier;$i++) {
      ($gpos,$gg_vionk,$gg_vionk_ps) = split(' ',<IN>);
      if($gg_vionk_ps > $ggv_max) {$ggv_max = $gg_vionk_ps;}
      if($gg_vionk_ps < $ggv_min) {$ggv_min = $gg_vionk_ps;}
       print OUT "$gpos $gg_vionk $gg_vionk_ps\n";
    }
    close(OUT);
    $m++;
  }
}
close(IN);

################################################################################
#  gnuplot

### Parameters
$ndiv_max = 5;

##### Fourier transform of potentials V(r) #####
open(OUT,">$$.gpi");
print OUT "set terminal postscript eps enhanced color solid \"Helvetica\" 12\n";
$ft_file = "$ARGV[0]" . "_ft" . ".eps";
print OUT "set output \"$ft_file\"\n";
print OUT "set xzeroaxis\n";
print OUT "set border 31 lw 1\n";

print OUT "set size 0.5,0.5\n";
#print OUT "set key right bottom\n";
print OUT "set nokey\n";
print OUT "set xtics 5\n";
print OUT "set mxtics 5\n";
for($i=0;($ggv_max-$ggv_min)/$ntic[$i] > $ndiv_max;$i++) {next;}
$ytics_guess = $ntic[$i];
print OUT "set ytics $ytics_guess\n";
print OUT "set mytics $ytics_guess\n";
print OUT "set xlabel \"q\"\n";
print OUT "set ylabel \"q^{2}V_{/Times-Italic l}(q)\"\n";

print OUT "plot [$gmin:$gmax] \\\n";
$ic = 0;
for($i=0;$i<$m;$i++) {
  if($ic != 0) {print OUT ", \\\n";}
  $line_type = $ll[$i]+1;
  print OUT "\'$file[$i]\' u 1:3 t \'$lang[$ll[$i]]\' w l lt $line_type lw 4";
  $ic++;
}
if($ic != 0) {print OUT ", \\\n";}
$line_type = 0;
print OUT "\'$file0\' u 1:2 t \'local\' w l lt $line_type lw 1";
$ic++;
print OUT "\n";
close(OUT);

`gnuplot $$.gpi`;
`rm $$.gpi`;

`rm $file0`;
for($i=0;$i<$m;$i++) {`rm $file[$i]`;}
