! ************************************************************* 
!
!   This is a software package CIAO
!
!     developed as a part of the national project "Research and 
!     Development of Innovative Simulation software",which is   
!     supported by the next-generation IT program of MEXT of Japan
!
!   latest version: 
!
!     4.0:  2013/01/17 
!           codes for spin-polarized pseudopotential generation are added
!
! ************************************************************* 
!
!  Software name : CIAO (Code for Investigating Atomic Orbitals)
!  Subroutine(s) : set_version, write_title, write_version
!  Author(s)     : Masakuni Okamoto (August 25, 2003)
!
!  The license of the code and contact address :
!  See the files, COPYRIGHT and LICENSE (or LICENSE_J.pdf)
!
!=====================================================================
   subroutine set_version
!=====================================================================
!
!  M. Okamoto
!
!---------------------------------------------------------------------
   use parameters
   implicit none

  !================   version number should not exceed 4-characters.
   version = '3.00'
  !================

  !======================   date should not exceed 11-characters.
   vdate = '2011-FEB-28'
  !======================

! ==================================== modified by K. T. ========== 4.0
   version = '4.00'
   vdate = '2013-Mar-01'
! ================================================================= 4.0

   end subroutine set_version

!=====================================================================
   subroutine write_title(ifile,day_in)
!=====================================================================
!
!  M. Okamoto
!
!---------------------------------------------------------------------
   use parameters
   implicit none
   integer,intent(in)       :: ifile
   character(20),intent(in) :: day_in
   write(ifile,*)
   write(ifile,'(a)')  '********************************'
   write(ifile,'(5a)') '***   CIAO   version ',version,'    ***','    ',day_in
   write(ifile,'(3a)') '***          ',vdate,'     ***'
   write(ifile,'(a)')  '********************************'
   end subroutine write_title

!=====================================================================
   subroutine write_version(ifile)
!=====================================================================
!
!  M. Okamoto
!
!---------------------------------------------------------------------
   use parameters
   implicit none
   integer,intent(in) :: ifile
   write(ifile,*)
   write(ifile,'(a)')  '********************************'
   write(ifile,'(3a)') '***   CIAO   version ',version,'    ***'
   write(ifile,'(3a)') '***          ',vdate,'     ***'
   write(ifile,'(a)')  '********************************'
   end subroutine write_version

