#!/usr/bin/perl
#
#  Copyright (C) 2003, 2004 Takenori Yamamoto and Masakuni Okamoto.
#
#  This perl script was originally written by Takenori Yamamoto.
#  The script was modified by Masakuni Okamoto.
#
#  Last update: December 24, 2004.
#
################################################################################
#//////////////////////////////// Wave functions ///////////////////////////////

$rmax_phi  = 10;  $gmax_phi  = 10;
$rmin_phi  =  0;  $gmin_phi  =  0;

$rmax_beta =  5;  $gmax_beta = 20;
$rmin_beta =  0;  $gmin_beta =  0;

$rphi_max_plot =  3;  $gphi_max_plot =  3;
$rphi_min_plot = -2;  $gphi_min_plot = -2;

@lang = ('s','p','d','f');
@ntic = (0.01,0.02,0.05,0.1,0.2,0.5,1,2,5,10,20,50,100,200,500,
         1000,2000,5000,10000,20000,50000,100000,200000,500000,
         1000000,2000000,5000000);

################################################################################
#  Read data from a command-line

if(@ARGV<1) {
  print "Usage: print_eps_us_qps FileTitle [--formatted]\n";
  exit(0);
} else {
  $is_formatted = 0;
  foreach $s (@ARGV) {
    if($s =~/--formatted/ || $s =~/-f/) {
      $is_formatted = 1;
    }
  }
}

################################################################################
#  Read data from a file

print "*** Wavefunctions ***\n";
print "@ARGV\n";
$infile = "$ARGV[0]" . ".us";
print "<IN> = $infile\n";
if(! -e "$infile") {
  print "#############################################################\n";
  print "##   File not exists  -->  $infile\n";
  print "##   Please prepare the missing file.\n";
  print "#############################################################\n";
} else {
  print "File exists --> $infile\n";

open(IN,"<$infile");
while($line = <IN>) {
  if($line =~/Element/) {
    ($element) = split(' ',$line);
    print "$element\n";
  } elsif($line =~/ng_mesh/) {
    @line=split(' ',$line);
    $nmesh = $line[0];
    $gmesh = $line[1];
    print "nmesh   : $nmesh\n";
    print "ng_mesh : $gmesh\n";
    last;
  }
}
$mr = 0;
$mg = 0;
while($line = <IN>) {
  if($line =~/ln,tn/) {
    @line=split(' ',$line);
    $l=$line[2];
    $t=$line[3];
    print "$lang[$l]($t)\n";
  } elsif($line =~/pp_type/) {
    @line=split(' ',$line);
    $pp_type = $line[2];
    print "   PP_type : $pp_type\n";
  } elsif($line =~/eref/) {
    @line=split(' ',$line);
    $ee = $line[2];
    print "   Eref    : $ee\n";
  } elsif($line =~/rcut/) {
    @line=split(' ',$line);
    $rr = $line[2];
    print "   Rc      : $rr\n";
  } elsif($line =~/rpos/) {
    print "   Real-space\n";
    $rphi_max[$mr]  = -1.0e3;
    $rphi_min[$mr]  = +1.0e3;
    $rbeta_max[$mr] = -1.0e3;
    $rbeta_min[$mr] = +1.0e3;
    $rfile[$mr] = "usr" . "_$element" . "_$l" . "_$t" . ".dat";
    $ll[$mr] = $l;
    $tt[$mr] = $t;
    $type[$mr] = $pp_type;
    $eref[$mr] = $ee;
    $rcut[$mr] = $rr;
    $have_zero[$mr] = 0;
    $r0[$mr]      = -1.0e3;
    $r1[$mr]      = -1.0e3;
    $ifound0[$mr] = 0;
    $ifound1[$mr] = 0;
    $rpsi0[$mr]   = 0;
    $rpsi1[$mr]   = 0;
    open(OUT,">$rfile[$mr]");
    $ic = 0;
    for($i=0;$i<$nmesh-1;$i++) {
      ($rpos,$rpsi,$rphi,$rchi,$rbeta) = split(' ',<IN>);
      if($rpsi > $rphi_max[$mr]) {$rphi_max[$mr] = $rpsi;}
      if($rpsi < $rphi_min[$mr]) {$rphi_min[$mr] = $rpsi;}
      if($rphi > $rphi_max[$mr]) {$rphi_max[$mr] = $rphi;}
      if($rphi < $rphi_min[$mr]) {$rphi_min[$mr] = $rphi;}
      if($rchi > $rbeta_max[$mr]) {$rbeta_max[$mr] = $rchi;}
      if($rchi < $rbeta_min[$mr]) {$rbeta_min[$mr] = $rchi;}
      if($rbeta > $rbeta_max[$mr]) {$rbeta_max[$mr] = $rbeta;}
      if($rbeta < $rbeta_min[$mr]) {$rbeta_min[$mr] = $rbeta;}
      if($rpos < $rcut[$mr] && $ifound0[$mr] == 0) 
        {$r0[$mr] = $rpos; $rpsi0[$mr] = $rpsi;} else {$ifound0[$mr] = 1;}
      if($ifound0[$mr] == 1 && $ifound1[$mr] == 0) 
        {$r1[$mr] = $rpos; $rpsi1[$mr] = $rpsi; $ifound1[$mr] = 1;}
      if((abs($rpsi) < 1.0e-10 && $rpos > 0.1 && $rpos < 8) || ($rpos > 8 && $ic > 10)) {
        $rpsi = 'zero';}
      if((abs($rphi) < 1.0e-10 && $rpos > 0.1 && $rpos < 8) || ($rpos > 8 && $ic > 10)) {
        $rphi = 'zero'; $have_zero[$mr] = 1; $ic++;}
      print OUT "$rpos $rpsi $rphi $rchi $rbeta\n";
    }
    $mr++;
    close(OUT);
  } elsif($line =~/gpos/) {
    print "   Reciprocal-space\n";
    $gphi_max[$mg]  = -1.0e3;
    $gphi_min[$mg]  = +1.0e3;
    $gbeta_max[$mg] = -1.0e3;
    $gbeta_min[$mg] = +1.0e3;
    $gfile[$mg] = "usg" . "_$element" . "_$l" . "_$t" . ".dat";
    open(OUT,">$gfile[$mg]");
    for($i=0;$i<$gmesh-1;$i++) {
      ($gpos,$gpsi,$gphi,$gchi,$gbeta) = split(' ',<IN>);
      if($gpsi > $gphi_max[$mg]) {$gphi_max[$mg] = $gpsi;}
      if($gpsi < $gphi_min[$mg]) {$gphi_min[$mg] = $gpsi;}
      if($gphi > $gphi_max[$mg]) {$gphi_max[$mg] = $gphi;}
      if($gphi < $gphi_min[$mg]) {$gphi_min[$mg] = $gphi;}
      if($gchi > $gbeta_max[$mg]) {$gbeta_max[$mg] = $gchi;}
      if($gchi < $gbeta_min[$mg]) {$gbeta_min[$mg] = $gchi;}
      if($gbeta > $gbeta_max[$mg]) {$gbeta_max[$mg] = $gbeta;}
      if($gbeta < $gbeta_min[$mg]) {$gbeta_min[$mg] = $gbeta;}
      print OUT "$gpos $gpsi $gphi $gchi $gbeta\n";
    }
    $mg++;
    close(OUT);
  }
}
close(IN);
for($i=0;$i<$mg;$i++) {print "$i, $have_zero[$i]\n";}

for($i=0;$i<$mr;$i++) {
  print "$i: $lang[$ll[$i]]$tt[$i]\n";
}

$m_us = 0;
$ln[$m_us] = $ll[0]; $tmax[$m_us] = 1; $lt[$m_us][$tmax[$m_us]] = 0;
for($i=1;$i<$mr;$i++) {
  $ln_test = $ll[$i];
  for($j=0;$j<=$m_us;$j++) {
    if($ln_test == $ln[$j]) {$tmax[$j]++; $lt[$m_us][$tmax[$m_us]] = $i; last;}
    if($j == $m_us) {$m_us++; $ln[$m_us] = $ll[$i]; $tmax[$m_us] = 0; $lt[$m_us][$tmax[$m_us]] = $i;}
  }
}
print "m = $m_us\n";
$k = 0;
for($i=0;$i<=$m_us;$i++) {
  print "   tmax = $tmax[$i]\n";
  for($j=1;$j<=$tmax[$i];$j++) { $k++;
    print "      $k: (l,t) = ($ln[$i],$j), (i,j) = ($i,$j) --> $lt[$i][$j]\n";
  }
}

for($i=0;$i<=$m_us;$i++) {
  $rphi_n_max[$i] = -1.0e3;
  $rphi_n_min[$i] = +1.0e3;
  $gphi_n_max[$i] = -1.0e3;
  $gphi_n_min[$i] = +1.0e3;
  $rbeta_n_max[$i] = -1.0e3;
  $rbeta_n_min[$i] = +1.0e3;
  $gbeta_n_max[$i] = -1.0e3;
  $gbeta_n_min[$i] = +1.0e3;
  for($j=1;$j<=$tmax[$i];$j++) {
    $test = $rphi_max[$lt[$i][$j]];  if($test > $rphi_n_max[$i])  {$rphi_n_max[$i]  = $test;}
    $test = $rphi_min[$lt[$i][$j]];  if($test < $rphi_n_min[$i])  {$rphi_n_min[$i]  = $test;}
    $test = $rbeta_max[$lt[$i][$j]]; if($test > $rbeta_n_max[$i]) {$rbeta_n_max[$i] = $test;}
    $test = $rbeta_min[$lt[$i][$j]]; if($test < $rbeta_n_min[$i]) {$rbeta_n_min[$i] = $test;}
    $test = $gphi_max[$lt[$i][$j]];  if($test > $gphi_n_max[$i])  {$gphi_n_max[$i]  = $test;}
    $test = $gphi_min[$lt[$i][$j]];  if($test < $gphi_n_min[$i])  {$gphi_n_min[$i]  = $test;}
    $test = $gbeta_max[$lt[$i][$j]]; if($test > $gbeta_n_max[$i]) {$gbeta_n_max[$i] = $test;}
    $test = $gbeta_min[$lt[$i][$j]]; if($test < $gbeta_n_min[$i]) {$gbeta_n_min[$i] = $test;}
  }
}

################################################################################
#  gnuplot

### Parameters
$ndiv_max = 5;

##### r*phi(r) #####
for($i=0;$i<=$m_us;$i++) {
  open(OUT,">$$.gpi");
  $l = $ln[$i];
  $rphi_file[$i] = "$ARGV[0]" . "_us" . "_rphi" . "_$lang[$l]" . ".eps";
  print "$rphi_file[$i]\n";
  print OUT "set terminal postscript eps enhanced color solid \"Helvetica\" 12\n";
  print OUT "set output \"$rphi_file[$i]\"\n";
  print OUT "set xzeroaxis\n";
  print OUT "set border 31 lw 1\n";
  print OUT "set missing \"zero\"\n";
  print OUT "set size 0.5,0.5\n";
  print OUT "set key right top\n";
  #print OUT "set nokey\n";
  print OUT "set xtics 1\n";
  print OUT "set mxtics 1\n";
  if($rphi_n_max[$i] > $rphi_max_plot) {$rphi_n_max[$i] = $rphi_max_plot;}
  if($rphi_n_min[$i] < $rphi_min_plot) {$rphi_n_min[$i] = $rphi_min_plot;}
  for($p=0;int(($rphi_n_max[$i]-$rphi_n_min[$i])/$ntic[$p]) > $ndiv_max;$p++) {next;}
  $ytics_guess = $ntic[$p];
  $rphi_max_guess = int($rphi_n_max[$i]/$ntic[$p])*$ntic[$p]+$ntic[$p];
  $rphi_min_guess = int($rphi_n_min[$i]/$ntic[$p])*$ntic[$p]-$ntic[$p];
  print OUT "set ytics $ytics_guess\n";
  print OUT "set mytics 1\n";
  print OUT "set format x \"%1.0f\"\n";
  #print OUT "set format y \"%2.0f\"\n";
  if($ytics_guess < 0.1) {
  print OUT "set format y \"%4.2f\"\n";
  } elsif($ytics_guess < 1) {
  print OUT "set format y \"%3.1f\"\n";
  } else {
  print OUT "set format y \"%2.0f\"\n"; 
  }
  print OUT "set xlabel \"r\"\n";
  print OUT "set ylabel \"r{/Symbol y}_{/Times-Italic n}(r)\"\n";
  print OUT "set label \"$element\" center at graph 0.11,0.86 font \"Helvetica-Bold,36\"\n";
  print OUT "plot [$rmin_phi:$rmax_phi][$rphi_min_guess:$rphi_max_guess] \\\n";
  $ic = 0;
  for($j=1;$j<=$tmax[$i];$j++) {
    $k = $lt[$i][$j]; $t = $j;
    if($ic != 0) {print OUT ", \\\n";}
    $line_type = $j;
    print OUT "\"$rfile[$k]\" u 1:2 notitle           w l lt $line_type lw 1, \\\n";
    print OUT "\"$rfile[$k]\" u 1:3 t \"$lang[$l]$t\" w l lt $line_type lw 4";
    $ic++;
  }
  print OUT "\n";
  for($j=1;$j<=$tmax[$i];$j++) {
    $k = $lt[$i][$j]; $t = $j;
    print OUT "set arrow from $r0[$k],$rpsi0[$k]-0.3 to $r0[$k],$rpsi0[$k]-0.03 lt $t lw 1\n";
  }
  close(OUT);
  `gnuplot $$.gpi`;
  `rm $$.gpi`;
}

##### r*beta(r) #####
for($i=0;$i<=$m_us;$i++) {
  open(OUT,">$$.gpi");
  $l = $ln[$i];
  $rbeta_file[$i] = "$ARGV[0]" . "_us" . "_rbeta" . "_$lang[$l]" . ".eps";
  print "$rbeta_file[$i]\n";
  print OUT "set terminal postscript eps enhanced color solid \"Helvetica\" 12\n";
  print OUT "set output \"$rbeta_file[$i]\"\n";
  print OUT "set xzeroaxis\n";
  print OUT "set border 31 lw 1\n";
  print OUT "set missing \"zero\"\n";
  print OUT "set size 0.5,0.5\n";
  #print OUT "set key right top\n";
  print OUT "set nokey\n";
  print OUT "set xtics 1\n";
  print OUT "set mxtics 1\n";
  for($p=0;int(($rbeta_n_max[$i]-$rbeta_n_min[$i])/$ntic[$p]) > $ndiv_max;$p++) {next;}
  $ytics_guess = $ntic[$p];
  $rbeta_max_guess = int($rbeta_n_max[$i]/$ntic[$p])*$ntic[$p]+$ntic[$p];
  $rbeta_min_guess = int($rbeta_n_min[$i]/$ntic[$p])*$ntic[$p]-$ntic[$p];
  print OUT "set ytics $ytics_guess\n";
  print OUT "set mytics 1\n";
  print OUT "set format x \"%1.0f\"\n";
  #print OUT "set format y \"%2.0f\"\n";
  if($ytics_guess < 0.1) {
  print OUT "set format y \"%4.2f\"\n";
  } elsif($ytics_guess < 1) {
  print OUT "set format y \"%3.1f\"\n";
  } elsif($ytics_guess < 10) {
  print OUT "set format y \"%2.0f\"\n";
  } elsif($ytics_guess < 100) {
  print OUT "set format y \"%3.0f\"\n";
  } else {
  print OUT "set format y \"%4.0f\"\n"; 
  }
  print OUT "set xlabel \"r\"\n";
  print OUT "set ylabel \"r{/Symbol c}_{/Times-Italic n}(r), r{/Symbol b}_{/Times-Italic n}(r)\"\n";
  print OUT "plot [$rmin_beta:$rmax_beta][$rbeta_min_guess:$rbeta_max_guess] \\\n";
  $ic = 0;
  for($j=1;$j<=$tmax[$i];$j++) {
    $k = $lt[$i][$j]; $t = $j;
    if($ic != 0) {print OUT ", \\\n";}
    $line_type = $j;
    #print OUT "\"$rfile[$k]\" u 1:4 notitle           w l lt $line_type lw 1";
    print OUT "\"$rfile[$k]\" u 1:4 notitle           w l lt $line_type lw 1, \\\n";
    print OUT "\"$rfile[$k]\" u 1:5 t \"$lang[$l]$t\" w l lt $line_type lw 4";
    $ic++;
  }
  print OUT "\n";
  $ic = 0;
  if($is_formatted == 1) {
    print OUT "set label \"Rc($lang[$l]$t)=%8.5f\",$rcut[$lt[$i][$j]] \\\n";
  } else {
    $tmp = int($rcut[$lt[$i][$j]]*1.0e5)*1.0e-5;
    print OUT "set label \"Rc($lang[$l]$t)=$tmp\" \\\n";
  }
  print OUT "at graph 0.68,0.9-$ic*0.05 font \"Courier,9\"\n";
  print OUT "\n";
  close(OUT);
  `gnuplot $$.gpi`;
  `rm $$.gpi`;
}

##### g*phi(g) #####
for($i=0;$i<=$m_us;$i++) {
  open(OUT,">$$.gpi");
  $l = $ln[$i];
  $gphi_file[$i] = "$ARGV[0]" . "_us" . "_gphi" . "_$lang[$l]" . ".eps";
  print "$gphi_file[$i]\n";
  print OUT "set terminal postscript eps enhanced color solid \"Helvetica\" 12\n";
  print OUT "set output \"$gphi_file[$i]\"\n";
  print OUT "set xzeroaxis\n";
  print OUT "set border 31 lw 1\n";
  print OUT "set missing \"zero\"\n";
  print OUT "set size 0.5,0.5\n";
  #print OUT "set key right top\n";
  print OUT "set nokey\n";
  print OUT "set xtics 5\n";
  print OUT "set mxtics 5\n";
  if($gphi_n_max[$i] > $gphi_max_plot) {$gphi_n_max[$i] = $gphi_max_plot;}
  if($gphi_n_min[$i] < $gphi_min_plot) {$gphi_n_min[$i] = $gphi_min_plot;}
  for($p=0;($gphi_n_max[$i]-$gphi_n_min[$i])/$ntic[$p] > $ndiv_max;$p++) {next;}
  $ytics_guess = $ntic[$p];
  $gphi_max_guess = int($gphi_n_max[$i]/$ntic[$p])*$ntic[$p]+$ntic[$p];
  $gphi_min_guess = int($gphi_n_min[$i]/$ntic[$p])*$ntic[$p]-$ntic[$p];
  print OUT "set ytics $ytics_guess\n";
  print OUT "set mytics 1\n";
  print OUT "set format x \"%1.0f\"\n";
  #print OUT "set format y \"%2.0f\"\n";
  if($ytics_guess < 0.1) {
  print OUT "set format y \"%4.2f\"\n";
  } elsif($ytics_guess < 1) {
  print OUT "set format y \"%3.1f\"\n";
  } elsif($ytics_guess < 10) {
  print OUT "set format y \"%2.0f\"\n";
  } elsif($ytics_guess < 100) {
  print OUT "set format y \"%3.0f\"\n";
  } else {
  print OUT "set format y \"%4.0f\"\n"; 
  }
  print OUT "set xlabel \"q\"\n";
  print OUT "set ylabel \"q{/Symbol y}_{/Times-Italic n}(q)\"\n";
  print OUT "plot [$gmin_phi:$gmax_phi][$gphi_min_guess:$gphi_max_guess] \\\n";
  $ic = 0;
  for($j=1;$j<=$tmax[$i];$j++) {
    $k = $lt[$i][$j]; $t = $j;
    if($ic != 0) {print OUT ", \\\n";}
    $line_type = $j;
    print OUT "\"$gfile[$k]\" u 1:2 notitle           w l lt $line_type lw 1, \\\n";
    print OUT "\"$gfile[$k]\" u 1:3 t \"$lang[$l]$t\" w l lt $line_type lw 4";
    $ic++;
  }
  print OUT "\n";
  close(OUT);
  `gnuplot $$.gpi`;
  `rm $$.gpi`;
}

##### g*beta(g) #####
for($i=0;$i<=$m_us;$i++) {
  open(OUT,">$$.gpi");
  $l = $ln[$i];
  $gbeta_file[$i] = "$ARGV[0]" . "_us" . "_gbeta" . "_$lang[$l]" . ".eps";
  print "$gbeta_file[$i]\n";
  print OUT "set terminal postscript eps enhanced color solid \"Helvetica\" 12\n";
  print OUT "set output \"$gbeta_file[$i]\"\n";
  print OUT "set xzeroaxis\n";
  print OUT "set border 31 lw 1\n";
  print OUT "set missing \"zero\"\n";
  print OUT "set size 0.5,0.5\n";
  #print OUT "set key right top\n";
  print OUT "set nokey\n";
  print OUT "set xtics 5\n";
  print OUT "set mxtics 5\n";
  for($p=0;($gbeta_n_max[$i]-$gbeta_n_min[$i])/$ntic[$p] > $ndiv_max;$p++) {next;}
  $ytics_guess = $ntic[$p];
  $gbeta_max_guess = int($gbeta_n_max[$i]/$ntic[$p])*$ntic[$p]+$ntic[$p];
  $gbeta_min_guess = int($gbeta_n_min[$i]/$ntic[$p])*$ntic[$p]-$ntic[$p];
  print OUT "set ytics $ytics_guess\n";
  print OUT "set mytics 1\n";
  print OUT "set format x \"%1.0f\"\n";
  #print OUT "set format y \"%2.0f\"\n";
  if($ytics_guess < 0.1) {
  print OUT "set format y \"%4.2f\"\n";
  } elsif($ytics_guess < 1) {
  print OUT "set format y \"%3.1f\"\n";
  } elsif($ytics_guess < 10) {
  print OUT "set format y \"%2.0f\"\n";
  } elsif($ytics_guess < 100) {
  print OUT "set format y \"%3.0f\"\n";
  } else {
  print OUT "set format y \"%4.0f\"\n"; 
  }
  print OUT "set xlabel \"q\"\n";
  print OUT "set ylabel \"q{/Symbol c}_{/Times-Italic n}(q), q{/Symbol b}_{/Times-Italic n}(q)\"\n";
  print OUT "plot [$gmin_beta:$gmax_beta][$gbeta_min_guess:$gbeta_max_guess] \\\n";
  $ic = 0;
  for($j=1;$j<=$tmax[$i];$j++) {
    $k = $lt[$i][$j]; $t = $j;
    if($ic != 0) {print OUT ", \\\n";}
    $line_type = $j;
    print OUT "\"$gfile[$k]\" u 1:4 notitle           w l lt $line_type lw 1, \\\n";
    print OUT "\"$gfile[$k]\" u 1:5 t \"$lang[$l]$t\" w l lt $line_type lw 4";
    $ic++;
  }
  print OUT "\n";
  close(OUT);
  `gnuplot $$.gpi`;
  `rm $$.gpi`;
}

for($i=0;$i<$mr;$i++) {`rm $rfile[$i]`;}
for($i=0;$i<$mg;$i++) {`rm $gfile[$i]`;}

}

################################################################################
#////////////////////////////// Deficit charges ////////////////////////////////

$gmax = 20;   $rmax =  5;
$gmin =  0;   $rmin =  0;

@lang = ('s','p','d','f','g','h','i');
@ntic = (0.01,0.02,0.05,0.1,0.2,0.5,1,2,5,10,20,50,100,200,500);

################################################################################
#  Read data from a file

print "*** Deficit charges ***\n";
print "@ARGV\n";
$infile = "$ARGV[0]" . ".qps";
print "<IN> = $infile\n";
if(! -e "$infile") {
  print "#############################################################\n";
  print "##   File not exists  -->  $infile\n";
  print "##   Please prepare the missing file.\n";
  print "#############################################################\n";
} else {
  print "File exists --> $infile\n";

open IN,"<$infile";
while($line = <IN>) {
  if($line =~/Element/) {
    ($element) = split(' ',$line);
    print "$element\n";
  } elsif($line =~/ng_mesh/) {
    @line=split(' ',$line);
    $nmesh = $line[0];
    $gmesh = $line[1];
    print "nmesh   : $nmesh\n";
    print "ng_mesh : $gmesh\n";
    last;
  }
}
$m_qps = -1;
while($line = <IN>) {
  if($line =~/Q\[nm\]/) {
    $type = 'qnm';
    @line = split(' ',$line);
    if(@line<7) {
      push @line, split(' ',<IN>);
    }
    $l1 = $line[3];
    $t1 = $line[4];
    $l2 = $line[5];
    $t2 = $line[6];
    print "Qnm: (l1,t1,l2,t2) = ($l1,$t1,$l2,$t2)\n";
  } elsif($line =~/Qps/) {
    $type = 'qps';
    @line = split(' ',$line);
    if(@line<8) {
      push @line, split(' ',<IN>);
    }
    $l1 = $line[3];
    $t1 = $line[4];
    $l2 = $line[5];
    $t2 = $line[6];
    $l3 = $line[7];
    print "Qps: (l1,t1,l2,t2,l3) = ($l1,$t1,$l2,$t2,$l3)\n";
  } elsif($line =~/rpos/) {
    print "Real space\n";
    if($type =~/qnm/) { $m_qps++;
      $rrq_max[$m_qps]  = -1.0e3;
      $rrq_min[$m_qps]  = +1.0e3;
      $file = "$type" . "r" . "_$element" . "_$lang[$l1]$t1$lang[$l2]$t2" . ".dat";
      $qnmrfile[$m_qps] = $file;
      $lae1[$m_qps] = $l1;
      $tae1[$m_qps] = $t1;
      $lae2[$m_qps] = $l2;
      $tae2[$m_qps] = $t2;
      $ml3r[$m_qps] = 0;
    } else {
      $file = "$type" . "r" . "_$element" . "_$lang[$l1]$t1$lang[$l2]$t2" . "_$lang[$l3]" . ".dat";
      $qpsrfile[$m_qps][$ml3r[$m_qps]] = $file;
      $lps1[$m_qps][$ml3r[$m_qps]] = $l1;
      $tps1[$m_qps][$ml3r[$m_qps]] = $t1;
      $lps2[$m_qps][$ml3r[$m_qps]] = $l2;
      $tps2[$m_qps][$ml3r[$m_qps]] = $t2;
      $lps3[$m_qps][$ml3r[$m_qps]] = $l3;
      $ml3r[$m_qps]++;
    }
    open(OUT,">$file");
    for($i=0;$i<$nmesh;$i++) {
      ($rpos,$rrq) = split(' ',<IN>);
      if($rrq > $rrq_max[$m_qps]) {$rrq_max[$m_qps] = $rrq;}
      if($rrq < $rrq_min[$m_qps]) {$rrq_min[$m_qps] = $rrq;}
      print OUT "$rpos $rrq\n";
    }
    close(OUT);
    print "   ml3r[$m_qps] = $ml3r[$m_qps]\n";
  } elsif($line =~/gpos/) {
    print "Reciprocal space\n";
    if($type =~/qnm/) {
      $ggq_max  = -1.0e3;
      $ggq_min  = +1.0e3;
      $file = "$type" . "g" . "_$element" . "_$lang[$l1]$t1$lang[$l2]$t2" . ".dat";
      $qnmgfile[$m_qps] = $file;
      $ml3g[$m_qps] = 0;
    } else {
      $file = "$type" . "g" . "_$element" . "_$lang[$l1]$t1$lang[$l2]$t2" . "_$lang[$l3]" . ".dat";
      $qpsgfile[$m_qps][$ml3g[$m_qps]] = $file;
      $ml3g[$m_qps]++;
    }
    open(OUT,">$file");
    for($i=0;$i<$gmesh-1;$i++) {
      ($gpos,$ggq) = split(' ',<IN>);
      if($ggq > $ggq_max[$m_qps]) {$ggq_max[$m_qps] = $ggq;}
      if($ggq < $ggq_min[$m_qps]) {$ggq_min[$m_qps] = $ggq;}
      print OUT "$gpos $ggq\n";
    }
    close(OUT);
    print "   ml3g[$m_qps] = $ml3g[$m_qps]\n";
  }
}
close(IN);

################################################################################
#  gnuplot

### Parameters
$ndiv_max = 5;

##### Deficit charge Q[nm](r) & Qps[nmL](r) #####
for($i=0;$i<=$m_qps;$i++) {
  $l1 = $lae1[$i];
  $t1 = $tae1[$i];
  $l2 = $lae2[$i];
  $t2 = $tae2[$i];
  open(OUT,">plot_qps");
  $rrq_file[$i] = "$ARGV[0]" . "_qps" . "_rrq" . "_$lang[$l1]$t1$lang[$l2]$t2" . ".eps";
  print OUT "set output \"$rrq_file[$i]\"\n";
  print OUT "set terminal postscript eps enhanced color solid \"Helvetica\" 12\n";
  print OUT "set xzeroaxis\n";
  print OUT "set border 31 lw 1\n";
  print OUT "set size 0.5,0.5\n";
  print OUT "set xtics 1\n";
  print OUT "set mxtics 1\n";
  for($j=0;($rrq_max[$i]-$rrq_min[$i])/$ntic[$j] > $ndiv_max;$j++) {next;}
  $ytics_guess = $ntic[$j];
  $rrq_max_guess = int($rrq_max[$i]/$ntic[$j])*$ntic[$j]+$ntic[$j];
  $rrq_min_guess = int($rrq_min[$i]/$ntic[$j])*$ntic[$j]-$ntic[$j];
  print OUT "set ytics $ytics_guess\n";
  print OUT "set mytics 1\n";
  print OUT "set format x \"%1.0f\"\n";
  #print OUT "set format y \"%2.0f\"\n";
  if($ytics_guess < 0.1) {
  print OUT "set format y \"%4.2f\"\n";
  } elsif($ytics_guess < 1) {
  print OUT "set format y \"%3.1f\"\n";
  } elsif($ytics_guess < 10) {
  print OUT "set format y \"%2.0f\"\n";
  } elsif($ytics_guess < 100) {
  print OUT "set format y \"%3.0f\"\n";
  } else {
  print OUT "set format y \"%4.0f\"\n"; 
  }
  print OUT "set xlabel \"r\"\n";
  print OUT "set ylabel \"r^{2}Q_{/Times-Italic nm}(r)\"\n";
  print OUT "plot [$rmin:$rmax][$rrq_min_guess:$rrq_max_guess] \\\n";
  print OUT "\"$qnmrfile[$i]\" u 1:2 t \"$lang[$l1]$t1-$lang[$l2]$t2\" w l lw 1, \\\n";
  for($j=0;$j<$ml3r[$i];$j++) {
    $l1 = $lps1[$i][$j];
    $t1 = $tps1[$i][$j];
    $l2 = $lps2[$i][$j];
    $t2 = $tps2[$i][$j];
    $l3 = $lps3[$i][$j];
    print OUT "\"$qpsrfile[$i][$j]\" u 1:2 t \"L = $lang[$l3]\" w l lw 4";
    if($j<$ml3r[$i]-1) {
      print OUT ", \\\n";
    } else {
      print OUT "\n";
    }
  }
  `gnuplot plot_qps`;
  `rm plot_qps`;
  close(OUT);
}

##### Deficit charge Q[nm](G) & Qps[nmL](G) #####
for($i=0;$i<=$m_qps;$i++) {
  $l1 = $lae1[$i];
  $t1 = $tae1[$i];
  $l2 = $lae2[$i];
  $t2 = $tae2[$i];
  open(OUT,">plot_qps");
  $ggq_file[$i] = "$ARGV[0]" . "_qps" . "_ggq" . "_$lang[$l1]$t1$lang[$l2]$t2" . ".eps";
  print OUT "set output \"$ggq_file[$i]\"\n";
  print OUT "set terminal postscript eps enhanced color solid \"Helvetica\" 12\n";
  print OUT "set xzeroaxis\n";
  print OUT "set border 31 lw 1\n";
  
  print OUT "set size 0.5,0.5\n";
  print OUT "set xtics 5\n";
  print OUT "set mxtics 5\n";
  for($j=0;($ggq_max[$i]-$ggq_min[$i])/$ntic[$j] > $ndiv_max;$j++) {next;}
  $ytics_guess = $ntic[$j];
  #$ytics_guess = 1;
  $ggq_max_guess = int($ggq_max[$i]/$ntic[$j])*$ntic[$j]+$ntic[$j];
  $ggq_min_guess = int($ggq_min[$i]/$ntic[$j])*$ntic[$j]-$ntic[$j];
  print OUT "set ytics $ytics_guess\n";
  print OUT "set mytics 1\n";
  print OUT "set format x \"%1.0f\"\n";
  #print OUT "set format y \"%2.0f\"\n";
  if($ytics_guess < 0.1) {
  print OUT "set format y \"%4.2f\"\n";
  } elsif($ytics_guess < 1) {
  print OUT "set format y \"%3.1f\"\n";
  } elsif($ytics_guess < 10) {
  print OUT "set format y \"%2.0f\"\n";
  } elsif($ytics_guess < 100) {
  print OUT "set format y \"%3.0f\"\n";
  } else {
  print OUT "set format y \"%4.0f\"\n"; 
  }
  print OUT "set xlabel \"q\"\n";
  print OUT "set ylabel \"q^{2}Q_{/Times-Italic nm}(q)\"\n";
  print OUT "plot [$gmin:$gmax][$ggq_min_guess:$ggq_max_guess] \\\n";
  print OUT "\"$qnmgfile[$i]\" u 1:2 t \"$lang[$l1]$t1-$lang[$l2]$t2\" w l lw 1, \\\n";
  for($j=0;$j<$ml3g[$i];$j++) {
    $l1 = $lps1[$i][$j];
    $t1 = $tps1[$i][$j];
    $l2 = $lps2[$i][$j];
    $t2 = $tps2[$i][$j];
    $l3 = $lps3[$i][$j];
    print OUT "\"$qpsgfile[$i][$j]\" u 1:2 t \"L = $lang[$l3]\" w l lw 4";
    if($j<$ml3g[$i]-1) {
      print OUT ", \\\n";
    } else {
      print OUT "\n";
    }
  }
  `gnuplot plot_qps`;
  `rm plot_qps`;
  close(OUT);
}

for($i=0;$i<=$m_qps;$i++) {
  `rm $qnmrfile[$i]`;
  `rm $qnmgfile[$i]`;
  for ($j=0;$j<$ml3r[$i];$j++) {`rm $qpsrfile[$i][$j]`;}
  for ($j=0;$j<$ml3g[$i];$j++) {`rm $qpsgfile[$i][$j]`;}
}

}

################################################################################
#///////////////////////////////////////////////////////////////////////////////
#  generate a tex file

$infile = "$ARGV[0]" . ".pp";
if(-e "$infile") {$with_pp = 1;} 
else {$with_pp = 0; print "### CAUTION ### Not found --> $infile\n";}
$infile = "$ARGV[0]" . ".pcc";
if(-e "$infile") {$with_pcc = 1;} 
else {$with_pcc = 0; print "### CAUTION ### Not found --> $infile\n";}
$infile = "$ARGV[0]" . ".us";
if(-e "$infile") {$with_us = 1;} 
else {$with_us = 0; print "### CAUTION ### Not found --> $infile\n";}
$infile = "$ARGV[0]" . ".qps";
if(-e "$infile") {$with_qps = 1;} 
else {$with_qps = 0; print "### CAUTION ### Not found --> $infile\n";}
$infile = "$ARGV[0]" . ".ldr";
if(-e "$infile") {$with_ldr = 1;} 
else {$with_ldr = 0; print "### CAUTION ### Not found --> $infile\n";}
$infile = "$ARGV[0]" . ".sol";
if(-e "$infile") {$with_sol = 1;} 
else {$with_sol = 0; print "### CAUTION ### Not found --> $infile\n";}

open(OUT,">layout_us.tex");
print OUT "\\documentclass[landscape,a4paper]{article}\n";
print OUT "\\usepackage{graphicx}\n";
print OUT "\\topmargin     = -25mm   \\headsep        =  15mm\n";
print OUT "\\oddsidemargin =   0mm   \\evensidemargin =   0mm\n";
print OUT "\\textwidth     = 235mm   \\textheight     = 170mm\n";
print OUT "\\unitlength    =   1mm\n";
print OUT "\\begin{document}\n";
print OUT "\\pagestyle{empty}\n";
### rphi, gphi
if($with_us == 1 || $with_sol == 1) {
print OUT "\\begin{figure}\n";
print OUT "  \\begin{center}\n";
print OUT "    \\begin{tabular}{cc}\n";
if($with_us == 1) {
print OUT "      \\resizebox{120mm}{!}{\\includegraphics{$ARGV[0]_us_rphi.eps}} &\n";
print OUT "      \\resizebox{120mm}{!}{\\includegraphics{$ARGV[0]_us_gphi.eps}} \\\\\n";
}
if($with_sol == 1) {
print OUT "      \\resizebox{120mm}{!}{\\includegraphics{$ARGV[0]_sol_rphi.eps}} & \\\\\n";
}
print OUT "    \\end{tabular}\n";
print OUT "  \\end{center}\n";
print OUT "\\end{figure}\n";
}
### ldr, rho
if($with_ldr == 1) {
print OUT "\\clearpage\n";
print OUT "\\begin{figure}\n";
print OUT "  \\begin{center}\n";
print OUT "    \\begin{tabular}{cc}\n";
if($with_ldr == 1) {
print OUT "      \\resizebox{120mm}{!}{\\includegraphics{$ARGV[0]_ldr.eps}} &\n";
print OUT "      \\resizebox{120mm}{!}{\\includegraphics{$ARGV[0]_ldr_std.eps}} \\\\\n";
}
print OUT "    \\end{tabular}\n";
print OUT "  \\end{center}\n";
print OUT "\\end{figure}\n";
}
### rho_ae, rho_sol, vloc, rho_pcc, ggrho_pcc
if($with_sol == 1 || $with_pcc == 1) {
print OUT "\\clearpage\n";
print OUT "\\begin{figure}\n";
print OUT "  \\begin{center}\n";
print OUT "    \\begin{tabular}{cc}\n";
if($with_sol == 1) {
print OUT "      \\resizebox{120mm}{!}{\\includegraphics{$ARGV[0]_sol_rho.eps}} &\n";
print OUT "      \\resizebox{120mm}{!}{\\includegraphics{$ARGV[0]_sol_vloc.eps}} \\\\\n";
}
if($with_pcc == 1) {
print OUT "      \\resizebox{120mm}{!}{\\includegraphics{$ARGV[0]_pcc_rho.eps}} &\n";
print OUT "      \\resizebox{120mm}{!}{\\includegraphics{$ARGV[0]_pcc_ggrho.eps}} \\\\\n";
}
print OUT "    \\end{tabular}\n";
print OUT "  \\end{center}\n";
print OUT "\\end{figure}\n";
}
### rphi, gphi, rbeta, gbeta
if($with_us == 1) {
for($i=0;$i<=$m_us;$i++) {
  print OUT "\\clearpage\n";
  print OUT "\\begin{figure}\n";
  print OUT "  \\begin{center}\n";
  print OUT "    \\begin{tabular}{cc}\n";
  print OUT "      \\resizebox{120mm}{!}{\\includegraphics{$rphi_file[$i]}} &\n";
  print OUT "      \\resizebox{120mm}{!}{\\includegraphics{$gphi_file[$i]}} \\\\\n";
  print OUT "      \\resizebox{120mm}{!}{\\includegraphics{$rbeta_file[$i]}} & \n";
  print OUT "      \\resizebox{120mm}{!}{\\includegraphics{$gbeta_file[$i]}} \\\\\n";
  print OUT "    \\end{tabular}\n";
  print OUT "  \\end{center}\n";
  print OUT "\\end{figure}\n";
}}
### rrq, ggq
if($with_qps == 1) {
for($j=0;$j<=int($m_qps/2);$j++) { $i = 2*$j;
  print OUT "\\clearpage\n";
  print OUT "\\begin{figure}\n";
  print OUT "  \\begin{center}\n";
  print OUT "    \\begin{tabular}{cc}\n";
  print OUT "      \\resizebox{120mm}{!}{\\includegraphics{$rrq_file[$i]}} &\n";
  print OUT "      \\resizebox{120mm}{!}{\\includegraphics{$ggq_file[$i]}} \\\\\n";
  if($j < int($m_qps/2) || $m_qps - 2*int($m_qps/2) == 1) {
    print OUT "      \\resizebox{120mm}{!}{\\includegraphics{$rrq_file[$i+1]}} & \n";
    print OUT "      \\resizebox{120mm}{!}{\\includegraphics{$ggq_file[$i+1]}} \\\\\n";
  }
  print OUT "    \\end{tabular}\n";
  print OUT "  \\end{center}\n";
  print OUT "\\end{figure}\n";
}}
print OUT "\\end{document}\n";
