#!/usr/bin/perl
#
#  Copyright (C) 2003, 2004 Masakuni Okamoto.
#
#  This script was written by Masakuni Okamoto.
#
#  Last update: March 1, 2004.
#
################################################################################
#/////////////////////////////////// PCC ///////////////////////////////////////

$rmin = 0;
$rmax = 5;
$gmin =  0;
$gmax = 20;

@lang = ('s','p','d','f');
@ntic = (0.01,0.02,0.05,0.1,0.2,0.5,1,2,5,10,20,50,100,200,500,
         1000,2000,5000,10000,20000,50000,100000,200000,500000,
         1000000,2000000,5000000);

$rho_pcc_max = 0;
$rho_pcc_min = 0;
$rho_val_max = 0;
$rho_val_min = 0;
$gg_rho_max  = 0;
$gg_rho_min  = 0;

################################################################################
#  Read data from a command-line

if(@ARGV<1) {
  print "Usage: print_eps_pp FileTitle [--formatted]\n";
  exit(0);
} else {
  $is_formatted = 0;
  foreach $s (@ARGV) {
    if($s =~/--formatted/ || $s =~/-f/) {
      $is_formatted = 1;
    }
  }
}

################################################################################
#  Read data from a file

print "*** PCC ***\n";
print "@ARGV\n";
$infile = "$ARGV[0]" . ".pcc";
print "<IN> = $infile\n";
if(! -e "$infile") {
  print "#############################################################\n";
  print "##   File not exists  -->  $infile\n";
  print "##   Please prepare the missing file.\n";
  print "#############################################################\n";
  exit(1);
} else {
  print "File exists --> $infile\n";
}
open(IN,"<$infile");
while($line = <IN>) {
  if($line =~/Element/) {
    ($element) = split(' ',$line);
    print "$element\n";
  } elsif($line =~/Zc/) {
    ($zc) = split(':',$line);
    print "   Zc      = $zc\n";
  } elsif($line =~/Zv/) {
    ($zc) = split(':',$line);
    print "   Zv      = $zv\n";
  } elsif($line =~/ng_mesh/) {
    ($nmesh,$ng_mesh) = split(' ',$line);
    print "   nmesh   = $nmesh\n";
    print "   ng_mesh = $ng_mesh\n";
  } elsif($line =~/rcut/) {
    ($rcut) = split(':',$line);
    print "   Rc      = $rcut\n";
  } elsif($line =~/gcut/) {
    ($gcut) = split(':',$line);
    print "   Gc      = $gcut\n";
    last;
  }
}
while($line = <IN>) {
  if($line =~/rpos/) {
    $file_r = "pcc" . "_$element" . "_r" . ".dat";
    print "   file = $file_r\n";
    $ifound0 = 0;
    $ifound1 = 0;
    $r0 = -1.0e3;
    $r1 = -1.0e3;
    $pcc0 = 0;
    $pcc1 = 0;
    open(OUT,">$file_r");
    for($i=0;$i<$nmesh;$i++) {
      ($rpos,$rho_core,$rho_pcc,$rho_val) = split(' ',<IN>);
      $rho = $rho_core + $rho_val;
      if($rho_pcc > $rho_pcc_max) {$rho_pcc_max = $rho_pcc;}
      if($rho_pcc < $rho_pcc_min) {$rho_pcc_min = $rho_pcc;}
      if($rho_val > $rho_val_max) {$rho_val_max = $rho_val;}
      if($rho_val < $rho_val_min) {$rho_val_min = $rho_val;}
      if($rpos < $rcut && $ifound0 == 0) 
        {$r0 = $rpos; $pcc0 = $rho_pcc;} else {$ifound0 = 1;}
      if($ifound0 == 1 && $ifound1 == 0) 
        {$r1 = $rpos; $pcc1 = $rho_pcc; $ifound1 = 1;}
      print OUT "$rpos $rho $rho_core $rho_pcc $rho_val\n";
    }
    close(OUT);
  } elsif($line =~/gpos/) {
    $file_g = "pcc" . "_$element" . "_g" . ".dat";
    print "   file = $file_g\n";
    open(OUT,">$file_g");
    for($i=0;$i<$ng_mesh;$i++) {
      ($gpos,$gg_rho_core,$gg_rho_pcc,$gg_rho_val) = split(' ',<IN>);
      $gg_rho = $gg_rho_core + $gg_rho_val;
      if($gg_rho_pcc > $gg_rho_max) {$gg_rho_max = $gg_rho_pcc;}
      if($gg_rho_pcc < $gg_rho_min) {$gg_rho_min = $gg_rho_pcc;}
      if($gg_rho_val > $gg_rho_max) {$gg_rho_max = $gg_rho_val;}
      if($gg_rho_val < $gg_rho_min) {$gg_rho_min = $gg_rho_val;}
      print OUT "$gpos $gg_rho $gg_rho_core $gg_rho_pcc $gg_rho_val\n";
    }
    close(OUT);
  }
}
close(IN);

################################################################################
#  gnuplot

### Parameters
$ndiv_max = 5;

##### PCC (real-space) #####
open(OUT,">$$.gpi");
print OUT "set terminal postscript eps enhanced color solid \"Helvetica\" 12\n";
$pcc_file_r = "$ARGV[0]" . "_pcc" . "_rho" . ".eps";
print OUT "set output \"$pcc_file_r\"\n";
print OUT "set xzeroaxis\n";
print OUT "set border 31 lw 1\n";

print OUT "set size 0.5,0.5\n";
print OUT "set key right top\n";
#print OUT "set nokey\n";
print OUT "set xtics 1\n";
print OUT "set mxtics 1\n";
for($i=0;int(($rho_pcc_max*2-$rho_pcc_min)/$ntic[$i]) > $ndiv_max;$i++) {next;}
$ytics_guess = $ntic[$i];
$mytics_guess = 1;
$rho_max_guess = int($rho_pcc_max*2/$ntic[$i])*$ntic[$i]+$ntic[$i];
$rho_min_guess = int($rho_pcc_min/$ntic[$i])*$ntic[$i]-$ntic[$i];
print OUT "set ytics $ytics_guess\n";
print OUT "set mytics $mytics_guess\n";
print OUT "set format x \"%1.0f\"\n";
if($ytics_guess < 0.1) {
print OUT "set format y \"%4.2f\"\n";
} elsif($ytics_guess < 1) {
print OUT "set format y \"%3.1f\"\n";
} elsif($ytics_guess < 10) {
print OUT "set format y \"%2.0f\"\n";
} elsif($ytics_guess < 100) {
print OUT "set format y \"%3.0f\"\n";
} else {
print OUT "set format y \"%4.0f\"\n";
}
print OUT "set xlabel \"r\"\n";
print OUT "set ylabel \"n(r)\"\n";

$arrow_length = abs($rho_max_guess-$rho_min_guess)/10;
$arrow_offset = abs($rho_max_guess-$rho_min_guess)/60;
print OUT "set arrow from $r0,$pcc0-$arrow_length to $r0,$pcc0-$arrow_offset lt 3 lw 1\n";
if($is_formatted == 1) {
  print OUT "set label \"Rc=%8.5f\",$rcut \\\n";
} else {
  $tmp = int($rcut*1.0e5)*1.0e-5;
  print OUT "set label \"Rc=$tmp\" \\\n";
}
print OUT "at graph 0.68,0.1 font \"Courier,9\"\n";

print OUT "plot [$rmin:$rmax][$rho_min_guess:$rho_max_guess] \\\n";
print OUT "\'$file_r\' u 1:3 t \'Core\'    w l lt 1 lw 4, \\\n";
print OUT "\'$file_r\' u 1:4 t \'PCC\'     w l lt 3 lw 4, \\\n";
print OUT "\'$file_r\' u 1:5 t \'Valence\' w l lt 2 lw 4, \\\n";
print OUT "\'$file_r\' u 1:2 t \'Total\'   w l lt 0 lw 1";
print OUT "\n";
close(OUT);

`gnuplot $$.gpi`;
`rm $$.gpi`;

`rm $file_r`;

##### PCC (reciprocal-space) #####
open(OUT,">$$.gpi");
print OUT "set terminal postscript eps enhanced color solid \"Helvetica\" 12\n";
$pcc_file_g = "$ARGV[0]" . "_pcc" . "_ggrho" . ".eps";
print OUT "set output \"$pcc_file_g\"\n";
print OUT "set xzeroaxis\n";
print OUT "set border 31 lw 1\n";

print OUT "set size 0.5,0.5\n";
print OUT "set key right top\n";
#print OUT "set nokey\n";
print OUT "set xtics 5\n";
print OUT "set mxtics 5\n";
for($i=0;int(($gg_rho_max-$gg_rho_min)/$ntic[$i]) > $ndiv_max;$i++) {next;}
$ytics_guess = $ntic[$i];
$mytics_guess = 1;
$gg_rho_max_guess = int($gg_rho_max/$ntic[$i])*$ntic[$i]+$ntic[$i]+$ntic[$i];
$gg_rho_min_guess = int($gg_rho_min/$ntic[$i])*$ntic[$i]-$ntic[$i];
print OUT "set ytics $ytics_guess\n";
print OUT "set mytics $mytics_guess\n";
print OUT "set format x \"%2.0f\"\n";
if($ytics_guess < 0.1) {
print OUT "set format y \"%4.2f\"\n";
} elsif($ytics_guess < 1) {
print OUT "set format y \"%3.1f\"\n";
} elsif($ytics_guess < 10) {
print OUT "set format y \"%2.0f\"\n";
} elsif($ytics_guess < 100) {
print OUT "set format y \"%3.0f\"\n";
} else {
print OUT "set format y \"%4.0f\"\n";
}
print OUT "set xlabel \"q\"\n";
print OUT "set ylabel \"q^{2}n(q)\"\n";

print OUT "plot [$gmin:$gmax][$gg_rho_min_guess:$gg_rho_max_guess] \\\n";
print OUT "\'$file_g\' u 1:3 t \'Core\'    w l lt 1 lw 4, \\\n";
print OUT "\'$file_g\' u 1:4 t \'PCC\'     w l lt 3 lw 4, \\\n";
print OUT "\'$file_g\' u 1:5 t \'Valence\' w l lt 2 lw 4, \\\n";
print OUT "\'$file_g\' u 1:2 t \'Total\'   w l lt 0 lw 1";
print OUT "\n";
close(OUT);

`gnuplot $$.gpi`;
`rm $$.gpi`;

`rm $file_g`;
