#!/usr/bin/perl
#
#  Copyright (C) 2003-2005 Takenori Yamamoto and Masakuni Okamoto.
#
#  This perl script was originally written by Takenori Yamamoto.
#  The script was modified by Masakuni Okamoto.
#
#  Last update: February 6, 2005.
#
################################################################################
#/////////////////////////// Logarithmic derivatives ///////////////////////////

$ldrmax_plot =  20.0;
$ldrmin_plot = -20.0;

@lang = ('s','p','d','f');
@ntic = (1,2,5,10,20,50,100,200,500,1000);
$emin   =  1.0e3;
$emax   = -1.0e3;
$ldrmin = $ldrmin_plot;
$ldrmax = $ldrmax_plot;
$arrow_offset = abs($ldrmax_plot-$ldrmin_plot)/60;
$arrow_length = abs($ldrmax_plot-$ldrmin_plot)/10;

################################################################################
#  Read data from a command-line

if(@ARGV<1) {
  print "Usage: print_eps_ldr FileTitle [--formatted]\n";
  exit(0);
} else {
  $is_formatted = 0;
  foreach $s (@ARGV) {
    if($s =~/--formatted/ || $s =~/-f/) {
      $is_formatted = 1;
    }
  }
}

################################################################################
#  Read data from a file

print "*** Logarithmic derivatives ***\n";
print "@ARGV\n";
$infile = "$ARGV[0]" . ".ldr";
print "<IN> = $infile\n";
if(! -e "$infile") {
  print "#############################################################\n";
  print "##   File not exists  -->  $infile\n";
  print "##   Please prepare the missing file.\n";
  print "#############################################################\n";
  exit(1);
} else {
  print "File exists --> $infile\n";
}
open(IN,"<$infile");
while($line = <IN>) {
  if($line =~/Element/) {
    ($element) = split(' ',$line);
    print "$element\n";
  } elsif($line =~/ne_mesh/) {
    ($ne_mesh) = split(':',$line);
    print "$ne_mesh\n";
    last;
  }
}
$rcut_logderi=0;
$m=0;
while($line = <IN>) {
  if($line =~/l, nref, s/) {
    ($l,$nref,$s) = split(' ',$line);
    $ll[$m] = $l;
    $nnref[$m] = $nref;
    print "$lang[$l], $nref\n";
    for($j=0;$j<$nref;$j++) {
      ($elevel[$m][$j],$dummy) = split(':',<IN>);
      print "   Eref($j): $elevel[$m][$j]\n";
      $e0[$m][$j] = -1.0e3;
      $e1[$m][$j] = -1.0e3;
      $ifound0[$m][$j] = 0;
      $ifound1[$m][$j] = 0;
      $ldr_ae0[$m][$j] = 0;
      $ldr_ae1[$m][$j] = 0;
    }
    ($rcut[$m],$dummy) = split(':',<IN>);
    print "   Rc     : $rcut[$m]\n";
    if($rcut[$m] > $rcut_logderi) {$rcut_logderi = $rcut[$m];}
  } elsif($line =~/ee/) {
    $file[$m] = "ldr" . "_$lang[$l]" . ".dat";
    print "   file = $file[$m]\n";
    open(OUT,">$file[$m]");
    for($i=0;$i<$ne_mesh;$i++) {
      ($ee,$ldr_ae,$ldr_us) = split(' ',<IN>);
      if($ee < $emin) {
        $emin = $ee;
      } elsif($ee > $emax) {
        $emax = $ee;
      }
      for($j=0;$j<$nref;$j++) {
         if($ee < $elevel[$m][$j] && $ifound0[$m][$j] == 0) 
            {$e0[$m][$j] = $ee; $ldr_ae0[$m][$j] = $ldr_ae;} else {$ifound0[$m][$j] = 1;}
         if($ifound0[$m][$j] == 1 && $ifound1[$m][$j] == 0) 
            {$e1[$m][$j] = $ee; $ldr_ae1[$m][$j] = $ldr_ae; $ifound1[$m][$j] = 1;}
      }
      print OUT "$ee $ldr_ae $ldr_us\n";
    }
    close(OUT);
    $m++;
  }
}
close(IN);

################################################################################
#  gnuplot

### Parameters
$ndiv_max = 5;

##### check_ldr.eps #####
open(OUT,">$$.gpi");
$ldr_file = "$ARGV[0]" . "_ldr" . ".eps";
print OUT "set terminal postscript eps enhanced color solid \"Helvetica\" 12\n";
print OUT "set output \"$ldr_file\"\n";
print OUT "set xzeroaxis\n";
print OUT "set border 31 lw 1\n";

print OUT "set size 0.5,0.5\n";
#print OUT "set key left top\n";
print OUT "set nokey\n";
for($i=0;int(($emax-$emin)/$ntic[$i]) > $ndiv_max;$i++) {next;}
$xtics_guess = $ntic[$i];
print OUT "set xtics $xtics_guess\n";
print OUT "set mxtics 1\n";
for($i=0;int(($ldrmax-$ldrmin)/$ntic[$i]) > $ndiv_max;$i++) {next;}
$ytics_guess = $ntic[$i];
print OUT "set ytics $ytics_guess\n";
print OUT "set mytics 1\n";
print OUT "set format x \"%2.0f\"\n";
print OUT "set format y \"%2.0f\"\n";
print OUT "set xlabel \"E\"\n";
print OUT "set ylabel \"dlog(r{/Symbol y}_{/Times-Italic l}(r,E))/dr\"\n";
print OUT "set label \"$element\" center at graph 0.11,0.86 font \"Helvetica-Bold,36\"\n";

$ic = -2;
if($is_formatted == 1) {
  print OUT "set label \"Rc   =%8.5f\",$rcut_logderi \\\n";
} else {
  $tmp = int($rcut_logderi*1.0e5)*1.0e-5;
  print OUT "set label \"Rc   = $tmp\" \\\n";
}
print OUT "at graph 0.05,0.3-$ic*0.05 font \"Courier,9\"\n";
$ic++;
for($i=0;$i<$m;$i++) {
  for($j=0;$j<$nnref[$i];$j++) {
    $jj = $j + 1;
    if($is_formatted == 1) {
      print OUT "set label \"E($lang[$ll[$i]]$jj)=%8.5f\",$elevel[$i][$j] \\\n";
    } else {
      $tmp = int($elevel[$i][$j]*1.0e5)*1.0e-5;
      print OUT "set label \"E($lang[$ll[$i]]$jj)=$tmp\" \\\n";
    }
    print OUT "at graph 0.05,0.3-$ic*0.05 font \"Courier,9\"\n";
    $ic++;
  }
}

for($i=0;$i<$m;$i++) {
  for($j=0;$j<$nnref[$i];$j++) {
    print OUT "set arrow from $e0[$i][$j],$ldr_ae0[$i][$j]-$arrow_length to $e0[$i][$j],$ldr_ae0[$i][$j]-$arrow_offset lt $ll[$i]+1 lw 1\n";
  }
}

print OUT "plot [$emin:$emax][$ldrmin_plot:$ldrmax_plot] \\\n";
$ic = 0;
for($i=0;$i<$m;$i++) {
  if($ic != 0) {print OUT ", \\\n";}
  $line_type = $ll[$i]+1;
  print OUT "\'$file[$i]\' u 1:2 notitle              w l lt $line_type lw 1, \\\n";
  print OUT "\'$file[$i]\' u 1:3 t \'$lang[$ll[$i]]\' w l lt $line_type lw 4";
  $ic++;
}
print OUT "\n";
close(OUT);

`gnuplot $$.gpi`;
`rm $$.gpi`;

##### check_ldr_std.eps #####
$emin   = -2;
$emax   =  1;
open(OUT,">$$.gpi");
$ldr_std_file = "$ARGV[0]" . "_ldr" . "_std" . ".eps";
print OUT "set terminal postscript eps enhanced color solid \"Helvetica\" 12\n";
print OUT "set output \"$ldr_std_file\"\n";
print OUT "set xzeroaxis\n";
print OUT "set border 31 lw 1\n";

print OUT "set size 0.5,0.5\n";
print OUT "set key left top\n";
#print OUT "set nokey\n";
for($i=0;($emax-$emin)/$ntic[$i] > $ndiv_max;$i++) {next;}
$xtics_guess = $ntic[$i];
print OUT "set xtics $xtics_guess\n";
print OUT "set mxtics 1\n";
for($i=0;($ldrmax-$ldrmin)/$ntic[$i] > $ndiv_max;$i++) {next;}
$ytics_guess = $ntic[$i];
print OUT "set ytics $ytics_guess\n";
print OUT "set mytics 1\n";
print OUT "set format x \"%2.0f\"\n";
print OUT "set format y \"%2.0f\"\n";
print OUT "set xlabel \"E\"\n";
print OUT "set ylabel \"dlog(r{/Symbol y}_{/Times-Italic l}(r,E))/dr\"\n";

$ic = -1;
for($i=0;$i<$m;$i++) {
  for($j=0;$j<$nnref[$i];$j++) {
    $jj = $j + 1;
    if($is_formatted == 1) {
      print OUT "set label \"E($lang[$ll[$i]]$jj)=%8.5f\",$elevel[$i][$j] \\\n";
    } else {
      $tmp = int($elevel[$i][$j]*1.0e5)*1.0e-5;
      print OUT "set label \"E($lang[$ll[$i]]$jj)=$tmp\" \\\n";
    }
    print OUT "at graph 0.05,0.3-$ic*0.05 font \"Courier,9\"\n";
    $ic++;
  }
}

for($i=0;$i<$m;$i++) {
  for($j=0;$j<$nnref[$i];$j++) {
    print OUT "set arrow from $e0[$i][$j],$ldr_ae0[$i][$j]-$arrow_length to $e0[$i][$j],$ldr_ae0[$i][$j]-$arrow_offset lt $ll[$i]+1 lw 1\n";
  }
}

print OUT "plot [$emin:$emax][$ldrmin_plot:$ldrmax_plot] \\\n";
$ic = 0;
for($i=0;$i<$m;$i++) {
  if($ic != 0) {print OUT ", \\\n";}
  $line_type = $ll[$i]+1;
  print OUT "\'$file[$i]\' u 1:2 notitle              w l lt $line_type lw 1, \\\n";
  print OUT "\'$file[$i]\' u 1:3 t \'$lang[$ll[$i]]\' w l lt $line_type lw 4";
  $ic++;
}
print OUT "\n";
close(OUT);

`gnuplot $$.gpi`;
`rm $$.gpi`;

for($i=0;$i<$m;$i++) {`rm $file[$i]`;}
