/*******************************************************************************
!------------------------------------------------------------------------------
!  SOFTWARE NAME : ppconv version 1.0
!
!  HEADER FILE NAME: ppconv.h
!
!  AUTHOR: K. Mae   August, 2003
!  
!  The license of the code and contact address:
!  See the files, COPYRIGHT and LICENSE (or LICENSE_J.pdf)                  
!------------------------------------------------------------------------------

Header file for Pseudopotential input-file conversion program PPCONV10.C
gncpp <-> standard <-> psv

last modification: 2003.8.21 by K. Mae
******************************************************************************/
#include	<time.h>
#include	<ctype.h>
#include	<stdio.h>
#include	<fcntl.h>
#include	<memory.h>
#include	<stdlib.h>
#include	<math.h>
#include	<string.h>

#define MAXCONF		20
#define MAXWFTAU	5
#define	MAXQPS		64


#define KN_END						999
#define KN_ATOM						0
#define KN_ALL_ELECTRON				1
#define KN_TITLE					101
#define KN_SPIN						102
#define KN_KS_EQUATION				103
#define KN_CONFIGURATION			104
#define KN_CORE_POTENTIAL			105
#define KN_XC_POTENTIAL				106
#define KN_RMESH					107
#define KN_MIXING					108
#define KN_MIX						1081
#define KN_ANDERSON					1082
#define KN_CONVERGENCE				109
#define KN_CONV_SCF					1091
#define KN_ENERGY					10911
#define KN_POTENTIAL				10912
#define KN_MAX_ITERATION			10913
#define KN_OUTPUT_RHO				911
#define KN_OUTPUT_RM				912
#define KN_PREDICTOR_CORRECTOR		111
#define KN_DIFF_ORDER				112
#define KN_NUM_COEFF_VEFF			113
#define KN_PSEUDOPOTENTIAL			2
#define KN_RCUT						2001
#define KN_SHAPE					2002
#define KN_GMESH					2003
#define KN_WF						201
#define KN_S						2011
#define KN_P						2012
#define KN_D						2013
#define KN_F						2014
#define KN_NC						2015
#define KN_US						2016
#define KN_LOCAL					202
#define KN_QPS						203
#define KN_CORE_CORRE				204
#define KN_FOURIER_TRANSFORM		205
#define KN_LOGARITHMIC_DERIVATIVE	206
#define KN_EMESH					2061
#define KN_OUTPUT_PP				921
#define KN_OUTPUT_FT				922
#define KN_OUTPUT_LOGDERI			923
#define KN_DEBUG					3
#define KN_OUTPUT					9


#define NKEYLIST 44
char *keylist[NKEYLIST] = {
	"atom",					/*0*/
	"all_electron",			/*1*/
	"title",				/*2*/
	"spin",					/*3*/
	"ks_equation",			/*4*/
	"configuration",		/*5*/
	"core_potential",		/*6*/
	"xc_potential",			/*7*/
	"rmesh",				/*8*/
	"mixing",				/*9*/
	"mix",					/*10*/
	"anderson",				/*11*/
	"convergence",			/*12*/
	"scf",					/*13*/
	"energy",				/*14*/
	"potential",			/*15*/
	"max_iteration",		/*16*/
	"rho",					/*17*/
	"rm",					/*18*/
	"predictor_corrector",	/*19*/
	"diff_order",			/*20*/
	"num_coeff_veff",		/*21*/
	"pseudopotential",		/*22*/
	"rcut",					/*23*/
	"shape",				/*24*/
	"gmesh",				/*25*/
	"wf",					/*26*/
	"s",					/*27*/
	"p",					/*28*/
	"d",					/*29*/
	"f",					/*30*/
	"nc",					/*31*/
	"us",					/*32*/
	"local",				/*33*/
	"qps",					/*34*/
	"core_correction",		/*35*/
	"fourier_transform",	/*36*/
	"logarithmic_derivative",	/*37*/
	"emesh",				/*38*/
	"pp",					/*39*/
	"ft",					/*40*/
	"logderi",				/*41*/
	"debug",				/*42*/
	"output"				/*43*/
};

int keyno[NKEYLIST] = {
	KN_ATOM,
	KN_ALL_ELECTRON,
	KN_TITLE,
	KN_SPIN,
	KN_KS_EQUATION,
	KN_CONFIGURATION,
	KN_CORE_POTENTIAL,
	KN_XC_POTENTIAL,
	KN_RMESH,
	KN_MIXING,
	KN_MIX,
	KN_ANDERSON,
	KN_CONVERGENCE,
	KN_CONV_SCF,
	KN_ENERGY,
	KN_POTENTIAL,
	KN_MAX_ITERATION,
	KN_OUTPUT_RHO,
	KN_OUTPUT_RM,
	KN_PREDICTOR_CORRECTOR,
	KN_DIFF_ORDER,
	KN_NUM_COEFF_VEFF,
	KN_PSEUDOPOTENTIAL,
	KN_RCUT,
	KN_SHAPE,
	KN_GMESH,
	KN_WF,
	KN_S,
	KN_P,
	KN_D,
	KN_F,
	KN_NC,
	KN_US,
	KN_LOCAL,
	KN_QPS,
	KN_CORE_CORRE,
	KN_FOURIER_TRANSFORM,
	KN_LOGARITHMIC_DERIVATIVE,
	KN_EMESH,
	KN_OUTPUT_PP,
	KN_OUTPUT_FT,
	KN_OUTPUT_LOGDERI,
	KN_DEBUG,
	KN_OUTPUT,
};

/************************************
for standard format
***********************************/
#define NYESNO	4
char *yes_no[NYESNO] = { "no","n","yes","y" };
#define NMORA	2
char *m_or_a[NMORA] = { "manual", "automatic" };
#define NSPINALT	2
char *spin_alt[NSPINALT] = { "restricted", "polarized"  };
#define NKSEQUATIONALT	4
char *ks_equation_alt[NKSEQUATIONALT] = { "nonrel", "srel", "rel", "srel_gncpp" };
#define NSPDFALT	4
char *spdf_alt[NSPDFALT] = {"s","p","d","f"};
#define NORBITALALT	19
char *orbital_alt[NORBITALALT] = {"1s","2s","2p","3s","3p","3d","4s","4p","4d","4f","5s","5p","5d","5f","6s","6p","6d","7s","7p"};
#define NCOREPOTENTIALALT	2
char *core_potential_alt[NCOREPOTENTIALALT] = { "normal", "patom" };
#define NXCPOTENTIALALT	4
char *xc_potential_alt[NXCPOTENTIALALT] = { "ldapz81", "ldapw92", "ggapbe96", "ggarevpbe" };
#define NSHAPEALT	4
char *shape_alt[NSHAPEALT] = { "polynomial", "sbessel", "tm90", "kerker85" };
#define NPPTYPEALT	2
char *pptype_alt[NPPTYPEALT] = { "nc", "us" };
#define NLOCALALT	3
char *local_alt[NLOCALALT] = {"orbital","gncpp","psv"};
#define NCORECORREALT 3
char *core_corre_alt[NCORECORREALT] = {"none", "pcc", "fcc"}; 
#define NCCRCUTALT 3
char *cc_rcut_alt[NCCRCUTALT] = {"automatic", "radius", "cv_ratio"}; 
#define NOUTPUTALT	3
char *output_alt[NOUTPUTALT] = { "none", "igor", "gnuplot" };
#define NOUTPUTPPALT	4
char *output_pp_alt[NOUTPUTPPALT] = { "none", "gncpp", "psv", "ppot" };


/************************************
for gncpp format
***********************************/
#define NGNXCALT	4
char *gn_xc_alt[NGNXCALT] = { "pz", "ldapw91", "ggapbe", "ggabp" };
int nl[NORBITALALT][2] = {
	{1,0}, {2,0}, {2,1}, {3,0}, {3,1}, {3,2}, {4,0}, {4,1}, {4,2}, {4,3},
	{5,0}, {5,1}, {5,2}, {5,3}, {6,0}, {6,1}, {6,2}, {7,0}, {7,1}
};

/************************************
for psv format
***********************************/
#define NPSVXCALT	3
char *psv_xc_alt[NPSVXCALT] = { "'ggapw91'", "'ldapw92'", "'ggapbe96'"  };

/*********************************
common variables
************************************/
#define RBUFSIZE 8192
FILE *fpr;
FILE *fpw;
FILE *fpl;
char rfile[128];
char wfile[128];
char rbuf[RBUFSIZE];
char keyword[32];
char pbuf[32];
int rptr;
int rlen;

/***********************************
variable for std. format
************************************/
int atom;

char title[128];
int spin;
double spin_val;
int ks_equation;
int num_cnf;
int num_occ;
struct CONFIGURATION {
	int orbital;
	double up;
	double down;
} conf[MAXCONF];
int core_potential;
int xc_potential;
int rmesh;
int rmesh_val0;
double rmesh_val1;
double rmesh_val2;
double mix;
int anderson;
double conv_scf_e;
double conv_scf_p;
int conv_max_iteration;
double conv_wf;
int pre_cor0;
int pre_cor1;
int diff_order;
int num_coeff_veff;
int output_rho;
int output_rm;

int is_calc_pp;
struct WF_SPDF {
	int orbital;
	int pptype;
	int num_rcut;
	double rcut[MAXWFTAU][2];
} wf_l[4];
int wf_nc_shape;
int wf_nc_shape_val;
int wf_us_shape;
int wf_us_shape_val;
int wf_gmesh;
int wf_gmesh_val0;
double wf_gmesh_val1;
double wf_gmesh_val2;
int local;
int local_val;
double local_rcloc, local_const, local_lamda;
int qps_num_rcut;
int qps_rcut[MAXQPS][5];
double qps_rcut_val[MAXQPS];
int qps_shape;
int qps_shape_val;
int qps_gmesh;
int qps_gmesh_val0;
double qps_gmesh_val1;
double qps_gmesh_val2;
int core_corre;
int cc_rcut;
double cc_rcut_val;
int cc_shape;
int cc_shape_val;
int cc_gmesh;
int cc_gmesh_val0;
double cc_gmesh_val1;
double cc_gmesh_val2;

int is_calc_ft;
int ft_gmesh;
int ft_gmesh_val0;
double ft_gmesh_val1;
double ft_gmesh_val2;

int is_calc_ld;
int ld_emesh;
int ld_emesh_val0;
double ld_emesh_val1;
double ld_emesh_val2;
double ld_rcut;

int num_output_pp;
int output_pp[5];
int output_ft;
int output_logderi;

int is_write_debug;

/***********************************
variable for gncpp format
************************************/
int gn_mesh;
double gn_xh, gn_rmax, gn_rinf;
double gn_pmix, gn_edel, gn_vdel;
int gn_jprt, gn_jrh, gn_ifp, gn_nshl, gn_irela;
int gn_xc;
int gn_natom;
double gn_xion;
int gn_nljc[MAXCONF];
double gn_wnlj[MAXCONF], gn_down[MAXCONF];
int gn_lpsmax, gn_iloc, gn_ivan;
double gn_rcloc, gn_const, gn_lamda;
struct GN_WF_t {
	int l1;
	int itau;
	int ivanl;
	int norb[MAXWFTAU];
	double r_cl[MAXWFTAU];
	double etau[MAXWFTAU];
} gn_wf[4];
double gn_gmaxwf;
int gn_meshgw, gn_mopsw;
double gn_gmaxps;
int gn_meshgs, gn_mopsc;
int gn_num_qps;
int gn_il1[MAXQPS], gn_t1[MAXQPS], gn_il2[MAXQPS], gn_t2[MAXQPS], gn_il3[MAXQPS], gn_il4[MAXQPS];
double gn_rcmlt[MAXQPS];
int gn_ipcc;
double gn_crc0;
double gn_gmaxpc;
int gn_meshgc, gn_mopcc;

/***********************************
variable for psv format
************************************/
int psv_xctype;
double psv_zn;
int psv_irela;
int psv_ncst;
int psv_nvstal;
struct PSV_ELECTRON_t {
	int		n;
	int		l;
	double	occup;
	double	e;
}	psv_ce[MAXCONF], psv_ve[MAXCONF];
int psv_itermx, psv_mesh;
double psv_radmin, psv_radmax;
double psv_conv, psv_beta;
double psv_zv;
int psv_ipcc;
double psv_rpcc;
int psv_nvst;
struct PSV_WF_t {
	int nv;
	int lv;
	double rc;
	int ipot;
	int iwav;
	int nref;
	double eref[MAXWFTAU];
} psv_wf[4];
int psv_iloc;
int psv_np;
int psv_lp;
double psv_rcp;
int psv_iwavp;
int psv_ipq;
double psv_rin[16];
double psv_gc, psv_gh;
int psv_ng;
int psv_nsst;
struct PSV_NS_t {
	int ns;
	int ls;
	double swgt;
}	psv_ns[16];	/*max?*/
int psv_norb;
struct PSV_ELECTRON_t psv_solps[MAXCONF];
double psv_emin, psv_emax;
int psv_neng;
double psv_rdrv;

