! ************************************************************* 
!
!   This is a software package CIAO
!
!     developed as a part of the national project "Research and 
!     Development of Innovative Simulation software",which is   
!     supported by the next-generation IT program of MEXT of Japan
!
!   latest version: 
!
!     4.0:  2013/01/17 
!           codes for spin-polarized pseudopotential generation are added
!
! ************************************************************* 
!
!  Software name : CIAO (Code for Investigating Atomic Orbitals)
!  Subroutine(s) : generate_rmesh, generate_gmesh
!  Author(s)     : Masakuni Okamoto (August 25, 2003)
!
!  The license of the code and contact address :
!  See the files, COPYRIGHT and LICENSE (or LICENSE_J.pdf)
!
!=====================================================================
   subroutine generate_rmesh(ier,mesh,rmin,rmax, &
                             xmin,xmax,dx,xpos,rpos,wr)
!=====================================================================
!
!  M. Okamoto
!
!---------------------------------------------------------------------
   implicit none
   integer,intent(in)  :: mesh
   real(8),intent(in)  :: rmin, rmax
   integer,intent(out) :: ier
   real(8),intent(out) :: xmin, xmax, dx, &
                          xpos(mesh), rpos(mesh), wr(mesh)
   integer :: ir
   real(8) :: rr
   ier = 0
   xmin = log(rmin)
   xmax = log(rmax)
   dx = (xmax - xmin)/dble(mesh-1)
   rr = rmax / rmin
   do ir = 1,mesh
      xpos(ir) = xmin + dble(ir-1) * dx
      rpos(ir) = exp(xpos(ir))
   end do
   call set_weight_exp(ier,1,mesh,rpos,wr)
   end subroutine generate_rmesh

!=====================================================================
   subroutine generate_gmesh(ier,mesh,gmin,gmax,gpos,wg)
!=====================================================================
!
!  M. Okamoto
!
!---------------------------------------------------------------------
   implicit none
   integer,intent(in)  :: mesh
   real(8),intent(in)  :: gmin, gmax
   integer,intent(out) :: ier
   real(8),intent(out) :: gpos(mesh), wg(mesh)
   integer :: ig
   ier = 0
   do ig = 1,mesh
      gpos(ig) = gmin + dble(ig-1)/dble(mesh-1) * (gmax-gmin)
   end do
   call set_weight_unif(ier,1,mesh,gpos,wg)
   end subroutine generate_gmesh
