! @@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@ !
! @@                                                                @@ !
! @@       PROGRAM  ASCOT 2014.440 (ver.4.53)                       @@ !
! @@     "Abinitio Simulation Code for Quantum Transport"           @@ !
! @@                                                                @@ !
! @@                                                                @@ !
! @@  AUTHOR(S): Hisashi KONDO (Univ. Tokyo)                        @@ !
! @@             Naoki WATANABE (Mizuho I.R.)                       @@ !
! @@             Nobutaka NISHIKAWA (Mizuho I.R.)                   @@ !
! @@                                                09/May/2014     @@ !
! @@                                                                @@ !
! @@  Contact address: Phase System Consortium                      @@ !
! @@                                                                @@ !
! @@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@ !

subroutine set_hamiltonian_temp(file_parameter1,file_parameter2,file_parameter3)

  use hamiltonian_sgf
  use hamiltonian_c
  use hamiltonian_temp

  implicit none
  include 'mpif.h'
  character(50), intent(in) :: file_parameter1,file_parameter2,file_parameter3
  real(8) :: vv_temp
  integer :: i_spin_temp


  vv_temp=0.d0
  i_spin_temp=0

  call set_ham_negf_c(file_parameter1)
  call set_ham_negf_l(file_parameter2,vv_temp,i_spin_temp)
  call set_ham_negf_r(file_parameter3,vv_temp,i_spin_temp)

  if( spin_ll /= spin_cc .or. spin_cc /= spin_rr ) then
     write(6,*) 'error: spin1',spin_ll,spin_cc,spin_rr
     stop
  end if

  return
end subroutine set_hamiltonian_temp

subroutine set_ham_negf_c1(file_parameter)
  use hamiltonian_sgf
  use hamiltonian_c
  use hamiltonian_temp
  use scf_negf
  use ac_mpi_module
  use mod_mpi

  implicit none
  character(50), intent(in) :: file_parameter

  logical :: ex
  integer :: l
  character(55) :: fname1

  open(unit=16,file=file_tempout,position='append')
  write(16,*) '++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++'
  write(16,*) '+++++++++++        loading hamiltonian matrices: scattering'
  write(16,999) trim(file_parameter)
  write(16,*) '++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++'
999 format(' +++++++++++        read file:: ',a)
  close(16)

  fname1=trim(file_parameter)//'_0001'
  inquire(file=fname1,exist=ex)
  if( .not. ex ) then
     open(unit=16,file=file_tempout,position='append')
     write(16,'(a,a)') '      ++++++ Error: can not open file ', fname1
     close(16)
     stop
  end if
  inquire(file=fname1,exist=ex)
  open(unit=19,file=fname1,status='old')
  read(19,*) natom_ac_ct,natom_ac_cl,natom_ac_cr,nl_ac_c,spin_cc             &
       ,m_mat_max_l,m_mat_max_c,m_mat_max_r
  read(19,*) cell_tempabc(1,1),cell_tempabc(1,2),cell_tempabc(1,3)
  read(19,*) cell_tempabc(2,1),cell_tempabc(2,2),cell_tempabc(2,3)
  read(19,*) cell_tempabc(3,1),cell_tempabc(3,2),cell_tempabc(3,3)
  close(19)
  spin_cc=spin_cc+1
  spin_switch_cc=spin_cc

  if( ispin_pol_scf /= spin_switch_cc ) then
     open(unit=16,file=file_tempout,position='append')
     write(16,'(a,a)') '      ++++++ Error: spin ...'                        &
          ,ispin_pol_scf,spin_switch_cc
     close(16)
     stop
  end if

  call alo_ham_negf_type_c1

  do l=1,param_cell_nl
     rac_c(1,l)=param_cell_vl(l,1)
     rac_c(2,l)=param_cell_vl(l,2)
     rac_c(3,l)=param_cell_vl(l,3)
  end do

  return
end subroutine set_ham_negf_c1

subroutine set_ham_negf_c(file_parameter)
  use hamiltonian_sgf
  use hamiltonian_c
  use hamiltonian_temp
  use ac_mpi_module
  use mod_mpi

  implicit none
  character(50), intent(in) :: file_parameter

  logical :: ex

  integer :: l,a,b,l_t,a_t,b_t,i1,j1
  integer :: i2,i_temp1,i_temp2
  real(8) :: temp1,temp2,temp3,temp4
  character(1) :: character_temp(4),a_c(10)
  character(55) :: fname,fname1

  open(unit=16,file=file_tempout,position='append')
  write(16,*) '++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++'
  write(16,*) '+++++++++++        loading hamiltonian matrices: scattering'
  write(16,999) trim(file_parameter)
  write(16,*) '++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++'
999 format(' +++++++++++        read file:: ',a)
  close(16)

  fname1=trim(file_parameter)//'_0001'
  inquire(file=fname1,exist=ex)
  if( .not. ex ) then
     open(unit=16,file=file_tempout,position='append')
     write(16,'(a,a)') '      ++++++ Error: can not open file ', fname1
     close(16)
     stop
  end if
  inquire(file=fname1,exist=ex)
  open(unit=19,file=fname1,status='old')
  read(19,*) natom_ac_ct,natom_ac_cl,natom_ac_cr,nl_ac_c,spin_cc             &
       ,m_mat_max_l,m_mat_max_c,m_mat_max_r
  read(19,*) cell_tempabc(1,1),cell_tempabc(1,2),cell_tempabc(1,3)
  read(19,*) cell_tempabc(2,1),cell_tempabc(2,2),cell_tempabc(2,3)
  read(19,*) cell_tempabc(3,1),cell_tempabc(3,2),cell_tempabc(3,3)
  close(19)
  spin_cc=spin_cc+1
  spin_switch_cc=spin_cc
  call alo_ham_negf_type_c1

  a_c(1)='0'
  a_c(2)='1'
  a_c(3)='2'
  a_c(4)='3'
  a_c(5)='4'
  a_c(6)='5'
  a_c(7)='6'
  a_c(8)='7'
  a_c(9)='8'
  a_c(10)='9'

  do a=1,natom_ac_ct

     i_temp1=a
     do i2=1,4
        i_temp2=i_temp1/(10**(4-i2))
        character_temp(i2)=a_c(i_temp2+1)
        i_temp1=i_temp1-(10**(4-i2))*i_temp2
     end do
     fname=trim(file_parameter)//'_'//character_temp(1)//character_temp(2)     &
          //character_temp(3)//character_temp(4)
     inquire(file=fname,exist=ex)
     if( .not. ex ) then
        open(unit=16,file=file_tempout,position='append')
        write(16,'(a,a)') '      ++++++ Error: can not open file ', fname
        close(16)
        stop
     end if

     open(unit=19,file=fname,status='old')
     read(19,*) 
     read(19,*) 
     read(19,*) 
     read(19,*) 
     do l=1,nl_ac_c
        do b=1,natom_ac_ct
           read(19,*)
           read(19,*) a_t,l_t,b_t,i_over_c(b,a,l),i_orb_c(a),i_orb_c(b)
           read(19,*) rac_c(1,l),rac_c(2,l),rac_c(3,l)

           if(l/=l_t+1) then
              open(unit=16,file=file_tempout,position='append')
              write(16,'(a,a)') '      ++++++ Error: l ', fname
              close(16)
              stop
           end if
           if(a/=a_t+1) then
              open(unit=16,file=file_tempout,position='append')
              write(16,'(a,a)') '      ++++++ Error: a3 ', fname
              close(16)
              stop
           end if
           if(b/=b_t+1) then
              open(unit=16,file=file_tempout,position='append')
              write(16,'(a,a)') '      ++++++ Error: b ', fname
              close(16)
              stop
           end if

           if( i_over_c(b,a,l) == 1 ) then
              cycle
           end if

           call alo_ham_negf_type_c2(a,b,l,i_orb_c(a),i_orb_c(b))

           do i1=1,i_orb_c(a)

              do j1=1,i_orb_c(b)
                 if( spin_cc == 1 ) then
                    read(19,*) ht_hs_c(b,a,l)%s(j1,i1),temp2                       &
                         ,ht_hs_c(b,a,l)%h(1,j1,i1) 
                 else
                    if( spin_cc == 2 ) then
                       read(19,*) ht_hs_c(b,a,l)%s(j1,i1),temp2                     &
                            ,ht_hs_c(b,a,l)%h(1,j1,i1),ht_hs_c(b,a,l)%h(2,j1,i1)
                    else
                       read(19,*) ht_hs_c(b,a,l)%s(j1,i1)
                       read(19,*)
                       read(19,*)
                       read(19,*) temp1,temp2,temp3,temp4
                       ht_hs_c(b,a,l)%hls(1,j1,i1)=dcmplx(temp1,temp2)
                       ht_hs_c(b,a,l)%hls(2,j1,i1)=dcmplx(temp3,temp4)
                       read(19,*) temp1,temp2,temp3,temp4
                       ht_hs_c(b,a,l)%hls(3,j1,i1)=dcmplx(temp1,temp2)
                       ht_hs_c(b,a,l)%hls(4,j1,i1)=dcmplx(temp3,temp4)
                       read(19,*)
                       read(19,*)
                    end if
                 end if
              end do
           end do
        end do
     end do
     close(19)
  end do

  return
end subroutine set_ham_negf_c

subroutine set_ham_negf_l(file_parameter,vv_temp,i_rotspin_l)
  use hamiltonian_sgf
  use hamiltonian_c
  use hamiltonian_temp
  use constant
  use ac_mpi_module
  use mod_mpi

  implicit none
  character(50), intent(in) :: file_parameter
  integer, intent(in) :: i_rotspin_l
  real(8), intent(in) :: vv_temp

  logical :: ex

  integer :: l,a,b,l_t,a_t,b_t,i1,j1
  integer :: i2,i_temp1,i_temp2
  real(8) :: temp1,temp2,temp3,temp4
  character(1) :: character_temp(4),a_c(10)
  character(55) :: fname,fname1

  open(unit=16,file=file_tempout,position='append')
  write(16,*) '++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++'
  write(16,*) '+++++++++++        loading hamiltonian matrices: left lead'
  write(16,999) trim(file_parameter)
  write(16,*) '++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++'
999 format(' +++++++++++        read file:: ',a)
  close(16)

  fname1=trim(file_parameter)//'_0001'
  inquire(file=fname1,exist=ex)
  if( .not. ex ) then
     open(unit=16,file=file_tempout,position='append')
     write(16,'(a,a)') '      ++++++ Error: can not open file ', fname1
     close(16)
     stop
  end if
  open(unit=19,file=fname1,status='old')
  read(19,*) natom_ac_lt,natom_ac_ll,natom_ac_lr,nl_ac_l,spin_ll             &
       ,mat_max_ll,i_temp1,i_temp2,ele_num_ll,temp1
  spin_ll=spin_ll+1
  close(19)
  call alo_ham_negf_type_l1

  a_c(1)='0'
  a_c(2)='1'
  a_c(3)='2'
  a_c(4)='3'
  a_c(5)='4'
  a_c(6)='5'
  a_c(7)='6'
  a_c(8)='7'
  a_c(9)='8'
  a_c(10)='9'

  do a=1,natom_ac_lt

     i_temp1=a
     do i2=1,4
        i_temp2=i_temp1/(10**(4-i2))
        character_temp(i2)=a_c(i_temp2+1)
        i_temp1=i_temp1-(10**(4-i2))*i_temp2
     end do
     fname=trim(file_parameter)//'_'//character_temp(1)//character_temp(2)     &
          //character_temp(3)//character_temp(4)
     inquire(file=fname,exist=ex)
     if( .not. ex ) then
        open(unit=16,file=file_tempout,position='append')
        write(16,'(a,a)') '      ++++++ Error: can not open file ', fname
        close(16)
        stop
     end if

     open(unit=19,file=fname,status='old')
     read(19,*)
     read(19,*) 
     read(19,*) 
     read(19,*) 

     do l=1,nl_ac_l
        do b=1,natom_ac_lt
           read(19,*)
           read(19,*) a_t,l_t,b_t,i_over_l(b,a,l),i_orb_l(a),i_orb_l(b)
           read(19,*) rac_l(1,l),rac_l(2,l),rac_l(3,l)

           if(l/=l_t+1) then
              open(unit=16,file=file_tempout,position='append')
              write(16,'(a,a)') '      ++++++ Error: l ', fname
              close(16)
              stop
           end if
           if(a/=a_t+1) then
              open(unit=16,file=file_tempout,position='append')
              write(16,'(a,a)') '      ++++++ Error: a4 ', fname
              close(16)
              stop
           end if
           if(b/=b_t+1) then
              open(unit=16,file=file_tempout,position='append')
              write(16,'(a,a)') '      ++++++ Error: b ', fname
              close(16)
              stop
           end if

           if( i_over_l(b,a,l) == 1 ) then
              cycle
           end if

           call alo_ham_negf_type_l2(a,b,l,i_orb_l(a),i_orb_l(b))

           do i1=1,i_orb_l(a)

              do j1=1,i_orb_l(b)
                 if( spin_ll == 1 ) then
                    read(19,*) ht_hs_l(b,a,l)%s(j1,i1),temp2                       &
                         ,ht_hs_l(b,a,l)%h(1,j1,i1)
                    ht_hs_l(b,a,l)%h(1,j1,i1)=ht_hs_l(b,a,l)%h(1,j1,i1)            &
                         +vv_temp*ht_hs_l(b,a,l)%s(j1,i1)/ene_scale
                 else
                    if( spin_cc == 2 ) then
                       if( i_rotspin_l == 0 ) then
                          read(19,*) ht_hs_l(b,a,l)%s(j1,i1),temp2                   &
                               ,ht_hs_l(b,a,l)%h(1,j1,i1),ht_hs_l(b,a,l)%h(2,j1,i1)
                       else
                          read(19,*) ht_hs_l(b,a,l)%s(j1,i1),temp2                   &
                               ,ht_hs_l(b,a,l)%h(2,j1,i1),ht_hs_l(b,a,l)%h(1,j1,i1)
                       end if
                       ht_hs_l(b,a,l)%h(1,j1,i1)=ht_hs_l(b,a,l)%h(1,j1,i1)          &
                            +vv_temp*ht_hs_l(b,a,l)%s(j1,i1)/ene_scale
                       ht_hs_l(b,a,l)%h(2,j1,i1)=ht_hs_l(b,a,l)%h(2,j1,i1)          &
                            +vv_temp*ht_hs_l(b,a,l)%s(j1,i1)/ene_scale
                    else
                       read(19,*) ht_hs_l(b,a,l)%s(j1,i1)
                       read(19,*)
                       read(19,*)
                       read(19,*) temp1,temp2,temp3,temp4
                       ht_hs_l(b,a,l)%hls(1,j1,i1)                                  &
                            =dcmplx(temp1+vv_temp*ht_hs_l(b,a,l)%s(j1,i1)/ene_scale &
                            ,temp2)
                       ht_hs_l(b,a,l)%hls(2,j1,i1)=dcmplx(temp3,temp4)
                       read(19,*) temp1,temp2,temp3,temp4
                       ht_hs_l(b,a,l)%hls(3,j1,i1)=dcmplx(temp1,temp2)
                       ht_hs_l(b,a,l)%hls(4,j1,i1)                                  &
                            =dcmplx(temp3+vv_temp*ht_hs_l(b,a,l)%s(j1,i1)/ene_scale &
                            ,temp4)
                       read(19,*)
                       read(19,*)
                    end if
                 end if
              end do
           end do
        end do
     end do

     close(19)
  end do

  return
end subroutine set_ham_negf_l

subroutine set_ham_negf_r(file_parameter,vv_temp,i_rotspin_r)
  use hamiltonian_sgf
  use hamiltonian_c
  use hamiltonian_temp
  use constant
  use ac_mpi_module
  use mod_mpi

  implicit none
  character(50), intent(in) :: file_parameter
  integer, intent(in) :: i_rotspin_r
  real(8), intent(in) :: vv_temp

  logical :: ex

  integer :: l,a,b,l_t,a_t,b_t,i1,j1
  integer :: i2,i_temp1,i_temp2
  real(8) :: temp1,temp2,temp3,temp4
  character(1) :: character_temp(4),a_c(10)
  character(55) :: fname,fname1

  open(unit=16,file=file_tempout,position='append')
  write(16,*) '++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++'
  write(16,*) '+++++++++++        loading hamiltonian matrices: right lead'
  write(16,999) trim(file_parameter)
  write(16,*) '++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++'
999 format(' +++++++++++        read file:: ',a)
  close(16)

  fname1=trim(file_parameter)//'_0001'
  inquire(file=fname1,exist=ex)
  if( .not. ex ) then
     open(unit=16,file=file_tempout,position='append')
     write(16,'(a,a)') '      ++++++ Error: can not open file ', fname1
     close(16)
     stop
  end if
  open(unit=19,file=fname1,status='old')
  read(19,*) natom_ac_rt,natom_ac_rl,natom_ac_rr,nl_ac_r,spin_rr             &
       ,i_temp1,i_temp2,mat_max_rr,temp1,ele_num_rr
  spin_rr=spin_rr+1
  close(19)
  call alo_ham_negf_type_r1

  a_c(1)='0'
  a_c(2)='1'
  a_c(3)='2'
  a_c(4)='3'
  a_c(5)='4'
  a_c(6)='5'
  a_c(7)='6'
  a_c(8)='7'
  a_c(9)='8'
  a_c(10)='9'

  do a=1,natom_ac_rt

     i_temp1=a
     do i2=1,4
        i_temp2=i_temp1/(10**(4-i2))
        character_temp(i2)=a_c(i_temp2+1)
        i_temp1=i_temp1-(10**(4-i2))*i_temp2
     end do
     fname=trim(file_parameter)//'_'//character_temp(1)//character_temp(2)     &
          //character_temp(3)//character_temp(4)
     inquire(file=fname,exist=ex)
     if( .not. ex ) then
        open(unit=16,file=file_tempout,position='append')
        write(16,'(a,a)') '      ++++++ Error: can not open file ', fname
        close(16)
        stop
     end if

     open(unit=19,file=fname,status='old')
     read(19,*) 
     read(19,*) 
     read(19,*) 
     read(19,*) 

     do l=1,nl_ac_r
        do b=1,natom_ac_rt
           read(19,*)
           read(19,*) a_t,l_t,b_t,i_over_r(b,a,l),i_orb_r(a),i_orb_r(b)
           read(19,*) rac_r(1,l),rac_r(2,l),rac_r(3,l)

           if(l/=l_t+1) then
              open(unit=16,file=file_tempout,position='append')
              write(16,'(a,a)') '      ++++++ Error: l ', fname
              close(16)
              stop
           end if
           if(a/=a_t+1) then
              open(unit=16,file=file_tempout,position='append')
              write(16,'(a,a)') '      ++++++ Error: a5 ', fname
              close(16)
              stop
           end if
           if(b/=b_t+1) then
              open(unit=16,file=file_tempout,position='append')
              write(16,'(a,a)') '      ++++++ Error: b ', fname
              close(16)
              stop
           end if

           if( i_over_r(b,a,l) == 1 ) then
              cycle
           end if

           call alo_ham_negf_type_r2(a,b,l,i_orb_r(a),i_orb_r(b))

           do i1=1,i_orb_r(a)

              do j1=1,i_orb_r(b)
                 if( spin_rr == 1 ) then
                    read(19,*) ht_hs_r(b,a,l)%s(j1,i1),temp2                       &
                         ,ht_hs_r(b,a,l)%h(1,j1,i1)
                    ht_hs_r(b,a,l)%h(1,j1,i1)=ht_hs_r(b,a,l)%h(1,j1,i1)            &
                         +vv_temp*ht_hs_r(b,a,l)%s(j1,i1)/ene_scale
                 else
                    if( spin_cc == 2 ) then
                       if( i_rotspin_r == 0 ) then
                          read(19,*) ht_hs_r(b,a,l)%s(j1,i1),temp2                   &
                               ,ht_hs_r(b,a,l)%h(1,j1,i1),ht_hs_r(b,a,l)%h(2,j1,i1)
                       else
                          read(19,*) ht_hs_r(b,a,l)%s(j1,i1),temp2                   &
                               ,ht_hs_r(b,a,l)%h(2,j1,i1),ht_hs_r(b,a,l)%h(1,j1,i1)
                       end if
                       ht_hs_r(b,a,l)%h(1,j1,i1)=ht_hs_r(b,a,l)%h(1,j1,i1)          &
                            +vv_temp*ht_hs_r(b,a,l)%s(j1,i1)/ene_scale
                       ht_hs_r(b,a,l)%h(2,j1,i1)=ht_hs_r(b,a,l)%h(2,j1,i1)          &
                            +vv_temp*ht_hs_r(b,a,l)%s(j1,i1)/ene_scale
                    else
                       read(19,*) ht_hs_r(b,a,l)%s(j1,i1)
                       read(19,*)
                       read(19,*)
                       read(19,*) temp1,temp2,temp3,temp4
                       ht_hs_r(b,a,l)%hls(1,j1,i1)                                  &
                            =dcmplx(temp1+vv_temp*ht_hs_r(b,a,l)%s(j1,i1)/ene_scale &
                            ,temp2)
                       ht_hs_r(b,a,l)%hls(2,j1,i1)=dcmplx(temp3,temp4)
                       read(19,*) temp1,temp2,temp3,temp4
                       ht_hs_r(b,a,l)%hls(3,j1,i1)=dcmplx(temp1,temp2)
                       ht_hs_r(b,a,l)%hls(4,j1,i1)                                  &
                            =dcmplx(temp3+vv_temp*ht_hs_r(b,a,l)%s(j1,i1)/ene_scale &
                            ,temp4)
                       read(19,*)
                       read(19,*)
                    end if
                 end if
              end do
           end do
        end do
     end do

     close(19)
  end do

  return
end subroutine set_ham_negf_r

subroutine set_ham_temp_ham_c0(descCC,qx_st,qy_st)
  use hamiltonian_sgf
  use hamiltonian_c
  use hamiltonian_temp
  use constant
  use ac_mpi_module
  use mod_mpi

  implicit none

  type(MPI_MatDesc), intent(in) :: descCC
  real(8), intent(in) :: qx_st,qy_st

  integer, allocatable :: i_orb_lr(:)
  complex(8), allocatable :: h_cc(:,:,:)
  complex(8), allocatable :: s_cc(:,:)
  complex(8), allocatable :: work(:,:)

  integer :: i1,j1,ier,a,b,l,ispin,ls_spin
  complex(8) :: const
  real(8) :: co,sn

  integer :: i, j

  complex(8), allocatable :: h_cc_all(:,:,:)
  complex(8), allocatable :: s_cc_all(:,:)


  allocate(i_orb_lr(natom_ac_ct+1),stat=ier)
  if( ier /= 0 ) then
     write(6,*) 'error allocate: alo_ham_negf_type_c1'
     stop
  end if

  i_orb_lr(1)=0
  do i1=1,natom_ac_ct
     i_orb_lr(i1+1)=i_orb_lr(i1)+i_orb_c(i1)
  end do


  if( spin_cc /= 2 ) then
     ls_spin=1
  else
     ls_spin=2
  end if

  allocate(s_cc(descCC%nrow, descCC%scol:descCC%ecol),stat=ier)
  allocate(h_cc(descCC%nrow, descCC%scol:descCC%ecol, ls_spin),stat=ier)

  if( ier /= 0 ) then
     write(6,*) 'error allocate: alo_ham_negf_type_c1'
     stop
  end if

  do ispin=1,ls_spin
     h_cc(:,:,ispin) = dcmplx(0.d0,0.d0)
  end do
  s_cc(:,:) = dcmplx(0.d0,0.d0)


  allocate(h_cc_all(descCC%nrow,descCC%ncol,ls_spin),stat=ier)
  do ispin=1,ls_spin
     h_cc_all(:,:,ispin) = dcmplx(0.d0,0.d0)
  end do

  do a=1,natom_ac_ct
     do b=1,natom_ac_ct

        if( a <= natom_ac_cl .and. b > natom_ac_ct-natom_ac_cr ) then
           cycle
        end if
        if( b <= natom_ac_cl .and. a > natom_ac_ct-natom_ac_cr ) then
           cycle
        end if

        do l=1,nl_ac_c
           if( i_over_c(a,b,l) == 1 ) then
              cycle
           end if

           co=dcos(qx_st*rac_c(2,l)+qy_st*rac_c(3,l))
           sn=dsin(qx_st*rac_c(2,l)+qy_st*rac_c(3,l))

           if( l /= 1 ) then
              const=dcmplx(co,sn)
           else
              const=dcmplx(co,sn)*0.5d0
           end if

           do i1=1,i_orb_c(a)
              do j1=1,i_orb_c(b)

                 i = i_orb_lr(a)+i1
                 j = i_orb_lr(b)+j1
                 if( i<descCC%srow .or. descCC%erow<i ) cycle 
                 if( j<descCC%scol .or. descCC%ecol<j ) cycle 

                 if( spin_cc /= 4 ) then
                    do ispin=1,ls_spin
                       h_cc_all(i,j,ispin) = h_cc_all(i,j,ispin) + const*dcmplx(ht_hs_c(a,b,l)%h(ispin,i1,j1)*ene_scale,0.d0)
                    end do
                 else
                    h_cc_all(i*2-1,j*2-1,1) = h_cc_all(i*2-1,j*2-1,1) + const*ht_hs_c(a,b,l)%hls(1,i1,j1)*ene_scale
                    h_cc_all(i*2-1,j*2-0,1) = h_cc_all(i*2-1,j*2-0,1) + const*ht_hs_c(a,b,l)%hls(2,i1,j1)*ene_scale
                    h_cc_all(i*2-0,j*2-1,1) = h_cc_all(i*2-0,j*2-1,1) + const*ht_hs_c(a,b,l)%hls(3,i1,j1)*ene_scale
                    h_cc_all(i*2-0,j*2-0,1) = h_cc_all(i*2-0,j*2-0,1) + const*ht_hs_c(a,b,l)%hls(4,i1,j1)*ene_scale
                 end if
              end do
           end do
        end do
     end do
  end do

  do ispin=1,ls_spin
     call MPI__Allgather_MatrixM_ASCOT( descCC, h_cc_all(:,:,ispin) ) 
  end do

  do ispin=1,ls_spin
     do j=descCC%scol,descCC%ecol
        do i=1,descCC%nrow
           h_cc(i,j,ispin) = h_cc_all(i,j,ispin) 
        end do
     end do
  end do
  deallocate(h_cc_all) 


  allocate(s_cc_all(descCC%nrow,descCC%ncol),stat=ier)
  s_cc_all(:,:) = dcmplx(0.d0,0.d0)

  do a=1,natom_ac_ct
     do b=1,natom_ac_ct

        if( a <= natom_ac_cl .and. b > natom_ac_ct-natom_ac_cr ) then
           cycle
        end if
        if( b <= natom_ac_cl .and. a > natom_ac_ct-natom_ac_cr ) then
           cycle
        end if

        do l=1,nl_ac_c
           if( i_over_c(a,b,l) == 1 ) then
              cycle
           end if

           co=dcos(qx_st*rac_c(2,l)+qy_st*rac_c(3,l))
           sn=dsin(qx_st*rac_c(2,l)+qy_st*rac_c(3,l))

           if( l /= 1 ) then
              const=dcmplx(co,sn)
           else
              const=dcmplx(co,sn)*0.5d0
           end if

           do i1=1,i_orb_c(a)
              do j1=1,i_orb_c(b)

                 i = i_orb_lr(a)+i1
                 j = i_orb_lr(b)+j1
                 if( i<descCC%srow .or. descCC%erow<i ) cycle 
                 if( j<descCC%scol .or. descCC%ecol<j ) cycle 

                 if( spin_cc /= 4 ) then
                    s_cc_all(i,j) = s_cc_all(i,j) + const*dcmplx(ht_hs_c(a,b,l)%s(i1,j1),0.d0)
                 else
                    s_cc_all(i*2-1,j*2-1)   = s_cc_all(i*2-1,j*2-1)   + const*dcmplx(ht_hs_c(a,b,l)%s(i1,j1),0.d0)
                    s_cc_all(i*2-0,j*2-0)   = s_cc_all(i*2-0,j*2-0)   + const*dcmplx(ht_hs_c(a,b,l)%s(i1,j1),0.d0)
                 end if
              end do
           end do
        end do
     end do
  end do

  call MPI__Allgather_MatrixM_ASCOT( descCC, s_cc_all ) 

  do j=descCC%scol,descCC%ecol
     do i=1,descCC%nrow
        s_cc(i,j) = s_cc_all(i,j) 
     end do
  end do
  deallocate(s_cc_all) 


  allocate(work(descCC%nrow, descCC%scol:descCC%ecol), stat=ier)
  do ispin=1,ls_spin
     work(:,:) = h_cc(:,:,ispin)
     call MPI__ZTRANC_ASCOT( descCC, C1, h_cc(:,:,ispin), C1, work ) 
  end do
  work(:,:) = s_cc(:,:)
  call MPI__ZTRANC_ASCOT( descCC, C1, s_cc, C1, work ) 
  deallocate(work)

  do ispin=1,ls_spin
     hcc_t(:,:,ispin) = h_cc(:,:,ispin) 
  end do
  scc_t(:,:) = s_cc(:,:) 

  deallocate(i_orb_lr,h_cc,s_cc,stat=ier)
  if( ier /= 0 ) then
     write(6,*) 'error allocate: alo_ham_negf_type_c1'
     stop
  end if

  return
end subroutine set_ham_temp_ham_c0

subroutine set_ham_temp_ham_c(descCC,qx_st,qy_st)
  use hamiltonian_sgf
  use hamiltonian_c
  use hamiltonian_temp
  use constant
  use ac_mpi_module
  use mod_mpi

  implicit none

  type(MPI_MatDesc), intent(in) :: descCC
  real(8), intent(in) :: qx_st,qy_st

  integer, allocatable :: i_orb_lr(:)
  complex(8), allocatable :: h_cc(:,:,:)
  complex(8), allocatable :: s_cc(:,:)
  complex(8), allocatable :: work(:,:)

  integer :: i1,j1,ier,a,b,l,ispin,ls_spin
  complex(8) :: const
  real(8) :: co,sn

  integer :: i, j

  complex(8), allocatable :: h_cc_all(:,:,:)
  complex(8), allocatable :: s_cc_all(:,:)


  allocate(i_orb_lr(natom_ac_ct+1),stat=ier)
  if( ier /= 0 ) then
     write(6,*) 'error allocate: alo_ham_negf_type_c1'
     stop
  end if

  i_orb_lr(1)=0
  do i1=1,natom_ac_ct
     i_orb_lr(i1+1)=i_orb_lr(i1)+i_orb_c(i1)
  end do


  if( spin_cc /= 2 ) then
     ls_spin=1
  else
     ls_spin=2
  end if

  allocate(s_cc(descCC%nrow, descCC%scol:descCC%ecol),stat=ier)
  allocate(h_cc(descCC%nrow, descCC%scol:descCC%ecol, ls_spin),stat=ier)

  if( ier /= 0 ) then
     write(6,*) 'error allocate: alo_ham_negf_type_c1'
     stop
  end if

  do ispin=1,ls_spin
     h_cc(:,:,ispin) = dcmplx(0.d0,0.d0)
  end do
  s_cc(:,:) = dcmplx(0.d0,0.d0)



  allocate(h_cc_all(descCC%nrow,descCC%scol:descCC%ecol,ls_spin),stat=ier)
  do ispin=1,ls_spin
     h_cc_all(:,:,ispin) = dcmplx(0.d0,0.d0)
  end do

  do a=1,natom_ac_ct
     do b=1,natom_ac_ct

        if( a <= natom_ac_cl .and. b > natom_ac_ct-natom_ac_cr ) then
           cycle
        end if
        if( b <= natom_ac_cl .and. a > natom_ac_ct-natom_ac_cr ) then
           cycle
        end if

        do l=1,nl_ac_c
           if( i_over_c(a,b,l) == 1 ) then
              cycle
           end if

           co=dcos(qx_st*rac_c(2,l)+qy_st*rac_c(3,l))
           sn=dsin(qx_st*rac_c(2,l)+qy_st*rac_c(3,l))

           if( l /= 1 ) then
              const=dcmplx(co,sn)
           else
              const=dcmplx(co,sn)*0.5d0
           end if

           do i1=1,i_orb_c(a)
              do j1=1,i_orb_c(b)

                 i = i_orb_lr(a)+i1
                 j = i_orb_lr(b)+j1
                 if( i<descCC%srow .or. descCC%erow<i ) cycle 
                 if( j<descCC%scol .or. descCC%ecol<j ) cycle 

                 if( spin_cc /= 4 ) then
                    do ispin=1,ls_spin
                       h_cc_all(i,j,ispin) = h_cc_all(i,j,ispin) + const*dcmplx(ht_hs_c(a,b,l)%h(ispin,i1,j1)*ene_scale,0.d0)
                    end do
                 else
                    h_cc_all(i*2-1,j*2-1,1) = h_cc_all(i*2-1,j*2-1,1) + const*ht_hs_c(a,b,l)%hls(1,i1,j1)*ene_scale
                    h_cc_all(i*2-1,j*2-0,1) = h_cc_all(i*2-1,j*2-0,1) + const*ht_hs_c(a,b,l)%hls(2,i1,j1)*ene_scale
                    h_cc_all(i*2-0,j*2-1,1) = h_cc_all(i*2-0,j*2-1,1) + const*ht_hs_c(a,b,l)%hls(3,i1,j1)*ene_scale
                    h_cc_all(i*2-0,j*2-0,1) = h_cc_all(i*2-0,j*2-0,1) + const*ht_hs_c(a,b,l)%hls(4,i1,j1)*ene_scale
                 end if
              end do
           end do
        end do
     end do
  end do



  do ispin=1,ls_spin
     do j=descCC%scol,descCC%ecol
        do i=1,descCC%nrow
           h_cc(i,j,ispin) = h_cc_all(i,j,ispin) 
        end do
     end do
  end do


  deallocate(h_cc_all) 



  allocate(s_cc_all(descCC%nrow,descCC%scol:descCC%ecol),stat=ier)
  s_cc_all(:,:) = dcmplx(0.d0,0.d0)

  do a=1,natom_ac_ct
     do b=1,natom_ac_ct

        if( a <= natom_ac_cl .and. b > natom_ac_ct-natom_ac_cr ) then
           cycle
        end if
        if( b <= natom_ac_cl .and. a > natom_ac_ct-natom_ac_cr ) then
           cycle
        end if

        do l=1,nl_ac_c
           if( i_over_c(a,b,l) == 1 ) then
              cycle
           end if

           co=dcos(qx_st*rac_c(2,l)+qy_st*rac_c(3,l))
           sn=dsin(qx_st*rac_c(2,l)+qy_st*rac_c(3,l))

           if( l /= 1 ) then
              const=dcmplx(co,sn)
           else
              const=dcmplx(co,sn)*0.5d0
           end if

           do i1=1,i_orb_c(a)
              do j1=1,i_orb_c(b)

                 i = i_orb_lr(a)+i1
                 j = i_orb_lr(b)+j1
                 if( i<descCC%srow .or. descCC%erow<i ) cycle 
                 if( j<descCC%scol .or. descCC%ecol<j ) cycle 

                 if( spin_cc /= 4 ) then
                    s_cc_all(i,j) = s_cc_all(i,j) + const*dcmplx(ht_hs_c(a,b,l)%s(i1,j1),0.d0)
                 else
                    s_cc_all(i*2-1,j*2-1)   = s_cc_all(i*2-1,j*2-1)   + const*dcmplx(ht_hs_c(a,b,l)%s(i1,j1),0.d0)
                    s_cc_all(i*2-0,j*2-0)   = s_cc_all(i*2-0,j*2-0)   + const*dcmplx(ht_hs_c(a,b,l)%s(i1,j1),0.d0)
                 end if
              end do
           end do
        end do
     end do
  end do



  do j=descCC%scol,descCC%ecol
     do i=1,descCC%nrow
        s_cc(i,j) = s_cc_all(i,j) 
     end do
  end do


  deallocate(s_cc_all) 


  allocate(work(descCC%nrow, descCC%scol:descCC%ecol), stat=ier)
  do ispin=1,ls_spin
     work(:,:) = h_cc(:,:,ispin)
     call MPI__ZTRANC_ASCOT( descCC, C1, h_cc(:,:,ispin), C1, work ) 
  end do
  work(:,:) = s_cc(:,:)
  call MPI__ZTRANC_ASCOT( descCC, C1, s_cc, C1, work ) 
  deallocate(work)

  do ispin=1,ls_spin
     hcc_t(:,:,ispin) = h_cc(:,:,ispin) 
  end do
  scc_t(:,:) = s_cc(:,:) 

  deallocate(i_orb_lr,h_cc,s_cc,stat=ier)
  if( ier /= 0 ) then
     write(6,*) 'error allocate: alo_ham_negf_type_c1'
     stop
  end if

  return
end subroutine set_ham_temp_ham_c

subroutine set_ham_temp_ham_l(descLL,qx_st,qy_st)
  use hamiltonian_sgf
  use hamiltonian_c
  use hamiltonian_temp
  use constant
  use scf_negf
  use ac_mpi_module
  use mod_mpi

  implicit none

  type(MPI_MatDesc), intent(in) :: descLL
  real(8), intent(in) :: qx_st,qy_st

  integer, allocatable :: i_orb_lr(:)
  complex(8), allocatable :: h_00l(:,:,:), h_01l(:,:,:), h_10l(:,:,:)
  complex(8), allocatable :: s_00l(:,:), s_01l(:,:), s_10l(:,:)
  complex(8), allocatable :: work(:,:)

  integer :: i1,j1,ier,a,b,l,ispin,ls_spin,i1_do
  complex(8) :: const
  real(8) :: co,sn


  integer :: i, j

  complex(8), allocatable :: h_00l_all(:,:,:), h_01l_all(:,:,:), h_10l_all(:,:,:)
  complex(8), allocatable :: s_00l_all(:,:), s_01l_all(:,:), s_10l_all(:,:)


  allocate(i_orb_lr(natom_ac_lt+1),stat=ier)
  if( ier /= 0 ) then
     write(6,*) 'error allocate: alo_ham_negf_type_c1'
     stop
  end if

  i_orb_lr(1)=0
  do i1=1, natom_ac_lt
     i_orb_lr(i1+1)=i_orb_lr(i1)+i_orb_l(i1)
  end do


  if( spin_ll /= 2 ) then
     ls_spin=1
  else
     ls_spin=2
  end if

  allocate(s_00l(descLL%nrow, descLL%scol:descLL%ecol), stat=ier)
  allocate(h_00l(descLL%nrow, descLL%scol:descLL%ecol,ls_spin), stat=ier)
  allocate(s_01l(descLL%nrow, descLL%scol:descLL%ecol), stat=ier)
  allocate(h_01l(descLL%nrow, descLL%scol:descLL%ecol,ls_spin), stat=ier)
  allocate(s_10l(descLL%nrow, descLL%scol:descLL%ecol), stat=ier)
  allocate(h_10l(descLL%nrow, descLL%scol:descLL%ecol,ls_spin), stat=ier)

  if( ier /= 0 ) then
     write(6,*) 'error allocate: alo_ham_negf_type_c1'
     stop
  end if

  do ispin=1,ls_spin
     h_00l(:,:,ispin) = dcmplx(0.d0,0.d0)
     h_10l(:,:,ispin) = dcmplx(0.d0,0.d0)
     h_01l(:,:,ispin) = dcmplx(0.d0,0.d0)
  end do
  s_00l(:,:) = dcmplx(0.d0,0.d0)
  s_10l(:,:) = dcmplx(0.d0,0.d0)
  s_01l(:,:) = dcmplx(0.d0,0.d0)


  allocate(s_00l_all(descLL%nrow,descLL%ncol),stat=ier)
  allocate(h_00l_all(descLL%nrow,descLL%ncol,ls_spin),stat=ier)

  do ispin=1,ls_spin
     h_00l_all(:,:,ispin) = dcmplx(0.d0,0.d0)
  end do
  s_00l_all(:,:) = dcmplx(0.d0,0.d0)

  do a=1,natom_ac_ll
     do b=1,natom_ac_ll

        do l=1,nl_ac_l
           if( i_over_l(a,b,l) == 1 ) then
              cycle
           end if

           co=dcos(qx_st*rac_l(2,l)+qy_st*rac_l(3,l))
           sn=dsin(qx_st*rac_l(2,l)+qy_st*rac_l(3,l))

           if( l /= 1 ) then
              const=dcmplx(co,sn)
           else
              const=dcmplx(co,sn)*0.5d0
           end if

           do i1=1,i_orb_l(a)
              do j1=1,i_orb_l(b)

                 i = i_orb_lr(a)+i1
                 j = i_orb_lr(b)+j1
                 if( i<descLL%srow .or. descLL%erow<i ) cycle 
                 if( j<descLL%scol .or. descLL%ecol<j ) cycle 

                 if( spin_ll < 4 ) then
                    do ispin=1,ls_spin
                       h_00l_all(i,j,ispin) = h_00l_all(i,j,ispin) + const*dcmplx(ht_hs_l(a,b,l)%h(ispin,i1,j1)*ene_scale,0.d0)
                    end do
                    s_00l_all(i,j) = s_00l_all(i,j) + const*dcmplx(ht_hs_l(a,b,l)%s(i1,j1),0.d0)
                 else
                    h_00l_all(i*2-1,j*2-1,1) = h_00l_all(i*2-1,j*2-1,1) + const*ht_hs_l(a,b,l)%hls(1,i1,j1)*ene_scale
                    h_00l_all(i*2-1,j*2-0,1) = h_00l_all(i*2-1,j*2-0,1) + const*ht_hs_l(a,b,l)%hls(2,i1,j1)*ene_scale
                    h_00l_all(i*2-0,j*2-1,1) = h_00l_all(i*2-0,j*2-1,1) + const*ht_hs_l(a,b,l)%hls(3,i1,j1)*ene_scale
                    h_00l_all(i*2-0,j*2-0,1) = h_00l_all(i*2-0,j*2-0,1) + const*ht_hs_l(a,b,l)%hls(4,i1,j1)*ene_scale
                    s_00l_all(i*2-1,j*2-1)   = s_00l_all(i*2-1,j*2-1)   + const*dcmplx(ht_hs_l(a,b,l)%s(i1,j1),0.d0)
                    s_00l_all(i*2-0,j*2-0)   = s_00l_all(i*2-0,j*2-0)   + const*dcmplx(ht_hs_l(a,b,l)%s(i1,j1),0.d0)
                 end if
              end do
           end do
        end do
     end do
  end do

  do ispin=1,ls_spin
     call MPI__Allgather_MatrixM_ASCOT( descLL, h_00l_all(:,:,ispin) ) 
  end do
  call MPI__Allgather_MatrixM_ASCOT( descLL, s_00l_all ) 

  do ispin=1,ls_spin
     do j=descLL%scol,descLL%ecol
        do i=1,descLL%nrow
           h_00l(i,j,ispin) = h_00l_all(i,j,ispin) 
        end do
     end do
  end do

  do j=descLL%scol,descLL%ecol
     do i=1,descLL%nrow
        s_00l(i,j) = s_00l_all(i,j) 
     end do
  end do

  deallocate(h_00l_all,s_00l_all) 


  allocate(s_01l_all(descLL%nrow,descLL%ncol),stat=ier)
  allocate(h_01l_all(descLL%nrow,descLL%ncol,ls_spin),stat=ier)

  do ispin=1,ls_spin
     h_01l_all(:,:,ispin) = dcmplx(0.d0,0.d0)
  end do
  s_01l_all(:,:) = dcmplx(0.d0,0.d0)

  i1_do=i_orb_lr(natom_ac_lt-natom_ac_ll+1)
  do a=1,natom_ac_ll
     do b=natom_ac_lt-natom_ac_ll+1,natom_ac_lt

        do l=1,nl_ac_l
           if( i_over_l(a,b,l) == 1 ) then
              cycle
           end if

           co=dcos(qx_st*rac_l(2,l)+qy_st*rac_l(3,l))
           sn=dsin(qx_st*rac_l(2,l)+qy_st*rac_l(3,l))

           if( l /= 1 ) then
              const=dcmplx(co,sn)
           else
              const=dcmplx(co,sn)*0.5d0
           end if

           do i1=1,i_orb_l(a)
              do j1=1,i_orb_l(b)

                 i = i_orb_lr(a)+i1
                 j = i_orb_lr(b)+j1 - i1_do
                 if( i<descLL%srow .or. descLL%erow<i ) cycle 
                 if( j<descLL%scol .or. descLL%ecol<j ) cycle 

                 if( spin_ll < 4 ) then
                    do ispin=1,ls_spin
                       h_01l_all(i,j,ispin) = h_01l_all(i,j,ispin) + const*dcmplx(ht_hs_l(a,b,l)%h(ispin,i1,j1)*ene_scale,0.d0)
                    end do
                    s_01l_all(i,j) = s_01l_all(i,j) + const*dcmplx(ht_hs_l(a,b,l)%s(i1,j1),0.d0)
                 else
                    h_01l_all(i*2-1,j*2-1,1) = h_01l_all(i*2-1,j*2-1,1) + const*ht_hs_l(a,b,l)%hls(1,i1,j1)*ene_scale
                    h_01l_all(i*2-1,j*2-0,1) = h_01l_all(i*2-1,j*2-0,1) + const*ht_hs_l(a,b,l)%hls(2,i1,j1)*ene_scale
                    h_01l_all(i*2-0,j*2-1,1) = h_01l_all(i*2-0,j*2-1,1) + const*ht_hs_l(a,b,l)%hls(3,i1,j1)*ene_scale
                    h_01l_all(i*2-0,j*2-0,1) = h_01l_all(i*2-0,j*2-0,1) + const*ht_hs_l(a,b,l)%hls(4,i1,j1)*ene_scale
                    s_01l_all(i*2-1,j*2-1)   = s_01l_all(i*2-1,j*2-1)   + const*dcmplx(ht_hs_l(a,b,l)%s(i1,j1),0.d0)
                    s_01l_all(i*2-0,j*2-0)   = s_01l_all(i*2-0,j*2-0)   + const*dcmplx(ht_hs_l(a,b,l)%s(i1,j1),0.d0)
                 end if
              end do
           end do
        end do
     end do
  end do

  do ispin=1,ls_spin
     call MPI__Allgather_MatrixM_ASCOT( descLL, h_01l_all(:,:,ispin) ) 
  end do
  call MPI__Allgather_MatrixM_ASCOT( descLL, s_01l_all ) 

  do ispin=1,ls_spin
     do j=descLL%scol,descLL%ecol
        do i=1,descLL%nrow
           h_01l(i,j,ispin) = h_01l_all(i,j,ispin) 
        end do
     end do
  end do

  do j=descLL%scol,descLL%ecol
     do i=1,descLL%nrow
        s_01l(i,j) = s_01l_all(i,j) 
     end do
  end do

  deallocate(h_01l_all,s_01l_all) 


  allocate(s_10l_all(descLL%nrow,descLL%ncol),stat=ier)
  allocate(h_10l_all(descLL%nrow,descLL%ncol,ls_spin),stat=ier)

  do ispin=1,ls_spin
     h_10l_all(:,:,ispin) = dcmplx(0.d0,0.d0)
  end do
  s_10l_all(:,:) = dcmplx(0.d0,0.d0)

  i1_do=i_orb_lr(natom_ac_lt-natom_ac_ll+1)
  do a=natom_ac_lt-natom_ac_ll+1,natom_ac_lt
     do b=1,natom_ac_ll

        do l=1,nl_ac_l
           if( i_over_l(a,b,l) == 1 ) then
              cycle
           end if

           co=dcos(qx_st*rac_l(2,l)+qy_st*rac_l(3,l))
           sn=dsin(qx_st*rac_l(2,l)+qy_st*rac_l(3,l))

           if( l /= 1 ) then
              const=dcmplx(co,sn)
           else
              const=dcmplx(co,sn)*0.5d0
           end if

           do i1=1,i_orb_l(a)
              do j1=1,i_orb_l(b)

                 i = i_orb_lr(a)+i1 - i1_do
                 j = i_orb_lr(b)+j1
                 if( i<descLL%srow .or. descLL%erow<i ) cycle 
                 if( j<descLL%scol .or. descLL%ecol<j ) cycle 

                 if( spin_ll < 4 ) then
                    do ispin=1,ls_spin
                       h_10l_all(i,j,ispin) = h_10l_all(i,j,ispin) + const*dcmplx(ht_hs_l(a,b,l)%h(ispin,i1,j1)*ene_scale,0.d0)
                    end do
                    s_10l_all(i,j) = s_10l_all(i,j) + const*dcmplx(ht_hs_l(a,b,l)%s(i1,j1),0.d0)
                 else
                    h_10l_all(i*2-1,j*2-1,1) = h_10l_all(i*2-1,j*2-1,1) + const*ht_hs_l(a,b,l)%hls(1,i1,j1)*ene_scale
                    h_10l_all(i*2-1,j*2-0,1) = h_10l_all(i*2-1,j*2-0,1) + const*ht_hs_l(a,b,l)%hls(2,i1,j1)*ene_scale
                    h_10l_all(i*2-0,j*2-1,1) = h_10l_all(i*2-0,j*2-1,1) + const*ht_hs_l(a,b,l)%hls(3,i1,j1)*ene_scale
                    h_10l_all(i*2-0,j*2-0,1) = h_10l_all(i*2-0,j*2-0,1) + const*ht_hs_l(a,b,l)%hls(4,i1,j1)*ene_scale
                    s_10l_all(i*2-1,j*2-1)   = s_10l_all(i*2-1,j*2-1)   + const*dcmplx(ht_hs_l(a,b,l)%s(i1,j1),0.d0)
                    s_10l_all(i*2-0,j*2-0)   = s_10l_all(i*2-0,j*2-0)   + const*dcmplx(ht_hs_l(a,b,l)%s(i1,j1),0.d0)
                 end if
              end do
           end do
        end do
     end do
  end do

  do ispin=1,ls_spin
     call MPI__Allgather_MatrixM_ASCOT( descLL, h_10l_all(:,:,ispin) ) 
  end do
  call MPI__Allgather_MatrixM_ASCOT( descLL, s_10l_all ) 

  do ispin=1,ls_spin
     do j=descLL%scol,descLL%ecol
        do i=1,descLL%nrow
           h_10l(i,j,ispin) = h_10l_all(i,j,ispin) 
        end do
     end do
  end do

  do j=descLL%scol,descLL%ecol
     do i=1,descLL%nrow
        s_10l(i,j) = s_10l_all(i,j) 
     end do
  end do

  deallocate(h_10l_all,s_10l_all) 


  allocate(work(descLL%nrow, descLL%scol:descLL%ecol), stat=ier)
  do ispin=1,ls_spin
     work(:,:) = h_00l(:,:,ispin)
     call MPI__ZTRANC_ASCOT( descLL, C1, h_00l(:,:,ispin), C1, work ) 
     call MPI__ZTRANC_ASCOT( descLL, C1, h_10l(:,:,ispin), C1, h_01l(:,:,ispin) ) 
     call MPI__ZTRANC_ASCOT( descLL, C0, h_01l(:,:,ispin), C1, h_10l(:,:,ispin) ) 
  end do
  work(:,:) = s_00l(:,:)
  call MPI__ZTRANC_ASCOT( descLL, C1, s_00l, C1, work ) 
  call MPI__ZTRANC_ASCOT( descLL, C1, s_10l, C1, s_01l ) 
  call MPI__ZTRANC_ASCOT( descLL, C0, s_01l, C1, s_10l ) 
  deallocate(work)

  do ispin=1,ls_spin
     h00_l_t(:,:,ispin) = h_00l(:,:,ispin) 
     h01_l_t(:,:,ispin) = h_01l(:,:,ispin) 
     h10_l_t(:,:,ispin) = h_10l(:,:,ispin) 
  end do
  s00_l_t(:,:) = s_00l(:,:) 
  s01_l_t(:,:) = s_01l(:,:) 
  s10_l_t(:,:) = s_10l(:,:) 

  deallocate(i_orb_lr,h_00l,s_00l,h_01l,s_01l,h_10l,s_10l,stat=ier)
  if( ier /= 0 ) then
     write(6,*) 'error allocate: alo_ham_negf_type_c1'
     stop
  end if

  return
end subroutine set_ham_temp_ham_l

subroutine set_ham_temp_ham_r(descRR,qx_st,qy_st)
  use hamiltonian_sgf
  use hamiltonian_c
  use hamiltonian_temp
  use constant
  use scf_negf
  use ac_mpi_module
  use mod_mpi

  implicit none

  type(MPI_MatDesc), intent(in) :: descRR
  real(8), intent(in) :: qx_st,qy_st

  integer, allocatable :: i_orb_lr(:)
  complex(8), allocatable :: h_00r(:,:,:), h_01r(:,:,:), h_10r(:,:,:)
  complex(8), allocatable :: s_00r(:,:), s_01r(:,:), s_10r(:,:)
  complex(8), allocatable :: h_00l(:,:,:), h_01l(:,:,:), h_10l(:,:,:)
  complex(8), allocatable :: s_00l(:,:), s_01l(:,:), s_10l(:,:)
  complex(8), allocatable :: work(:,:)

  integer :: i1,j1,ier,a,b,l,ispin,ls_spin,i1_do
  complex(8) :: const
  real(8) :: co,sn

  integer :: i, j

  complex(8), allocatable :: h_00r_all(:,:,:), h_01r_all(:,:,:), h_10r_all(:,:,:)
  complex(8), allocatable :: s_00r_all(:,:), s_01r_all(:,:), s_10r_all(:,:)


  allocate(i_orb_lr(natom_ac_rt+1),stat=ier)
  if( ier /= 0 ) then
     write(6,*) 'error allocate: alo_ham_negf_type_c1'
     stop
  end if

  i_orb_lr(1)=0
  do i1=1, natom_ac_rt
     i_orb_lr(i1+1)=i_orb_lr(i1)+i_orb_r(i1)
  end do


  if( spin_rr /= 2 ) then
     ls_spin=1
  else
     ls_spin=2
  end if

  allocate(s_00r(descRR%nrow, descRR%scol:descRR%ecol), stat=ier)
  allocate(s_01r(descRR%nrow, descRR%scol:descRR%ecol), stat=ier)
  allocate(s_10r(descRR%nrow, descRR%scol:descRR%ecol), stat=ier)
  allocate(h_00r(descRR%nrow, descRR%scol:descRR%ecol,ls_spin), stat=ier)
  allocate(h_01r(descRR%nrow, descRR%scol:descRR%ecol,ls_spin), stat=ier)
  allocate(h_10r(descRR%nrow, descRR%scol:descRR%ecol,ls_spin), stat=ier)

  if( ier /= 0 ) then
     write(6,*) 'error allocate: alo_ham_negf_type_c1'
     stop
  end if

  do ispin=1,ls_spin
     h_00r(:,:,ispin) = dcmplx(0.0d0,0.d0)
     h_01r(:,:,ispin) = dcmplx(0.0d0,0.d0)
     h_10r(:,:,ispin) = dcmplx(0.0d0,0.d0)
  end do
  s_00r(:,:) = dcmplx(0.0d0,0.d0)
  s_01r(:,:) = dcmplx(0.0d0,0.d0)
  s_10r(:,:) = dcmplx(0.0d0,0.d0)


  allocate(s_00r_all(descRR%nrow,descRR%ncol),stat=ier)
  allocate(h_00r_all(descRR%nrow,descRR%ncol,ls_spin),stat=ier)

  do ispin=1,ls_spin
     h_00r_all(:,:,ispin) = dcmplx(0.d0,0.d0)
  end do
  s_00r_all(:,:) = dcmplx(0.d0,0.d0)

  i1_do=i_orb_lr(natom_ac_rt-natom_ac_rr+1)

  do a=natom_ac_rt-natom_ac_rr+1,natom_ac_rt
     do b=natom_ac_rt-natom_ac_rr+1,natom_ac_rt

        do l=1,nl_ac_r
           if( i_over_r(a,b,l) == 1 ) then
              cycle
           end if

           co=dcos(qx_st*rac_r(2,l)+qy_st*rac_r(3,l))
           sn=dsin(qx_st*rac_r(2,l)+qy_st*rac_r(3,l))

           if( l /= 1 ) then
              const=dcmplx(co,sn)
           else
              const=dcmplx(co,sn)*0.5d0
           end if

           do i1=1,i_orb_r(a)
              do j1=1,i_orb_r(b)

                 i = i_orb_lr(a)+i1 - i1_do
                 j = i_orb_lr(b)+j1 - i1_do
                 if( i<descRR%srow .or. descRR%erow<i ) cycle 
                 if( j<descRR%scol .or. descRR%ecol<j ) cycle 

                 if( spin_ll < 4 ) then
                    do ispin=1,ls_spin
                       h_00r_all(i,j,ispin) = h_00r_all(i,j,ispin) + const*dcmplx(ht_hs_r(a,b,l)%h(ispin,i1,j1)*ene_scale,0.d0)
                    end do
                    s_00r_all(i,j) = s_00r_all(i,j) + const*dcmplx(ht_hs_r(a,b,l)%s(i1,j1),0.d0)
                 else
                    h_00r_all(i*2-1,j*2-1,1) = h_00r_all(i*2-1,j*2-1,1) + const*ht_hs_r(a,b,l)%hls(1,i1,j1)*ene_scale
                    h_00r_all(i*2-1,j*2-0,1) = h_00r_all(i*2-1,j*2-0,1) + const*ht_hs_r(a,b,l)%hls(2,i1,j1)*ene_scale
                    h_00r_all(i*2-0,j*2-1,1) = h_00r_all(i*2-0,j*2-1,1) + const*ht_hs_r(a,b,l)%hls(3,i1,j1)*ene_scale
                    h_00r_all(i*2-0,j*2-0,1) = h_00r_all(i*2-0,j*2-0,1) + const*ht_hs_r(a,b,l)%hls(4,i1,j1)*ene_scale
                    s_00r_all(i*2-1,j*2-1)   = s_00r_all(i*2-1,j*2-1)   + const*dcmplx(ht_hs_r(a,b,l)%s(i1,j1),0.d0)
                    s_00r_all(i*2-0,j*2-0)   = s_00r_all(i*2-0,j*2-0)   + const*dcmplx(ht_hs_r(a,b,l)%s(i1,j1),0.d0)
                 end if
              end do
           end do
        end do
     end do
  end do

  do ispin=1,ls_spin
     call MPI__Allgather_MatrixM_ASCOT( descRR, h_00r_all(:,:,ispin) ) 
  end do
  call MPI__Allgather_MatrixM_ASCOT( descRR, s_00r_all ) 

  do ispin=1,ls_spin
     do j=descRR%scol,descRR%ecol
        do i=1,descRR%nrow
           h_00r(i,j,ispin) = h_00r_all(i,j,ispin) 
        end do
     end do
  end do

  do j=descRR%scol,descRR%ecol
     do i=1,descRR%nrow
        s_00r(i,j) = s_00r_all(i,j) 
     end do
  end do

  deallocate(h_00r_all,s_00r_all) 


  allocate(s_01r_all(descRR%nrow,descRR%ncol),stat=ier)
  allocate(h_01r_all(descRR%nrow,descRR%ncol,ls_spin),stat=ier)

  do ispin=1,ls_spin
     h_01r_all(:,:,ispin) = dcmplx(0.d0,0.d0)
  end do
  s_01r_all(:,:) = dcmplx(0.d0,0.d0)

  i1_do=i_orb_lr(natom_ac_rt-natom_ac_rr+1)
  do a=natom_ac_rt-natom_ac_rr+1,natom_ac_rt
     do b=1,natom_ac_rr

        do l=1,nl_ac_r
           if( i_over_r(a,b,l) == 1 ) then
              cycle
           end if

           co=dcos(qx_st*rac_r(2,l)+qy_st*rac_r(3,l))
           sn=dsin(qx_st*rac_r(2,l)+qy_st*rac_r(3,l))

           if( l /= 1 ) then
              const=dcmplx(co,sn)
           else
              const=dcmplx(co,sn)*0.5d0
           end if

           do i1=1,i_orb_r(a)
              do j1=1,i_orb_r(b)

                 i = i_orb_lr(a)+i1 - i1_do
                 j = i_orb_lr(b)+j1
                 if( i<descRR%srow .or. descRR%erow<i ) cycle 
                 if( j<descRR%scol .or. descRR%ecol<j ) cycle 

                 if( spin_ll < 4 ) then
                    do ispin=1,ls_spin
                       h_01r_all(i,j,ispin) = h_01r_all(i,j,ispin) + const*dcmplx(ht_hs_r(a,b,l)%h(ispin,i1,j1)*ene_scale,0.d0)
                    end do
                    s_01r_all(i,j) = s_01r_all(i,j) + const*dcmplx(ht_hs_r(a,b,l)%s(i1,j1),0.d0)
                 else
                    h_01r_all(i*2-1,j*2-1,1) = h_01r_all(i*2-1,j*2-1,1) + const*ht_hs_r(a,b,l)%hls(1,i1,j1)*ene_scale
                    h_01r_all(i*2-1,j*2-0,1) = h_01r_all(i*2-1,j*2-0,1) + const*ht_hs_r(a,b,l)%hls(2,i1,j1)*ene_scale
                    h_01r_all(i*2-0,j*2-1,1) = h_01r_all(i*2-0,j*2-1,1) + const*ht_hs_r(a,b,l)%hls(3,i1,j1)*ene_scale
                    h_01r_all(i*2-0,j*2-0,1) = h_01r_all(i*2-0,j*2-0,1) + const*ht_hs_r(a,b,l)%hls(4,i1,j1)*ene_scale
                    s_01r_all(i*2-1,j*2-1)   = s_01r_all(i*2-1,j*2-1)   + const*dcmplx(ht_hs_r(a,b,l)%s(i1,j1),0.d0)
                    s_01r_all(i*2-0,j*2-0)   = s_01r_all(i*2-0,j*2-0)   + const*dcmplx(ht_hs_r(a,b,l)%s(i1,j1),0.d0)
                 end if
              end do
           end do
        end do
     end do
  end do

  do ispin=1,ls_spin
     call MPI__Allgather_MatrixM_ASCOT( descRR, h_01r_all(:,:,ispin) ) 
  end do
  call MPI__Allgather_MatrixM_ASCOT( descRR, s_01r_all ) 

  do ispin=1,ls_spin
     do j=descRR%scol,descRR%ecol
        do i=1,descRR%nrow
           h_01r(i,j,ispin) = h_01r_all(i,j,ispin) 
        end do
     end do
  end do

  do j=descRR%scol,descRR%ecol
     do i=1,descRR%nrow
        s_01r(i,j) = s_01r_all(i,j) 
     end do
  end do

  deallocate(h_01r_all,s_01r_all) 


  allocate(s_10r_all(descRR%nrow,descRR%ncol),stat=ier)
  allocate(h_10r_all(descRR%nrow,descRR%ncol,ls_spin),stat=ier)

  do ispin=1,ls_spin
     h_10r_all(:,:,ispin) = dcmplx(0.d0,0.d0)
  end do
  s_10r_all(:,:) = dcmplx(0.d0,0.d0)

  i1_do=i_orb_lr(natom_ac_rt-natom_ac_rr+1)

  do a=1,natom_ac_rr
     do b=natom_ac_rt-natom_ac_rr+1,natom_ac_rt

        do l=1,nl_ac_r
           if( i_over_r(a,b,l) == 1 ) then
              cycle
           end if

           co=dcos(qx_st*rac_r(2,l)+qy_st*rac_r(3,l))
           sn=dsin(qx_st*rac_r(2,l)+qy_st*rac_r(3,l))

           if( l /= 1 ) then
              const=dcmplx(co,sn)
           else
              const=dcmplx(co,sn)*0.5d0
           end if

           do i1=1,i_orb_r(a)
              do j1=1,i_orb_r(b)

                 i = i_orb_lr(a)+i1
                 j = i_orb_lr(b)+j1 - i1_do
                 if( i<descRR%srow .or. descRR%erow<i ) cycle 
                 if( j<descRR%scol .or. descRR%ecol<j ) cycle 

                 if( spin_ll < 4 ) then
                    do ispin=1,ls_spin
                       h_10r_all(i,j,ispin) = h_10r_all(i,j,ispin) + const*dcmplx(ht_hs_r(a,b,l)%h(ispin,i1,j1)*ene_scale,0.d0)
                    end do
                    s_10r_all(i,j) = s_10r_all(i,j) + const*dcmplx(ht_hs_r(a,b,l)%s(i1,j1),0.d0)
                 else
                    h_10r_all(i*2-1,j*2-1,1) = h_10r_all(i*2-1,j*2-1,1) + const*ht_hs_r(a,b,l)%hls(1,i1,j1)*ene_scale
                    h_10r_all(i*2-1,j*2-0,1) = h_10r_all(i*2-1,j*2-0,1) + const*ht_hs_r(a,b,l)%hls(2,i1,j1)*ene_scale
                    h_10r_all(i*2-0,j*2-1,1) = h_10r_all(i*2-0,j*2-1,1) + const*ht_hs_r(a,b,l)%hls(3,i1,j1)*ene_scale
                    h_10r_all(i*2-0,j*2-0,1) = h_10r_all(i*2-0,j*2-0,1) + const*ht_hs_r(a,b,l)%hls(4,i1,j1)*ene_scale
                    s_10r_all(i*2-1,j*2-1)   = s_10r_all(i*2-1,j*2-1)   + const*dcmplx(ht_hs_r(a,b,l)%s(i1,j1),0.d0)
                    s_10r_all(i*2-0,j*2-0)   = s_10r_all(i*2-0,j*2-0)   + const*dcmplx(ht_hs_r(a,b,l)%s(i1,j1),0.d0)
                 end if
              end do
           end do
        end do
     end do
  end do

  do ispin=1,ls_spin
     call MPI__Allgather_MatrixM_ASCOT( descRR, h_10r_all(:,:,ispin) ) 
  end do
  call MPI__Allgather_MatrixM_ASCOT( descRR, s_10r_all ) 

  do ispin=1,ls_spin
     do j=descRR%scol,descRR%ecol
        do i=1,descRR%nrow
           h_10r(i,j,ispin) = h_10r_all(i,j,ispin) 
        end do
     end do
  end do

  do j=descRR%scol,descRR%ecol
     do i=1,descRR%nrow
        s_10r(i,j) = s_10r_all(i,j) 
     end do
  end do

  deallocate(h_10r_all,s_10r_all) 


  allocate(work(descRR%nrow, descRR%scol:descRR%ecol), stat=ier)
  do ispin=1,ls_spin
     work(:,:) = h_00r(:,:,ispin)
     call MPI__ZTRANC_ASCOT( descRR, C1, h_00r(:,:,ispin), C1, work ) 
     call MPI__ZTRANC_ASCOT( descRR, C1, h_10r(:,:,ispin), C1, h_01r(:,:,ispin) ) 
     call MPI__ZTRANC_ASCOT( descRR, C0, h_01r(:,:,ispin), C1, h_10r(:,:,ispin) ) 
  end do
  work(:,:) = s_00r(:,:)
  call MPI__ZTRANC_ASCOT( descRR, C1, s_00r, C1, work ) 
  call MPI__ZTRANC_ASCOT( descRR, C1, s_10r, C1, s_01r ) 
  call MPI__ZTRANC_ASCOT( descRR, C0, s_01r, C1, s_10r ) 
  deallocate(work)

  do ispin=1,ls_spin
     h00_r_t(:,:,ispin) = h_00r(:,:,ispin) 
     h01_r_t(:,:,ispin) = h_01r(:,:,ispin) 
     h10_r_t(:,:,ispin) = h_10r(:,:,ispin) 
  end do
  s00_r_t(:,:) = s_00r(:,:) 
  s01_r_t(:,:) = s_01r(:,:) 
  s10_r_t(:,:) = s_10r(:,:) 

  deallocate(i_orb_lr,h_00r,s_00r,h_01r,s_01r,h_10r,s_10r,stat=ier) 
  if( ier /= 0 ) then
     write(6,*) 'error deallocate: alo_ham_negf_type_r1'
     stop
  end if

  return
end subroutine set_ham_temp_ham_r
