! @@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@ !
! @@                                                                @@ !
! @@       PROGRAM  ASCOT 2014.440 (ver.4.53)                       @@ !
! @@     "Abinitio Simulation Code for Quantum Transport"           @@ !
! @@                                                                @@ !
! @@                                                                @@ !
! @@  AUTHOR(S): Hisashi KONDO (Univ. Tokyo)                        @@ !
! @@                                                09/May/2014     @@ !
! @@                                                                @@ !
! @@  Contact address: Phase System Consortium                      @@ !
! @@                                                                @@ !
! @@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@ !

subroutine read_rtbh_parameter

  use condition_ini
  use rtbh_parameter

  implicit none
  integer :: i_do

  open(unit=19,file=file_parameter_tb_par,status='old')

  read(19,*) num_atom_kind_ini
  call alo_input_condition_1
  do i_do=1,num_atom_kind_ini
     read(19,*) atom_sign_ini(i_do),atom_num_ini(i_do),atom_mass_ini(i_do)    &
          ,atom_electron_ini(i_do),atom_orbital_ini(i_do)
  end do

  call alo_rtbh_parameter(num_atom_kind_ini)

  do i_do=1,num_atom_kind_ini
     read(19,*) 
     read(19,*) atomh_parameter(i_do)
     read(19,*) h_s(i_do)
     read(19,*) h_p(i_do)
     read(19,*) h_d(i_do)
     read(19,*) v_ss(i_do)
     read(19,*) v_ps(i_do)
     read(19,*) v_pp(i_do)
     read(19,*) v_ds(i_do)
     read(19,*) v_dp(i_do)
     read(19,*) v_dd(i_do)
     read(19,*) u_ss(i_do)
     read(19,*) u_ps(i_do)
     read(19,*) u_pp(i_do)
     read(19,*) u_ds(i_do)
     read(19,*) u_dp(i_do)
     read(19,*) u_dd(i_do)
     read(19,*) r_ss(i_do)
     read(19,*) r_ps(i_do)
     read(19,*) r_pp(i_do)
     read(19,*) r_ds(i_do)
     read(19,*) r_dp(i_do)
     read(19,*) r_dd(i_do)
  end do
  read(19,*)
  read(19,*) r1
  read(19,*) r2
  read(19,*) a
  read(19,*) b
  close(19)

  return
end subroutine read_rtbh_parameter

subroutine read_gsp_parameter

  use condition_ini
  use gsp_parameter

  implicit none
  integer :: i_do

  open(unit=19,file=file_parameter_tb_par,status='old')

  read(19,*) num_atom_kind_ini
  call alo_input_condition_1
  do i_do=1,num_atom_kind_ini
     read(19,*) atom_sign_ini(i_do),atom_num_ini(i_do),atom_mass_ini(i_do)    &
          ,atom_electron_ini(i_do),atom_orbital_ini(i_do)
  end do

  call alo_gsp_parameter(num_atom_kind_ini)

  do i_do=1,num_atom_kind_ini*num_atom_kind_ini
     read(19,*) 
     read(19,*) atom_parameter(i_do,1),atom_parameter(i_do,2)
     read(19,*) cutoff_r(i_do)
     read(19,*) r0(i_do)
     read(19,*) n(i_do)
     read(19,*) e_0(i_do)
     read(19,*) hs(i_do)
     read(19,*) hp(i_do)
     read(19,*) hd_t2g(i_do)
     read(19,*) hd_eg(i_do)
     read(19,*)
     read(19,*) h_sss(i_do)
     read(19,*) h_sps(i_do)
     read(19,*) h_pps(i_do)
     read(19,*) h_ppp(i_do)
     read(19,*) h_sds(i_do)
     read(19,*) h_pds(i_do)
     read(19,*) h_pdp(i_do)
     read(19,*) h_dds(i_do)
     read(19,*) h_ddp(i_do)
     read(19,*) h_ddd(i_do)
     read(19,*)
     read(19,*) nc_sss(i_do)
     read(19,*) nc_sps(i_do)
     read(19,*) nc_pps(i_do)
     read(19,*) nc_ppp(i_do)
     read(19,*) nc_sds(i_do)
     read(19,*) nc_pds(i_do)
     read(19,*) nc_pdp(i_do)
     read(19,*) nc_dds(i_do)
     read(19,*) nc_ddp(i_do)
     read(19,*) nc_ddd(i_do)
     read(19,*)
     read(19,*) rc_sss(i_do)
     read(19,*) rc_sps(i_do)
     read(19,*) rc_pps(i_do)
     read(19,*) rc_ppp(i_do)
     read(19,*) rc_sds(i_do)
     read(19,*) rc_pds(i_do)
     read(19,*) rc_pdp(i_do)
     read(19,*) rc_dds(i_do)
     read(19,*) rc_ddp(i_do)
     read(19,*) rc_ddd(i_do)
     read(19,*)
     read(19,*) m(i_do)
     read(19,*) mc(i_do)
     read(19,*) dc(i_do)
     read(19,*) c1(i_do)
     read(19,*) c2(i_do)
     read(19,*) c3(i_do)
     read(19,*) c4(i_do)
     read(19,*)
     read(19,*) phi0(i_do)
     read(19,*) d0(i_do)
     read(19,*)
     read(19,*) r1(i_do)
     read(19,*) tsc0(i_do)
     read(19,*) tsc1(i_do)
     read(19,*) tsc2(i_do)
     read(19,*) tsc3(i_do)
     read(19,*)
     read(19,*) d1(i_do)
     read(19,*) tpc0(i_do)
     read(19,*) tpc1(i_do)
     read(19,*) tpc2(i_do)
     read(19,*) tpc3(i_do)
  end do
  close(19)

  return
end subroutine read_gsp_parameter

subroutine set_pair_ini(atom_parameter)

  use condition_ini

  implicit none
  character(4), intent(in) ::                                                    &
       atom_parameter(num_atom_kind_ini*num_atom_kind_ini,2)
  integer :: i1_do,i2_do,i3_do

  do i1_do=1,num_atom_l
     do i2_do=1,num_atom_l
        do i3_do=1,num_atom_kind_ini*num_atom_kind_ini
           if( atom_kind_l(i1_do) == atom_parameter(i3_do,1)                      &
                .and. atom_kind_l(i2_do) == atom_parameter(i3_do,2) ) then
              pair_num_l(i1_do,i2_do)=i3_do
              go to 10
           end if
        end do
        write(6,*) 'error - set_pair_ini (ll)'
        stop
10      continue
     end do
  end do

  do i1_do=1,num_atom_r
     do i2_do=1,num_atom_r
        do i3_do=1,num_atom_kind_ini*num_atom_kind_ini
           if( atom_kind_r(i1_do) == atom_parameter(i3_do,1)                      &
                .and. atom_kind_r(i2_do) == atom_parameter(i3_do,2) ) then
              pair_num_r(i1_do,i2_do)=i3_do
              go to 20
           end if
        end do
        write(6,*) 'error - set_pair_ini (rr)'
        stop
20      continue
     end do
  end do

  do i1_do=1,num_atom_c
     do i2_do=1,num_atom_l
        do i3_do=1,num_atom_kind_ini*num_atom_kind_ini
           if( atom_kind_c(i1_do) == atom_parameter(i3_do,1)                      &
                .and. atom_kind_l(i2_do) == atom_parameter(i3_do,2) ) then
              pair_num_cl(i1_do,i2_do)=i3_do
              go to 30
           end if
        end do
        write(6,*) 'error - set_pair_ini (ml)'
        stop
30      continue
     end do
  end do

  do i1_do=1,num_atom_c
     do i2_do=1,num_atom_c
        do i3_do=1,num_atom_kind_ini*num_atom_kind_ini
           if( atom_kind_c(i1_do) == atom_parameter(i3_do,1)                      &
                .and. atom_kind_c(i2_do) == atom_parameter(i3_do,2) ) then
              pair_num_cc(i1_do,i2_do)=i3_do
              go to 40
           end if
        end do
        write(6,*) 'error - set_pair_ini (mm)'
        stop
40      continue
     end do
  end do

  do i1_do=1,num_atom_c
     do i2_do=1,num_atom_r
        do i3_do=1,num_atom_kind_ini*num_atom_kind_ini
           if( atom_kind_c(i1_do) == atom_parameter(i3_do,1)                      &
                .and. atom_kind_r(i2_do) == atom_parameter(i3_do,2) ) then
              pair_num_cr(i1_do,i2_do)=i3_do
              go to 50
           end if
        end do
        write(6,*) 'error - set_pair_ini (mr)'
        stop
50      continue
     end do
  end do

  return
end subroutine set_pair_ini
