! @@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@ !
! @@                                                                @@ !
! @@       PROGRAM  ASCOT 2014.440 (ver.4.53)                       @@ !
! @@     "Abinitio Simulation Code for Quantum Transport"           @@ !
! @@                                                                @@ !
! @@                                                                @@ !
! @@  AUTHOR(S): Hisashi KONDO (Univ. Tokyo)                        @@ !
! @@                                                09/May/2014     @@ !
! @@                                                                @@ !
! @@  Contact address: Phase System Consortium                      @@ !
! @@                                                                @@ !
! @@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@ !

subroutine read_input_tb_cordinate

  use condition_ini
  use scf_negf
  use hamiltonian_c
  use mod_mpi

  implicit none
  real(8) :: ra_temp(3)
  integer :: i_do,j_do,jr_do,i_temp
  integer :: i_r_l,i_r_c,i_r_r

  integer :: i_check,j_check
  character(256) :: buf
  character(50) :: dummy1,dummy2
  character(50) :: tag1,tag2,tag3

  open(unit=16,file=file_tempout,position='append')
  write(16,*)
  write(16,*)
  write(16,*) '********************** **************** **********************'
  write(16,*) '*         input  condition   ! tb- atomic stracture !        *'
  write(16,*) '********************** **************** **********************'
  write(16,*)
  close(16)


  v_l=0.d0
  v_c=0.d0
  v_r=0.d0
  open(unit=19,file=file_parameter_co,status='old')
  do 
     read(19,'(a)',end=100) buf
     if( buf == '' ) then
        cycle
     end if
     read(buf,*) tag1
     if( tag1(1:1) == '#' ) then
        cycle
     end if
     select case(tag1)
     case('tb_bias{')
        do 
           read(19,'(a)',end=100) buf
           if( buf == '' ) then
              cycle
           end if
           read(buf,*) tag2
           if( tag2(1:1) == '#' ) then
              cycle
           end if
           select case(tag2)
           case('left_region')
              read(buf,*) dummy1,dummy2,v_l
           case('junc_region','central_region')
              read(buf,*) dummy1,dummy2,v_c
           case('right_region')
              read(buf,*) dummy1,dummy2,v_r
           case('}tb_bias')
              go to 100
           end select
        end do
     end select
  end do
100 continue
  close(19)

  m_num_block_l=1
  m_num_block_m=1
  m_num_block_r=1
  open(unit=19,file=file_parameter_co,status='old')
  do 
     read(19,'(a)',end=110) buf
     if( buf == '' ) then
        cycle
     end if
     read(buf,*) tag1
     if( tag1(1:1) == '#' ) then
        cycle
     end if
     select case(tag1)
     case('tb_buffer_size{')
        do 
           read(19,'(a)',end=110) buf
           if( buf == '' ) then
              cycle
           end if
           read(buf,*) tag2
           if( tag2(1:1) == '#' ) then
              cycle
           end if
           select case(tag2)
           case('left_region')
              read(buf,*) dummy1,dummy2,m_num_block_l
           case('junc_region','central_region')
              read(buf,*) dummy1,dummy2,m_num_block_m
           case('right_region')
              read(buf,*) dummy1,dummy2,m_num_block_r
           case('}tb_buffer_size')
              go to 110
           end select
        end do
     end select
  end do
110 continue
  close(19)

  r_dis_l=0.d0
  r_dis_r=0.d0
  i_check=0
  j_check=0
  open(unit=19,file=file_parameter_co,status='old')
  do 
     read(19,'(a)',end=120) buf
     if( buf == '' ) then
        cycle
     end if
     read(buf,*) tag1
     if( tag1(1:1) == '#' ) then
        cycle
     end if
     select case(tag1)
     case('tb_distance{')
        do 
           read(19,'(a)',end=120) buf
           if( buf == '' ) then
              cycle
           end if
           read(buf,*) tag2
           if( tag2(1:1) == '#' ) then
              cycle
           end if
           select case(tag2)
           case('between_l_c')
              read(buf,*) dummy1,dummy2,r_dis_l
              i_check=1
           case('between_c_r')
              read(buf,*) dummy1,dummy2,r_dis_r
              j_check=1
           case('}tb_distance')
              go to 120
           end select
        end do
     end select
  end do
120 continue
  close(19)
  if( i_check == 0 ) then
     open(unit=17,file=file_tempout,position='append')
     write(17,*) '??? broken ??? //distance/between_l_c// => def'
     close(17)
  end if
  if( j_check == 0 ) then
     open(unit=17,file=file_tempout,position='append')
     write(17,*) '??? broken ??? //distance/between_c_r// => def'
     close(17)
  end if


  num_atom_c=0
  i_r_c=2
  i_check=0
  open(unit=19,file=file_parameter_co,status='old')
  do 
     read(19,'(a)',end=130) buf
     if( buf == '' ) then
        cycle
     end if
     read(buf,*) tag1
     if( tag1(1:1) == '#' ) then
        cycle
     end if
     select case(tag1)
     case('tb_junc_region{','tb_central_region{')
        do 
           read(19,'(a)',end=130) buf
           if( buf == '' ) then
              cycle
           end if
           read(buf,*) tag2
           if( tag2(1:1) == '#' ) then
              cycle
           end if
           select case(tag2)
           case('atom_number')
              read(buf,*) dummy1,dummy2,num_atom_c
           case('coordinate_system')
              read(buf,*) dummy1,dummy2,tag3
              if( tag3 == 'cartesian' ) then
                 i_r_c=0
              end if
              if( tag3 == 'pucv' ) then
                 i_r_c=1
              end if
           case('unit_vector{')
              do
                 read(19,'(a)',end=130) buf
                 if( buf == '' ) then
                    cycle
                 end if
                 read(buf,*) tag2
                 if( tag2(1:1) == '#' ) then
                    cycle
                 end if
                 if( tag2 == '}unit_vector' ) then
                    exit
                 end if
                 i_check=i_check+1
                 i_do=i_check
                 read(buf,*) unit_block_c(i_check,1),unit_block_c(i_check,2)  &
                      ,unit_block_c(i_check,3)
                 if( i_do == 1 ) then
                    if( unit_block_c(i_do,3) /= 0.d0 ) then
                       open(unit=17,file=file_tempout,position='append')
                       write(17,*) 'error unit (m)::: ',unit_block_c(i_do,3)
                       close(17)
                       stop
                    end if
                 end if
                 if( i_do == 2 ) then
                    if( unit_block_c(i_do,3) /= 0.d0 ) then
                       open(unit=17,file=file_tempout,position='append')
                       write(17,*) 'error unit (m)::: ',unit_block_c(i_do,3)
                       close(17)
                       stop
                    end if
                 end if
                 if( i_do == 3 ) then
                    if( unit_block_c(i_do,1) /= 0.d0 ) then
                       open(unit=17,file=file_tempout,position='append')
                       write(17,*) 'error unit (m)::: ',unit_block_c(i_do,1)
                       close(17)
                       stop
                    end if
                    if( unit_block_c(i_do,2) /= 0.d0 ) then
                       open(unit=17,file=file_tempout,position='append')
                       write(17,*) 'error unit (m)::: ',unit_block_c(i_do,2)
                       close(17)
                       stop
                    end if
                 end if
              end do
           case('}tb_junc_region','}tb_central_region')
              go to 130
           end select
        end do
     end select
  end do
130 continue
  close(19)

  if( num_atom_c == 0 ) then
     open(unit=17,file=file_tempout,position='append')
     write(17,*) '??? broken ??? //junc_region/atom_number// => stop'
     close(17)
     stop
  end if
  if( i_check /= 3 ) then
     open(unit=17,file=file_tempout,position='append')
     write(17,*) '??? broken ??? //junc_region/unit_vector// => stop'
     close(17)
     stop
  end if
  if( i_r_c == 2 ) then
     i_r_c=0
     open(unit=17,file=file_tempout,position='append')
     write(17,*)                                                              &
          '??? broken ??? //junc_region/coordinate_system// => cartesian'
     close(17)
  end if

  num_atom_l=0
  i_r_l=2
  i_check=0
  p_or_f_l=''
  open(unit=19,file=file_parameter_co,status='old')
  do 
     read(19,'(a)',end=140) buf
     if( buf == '' ) then
        cycle
     end if
     read(buf,*) tag1
     if( tag1(1:1) == '#' ) then
        cycle
     end if
     select case(tag1)
     case('tb_left_region{')
        do 
           read(19,'(a)',end=140) buf
           if( buf == '' ) then
              cycle
           end if
           read(buf,*) tag2
           if( tag2(1:1) == '#' ) then
              cycle
           end if
           select case(tag2)
           case('atom_number')
              read(buf,*) dummy1,dummy2,num_atom_l
           case('boundary')
              read(buf,*) dummy1,dummy2,p_or_f_l
           case('coordinate_system')
              read(buf,*) dummy1,dummy2,tag3
              if( tag3 == 'cartesian' ) then
                 i_r_l=0
              end if
              if( tag3 == 'pucv' ) then
                 i_r_l=1
              end if
           case('unit_vector{')
              do
                 read(19,'(a)',end=140) buf
                 if( buf == '' ) then
                    cycle
                 end if
                 read(buf,*) tag2
                 if( tag2(1:1) == '#' ) then
                    cycle
                 end if
                 if( tag2 == '}unit_vector' ) then
                    exit
                 end if
                 i_check=i_check+1
                 i_do=i_check
                 read(buf,*) unit_block_l(i_check,1),unit_block_l(i_check,2)  &
                      ,unit_block_l(i_check,3)
                 if( i_do == 1 ) then
                    if( unit_block_l(i_do,3) /= 0.d0 ) then
                       open(unit=17,file=file_tempout,position='append')
                       write(17,*) 'error unit (l)::: ',unit_block_l(i_do,3)
                       close(17)
                       stop
                    end if
                 end if
                 if( i_do == 2 ) then
                    if( unit_block_l(i_do,3) /= 0.d0 ) then
                       open(unit=17,file=file_tempout,position='append')
                       write(17,*) 'error unit (l)::: ',unit_block_l(i_do,3)
                       close(17)
                       stop
                    end if
                 end if
                 if( i_do == 3 ) then
                    if( unit_block_l(i_do,1) /= 0.d0 ) then
                       open(unit=17,file=file_tempout,position='append')
                       write(17,*) 'error unit (l)::: ',unit_block_l(i_do,1)
                       close(17)
                       stop
                    end if
                    if( unit_block_l(i_do,2) /= 0.d0 ) then
                       open(unit=17,file=file_tempout,position='append')
                       write(17,*) 'error unit (l)::: ',unit_block_l(i_do,2)
                       close(17)
                       stop
                    end if
                 end if
              end do
           case('}tb_left_region')
              go to 140
           end select
        end do
     end select
  end do
140 continue
  close(19)

  if( num_atom_l == 0 ) then
     open(unit=17,file=file_tempout,position='append')
     write(17,*) '??? broken ??? //left_region/atom_number// => stop'
     close(17)
     stop
  end if
  if( i_check /= 3 ) then
     open(unit=17,file=file_tempout,position='append')
     write(17,*) '??? broken ??? //left_region/unit_vector// => stop'
     close(17)
     stop
  end if
  if( p_or_f_l == '' ) then
     p_or_f_l='free'
  end if
  if( i_r_l == 2 ) then
     i_r_l=0
     open(unit=17,file=file_tempout,position='append')
     write(17,*)                                                              &
          '??? broken ??? //left_region/coordinate_system// => cartesian'
     close(17)
  end if

  num_atom_r=0
  i_r_r=2
  i_check=0
  p_or_f_r=''
  open(unit=19,file=file_parameter_co,status='old')
  do 
     read(19,'(a)',end=150) buf
     if( buf == '' ) then
        cycle
     end if
     read(buf,*) tag1
     if( tag1(1:1) == '#' ) then
        cycle
     end if
     select case(tag1)
     case('tb_right_region{')
        do 
           read(19,'(a)',end=150) buf
           if( buf == '' ) then
              cycle
           end if
           read(buf,*) tag2
           if( tag2(1:1) == '#' ) then
              cycle
           end if
           select case(tag2)
           case('atom_number')
              read(buf,*) dummy1,dummy2,num_atom_r
           case('boundary')
              read(buf,*) dummy1,dummy2,p_or_f_r
           case('coordinate_system')
              read(buf,*) dummy1,dummy2,tag3
              if( tag3 == 'cartesian' ) then
                 i_r_r=0
              end if
              if( tag3 == 'pucv' ) then
                 i_r_r=1
              end if
           case('unit_vector{')
              do
                 read(19,'(a)',end=150) buf
                 if( buf == '' ) then
                    cycle
                 end if
                 read(buf,*) tag2
                 if( tag2(1:1) == '#' ) then
                    cycle
                 end if
                 if( tag2 == '}unit_vector' ) then
                    exit
                 end if
                 i_check=i_check+1
                 i_do=i_check
                 read(buf,*) unit_block_r(i_check,1),unit_block_r(i_check,2)  &
                      ,unit_block_r(i_check,3)
                 if( i_do == 1 ) then
                    if( unit_block_r(i_do,3) /= 0.d0 ) then
                       open(unit=17,file=file_tempout,position='append')
                       write(17,*) 'error unit (r)::: ',unit_block_r(i_do,3)
                       close(17)
                       stop
                    end if
                 end if
                 if( i_do == 2 ) then
                    if( unit_block_r(i_do,3) /= 0.d0 ) then
                       open(unit=17,file=file_tempout,position='append')
                       write(17,*) 'error unit (r)::: ',unit_block_r(i_do,3)
                       close(17)
                       stop
                    end if
                 end if
                 if( i_do == 3 ) then
                    if( unit_block_r(i_do,1) /= 0.d0 ) then
                       open(unit=17,file=file_tempout,position='append')
                       write(17,*) 'error unit (r)::: ',unit_block_r(i_do,1)
                       close(17)
                       stop
                    end if
                    if( unit_block_r(i_do,2) /= 0.d0 ) then
                       open(unit=17,file=file_tempout,position='append')
                       write(17,*) 'error unit (r)::: ',unit_block_r(i_do,2)
                       close(17)
                       stop
                    end if
                 end if
              end do
           case('}tb_right_region')
              go to 150
           end select
        end do
     end select
  end do
150 continue
  close(19)

  if( num_atom_r == 0 ) then
     open(unit=17,file=file_tempout,position='append')
     write(17,*) '??? broken ??? //right_region/atom_number// => stop'
     close(17)
     stop
  end if
  if( i_check /= 3 ) then
     open(unit=17,file=file_tempout,position='append')
     write(17,*) '??? broken ??? //right_region/unit_vector// => stop'
     close(17)
     stop
  end if
  if( p_or_f_r == '' ) then
     p_or_f_r='free'
  end if
  if( i_r_r == 2 ) then
     i_r_r=0
     open(unit=17,file=file_tempout,position='append')
     write(17,*)                                                              &
          '??? broken ??? //right_region/coordinate_system// => cartesian'
     close(17)
  end if

  call alo_input_condition_3
  call alo_input_condition_4
  call alo_input_condition_5


  i_check=0
  open(unit=19,file=file_parameter_co,status='old')
  do 
     read(19,'(a)',end=160) buf
     if( buf == '' ) then
        cycle
     end if
     read(buf,*) tag1
     if( tag1(1:1) == '#' ) then
        cycle
     end if
     select case(tag1)
     case('tb_junc_region{','tb_central_region{')
        do 
           read(19,'(a)',end=160) buf
           if( buf == '' ) then
              cycle
           end if
           read(buf,*) tag2
           if( tag2(1:1) == '#' ) then
              cycle
           end if
           select case(tag2)
           case('atom_list{')
              do
                 read(19,'(a)',end=160) buf
                 if( buf == '' ) then
                    cycle
                 end if
                 read(buf,*) tag2
                 if( tag2(1:1) == '#' ) then
                    cycle
                 end if
                 if( tag2 == '}atom_list' ) then
                    exit
                 end if
                 i_check=i_check+1
                 i_do=i_check
                 read(buf,*) i_temp,atom_kind_c(i_do)                         &
                      ,ra_temp(1),ra_temp(2),ra_temp(3)
                 if( i_r_c == 1 ) then
                    do jr_do=1,3
                       ra_c(i_do,jr_do)=ra_temp(1)*unit_block_c(1,jr_do)        &
                            +ra_temp(2)*unit_block_c(2,jr_do)        &
                            +ra_temp(3)*unit_block_c(3,jr_do)
                    end do
                 else
                    if( i_r_c == 0 ) then
                       ra_c(i_do,1)=ra_temp(1)
                       ra_c(i_do,2)=ra_temp(2)
                       ra_c(i_do,3)=ra_temp(3)
                    else
                       write(6,*) 'error _ r-c'
                    end if
                 end if
                 do j_do=1,num_atom_kind_ini
                    if( atom_kind_c(i_do) == atom_sign_ini(j_do) ) then
                       atom_kindn_c(i_do)=j_do
                       exit
                    end if
                 end do
              end do
           case('}tb_junc_region','}tb_central_region')
              go to 160
           end select
        end do
     end select
  end do
160 continue
  close(19)

  if( num_atom_c /= i_check ) then
     open(unit=17,file=file_tempout,position='append')
     write(17,*) '??? broken ??? //junc_region/atom_list// => stop'
     close(17)
     stop
  end if

  num_unit_l(3)=1
  neighbor_z_max_l=1

  num_unit_l(1)=1
  num_unit_l(2)=1
  neighbor_x_max_l=1
  neighbor_y_max_l=1
  kx_max_l=1
  ky_max_l=1
  i_check=0
  open(unit=19,file=file_parameter_co,status='old')
  do 
     read(19,'(a)',end=170) buf
     if( buf == '' ) then
        cycle
     end if
     read(buf,*) tag1
     if( tag1(1:1) == '#' ) then
        cycle
     end if
     select case(tag1)
     case('tb_left_region{')
        do 
           read(19,'(a)',end=170) buf
           if( buf == '' ) then
              cycle
           end if
           read(buf,*) tag2
           if( tag2(1:1) == '#' ) then
              cycle
           end if
           select case(tag2)
           case('buffer_a')
              read(buf,*) dummy1,dummy2,num_unit_l(1)
           case('buffer_b')
              read(buf,*) dummy1,dummy2,num_unit_l(2)
           case('ka_max')
              read(buf,*) dummy1,dummy2,kx_max_l
           case('kb_max')
              read(buf,*) dummy1,dummy2,ky_max_l
           case('neighbor_a_max')
              read(buf,*) dummy1,dummy2,neighbor_x_max_l
           case('neighbor_b_max')
              read(buf,*) dummy1,dummy2,neighbor_y_max_l
           case('atom_list{')
              do
                 read(19,'(a)',end=170) buf
                 if( buf == '' ) then
                    cycle
                 end if
                 read(buf,*) tag2
                 if( tag2(1:1) == '#' ) then
                    cycle
                 end if
                 if( tag2 == '}atom_list' ) then
                    exit
                 end if
                 i_check=i_check+1
                 i_do=i_check
                 read(buf,*) i_temp,atom_kind_l(i_do)                         &
                      ,ra_temp(1),ra_temp(2),ra_temp(3)
                 if( i_r_l == 1 ) then
                    do jr_do=1,3
                       ra_l(i_do,jr_do)=ra_temp(1)*unit_block_l(1,jr_do)        &
                            +ra_temp(2)*unit_block_l(2,jr_do)        &
                            +ra_temp(3)*unit_block_l(3,jr_do)
                       if( jr_do == 3 ) then
                          ra_l(i_do,jr_do)=ra_l(i_do,jr_do)-unit_block_l(3,3)
                       end if
                    end do
                 else
                    if( i_r_l == 0 ) then
                       ra_l(i_do,1)=ra_temp(1)
                       ra_l(i_do,2)=ra_temp(2)
                       ra_l(i_do,3)=ra_temp(3)-unit_block_l(3,3)
                    else
                       write(6,*) 'error _ r-l'
                    end if
                 end if
                 do j_do=1,num_atom_kind_ini
                    if( atom_kind_l(i_do) == atom_sign_ini(j_do) ) then
                       atom_kindn_l(i_do)=j_do
                       exit
                    end if
                 end do
              end do
           case('}tb_left_region')
              go to 170
           end select
        end do
     end select
  end do
170 continue
  close(19)

  if( num_atom_l /= i_check ) then
     open(unit=17,file=file_tempout,position='append')
     write(17,*) '??? broken ??? //left_region/atom_list// => stop'
     close(17)
     stop
  end if
  if( p_or_f_l == 'free' .and. num_unit_l(1) == 0 ) then
     num_unit_l(1)=1
     open(unit=17,file=file_tempout,position='append')
     write(17,*) '??? broken ??? //left_region/buffer_a// => def'
     close(17)
  end if
  if( p_or_f_l == 'free' .and. num_unit_l(2) == 0 ) then
     num_unit_l(2)=1
     open(unit=17,file=file_tempout,position='append')
     write(17,*) '??? broken ??? //left_region/buffer_b// => def'
     close(17)
  end if
  if( p_or_f_l == 'periodic' .and. neighbor_x_max_l == 0 ) then
     neighbor_x_max_l=1
     open(unit=17,file=file_tempout,position='append')
     write(17,*) '??? broken ??? //left_region/neighbor_a_max// => def'
     close(17)
  end if
  if( p_or_f_l == 'periodic' .and. neighbor_y_max_l == 0 ) then
     neighbor_y_max_l=1
     open(unit=17,file=file_tempout,position='append')
     write(17,*) '??? broken ??? //left_region/neighbor_b_max// => def'
     close(17)
  end if
  if( p_or_f_l == 'periodic' .and. kx_max_l == 0 ) then
     kx_max_l=1
     open(unit=17,file=file_tempout,position='append')
     write(17,*) '??? broken ??? //left_region/ka_max// => def'
     close(17)
  end if
  if( p_or_f_l == 'periodic' .and. ky_max_l == 0 ) then
     ky_max_l=1
     open(unit=17,file=file_tempout,position='append')
     write(17,*) '??? broken ??? //left_region/kb_max// => def'
     close(17)
  end if
  if( p_or_f_l == 'free' ) then
     neighbor_x_max_l=1
     neighbor_y_max_l=1
     kx_max_l=1
     ky_max_l=1
  end if
  if( p_or_f_l == 'periodic' ) then
     num_unit_l(1)=1
     num_unit_l(2)=1
  end if

  num_unit_r(3)=1
  neighbor_z_max_r=1

  num_unit_r(1)=1
  num_unit_r(2)=1
  neighbor_x_max_r=1
  neighbor_y_max_r=1
  kx_max_r=1
  ky_max_r=1
  i_check=0
  open(unit=19,file=file_parameter_co,status='old')
  do 
     read(19,'(a)',end=180) buf
     if( buf == '' ) then
        cycle
     end if
     read(buf,*) tag1
     if( tag1(1:1) == '#' ) then
        cycle
     end if
     select case(tag1)
     case('tb_right_region{')
        do 
           read(19,'(a)',end=180) buf
           if( buf == '' ) then
              cycle
           end if
           read(buf,*) tag2
           if( tag2(1:1) == '#' ) then
              cycle
           end if
           select case(tag2)
           case('buffer_a')
              read(buf,*) dummy1,dummy2,num_unit_r(1)
           case('buffer_b')
              read(buf,*) dummy1,dummy2,num_unit_r(2)
           case('ka_max')
              read(buf,*) dummy1,dummy2,kx_max_r
           case('kb_max')
              read(buf,*) dummy1,dummy2,ky_max_r
           case('neighbor_a_max')
              read(buf,*) dummy1,dummy2,neighbor_x_max_r
           case('neighbor_b_max')
              read(buf,*) dummy1,dummy2,neighbor_y_max_r
           case('atom_list{')
              do
                 read(19,'(a)',end=180) buf
                 if( buf == '' ) then
                    cycle
                 end if
                 read(buf,*) tag2
                 if( tag2(1:1) == '#' ) then
                    cycle
                 end if
                 if( tag2 == '}atom_list' ) then
                    exit
                 end if
                 i_check=i_check+1
                 i_do=i_check
                 read(buf,*) i_temp,atom_kind_r(i_do)                         &
                      ,ra_temp(1),ra_temp(2),ra_temp(3)
                 if( i_r_r == 1 ) then
                    do jr_do=1,3
                       ra_r(i_do,jr_do)=ra_temp(1)*unit_block_r(1,jr_do)        &
                            +ra_temp(2)*unit_block_r(2,jr_do)        &
                            +ra_temp(3)*unit_block_r(3,jr_do)
                    end do
                 else
                    if( i_r_r == 0 ) then
                       ra_r(i_do,1)=ra_temp(1)
                       ra_r(i_do,2)=ra_temp(2)
                       ra_r(i_do,3)=ra_temp(3)
                    else
                       write(6,*) 'error _ r-r'
                    end if
                 end if
                 do j_do=1,num_atom_kind_ini
                    if( atom_kind_r(i_do) == atom_sign_ini(j_do) ) then
                       atom_kindn_r(i_do)=j_do
                       exit
                    end if
                 end do
              end do
           case('}tb_right_region')
              go to 180
           end select
        end do
     end select
  end do
180 continue
  close(19)

  if( num_atom_r /= i_check ) then
     open(unit=17,file=file_tempout,position='append')
     write(17,*) '??? broken ??? //right_region/atom_list// => stop'
     close(17)
     stop
  end if
  if( p_or_f_r == 'free' .and. num_unit_r(1) == 0 ) then
     num_unit_r(1)=1
     open(unit=17,file=file_tempout,position='append')
     write(17,*) '??? broken ??? //right_region/buffer_a// => def'
     close(17)
  end if
  if( p_or_f_r == 'free' .and. num_unit_r(2) == 0 ) then
     num_unit_r(2)=1
     open(unit=17,file=file_tempout,position='append')
     write(17,*) '??? broken ??? //right_region/buffer_b// => def'
     close(17)
  end if
  if( p_or_f_r == 'periodic' .and. neighbor_x_max_r == 0 ) then
     neighbor_x_max_r=1
     open(unit=17,file=file_tempout,position='append')
     write(17,*) '??? broken ??? //right_region/neighbor_a_max// => def'
     close(17)
  end if
  if( p_or_f_r == 'periodic' .and. neighbor_y_max_r == 0 ) then
     neighbor_y_max_r=1
     open(unit=17,file=file_tempout,position='append')
     write(17,*) '??? broken ??? //right_region/neighbor_b_max// => def'
     close(17)
  end if
  if( p_or_f_r == 'periodic' .and. kx_max_r == 0 ) then
     kx_max_r=1
     open(unit=17,file=file_tempout,position='append')
     write(17,*) '??? broken ??? //right_region/ka_max// => def'
     close(17)
  end if
  if( p_or_f_r == 'periodic' .and. ky_max_r == 0 ) then
     ky_max_r=1
     open(unit=17,file=file_tempout,position='append')
     write(17,*) '??? broken ??? //right_region/kb_max// => def'
     close(17)
  end if
  if( p_or_f_r == 'free' ) then
     neighbor_x_max_r=1
     neighbor_y_max_r=1
     kx_max_r=1
     ky_max_r=1
  end if
  if( p_or_f_r == 'periodic' ) then
     num_unit_r(1)=1
     num_unit_r(2)=1
  end if


  open(unit=16,file=file_tempout,position='append')

  write(16,*)
  write(16,*)                                                               &
       '====================== atomic stracture ======================'
  write(16,*) '                z:  direction of transport                '
  write(16,*)
  do i_do=1,num_atom_kind_ini
     write(16,909) i_do,atom_sign_ini(i_do)
  end do
909 format('                atom_kind: ',i4,5x,a5)

  write(16,*)
  if( p_or_f_l /= 'free' .or. p_or_f_r /= 'free' ) then
     write(16,920) p_or_f_l,p_or_f_r
920  format('  boundary condition(l,r): ',a10,a10)
  end if
  if( p_or_f_l == 'free'                                                     &
       .and. ( num_unit_l(1) /= 1 .or. num_unit_l(2) /= 1 ) ) then
     write(16,933) num_unit_l(1),num_unit_l(2)
933  format(' buffer size / left/(a,b): ',i5,i5)
  end if
  if( p_or_f_r == 'free'                                                     &
       .and. ( num_unit_r(1) /= 1 .or. num_unit_r(2) /= 1 ) ) then
     write(16,932) num_unit_r(1),num_unit_r(2)
932  format(' buffer size /right/(a,b): ',i5,i5)
  end if
  if( p_or_f_l == 'periodic' ) then
     write(16,921) kx_max_l,ky_max_l
921  format('k-point mesh / left/(a,b): ',i5,i5)
     write(16,934) neighbor_x_max_l,neighbor_y_max_l
934  format('neighbor_max / left/(a,b): ',i5,i5)
  end if
  if( p_or_f_r == 'periodic' ) then
     write(16,922) kx_max_r,ky_max_r
922  format('k-point mesh /right/(a,b): ',i5,i5)
     write(16,935) neighbor_x_max_r,neighbor_y_max_r
935  format('neighbor_max /right/(a,b): ',i5,i5)
  end if

  write(16,*)
  write(16,913) r_dis_l,r_dis_r
913 format('            distance(l,r): ',f10.5,f10.5,'  (Ang)')
  write(16,912) m_num_block_l,m_num_block_m,m_num_block_r
912 format('       buffer size(l,m,r): ',i5,i5,i5)
  if( dabs(v_l)+dabs(v_c)+dabs(v_r) > 1.d-10 ) then
     write(16,930) v_l,v_c,v_r
930  format('              bias(l,m,r): ',f8.3,f8.3,f8.3,'  (V)')
  end if

  write(16,*) 
  write(16,*)                                                                &
       '++++++++++++++++++++++   unit    cell   ++++++++++++++++++++++'
  write(16,*)

  write(16,*) '  ---  left   (Ang) ---'
  do i_do=1,3
     write(16,910) unit_block_l(i_do,1),unit_block_l(i_do,2)                  &
          ,unit_block_l(i_do,3)
  end do
  write(16,*) 
  write(16,*) '  ---  right  (Ang) ---'
  do i_do=1,3
     write(16,910) unit_block_r(i_do,1),unit_block_r(i_do,2)                  &
          ,unit_block_r(i_do,3)
  end do
  write(16,*) 
  write(16,*) '  ---  junc   (Ang) ---'
  do i_do=1,3
     write(16,910) unit_block_c(i_do,1),unit_block_c(i_do,2)                  &
          ,unit_block_c(i_do,3)
  end do
910 format(10x,f10.5,f10.5,f10.5)

  write(16,*) 
  write(16,*)                                                                &
       '++++++++++++++++++++++    coordinate    ++++++++++++++++++++++'
  write(16,*)
  write(16,931) num_atom_l,num_atom_c,num_atom_r
931 format('    number of atom(l,m,r): ',i5,i5,i5)
  write(16,*)
  write(16,*) '  ---  left   (Ang) ---'
  do i_do=1,num_atom_l
     write(16,911) i_do,atom_kind_l(i_do)                                     &
          ,ra_l(i_do,1),ra_l(i_do,2),ra_l(i_do,3)+unit_block_l(3,3)
  end do

  write(16,*)
  write(16,*) '  ---  right  (Ang) ---'
  do i_do=1,num_atom_r
     write(16,911) i_do,atom_kind_r(i_do)                                     &
          ,ra_r(i_do,1),ra_r(i_do,2),ra_r(i_do,3)
  end do
  write(16,*) 
  write(16,*) '  ---  junc   (Ang) ---'
  do i_do=1,num_atom_c
     write(16,911) i_do,atom_kind_c(i_do)                                     &
          ,ra_c(i_do,1),ra_c(i_do,2),ra_c(i_do,3)
  end do
911 format(10x,i5,5x,a5,f10.5,f10.5,f10.5)

  write(16,*)

  close(16)


  if( p_or_f_l == 'free' ) then
     kx_max_l=1
     ky_max_l=1
  end if
  if( p_or_f_r == 'free' ) then
     kx_max_r=1
     ky_max_r=1
  end if
  spin_switch_cc=1

  return
end subroutine read_input_tb_cordinate
