! @@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@ !
! @@                                                                @@ !
! @@       PROGRAM  ASCOT 2014.440 (ver.4.53)                       @@ !
! @@     "Abinitio Simulation Code for Quantum Transport"           @@ !
! @@                                                                @@ !
! @@                                                                @@ !
! @@  AUTHOR(S): Hisashi KONDO (Univ. Tokyo)                        @@ !
! @@             Naoki WATANABE (Mizuho I.R.)                       @@ !
! @@             Nobutaka NISHIKAWA (Mizuho I.R.)                   @@ !
! @@                                                09/May/2014     @@ !
! @@                                                                @@ !
! @@  Contact address: Phase System Consortium                      @@ !
! @@                                                                @@ !
! @@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@ !

subroutine print_site_sel(descCC,w,amat_temp6,bmat_temp6,ispin)

  use condition_ini
  use hamiltonian_c
  use gf_se_c
  use ac_mpi_module

  implicit none
  type(MPI_MatDesc), intent(in) :: descCC
  integer, intent(in) :: ispin
  complex(8), intent(in) :: w
  complex(8), intent(in) :: amat_temp6(descCC%nrow,descCC%scol:descCC%ecol)
  complex(8), intent(in) :: bmat_temp6(descCC%nrow,descCC%scol:descCC%ecol)
  integer :: i1_do,i2_do
  complex(8) :: temp

  if( calc_type == 'trans' .or. calc_type == 'iv' ) then

     if( switch_out_gf == 'diagonal' ) then
        if( w == omega_gs(1) ) then
           if( ispin == 1 ) then
              write(50,*) m_num_block_l,m_num_block_m,m_num_block_r
              write(50,*) num_atom_l,num_atom_c,num_atom_r
              write(50,*) iw_max_gs,m_mat_max_c
           else
              write(52,*) m_num_block_l,m_num_block_m,m_num_block_r
              write(52,*) num_atom_l,num_atom_c,num_atom_r
              write(52,*) iw_max_gs,m_mat_max_c
           end if
        end if
        do i1_do=descCC%scol,descCC%ecol
           temp=amat_temp6(i1_do,i1_do)
           if( ispin == 1 ) then
              write(50,999) dreal(w),i1_do,dreal(temp),dimag(temp)
           else
              write(52,999) dreal(w),i1_do,dreal(temp),dimag(temp)
           end if
        end do
     end if
999  format(d27.17,i5,d27.17,d27.17)

     if( switch_out_gf == 'all' ) then
        if( w == omega_gs(1) ) then
           if( ispin == 1 ) then
              write(50,*) m_num_block_l,m_num_block_m,m_num_block_r
              write(50,*) num_atom_l,num_atom_c,num_atom_r
              write(50,*) iw_max_gs,m_mat_max_c
           else
              write(52,*) m_num_block_l,m_num_block_m,m_num_block_r
              write(52,*) num_atom_l,num_atom_c,num_atom_r
              write(52,*) iw_max_gs,m_mat_max_c
           end if
        end if
        do i1_do=1,descCC%nrow
           if( ispin == 1 ) then
              write(50,*) i1_do,dreal(w),'****************************************'
           else
              write(52,*) i1_do,dreal(w),'****************************************'
           end if
           do i2_do=descCC%scol,descCC%ecol
              temp=amat_temp6(i1_do,i2_do)
              if( ispin == 1 ) then
                 write(50,*) i2_do,dreal(temp),dimag(temp)
              else
                 write(52,*) i2_do,dreal(temp),dimag(temp)
              end if
           end do
        end do
     end if

     if( switch_out_tr == 'all' ) then
        if( w == omega_gs(1) ) then
           if( ispin == 1 ) then
              write(46,*) m_num_block_l,m_num_block_m,m_num_block_r
              write(46,*) num_atom_l,num_atom_c,num_atom_r
              write(46,*) iw_max_gs,m_mat_max_c
           else
              write(47,*) m_num_block_l,m_num_block_m,m_num_block_r
              write(47,*) num_atom_l,num_atom_c,num_atom_r
              write(47,*) iw_max_gs,m_mat_max_c
           end if
        end if
        do i1_do=1,descCC%nrow
           if( ispin == 1 ) then
              write(46,*) i1_do,dreal(w),'****************************************'
           else
              write(47,*) i1_do,dreal(w),'****************************************'
           end if
           do i2_do=descCC%scol,descCC%ecol
              temp=bmat_temp6(i1_do,i2_do)
              if( ispin == 1 ) then
                 write(46,*) i2_do,dreal(temp),dimag(temp)
              else
                 write(47,*) i2_do,dreal(temp),dimag(temp)
              end if
           end do
        end do
     end if

  end if

  return
end subroutine print_site_sel

subroutine print_site_tra(descCC,w,amat_temp5,ispin)

  use condition_ini
  use hamiltonian_sgf
  use hamiltonian_c
  use gf_se_c
  use ac_mpi_module

  implicit none
  type(MPI_MatDesc), intent(in) :: descCC
  integer, intent(in) :: ispin
  complex(8), intent(in) :: w
  complex(8), intent(in) :: amat_temp5(descCC%nrow,descCC%scol:descCC%ecol)
  integer :: i1_do,i2_do,px,py,icou_l,qx,qy,icou_r
  complex(8) :: temp
  integer :: i, j


  if( calc_type == 'trans' .or. calc_type == 'iv' ) then

     if( switch_out_tr == 'diagonal' ) then
        if( w == omega_gs(1) ) then
           if( ispin == 1 ) then
              write(51,*) m_num_block_l,m_num_block_m,m_num_block_r
              write(51,*) num_atom_l,num_atom_c,num_atom_r
              write(51,*) iw_max_gs,m_mat_max_c
           else
              write(53,*) m_num_block_l,m_num_block_m,m_num_block_r
              write(53,*) num_atom_l,num_atom_c,num_atom_r
              write(53,*) iw_max_gs,m_mat_max_c
           end if
        end if
        do i1_do=descCC%scol,descCC%ecol
           temp=amat_temp5(i1_do,i1_do)
           if( ispin == 1 ) then
              write(51,999) dreal(w),i1_do,dreal(temp),dimag(temp)
           else
              write(53,999) dreal(w),i1_do,dreal(temp),dimag(temp)
           end if
        end do
     end if
999  format(d27.17,i5,d27.17,d27.17)

     if( switch_out_tr == 'tr' .or. switch_out_tr == 'all' ) then
        if( w == omega_gs(1) ) then
           if( ispin == 1 ) then
              write(51,*) m_num_block_l,m_num_block_m,m_num_block_r
              write(51,*) num_atom_l,num_atom_c,num_atom_r
              write(51,*) iw_max_gs,m_mat_max_c
           else
              write(53,*) m_num_block_l,m_num_block_m,m_num_block_r
              write(53,*) num_atom_l,num_atom_c,num_atom_r
              write(53,*) iw_max_gs,m_mat_max_c
           end if
        end if
        icou_l=0
        do i1_do=1,descCC%nrow
           do i2_do=descCC%scol,descCC%ecol
              if( amat_temp5(i1_do,i2_do) /= dcmplx(0.d0,0.d0) ) then
                 icou_l=icou_l+1
              end if
           end do
        end do
        if( ispin == 1 ) then
           write(51,*) icou_l,dreal(w),'****************************************'
        else
           write(53,*) icou_l,dreal(w),'****************************************'
        end if
        do i1_do=1,descCC%nrow
           do i2_do=descCC%scol,descCC%ecol
              temp=amat_temp5(i1_do,i2_do)
              if( ispin == 1 ) then
                 if( amat_temp5(i1_do,i2_do) /= dcmplx(0.d0,0.d0) ) then
                    write(51,*) i1_do,i2_do,dreal(temp),dimag(temp)
                 end if
              else
                 if( amat_temp5(i1_do,i2_do) /= dcmplx(0.d0,0.d0) ) then
                    write(53,*) i1_do,i2_do,dreal(temp),dimag(temp)
                 end if
              end if
           end do
        end do
     end if

     if( switch_out_tr == 'all' ) then
        if( w == omega_gs(1) ) then
           if( ispin == 1 ) then
              write(48,*) m_num_block_l,m_num_block_m,m_num_block_r
              write(48,*) num_atom_l,num_atom_c,num_atom_r
              write(48,*) iw_max_gs,m_mat_max_c
           else
              write(49,*) m_num_block_l,m_num_block_m,m_num_block_r
              write(49,*) num_atom_l,num_atom_c,num_atom_r
              write(49,*) iw_max_gs,m_mat_max_c
           end if
        end if
        icou_l=0
        do px=1,kx_max_ll                                         
           do py=1,ky_max_ll                                       
              do j=descCC%scol,descCC%ecol
                 do i=1,descCC%nrow
                    if( se_l_mat_per(i,j,px,py) /= dcmplx(0.d0,0.d0) ) then 
                       icou_l=icou_l+1
                    end if
                 end do
              end do
           end do
        end do
        do px=1,kx_max_ll
           do py=1,ky_max_ll
              if( ispin == 1 ) then
                 write(48,*) icou_l,dreal(w),dimag(w)                               &
                      ,'****************************************'
              else
                 write(49,*) icou_l,dreal(w),dimag(w)                               &
                      ,'****************************************'
              end if
              do j=descCC%scol,descCC%ecol
                 do i=1,descCC%nrow
                    if( se_l_mat_per(i,j,px,py) /= dcmplx(0.d0,0.d0) ) then 
                       temp=se_l_mat_per(i,j,px,py) 
                       if( ispin == 1 ) then
                          write(48,*) i,j,dreal(temp),dimag(temp) 
                       else
                          write(49,*) i,j,dreal(temp),dimag(temp) 
                       end if
                    end if
                 end do
              end do
           end do
        end do
        icou_r=0
        do qx=1,kx_max_rr                                         
           do qy=1,ky_max_rr                                       
              do j=descCC%scol,descCC%ecol
                 do i=1,descCC%nrow
                    if( se_r_mat_per(i,j,qx,qy) /= dcmplx(0.d0,0.d0) ) then 
                       icou_r=icou_r+1
                    end if
                 end do
              end do
           end do
        end do
        do qx=1,kx_max_rr
           do qy=1,ky_max_rr
              if( ispin == 1 ) then
                 write(48,*) icou_l,dreal(w),dimag(w)                               &
                      ,'****************************************'
              else
                 write(49,*) icou_l,dreal(w),dimag(w)                               &
                      ,'****************************************'
              end if
              do j=descCC%scol,descCC%ecol
                 do i=1,descCC%nrow
                    if( se_r_mat_per(i,j,qx,qy) /= dcmplx(0.d0,0.d0) ) then 
                       temp=se_r_mat_per(i,j,qx,qy) 
                       if( ispin == 1 ) then
                          write(48,*) i,j,dreal(temp),dimag(temp) 
                       else
                          write(49,*) i,j,dreal(temp),dimag(temp) 
                       end if
                    end if
                 end do
              end do
           end do
        end do
     end if

  end if

  return
end subroutine print_site_tra
