! @@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@ !
! @@                                                                @@ !
! @@       PROGRAM  ASCOT 2014.440 (ver.4.53)                       @@ !
! @@     "Abinitio Simulation Code for Quantum Transport"           @@ !
! @@                                                                @@ !
! @@                                                                @@ !
! @@  AUTHOR(S): Hisashi KONDO (Univ. Tokyo)                        @@ !
! @@             Naoki WATANABE (Mizuho I.R.)                       @@ !
! @@             Nobutaka NISHIKAWA (Mizuho I.R.)                   @@ !
! @@                                                09/May/2014     @@ !
! @@                                                                @@ !
! @@  Contact address: Phase System Consortium                      @@ !
! @@                                                                @@ !
! @@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@ !

module hamiltonian_zper

  implicit none
  integer :: mat_max_zper
  integer, pointer :: itemp(:,:,:),jtemp(:)
  complex(8), pointer :: h00_mat(:,:), s00_mat(:,:) 

contains
  subroutine alo_hamiltonian_zper_input(descZZ)
    use ac_mpi_module
    implicit none

    type(MPI_MatDesc), intent(in) :: descZZ

    integer :: ier,i1_do,i2_do

    allocate(h00_mat(descZZ%nrow, descZZ%scol:descZZ%ecol),stat=ier) 
    allocate(s00_mat(descZZ%nrow, descZZ%scol:descZZ%ecol),stat=ier) 
    if( ier /= 0 ) then
       write(6,*) 'error allocate: alo_hamiltonian_zper_input'
       stop
    end if

    h00_mat(:,:) = dcmplx(0.d0,0.d0) 
    s00_mat(:,:) = dcmplx(0.d0,0.d0) 

    return
  end subroutine alo_hamiltonian_zper_input

  subroutine unset_hamiltonian_zper_input

    implicit none
    integer :: ier

    deallocate(h00_mat,s00_mat,stat=ier) 
    if( ier /= 0 ) then
       write(6,*) 'error deallocate: unset_hamiltonian_zper_input'
       stop
    end if

    return
  end subroutine unset_hamiltonian_zper_input

  subroutine alo_hamiltonian_zper_free(descZZ,num_atom,num_unit)
    use ac_mpi_module
    implicit none

    type(MPI_MatDesc), intent(in) :: descZZ
    integer, intent(in) :: num_atom,num_unit(3)
    integer :: ier,i1_do,i2_do

    allocate(itemp(num_unit(1),num_unit(2),num_atom),stat=ier)
    allocate(h00_mat(descZZ%nrow, descZZ%scol:descZZ%ecol),stat=ier) 
    allocate(s00_mat(descZZ%nrow, descZZ%scol:descZZ%ecol),stat=ier) 

    if( ier /= 0 ) then
       write(6,*) 'error allocate: alo_hamiltonian_zper_free'
       stop
    end if

    h00_mat(:,:) = dcmplx(0.d0,0.d0) 
    s00_mat(:,:) = dcmplx(0.d0,0.d0) 

    return
  end subroutine alo_hamiltonian_zper_free

  subroutine unset_hamiltonian_zper_free

    implicit none
    integer :: ier

    deallocate(h00_mat,s00_mat,itemp,stat=ier) 
    if( ier /= 0 ) then
       write(6,*) 'error deallocate: unset_hamiltonian_zper_free'
       stop
    end if

    return
  end subroutine unset_hamiltonian_zper_free

  subroutine alo_hamiltonian_zper_periodic(descZZ,num_atom)
    use ac_mpi_module
    implicit none

    type(MPI_MatDesc), intent(in) :: descZZ
    integer, intent(in) :: num_atom
    integer :: ier,i1_do,i2_do

    allocate(jtemp(num_atom),stat=ier)
    allocate(h00_mat(descZZ%nrow, descZZ%scol:descZZ%ecol),stat=ier) 
    allocate(s00_mat(descZZ%nrow, descZZ%scol:descZZ%ecol),stat=ier) 
    if( ier /= 0 ) then
       write(6,*) 'error allocate: alo_hamiltonian_zper_periodic'
       stop
    end if

    h00_mat(:,:) = dcmplx(0.d0,0.d0) 
    s00_mat(:,:) = dcmplx(0.d0,0.d0) 

    return
  end subroutine alo_hamiltonian_zper_periodic

  subroutine unset_hamiltonian_zper_periodic

    implicit none
    integer :: ier

    deallocate(h00_mat,s00_mat,jtemp,stat=ier) 
    if( ier /= 0 ) then
       write(6,*) 'error deallocate: unset_hamiltonian_zper_periodic'
       stop
    end if

    return
  end subroutine unset_hamiltonian_zper_periodic

end module hamiltonian_zper
