! @@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@ !
! @@                                                                @@ !
! @@       PROGRAM  ASCOT 2014.440 (ver.4.40)                       @@ !
! @@     "Abinitio Simulation Code for Quantum Transport"           @@ !
! @@                                                                @@ !
! @@                                                                @@ !
! @@  AUTHOR(S): Hisashi KONDO (Univ. Tokyo)                        @@ !
! @@                                                09/May/2014     @@ !
! @@                                                                @@ !
! @@  Contact address: Phase System Consortium                      @@ !
! @@                                                                @@ !
! @@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@ !

subroutine onsite_ham_hami_cc(j1_count,max_atom_orbital,h_ijmn,s_ijmn,v)

  use condition_ini
  use locate_atom
  use rtbh_parameter

  implicit none
  integer, intent(in) :: max_atom_orbital,j1_count
  real(8), intent(in) :: v
  complex(8), intent(out) :: h_ijmn(max_atom_orbital,max_atom_orbital)
  complex(8), intent(out) :: s_ijmn(max_atom_orbital,max_atom_orbital)
  integer :: id

  id=atom_kindn_ccal(j1_count)

  h_ijmn=dcmplx(0.d0,0.d0)
  s_ijmn=dcmplx(0.d0,0.d0)

  h_ijmn(1,1)=dcmplx(h_s(id)+v,0.d0)
  h_ijmn(2,2)=dcmplx(h_p(id)+v,0.d0)
  h_ijmn(3,3)=dcmplx(h_p(id)+v,0.d0)
  h_ijmn(4,4)=dcmplx(h_p(id)+v,0.d0)

  s_ijmn(1,1)=dcmplx(1.d0,0.d0)
  s_ijmn(2,2)=dcmplx(1.d0,0.d0)
  s_ijmn(3,3)=dcmplx(1.d0,0.d0)
  s_ijmn(4,4)=dcmplx(1.d0,0.d0)

  return
end subroutine onsite_ham_hami_cc

subroutine off_ham_hami_cc(j1_count,j2_count,max_atom_orbital,h_ijmn,s_ijmn        &
     ,r_per_temp)

  use condition_ini
  use locate_atom

  implicit none
  integer, intent(in) :: max_atom_orbital,j1_count,j2_count
  real(8), intent(in) :: r_per_temp(3)
  complex(8), intent(out) :: h_ijmn(max_atom_orbital,max_atom_orbital)
  complex(8), intent(out) :: s_ijmn(max_atom_orbital,max_atom_orbital)

  integer :: id1,id2,j_do,jr_do
  real(8) :: r_distance,rab_distance(3),r_temp_a(3),r_temp_b(3)

  do jr_do=1,3
     r_temp_a(jr_do)=r_c(j1_count,jr_do)+r_per_temp(jr_do)
     r_temp_b(jr_do)=r_c(j2_count,jr_do)
  end do

  rab_distance=r_temp_b-r_temp_a

  r_distance=0.d0
  do j_do=1,3
     r_distance=r_distance+rab_distance(j_do)**2
  end do
  r_distance=dsqrt(r_distance)

  rab_distance=rab_distance/r_distance

  id1=atom_kindn_ccal(j1_count)
  id2=atom_kindn_ccal(j2_count)

  call set_off_rtbh(r_distance,rab_distance,id1,id2                            &
       ,max_atom_orbital,h_ijmn,s_ijmn)

  return
end subroutine off_ham_hami_cc

subroutine off_rtbh_hami_lc(i1_do,j2_count,max_atom_orbital,h_ijmn                 &
     ,s_ijmn,r_per_temp)

  use condition_ini
  use locate_atom

  implicit none
  integer, intent(in) :: max_atom_orbital,i1_do,j2_count
  real(8), intent(in) :: r_per_temp(3)
  complex(8), intent(out) :: h_ijmn(max_atom_orbital,max_atom_orbital)
  complex(8), intent(out) :: s_ijmn(max_atom_orbital,max_atom_orbital)

  integer :: id1,id2,j_do,jr_do
  real(8) :: r_distance,rab_distance(3),r_temp_a(3),r_temp_b(3)

  do jr_do=1,3
     r_temp_a(jr_do)=r_l(i1_do,jr_do)+r_per_temp(jr_do)
     r_temp_b(jr_do)=r_c(j2_count,jr_do)
  end do

  rab_distance=r_temp_b-r_temp_a

  r_distance=0.d0
  do j_do=1,3
     r_distance=r_distance+rab_distance(j_do)**2
  end do
  r_distance=dsqrt(r_distance)

  rab_distance=rab_distance/r_distance

  id1=atom_kindn_l(i1_do)
  id2=atom_kindn_ccal(j2_count)

  call set_off_rtbh(r_distance,rab_distance,id1,id2                            &
       ,max_atom_orbital,h_ijmn,s_ijmn)

  return
end subroutine off_rtbh_hami_lc

subroutine off_rtbh_hami_rc(i1_do,j2_count,max_atom_orbital,h_ijmn,s_ijmn          &
     ,r_per_temp)

  use condition_ini
  use locate_atom

  implicit none
  integer, intent(in) :: max_atom_orbital,i1_do,j2_count
  real(8), intent(in) :: r_per_temp(3)
  complex(8), intent(out) :: h_ijmn(max_atom_orbital,max_atom_orbital)
  complex(8), intent(out) :: s_ijmn(max_atom_orbital,max_atom_orbital)

  integer :: id1,id2,j_do,jr_do
  real(8) :: r_distance,rab_distance(3),r_temp_a(3),r_temp_b(3)

  do jr_do=1,3
     r_temp_a(jr_do)=r_r(i1_do,jr_do)+r_per_temp(jr_do)
     r_temp_b(jr_do)=r_c(j2_count,jr_do)
  end do

  rab_distance=r_temp_b-r_temp_a

  r_distance=0.d0
  do j_do=1,3
     r_distance=r_distance+rab_distance(j_do)**2
  end do
  r_distance=dsqrt(r_distance)

  rab_distance=rab_distance/r_distance

  id1=atom_kindn_r(i1_do)
  id2=atom_kindn_ccal(j2_count)

  call set_off_rtbh(r_distance,rab_distance,id1,id2                            &
       ,max_atom_orbital,h_ijmn,s_ijmn)

  return
end subroutine off_rtbh_hami_rc
