! @@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@ !
! @@                                                                @@ !
! @@       PROGRAM  ASCOT 2014.440 (ver.4.40)                       @@ !
! @@     "Abinitio Simulation Code for Quantum Transport"           @@ !
! @@                                                                @@ !
! @@                                                                @@ !
! @@  AUTHOR(S): Hisashi KONDO (Univ. Tokyo)                        @@ !
! @@             Naoki WATANABE, Nobutaka NISHIKAWA (Mizuho I.R.)   @@ !
! @@                                                09/May/2014     @@ !
! @@                                                                @@ !
! @@  Contact address: Phase System Consortium                      @@ !
! @@                                                                @@ !
! @@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@ !

program ascot_main

  use condition_ini
  use scf_negf
  use mod_mpi

  implicit none
  include 'mpif.h'

    integer       :: iargc
    character(50) :: calc_t_negfordft
    character(50) :: file_name

      call MPI_INIT(ierr)
      call MPI_COMM_SIZE(mpi_comm_world,nprocs,ierr)
      call MPI_COMM_RANK(mpi_comm_world,myrank,ierr)

      call MPI__Initialize__ASCOT

      call alo_tempout
      call gen_outf

!                       ------------------------------------                       !

      open(unit=16,file=file_tempout,position='append')
        write(16,*) ':-:-:-:-:-:-:-:-:-:-:-:-:-:-:-::-:-:-:-:-:-:-:-:-:-:-:-:-:-:-:'
        write(16,*) ':-:-:-:-:-:-:-:-:-:-:-:-:-:-:-::-:-:-:-:-:-:-:-:-:-:-:-:-:-:-:'
        write(16,*) ':-:-:-:-:-:-:-:-:                            :-:-:-:-:-:-:-:-:'
        write(16,*) ':-:-:-:-:-:-:-:-: Welcome to ASCOT ver. 4.4  :-:-:-:-:-:-:-:-:'
        write(16,*) ':-:-:-:-:-:-:-:-:                            :-:-:-:-:-:-:-:-:'
        write(16,*) ':-:-:-:-:-:-:-:-:-:-:-:-:-:-:-::-:-:-:-:-:-:-:-:-:-:-:-:-:-:-:'
        write(16,*) ':-:-:-:-:-:-:-:-:-:-:-:-:-:-:-::-:-:-:-:-:-:-:-:-:-:-:-:-:-:-:'
      close(16)

!                       ------------------------------------                       !

      if( myrank == 0 ) then
         if( iargc() >= 1 ) then
           call getarg(1,file_name)
         else
           file_name = ""
         end if
      end if
      call MPI_Bcast( file_name, 50, MPI_CHARACTER, 0, MPI_COMM_WORLD, ierr )
      if( file_name == "" ) then
         open(unit=16,file=file_tempout,position='append')
           write(16,*) '    ??? inputfile ???'
         close(16)
         call MPI_FINALIZE(ierr)
         stop
      end if

      call get_negfordft(file_name,calc_t_negfordft)

      if( calc_t_negfordft == 'dft' .or. calc_t_negfordft == 'DFT' ) then
        call ac_main(file_name)
        call MPI_FINALIZE(ierr)
        stop
      end if

      if( calc_t_negfordft /= 'negf' .and. calc_t_negfordft /= 'NEGF' ) then
        open(unit=16,file=file_tempout,position='append')
          write(16,*) '    +++++ error:: calc_type -  ',calc_t_negfordft
        close(16)
        stop
      end if

      call set_parameter(file_name)

!                       ------------------------------------                       !

      call set_condition_l
      if( switch_l_eigen == 'on' .or. dos_on_off_ini_l == 'on' ) then
        call set_chemical_potential(1)
        if( myrank == 0 ) then
          call print_text_l
        end if
      end if
      call save_hamiltonian_sgf_l
      call unset_condition_l

!                       ------------------------------------                       !

      call set_condition_r
      if( switch_r_eigen == 'on' .or. dos_on_off_ini_r == 'on' ) then
        call set_chemical_potential(2)
        if( myrank == 0 ) then
          call print_text_r
        end if
      end if
      call save_hamiltonian_sgf_r
      call unset_condition_r

!                       ------------------------------------                       !

      if( calc_type /= 'off' ) then
        if( ham_model_ini /= 'input' .and. ham_model_ini /= 'scf_accel' ) then
          call set_locate_atom
          call set_hami_c_pre
        end if
        call set_for_gf_se_c

        if( ham_model_ini == 'scf_accel' ) then
          call scf_main_negf_ac
        end if

        if( calc_type /= 'scf_only' ) then
          if( file_selfenergy == 'none' .or. file_selfe_outsw /= 'on' ) then
            call cal_gf_se_c
          else
            call cal_gf_se_read             ! Self-energies : from input file.
          end if
          if( myrank == 0 ) then
            call output_print
          end if
        end if
        call unset_for_gf_se_c
        if( ham_model_ini == 'scf_accel') then
          call scf_main_unset_negf
        end if
      end if

!                       ------------------------------------                       !

      open(unit=16,file=file_tempout,position='append')
          write(16,*)
          write(16,*)                                                              &
                    '******************** ******************** ********************'
          write(16,*)                                                              &
                    '*                        output files                        *'
          write(16,*)                                                              &
                    '******************** ******************** ********************'
          write(16,*)
        if( ham_model_ini == 'scf_accel' ) then
          write(16,*)                                                              &
                    '                             charge at site -> charge_open.dat'
          write(16,*) '                                  V_hartree -> negf_vh.cube'
          write(16,*)                                                              &
                    '                                      V_tot -> negf_vtot*.cube'
          write(16,*)'                                    density -> negf_den*.cube'
          if( force_calc_onoff == 'on' ) then
            write(16,*)                                                            &
                    '                                      force -> force_negf.dat'
          end if
        end if
        if( calc_type /= 'off' .and. calc_type /= 'scf_only' ) then
          if( calc_type == 'trans' ) then
            write(16,*) '                transmission against energy -> trans.dat'
            write(16,*) '          LDOS of all system against energy -> em_gf.dat'
            write(16,*) '     trace of the surface GF against energy -> sf_gf*.dat'
          end if
          if( calc_type == 'iv' ) then
            write(16,*) '                              current value -> iv.dat'
          end if
          if( switch_out_gf /= 'off' ) then
            if( switch_out_gf == 'all' ) then
              write(16,*)
              write(16,*) '                                     G(E) S -> gfc*.data'
            else
              write(16,*)
              write(16,*) '                diagonal elements of G(E) S -> gfc*.data'
            end if
          end if
          if( switch_out_tr /= 'off' ) then
            if( switch_out_tr == 'all' ) then
              write(16,*) '                                       G(E) -> ftg*.data'
              write(16,*) '                                   Gamma(E) -> gam*.data'
            else
              if( switch_out_tr == 'tr' ) then
                write(16,*)                                                        &
                          '                                       T(E) -> tra*.data'
              else
                write(16,*)                                                        &
                          '                  diagonal elements of T(E) -> tra*.data'
              end if
            end if
          end if
          if( switch_out_ham /= 'off' ) then
            write(16,*) '                         Hamiltonian matrix -> ham*.data'
          end if
          if( file_selfe_outsw /= 'off' .and. file_selfenergy == 'none' ) then
            write(16,*) '                        data of self energy -> sel.data*'
          end if
          write(16,*)
        end if
        if( switch_l_eigen == 'on' ) then
          write(16,*) '          band structure of left electrode  -> ev_l.dat'
        end if
        if( switch_r_eigen == 'on' ) then
          write(16,*) '          band structure of right electrode -> ev_r.dat'
        end if
        if( dos_on_off_ini_l == 'on' ) then
          write(16,*) '                     DOS of left electrode  -> nogf_l.dat'
        end if
        if( dos_on_off_ini_r == 'on' ) then
          write(16,*) '                     DOS of right electrode -> nogf_r.dat'
        end if
        write(16,*)
        write(16,*) ':-:-:-:-:-:-:-:-:-:-:-:-:-:-:-::-:-:-:-:-:-:-:-:-:-:-:-:-:-:-:'
        write(16,*) ':-:-:-:-:-:-:-:-:-:-:-:-:-:-:-::-:-:-:-:-:-:-:-:-:-:-:-:-:-:-:'
        write(16,*) ':-:-:-:-:-:-:-:-:                            :-:-:-:-:-:-:-:-:'
        write(16,*) ':-:-:-:-:-:-:-:-:           finished         :-:-:-:-:-:-:-:-:'
        write(16,*) ':-:-:-:-:-:-:-:-:                            :-:-:-:-:-:-:-:-:'
        write(16,*) ':-:-:-:-:-:-:-:-:-:-:-:-:-:-:-::-:-:-:-:-:-:-:-:-:-:-:-:-:-:-:'
        write(16,*) ':-:-:-:-:-:-:-:-:-:-:-:-:-:-:-::-:-:-:-:-:-:-:-:-:-:-:-:-:-:-:'
        write(16,*)
      close(16)

!                       ------------------------------------                       !

      call unset

!                       ------------------------------------                       !

      call MPI_FINALIZE(ierr)

  stop
end program ascot_main
