! @@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@ !
! @@                                                                @@ !
! @@       PROGRAM  ASCOT 2014.440 (ver.4.53)                       @@ !
! @@     "Abinitio Simulation Code for Quantum Transport"           @@ !
! @@                                                                @@ !
! @@                                                                @@ !
! @@  AUTHOR(S): Hisashi KONDO (Univ. Tokyo)                        @@ !
! @@                                                09/May/2014     @@ !
! @@                                                                @@ !
! @@  Contact address: Phase System Consortium                      @@ !
! @@                                                                @@ !
! @@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@ !

subroutine set_fft

  use scf_negf
  use fft

  implicit none
  integer :: i_do,j_do,i_temp,j_temp,ier
  integer, allocatable :: n(:)

  call alo_fft_1(n_a,n_b)
  call alo_fft_21(n_a)
  call alo_fft_22(n_b)

  if( ft_switch == 'fft' ) then
     return
  end if

  allocate(n(4),stat=ier)
  if( ier /= 0 ) then
     write(6,*) 'error allocate: set_fft'
     stop
  end if

  n(1)=7
  n(2)=5
  n(3)=3
  n(4)=2

  i_temp=n_a
  ix_fft=1
  j_temp=1
  do j_do=1,100
     do i_do=1,4
        if( mod(i_temp,n(i_do)) == 0 ) then
           if( ix_fft > j_temp ) then
              j_temp=j_temp*n(i_do)
           else
              ix_fft=ix_fft*n(i_do)
           end if
           i_temp=i_temp/n(i_do)
           exit
        end if
     end do
     if( i_temp == 1 ) then
        exit
     end if
  end do

  i_temp=n_b
  iy_fft=1
  j_temp=1
  do j_do=1,100
     do i_do=1,4
        if( mod(i_temp,n(i_do)) == 0 ) then
           if( iy_fft > j_temp ) then
              j_temp=j_temp*n(i_do)
           else
              iy_fft=iy_fft*n(i_do)
           end if
           i_temp=i_temp/n(i_do)
           exit
        end if
     end do
     if( i_temp == 1 ) then
        exit
     end if
  end do

  i_temp=n_c
  iz_fft=1
  j_temp=1
  do j_do=1,100
     do i_do=1,4
        if( mod(i_temp,n(i_do)) == 0 ) then
           if( iz_fft > j_temp ) then
              j_temp=j_temp*n(i_do)
           else
              iz_fft=iz_fft*n(i_do)
           end if
           i_temp=i_temp/n(i_do)
           exit
        end if
     end do
     if( i_temp == 1 ) then
        exit
     end if
  end do

  i_temp=n_c_l
  iz_fft_l=1
  j_temp=1
  do j_do=1,100
     do i_do=1,4
        if( mod(i_temp,n(i_do)) == 0 ) then
           if( iz_fft_l > j_temp ) then
              j_temp=j_temp*n(i_do)
           else
              iz_fft_l=iz_fft_l*n(i_do)
           end if
           i_temp=i_temp/n(i_do)
           exit
        end if
     end do
     if( i_temp == 1 ) then
        exit
     end if
  end do

  i_temp=n_c_r
  iz_fft_r=1
  j_temp=1
  do j_do=1,100
     do i_do=1,4
        if( mod(i_temp,n(i_do)) == 0 ) then
           if( iz_fft_r > j_temp ) then
              j_temp=j_temp*n(i_do)
           else
              iz_fft_r=iz_fft_r*n(i_do)
           end if
           i_temp=i_temp/n(i_do)
           exit
        end if
     end do
     if( i_temp == 1 ) then
        exit
     end if
  end do

  deallocate(n,stat=ier)
  if( ier /= 0 ) then
     write(6,*) 'error allocate: set_fft'
     stop
  end if

  return
end subroutine set_fft

subroutine unset_fft

  use scf_negf
  use fft

  call unset_fft_1
  call unset_fft_21
  call unset_fft_22

  return
end subroutine unset_fft
