! @@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@ !
! @@                                                                @@ !
! @@       PROGRAM  ASCOT 2014.440 (ver.4.53)                       @@ !
! @@     "Abinitio Simulation Code for Quantum Transport"           @@ !
! @@                                                                @@ !
! @@                                                                @@ !
! @@  AUTHOR(S): Hisashi KONDO (Univ. Tokyo)                        @@ !
! @@             Naoki WATANABE (Mizuho I.R.)                       @@ !
! @@             Nobutaka NISHIKAWA (Mizuho I.R.)                   @@ !
! @@                                                09/May/2014     @@ !
! @@                                                                @@ !
! @@  Contact address: Phase System Consortium                      @@ !
! @@                                                                @@ !
! @@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@ !

module surface_green_function

  implicit none
  complex(8), pointer :: gr00(:,:),gr01(:,:),gr02(:,:),temp(:,:)
  complex(8), pointer :: tr1(:,:),tr2(:,:),tm(:,:),tm_temp(:,:)
  complex(8), pointer :: es0(:,:),e00(:,:),alp(:,:),bet(:,:)

contains
  subroutine alo_surface_gf_transefer(descCC)
    use ac_mpi_module

    implicit none
    type(MPI_MatDesc), intent(in) :: descCC

    integer :: ier

    allocate(gr00(descCC%nrow, descCC%scol:descCC%ecol),stat=ier)
    allocate(gr01(descCC%nrow, descCC%scol:descCC%ecol),stat=ier)
    allocate(gr02(descCC%nrow, descCC%scol:descCC%ecol),stat=ier)
    allocate( tr1(descCC%nrow, descCC%scol:descCC%ecol),stat=ier)
    allocate( tr2(descCC%nrow, descCC%scol:descCC%ecol),stat=ier)
    allocate(  tm(descCC%nrow, descCC%scol:descCC%ecol),stat=ier)
    allocate(tm_temp(descCC%nrow, descCC%scol:descCC%ecol),stat=ier)
    allocate(temp(descCC%nrow, descCC%scol:descCC%ecol),stat=ier)
    if( ier /= 0 ) then
       write(6,*) 'error allocate: alo_surface_gf_transefer'
       stop
    end if

    return
  end subroutine alo_surface_gf_transefer

  subroutine unset_surface_gf_transefer

    implicit none
    integer :: ier

    deallocate(gr00,gr01,gr02,tr1,tr2,tm,tm_temp,temp,stat=ier)
    if( ier /= 0 ) then
       write(6,*) 'error deallocate: unset_surface_gf_transefer'
       stop
    end if

    return
  end subroutine unset_surface_gf_transefer

  subroutine alo_surface_gf_direct(descCC)
    use ac_mpi_module

    implicit none
    type(MPI_MatDesc), intent(in) :: descCC
    integer :: ier

    allocate(gr00(descCC%nrow, descCC%scol:descCC%ecol),stat=ier)
    allocate(gr01(descCC%nrow, descCC%scol:descCC%ecol),stat=ier)
    allocate(gr02(descCC%nrow, descCC%scol:descCC%ecol),stat=ier)
    allocate(es0(descCC%nrow, descCC%scol:descCC%ecol),stat=ier)
    allocate(e00(descCC%nrow, descCC%scol:descCC%ecol),stat=ier)
    allocate(alp(descCC%nrow, descCC%scol:descCC%ecol),stat=ier)
    allocate(bet(descCC%nrow, descCC%scol:descCC%ecol),stat=ier)
    allocate(temp(descCC%nrow, descCC%scol:descCC%ecol),stat=ier)
    if( ier /= 0 ) then
       write(6,*) 'error allocate: alo_surface_gf_direct'
       stop
    end if

    return
  end subroutine alo_surface_gf_direct

  subroutine unset_surface_gf_direct

    implicit none
    integer :: ier

    deallocate(gr00,gr01,gr02,es0,e00,alp,bet,temp,stat=ier)
    if( ier /= 0 ) then
       write(6,*) 'error deallocate: unset_surface_gf_direct'
       stop
    end if

    return
  end subroutine unset_surface_gf_direct
end module surface_green_function
