! @@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@ !
! @@                                                                @@ !
! @@       PROGRAM  ASCOT 2014.440 (ver.4.53)                       @@ !
! @@     "Abinitio Simulation Code for Quantum Transport"           @@ !
! @@                                                                @@ !
! @@                                                                @@ !
! @@  AUTHOR(S): Hisashi KONDO (Univ. Tokyo)                        @@ !
! @@             Naoki WATANABE (Mizuho I.R.)                       @@ !
! @@             Nobutaka NISHIKAWA (Mizuho I.R.)                   @@ !
! @@                                                09/May/2014     @@ !
! @@                                                                @@ !
! @@  Contact address: Phase System Consortium                      @@ !
! @@                                                                @@ !
! @@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@ !

module mod_mpi

  implicit none
  character(50) :: file_tempout
  character(50), pointer :: file_sf_scf(:,:,:,:) 
  character(50), pointer :: file_sf_tr(:,:) 

contains
  subroutine alo_mod_sftr(kt,file_selfenergy)
    use ac_mpi_module

    implicit none
    integer, intent(in) :: kt
    character(50), intent(in) :: file_selfenergy
    character(1) :: character_temp(4),character_temk(4),a(10)
    character(50) :: filename_temp
    character(60) :: filename_com
    integer :: i1,i2,k1,i_temp1,i_temp2,ier
    integer :: k, p

    if( file_selfenergy == 'none' ) then
       filename_temp='sel.data'
       filename_temp=adjustr(filename_temp)
    else
       filename_temp=adjustr(file_selfenergy)
    end if

    allocate(file_sf_tr(kt,0:MPI%size2-1),stat=ier)
    if( ier /= 0 ) then
       write(6,*) 'error allocate: lo_mod_sftr'
       stop
    end if


    do k=1, kt
       do p=0, MPI%size2-1
          write( filename_com,'("_k",i4.4,"_p",i4.4)') k, p

          file_sf_tr(k,p) = adjustl(trim(filename_temp)//filename_com)
       end do
    end do


    return
  end subroutine alo_mod_sftr

  subroutine dealo_mod_sftr

    implicit none
    integer :: ier

    deallocate(file_sf_tr,stat=ier)
    if( ier /= 0 ) then
       write(6,*) 'error allocate: delo_mod_sftr'
       stop
    end if

    return
  end subroutine dealo_mod_sftr

  subroutine alo_tempout
    use ac_mpi_module
    implicit none
    character(1) :: character_temp(4),a(10)
    integer :: i2,i_temp1,i_temp2
    character(50) :: filename_temp
    character(60) :: filename_com

    integer :: p

    filename_temp = "g.output"
    p = MPI%rank2

    write( filename_com,'("_p",i4.4)') p

    file_tempout = adjustl(trim(filename_temp)//filename_com)


    return
  end subroutine alo_tempout

  subroutine alo_mod_mpi(iw,ispin,kt,file_selfenergy_scf)
    use ac_mpi_module

    implicit none
    integer, intent(in) :: iw,ispin,kt
    character(50), intent(in) :: file_selfenergy_scf
    character(1) :: character_temp(4),character_temk(4),a(10)
    character(50) :: filename_temp
    character(60) :: filename_com
    integer :: i1,i2,i3,k1,i_temp1,i_temp2,ier
    integer :: s, k, w, p

    if( file_selfenergy_scf == 'none' ) then
       filename_temp='sel.in'
       filename_temp=adjustr(filename_temp)
    else
       filename_temp=adjustr(file_selfenergy_scf)
    end if

    allocate(file_sf_scf(ispin,kt,iw,0:MPI%size2-1),stat=ier)
    if( ier /= 0 ) then
       write(6,*) 'error allocate: alo_mod_mpi'
       stop
    end if

    do s=1,ispin
       do k=1, kt
          do w=1, iw
             do p=0, MPI%size2-1
                write( filename_com,'("_k",i4.4,"_s",i1.1,"_w",i4.4,"_p",i4.4)') &
                     k, s, w, p

                file_sf_scf(s,k,w,p) = adjustl(trim(filename_temp)//filename_com)

             end do
          end do
       end do
    end do


    return
  end subroutine alo_mod_mpi

  subroutine dealo_mod_mpi

    implicit none
    integer :: ier

    deallocate(file_sf_scf,stat=ier)
    if( ier /= 0 ) then
       write(6,*) 'error allocate: dealo_mod_mpi'
       stop
    end if

    return
  end subroutine dealo_mod_mpi

end module mod_mpi
