! @@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@ !
! @@                                                                @@ !
! @@       PROGRAM  ASCOT 2014.440 (ver.4.53)                       @@ !
! @@     "Abinitio Simulation Code for Quantum Transport"           @@ !
! @@                                                                @@ !
! @@                                                                @@ !
! @@  AUTHOR(S): Hisashi KONDO (Univ. Tokyo)                        @@ !
! @@                                                09/May/2014     @@ !
! @@                                                                @@ !
! @@  Contact address: Phase System Consortium                      @@ !
! @@                                                                @@ !
! @@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@ !

module condition_ini

  implicit none
  character(50) :: file_parameter
  character(50) :: file_parameter_co
  character(50) :: file_parameter_tb_par
  character(50) :: file_parameter1
  character(50) :: file_parameter2
  character(50) :: file_parameter3
  character(50) :: file_selfenergy
  character(50) :: file_selfe_outsw

  integer :: num_atom_kind_ini
  integer :: iteration_max_ini
  real(8) :: eps_ini
  character(50) :: sgf_method_ini
  character(50) :: ham_model_ini
  integer, pointer :: atom_orbital_ini(:)
  integer, pointer :: atom_num_ini(:)
  integer, pointer :: atom_electron_ini(:)
  real(8), pointer :: atom_mass_ini(:)
  character(4), pointer :: atom_sign_ini(:)

  integer :: method_sum_om
  integer :: om_block_num
  integer :: num_gra
  integer, pointer :: num_om_par(:)
  complex(8), pointer :: omega_if(:,:)
  character(50), pointer :: om_con_method(:)

  integer :: num_iv_mesh
  real(8) :: om_sum
  character(50) :: calc_type
  character(50) :: dos_on_off_ini_l,dos_on_off_ini_r
  character(50) :: eigen_s_as_ini
  character(50) :: switch_l_eigen
  character(50) :: switch_r_eigen
  character(50) :: switch_out_gf,switch_out_tr,switch_out_ham

  integer :: num_atom_l
  integer :: neighbor_x_max_l
  integer :: neighbor_y_max_l
  integer :: neighbor_z_max_l
  integer :: kx_max_l
  integer :: ky_max_l
  integer :: kz_max_l
  integer :: num_unit_l(3)
  real(8) :: v_l
  real(8) :: unit_block_l(3,3)
  character(50) :: p_or_f_l
  integer, pointer :: atom_kindn_l(:)
  integer, pointer :: pair_num_l(:,:)
  real(8), pointer :: ra_l(:,:)
  character(4), pointer :: atom_kind_l(:)

  integer :: num_atom_r
  integer :: neighbor_x_max_r
  integer :: neighbor_y_max_r
  integer :: neighbor_z_max_r
  integer :: kx_max_r
  integer :: ky_max_r
  integer :: kz_max_r
  integer :: num_unit_r(3)
  real(8) :: v_r
  real(8) :: unit_block_r(3,3)
  character(50) :: p_or_f_r
  integer, pointer :: atom_kindn_r(:)
  integer, pointer :: pair_num_r(:,:)
  real(8), pointer :: ra_r(:,:)
  character(4), pointer :: atom_kind_r(:)

  integer :: num_atom_c
  integer :: m_num_block_l
  integer :: m_num_block_m
  integer :: m_num_block_r
  real(8) :: r_dis_l
  real(8) :: r_dis_r
  real(8) :: unit_block_c(3,3)
  real(8) :: v_c
  integer, pointer :: atom_kindn_c(:)
  integer, pointer :: pair_num_cl(:,:)
  integer, pointer :: pair_num_cc(:,:)
  integer, pointer :: pair_num_cr(:,:)
  real(8), pointer :: ra_c(:,:)
  character(4), pointer :: atom_kind_c(:)

  real(8) :: cur_ene
  real(8) :: cur_om
  real(8) :: cur_l
  real(8) :: cur_r
  character(10) :: cur_lr

  character(50) :: filename_kpoint
  integer :: ka_tr,kb_tr

contains
  subroutine alo_input_condition_1

    implicit none
    integer :: ier

    allocate(atom_sign_ini(num_atom_kind_ini),atom_num_ini(num_atom_kind_ini)    &
         ,atom_mass_ini(num_atom_kind_ini)                                    &
         ,atom_electron_ini(num_atom_kind_ini)                                &
         ,atom_orbital_ini(num_atom_kind_ini),stat=ier)
    if( ier /= 0 ) then
       write(6,*) 'error allocate: alo_input_condition_1'
       stop
    end if

    return
  end subroutine alo_input_condition_1

  subroutine alo_input_condition_2

    implicit none
    integer :: ier

    allocate(num_om_par(om_block_num),om_con_method(om_block_num)                &
         ,omega_if(om_block_num,2),stat=ier)
    if( ier /= 0 ) then
       write(6,*) 'error allocate: alo_input_condition_2'
       stop
    end if

    return
  end subroutine alo_input_condition_2

  subroutine alo_input_condition_3

    implicit none
    integer :: ier

    allocate(ra_l(num_atom_l,3),atom_kind_l(num_atom_l)                          &
         ,atom_kindn_l(num_atom_l),stat=ier)
    if( ier /= 0 ) then
       write(6,*) 'error allocate: alo_input_condition_3'
       stop
    end if

    return
  end subroutine alo_input_condition_3

  subroutine alo_input_condition_4

    implicit none
    integer :: ier

    allocate(ra_r(num_atom_r,3),atom_kind_r(num_atom_r)                          &
         ,atom_kindn_r(num_atom_r),stat=ier)
    if( ier /= 0 ) then
       write(6,*) 'error allocate: alo_input_condition_4'
       stop
    end if

    return
  end subroutine alo_input_condition_4

  subroutine alo_input_condition_5

    implicit none
    integer :: ier

    allocate(ra_c(num_atom_c,3),atom_kind_c(num_atom_c)                          &
         ,atom_kindn_c(num_atom_c),stat=ier)
    if( ier /= 0 ) then
       write(6,*) 'error allocate: alo_input_condition_5'
       stop
    end if

    return
  end subroutine alo_input_condition_5

  subroutine alo_pair_ini                                            ! for GSP model

    implicit none
    integer :: ier

    allocate(pair_num_l(num_atom_l,num_atom_l),pair_num_r(num_atom_r,num_atom_r) &
         ,pair_num_cl(num_atom_c,num_atom_l),pair_num_cc(num_atom_c,num_atom_c) &
         ,pair_num_cr(num_atom_c,num_atom_r),stat=ier)
    if( ier /= 0 ) then
       write(6,*) 'error allocate: alo_pair_ini'
       stop
    end if

    return
  end subroutine alo_pair_ini

  subroutine unset_condition_ini

    implicit none
    integer :: ier

    deallocate(atom_sign_ini,atom_num_ini,atom_mass_ini,atom_electron_ini        &
         ,atom_orbital_ini                                                   &
         ,ra_l,atom_kind_l,atom_kindn_l,ra_r,atom_kind_r,atom_kindn_r        &
         ,ra_c,atom_kind_c,atom_kindn_c,stat=ier)
    if( ier /= 0 ) then
       write(6,*) 'error deallocate: unset_condition_ini'
       stop
    end if

    return
  end subroutine unset_condition_ini

  subroutine unset_condition_ini_1

    implicit none
    integer :: ier

    deallocate(num_om_par,om_con_method,omega_if,stat=ier)
    if( ier /= 0 ) then
       write(6,*) 'error deallocate: unset_condition_ini'
       stop
    end if

    return
  end subroutine unset_condition_ini_1

  subroutine unset_pair_ini                                          ! for GSP model

    implicit none
    integer :: ier

    deallocate(pair_num_l,pair_num_r,pair_num_cl,pair_num_cc,pair_num_cr         &
         ,stat=ier)
    if( ier /= 0 ) then
       write(6,*) 'error deallocate: unset_pair_ini'
       stop
    end if

    return
  end subroutine unset_pair_ini

end module condition_ini
