! @@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@ !
! @@                                                                @@ !
! @@       PROGRAM  ASCOT 2014.440 (ver.4.53)                       @@ !
! @@     "Abinitio Simulation Code for Quantum Transport"           @@ !
! @@                                                                @@ !
! @@                                                                @@ !
! @@  AUTHOR(S): Hisashi KONDO (Univ. Tokyo)                        @@ !
! @@             Naoki WATANABE (Mizuho I.R.)                       @@ !
! @@             Nobutaka NISHIKAWA (Mizuho I.R.)                   @@ !
! @@                                                09/May/2014     @@ !
! @@                                                                @@ !
! @@  Contact address: Phase System Consortium                      @@ !
! @@                                                                @@ !
! @@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@ !

subroutine green_function_scf(descCC,w,w_weight,iw_do,px,py,qx,qy,ispin)

  use scf_negf
  use hamiltonian_sgf
  use hamiltonian_c
  use gf_se_c
  use constant
  use condition_ini
  use ac_mpi_module

  implicit none
  type(MPI_MatDesc), intent(in) :: descCC
  integer, intent(in) :: iw_do,ispin
  integer, intent(in) :: px,py,qx,qy
  complex(8), intent(in) :: w,w_weight

  integer :: i1_do,i2_do,ier
  complex(8), allocatable :: amat_temp6(:,:),bmat_temp6(:,:),cmat_temp6(:,:)

  integer :: i, j

  allocate(amat_temp6(descCC%nrow, descCC%scol:descCC%ecol),stat=ier)
  allocate(bmat_temp6(descCC%nrow, descCC%scol:descCC%ecol),stat=ier)
  if( ier /= 0 ) then
     write(6,*) 'error allocate: green_function_scf 1'
     stop
  end if

  bmat_temp6(:,:) = w*s_cc_scf(:,:) - h_cc_scf(:,:,ispin)

  amat_temp6(:,:) = se_l_mat_per(:,:,px,py) + se_r_mat_per(:,:,qx,qy) 

  bmat_temp6(:,:) = bmat_temp6(:,:) - amat_temp6(:,:)

  call MPI__ZGETRI_ASCOT( descCC, bmat_temp6 )

  allocate(cmat_temp6(descCC%nrow, descCC%scol:descCC%ecol),stat=ier)

  if( i_bios_omega_scf(iw_do) == 1 ) then
     cmat_temp6(:,:) = bmat_temp6(:,:)*w_weight
     amat_temp6(:,:) = cmat_temp6(:,:)

     call MPI__ZTRANC_ASCOT( descCC, C1, cmat_temp6, C1, amat_temp6 ) 

     cdens(:,:,ispin) = cdens(:,:,ispin) + cmat_temp6(:,:)
  else
     if( dreal(w) <= cp_l ) then
        cmat_temp6(:,:) = -se_l_mat_per(:,:,px,py) 
        amat_temp6(:,:) = +se_l_mat_per(:,:,px,py) 

        call MPI__ZTRANC_ASCOT( descCC, C1, cmat_temp6, C1, amat_temp6 ) 
     else
        cmat_temp6(:,:)=dcmplx(0.d0,0.d0)
     end if

     if( dreal(w) <= cp_r ) then
        cmat_temp6(:,:) = -se_r_mat_per(:,:,qx,qy) + cmat_temp6(:,:)  
        amat_temp6(:,:) = +se_r_mat_per(:,:,px,py) 

        call MPI__ZTRANC_ASCOT( descCC, C1, cmat_temp6, C1, amat_temp6 ) 
     end if

     call MPI__ZGEMM_ASCOT( 'N', 'N', descCC, &
          C1, bmat_temp6, cmat_temp6, C0, amat_temp6 )

     call MPI__ZGEMM_ASCOT( 'N', 'C', descCC, &
          C1, amat_temp6, bmat_temp6, C0, cmat_temp6 )

     cmat_temp6(:,:) = cmat_temp6(:,:)*w_weight

     cdens(:,:,ispin) = cdens(:,:,ispin) + cmat_temp6(:,:)
  end if

  deallocate(amat_temp6,bmat_temp6,cmat_temp6,stat=ier)
  if( ier /= 0 ) then
     write(6,*) 'error deallocate: green_function_scf 3'
     stop
  end if

  return
end subroutine green_function_scf

subroutine calc_edm(descCC,ispin)

  use scf_negf
  use hamiltonian_sgf
  use hamiltonian_c
  use gf_se_c
  use constant
  use condition_ini
  use ac_mpi_module

  implicit none
  type(MPI_MatDesc), intent(in) :: descCC
  integer, intent(in) :: ispin

  integer :: i1_do,i2_do,ier
  complex(8), allocatable :: amat_temp6(:,:),bmat_temp6(:,:)
  complex(8), allocatable :: cmat_temp6(:,:),dmat_temp6(:,:)

  integer :: i, j

  allocate(amat_temp6(descCC%nrow, descCC%scol:descCC%ecol),stat=ier)
  allocate(bmat_temp6(descCC%nrow, descCC%scol:descCC%ecol),stat=ier)
  allocate(cmat_temp6(descCC%nrow, descCC%scol:descCC%ecol),stat=ier)
  allocate(dmat_temp6(descCC%nrow, descCC%scol:descCC%ecol),stat=ier)
  if( ier /= 0 ) then
     write(6,*) 'error allocate: green_function_scf 1'
     stop
  end if

  call alo_hami_c3(descCC)
  call set_hami_c_cc_scf(descCC,ispin)

  bmat_temp6(:,:) = scc_mat(:,:)

  call MPI__ZGETRI_ASCOT( descCC, bmat_temp6 )

  amat_temp6(:,:) = hcc_mat(:,:)

  call unset_hami_c31
  call unset_hami_c32

  call MPI__ZGEMM_ASCOT( 'N', 'N', descCC, &
       C1, bmat_temp6, amat_temp6, C0, cmat_temp6 )

  call MPI__ZGEMM_ASCOT( 'N', 'N', descCC, &
       C1, amat_temp6, bmat_temp6, C0, dmat_temp6 )

  amat_temp6(:,:) = cdens(:,:,ispin)*0.5d0

  call MPI__ZGEMM_ASCOT( 'N', 'N', descCC, &
       C1, cmat_temp6, amat_temp6, C0, bmat_temp6 )

  edens(:,:,ispin) = edens(:,:,ispin) + bmat_temp6(:,:)

  call MPI__ZGEMM_ASCOT( 'N', 'N', descCC, &
       C1, amat_temp6, dmat_temp6, C0, bmat_temp6 )

  edens(:,:,ispin) = edens(:,:,ispin) + bmat_temp6(:,:)

  deallocate(amat_temp6,bmat_temp6,cmat_temp6,dmat_temp6,stat=ier)
  if( ier /= 0 ) then
     write(6,*) 'error deallocate: green_function_scf 3'
     stop
  end if

  return
end subroutine calc_edm
