! @@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@ !
! @@                                                                @@ !
! @@       PROGRAM  ASCOT 2014.440 (ver.4.40)                       @@ !
! @@     "Abinitio Simulation Code for Quantum Transport"           @@ !
! @@                                                                @@ !
! @@                                                                @@ !
! @@  AUTHOR(S): Hisashi KONDO (Univ. Tokyo)                        @@ !
! @@                                                09/May/2014     @@ !
! @@                                                                @@ !
! @@  Contact address: Phase System Consortium                      @@ !
! @@                                                                @@ !
! @@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@ !

module rtbh_parameter

  implicit none
  real(8) :: a,b,r1,r2
  character(4), pointer :: atomh_parameter(:)
  real(8), pointer :: v_ss(:),v_ps(:),v_pp(:),v_ds(:),v_dp(:),v_dd(:)
  real(8), pointer :: u_ss(:),u_ps(:),u_pp(:),u_ds(:),u_dp(:),u_dd(:)
  real(8), pointer :: r_ss(:),r_ps(:),r_pp(:),r_ds(:),r_dp(:),r_dd(:)
  real(8), pointer :: h_s(:),h_p(:),h_d(:)

contains
  subroutine alo_rtbh_parameter(num_atom_kind)

    implicit none
    integer, intent(in) :: num_atom_kind
    integer :: i_temp,ier

    i_temp=num_atom_kind

    allocate(v_ss(i_temp),v_ps(i_temp),v_pp(i_temp),v_ds(i_temp),v_dp(i_temp)    &
         ,v_dd(i_temp),u_ss(i_temp),u_ps(i_temp),u_pp(i_temp),u_ds(i_temp)    &
         ,u_dp(i_temp),u_dd(i_temp),r_ss(i_temp),r_ps(i_temp),r_pp(i_temp)    &
         ,r_ds(i_temp),r_dp(i_temp),r_dd(i_temp),h_s(i_temp),h_p(i_temp)      &
         ,h_d(i_temp),atomh_parameter(i_temp),stat=ier)
    if( ier /= 0 ) then
       write(6,*) 'error allocate: alo_rtbh_parameter'
       stop
    end if

    return
  end subroutine alo_rtbh_parameter

  subroutine unset_rtbh_parameter

    implicit none
    integer :: ier

    deallocate(atomh_parameter,v_ss,v_ps,v_pp,v_ds,v_dp,v_dd,u_ss,u_ps,u_pp      &
         ,u_ds,u_dp,u_dd,r_ss,r_ps,r_pp,r_ds,r_dp,r_dd,h_s,h_p,h_d            &
         ,stat=ier)
    if( ier /= 0 ) then
       write(6,*) 'error deallocate: unset_rtbh_parameter'
       stop
    end if

    return
  end subroutine unset_rtbh_parameter
end module rtbh_parameter
