! @@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@ !
! @@                                                                @@ !
! @@       PROGRAM  ASCOT 2014.440 (ver.4.40)                       @@ !
! @@     "Abinitio Simulation Code for Quantum Transport"           @@ !
! @@                                                                @@ !
! @@                                                                @@ !
! @@  AUTHOR(S): Hisashi KONDO (Univ. Tokyo)                        @@ !
! @@                                                09/May/2014     @@ !
! @@                                                                @@ !
! @@  Contact address: Phase System Consortium                      @@ !
! @@                                                                @@ !
! @@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@ !

subroutine mat_mul(mat_max,amat_in_1,amat_in_2,amat_out)

  implicit none
  integer, intent(in) :: mat_max
  complex(8), intent(in) :: amat_in_1(mat_max,mat_max)
  complex(8), intent(in) :: amat_in_2(mat_max,mat_max)
  complex(8), intent(out) :: amat_out(mat_max,mat_max)
  integer :: mat1_do,mat2_do,i_do

  do mat2_do=1,mat_max
     do mat1_do=1,mat_max
        amat_out(mat1_do,mat2_do)=dcmplx(0.d0,0.d0)
     end do
  end do

  do mat2_do=1,mat_max
     do i_do=1,mat_max
        do mat1_do=1,mat_max
           amat_out(mat1_do,mat2_do)=amat_out(mat1_do,mat2_do)                    &
                +amat_in_1(mat1_do,i_do)*amat_in_2(i_do,mat2_do)
        end do
     end do
  end do

  return
end subroutine mat_mul

subroutine mat_mul2(mat_max1,mat_max2,mat_max3,mat_max4,mat_max5,mat_max6          &
     ,amat_in_1,amat_in_2,amat_out)

  implicit none
  integer, intent(in) :: mat_max1,mat_max2,mat_max3,mat_max4,mat_max5,mat_max6
  complex(8), intent(in) :: amat_in_1(mat_max1,mat_max2)
  complex(8), intent(in) :: amat_in_2(mat_max3,mat_max4)
  complex(8), intent(out) :: amat_out(mat_max5,mat_max6)
  integer :: mat1_do,mat2_do,i_do

  if( mat_max2 /= mat_max3 ) then
     write(6,*) 'error - matmul2_1',mat_max2,mat_max3
     stop
  end if
  if( mat_max1 /= mat_max5 ) then
     write(6,*) 'error - matmul2_2',mat_max2,mat_max3
     stop
  end if
  if( mat_max4 /= mat_max6 ) then
     write(6,*) 'error - matmul2_3',mat_max2,mat_max3
     stop
  end if

  do mat2_do=1,mat_max6
     do mat1_do=1,mat_max5
        amat_out(mat1_do,mat2_do)=dcmplx(0.d0,0.d0)
     end do
  end do

  do mat2_do=1,mat_max4
     do i_do=1,mat_max2
        do mat1_do=1,mat_max1
           amat_out(mat1_do,mat2_do)=amat_out(mat1_do,mat2_do)                    &
                +amat_in_1(mat1_do,i_do)*amat_in_2(i_do,mat2_do)
        end do
     end do
  end do

  return
end subroutine mat_mul2
