
subroutine Param__readMX( fname )
  use ac_misc_module
  implicit none

  character(len=*) fname

  integer        :: iunit
  logical        :: ex
  character(256) :: buf, tag

  integer        :: i, j
  real(8)  :: MOL_TO_AU, CEL_TO_AU
  character(16)  :: name
  character(64)  :: name_pao, mode, name_vps
  character(256) :: fname_pao, fname_vps
  character(16)  :: str

  real(8) :: R(3)
  real(8) :: ks(3), ke(3)
  integer        :: mesh
  type(Element_type), pointer :: elem
  real(8)  :: Qu, Qd
  character(256) :: dummy

  !*************************************************************
  open(unit=16,file=Param%Option%file_ac_tempout,position='append')
  write(16,*) '++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++'
  write(16,999) fname
  write(16,*)
999 format(' +++++++++++ start: read file:: ',a15)
  close(16)
  !*************************************************************

  inquire(file=fname,exist=ex)
  if( .not. ex ) then
     write(*,'(a,a)') '# Error!: can not open file', trim(fname) 
     stop
  end if
  iunit=1
  open(iunit, file=fname)

  MOL_TO_AU = AA_TO_AU ! default angstrom
  CEL_TO_AU = AA_TO_AU ! default angstrom

  do 
     read(iunit, '(a)', end=100) buf
     if( uncomment(buf) ) cycle
     read(buf,*) tag

     select case(tag)
     case('System.Name')
        read(buf,*) tag, Param%name

     case('Species.Number')
        read(buf,*) tag, Param%Data%nelem
        allocate( Param%Data%velem(Param%Data%nelem))
        allocate( Param%Data%velem_file(Param%Data%nelem,4))

     case('<Definition.of.Atomic.Species')
        do i=1, Param%Data%nelem
           read(iunit, '(a)') buf

           do j=1, len_trim(buf)
              if( buf(j:j) == '-' ) then
                 buf(j:j) = ' '
              endif
           end do

           read(buf,*) name, name_pao, mode, name_vps

           fname_pao = trim(Param%Data%path_pao) // "/" // trim(name_pao) // ".pao"
           fname_vps = trim(Param%Data%path_vps) // "/" // trim(name_vps) // ".vps"

           Param%Data%velem_file(i,1)=name
           Param%Data%velem_file(i,2)=fname_pao
           Param%Data%velem_file(i,4)=fname_vps
           Param%Data%velem_file(i,3)=mode

           call Element__readPAO_adpack( Param%Data%velem(i), name, fname_pao, mode, "" )
           call Element__readVPS_adpack( Param%Data%velem(i), name, fname_vps )

        end do
        read(iunit, '(a)') buf

     case('Atoms.Number')
        read(buf,*) tag, Param%Data%natom
        allocate( Param%Data%vatom(Param%Data%natom))

     case('Atoms.Number.Left')
        read(buf,*) tag, Param%Data%natom_left

     case('Atoms.Number.Right')
        read(buf,*) tag, Param%Data%natom_right

     case('Atoms.SpeciesAndCoordinates.Unit')
        read(buf,*) tag, str
        MOL_TO_AU = TO_AU(str)

     case('<Atoms.SpeciesAndCoordinates')
        do i=1, Param%Data%natom
           read(iunit,'(a)') buf
           read(buf,*) dummy, name, R(:), Qu, Qd
           if( dummy == dummy ) then ! to suppress a warning
           endif

           elem => Param__Data__getElement( name )

           call Atom__set( Param%Data%vatom(i), name, R*MOL_TO_AU, &
                elem%vpao(1)%Rc, -elem%Vloc%Q, elem%atomic_number, (Qu-Qd)/(Qu+Qd), .true. )
        end do
        read(iunit,'(a)') buf

     case('Atoms.UnitVectors.Unit')
        read(buf,*) tag, str
        CEL_TO_AU = TO_AU(str)

     case('<Atoms.UnitVectors')
        read(iunit,'(a)') buf
        read(buf,*) Param%Cell%La(:)

        read(iunit,'(a)') buf
        read(buf,*) Param%Cell%Lb(:)

        read(iunit,'(a)') buf
        read(buf,*) Param%Cell%Lc(:)

        Param%Cell%La = Param%Cell%La * CEL_TO_AU
        Param%Cell%Lb = Param%Cell%Lb * CEL_TO_AU
        Param%Cell%Lc = Param%Cell%Lc * CEL_TO_AU
        read(iunit,'(a)') buf

     case('scf.XcType')
        read(buf,*) tag, str
        select case(str)
        case('PZ81','LDA','LSDA-CA')
           Param%SCF%exc_type = 'PZ81'
        case('PW91','LSDA-PW')
           Param%SCF%exc_type = 'PW91'
        case('PBE')
           Param%SCF%exc_type = 'PBE'
        case default
           write(*,'(a,a)') '# Error!: scf.XcType is broken in file ', trim(fname)
           go to 1111
        end select

     case('scf.SpinPolarization')
        read(buf,*) tag, str
        select case(str)
        case('on','On','ON')
           Param%Option%spin_polar = .true.
           Param%Option%nspin  = 2
        case('off','Off','OFF')
           Param%Option%spin_polar = .false.
           Param%Option%nspin  = 1
        case default
           write(*,'(a,a)') &
                '# Error!: scf.SpinPolarization is broken in file ', trim(fname)
           go to 1111
        end select

     case('scf.cluster')
        read(buf,*) tag, str
        select case(str)
        case('on','On','ON')
           Param%Option%cluster = .true.
        case('off','Off','OFF')
           Param%Option%cluster = .false.
        case default
           write(*,'(a,a)') &
                '# Error!: scf.cluster is broken in file ', trim(fname)
           go to 1111
        end select

     case('scf.ElectronicTemperature')
        read(buf,*) tag, Param%SCF%Te
        Param%SCF%Te = Param%SCF%Te * KELVIN_TO_AU

     case('scf.energycutoff')
        read(buf,*) tag, Param%SCF%Ecutoff
        Param%SCF%Ecutoff = Param%SCF%ECUTOFF * RY_TO_AU

     case('scf.Kgrid')
        read(buf,*) tag, Param%SCF%Nka, Param%SCF%Nkb, Param%SCF%Nkc

     case('scf.Mixing.Type')
        read(buf,*) tag, str
        select case(str)
        case('simple','Simple')
           Param%SCF%mix_type = 'Simple'
           Param%SCF%mix_start = 0
           Param%SCF%mix_history = 1
        case('pulay','Pulay')
           Param%SCF%mix_type = 'Pulay'
        case('rmm-diis','Rmm-Diis','RMM-DIIS')
           Param%SCF%mix_type = 'Pulay'
        case('Anderson','anderson')
           Param%SCF%mix_type = 'Anderson'
           Param%SCF%mix_start = 0
           Param%SCF%mix_history = 3
        case default
           write(*,'(a,a)') '# Error!: scf.Mixing.Type is broken in file ', trim(fname)
           go to 1111
        end select

     case('scf.Init.Mixing.Weight')
        read(buf,*) tag, Param%SCF%mix_weight
     case('scf.Mixing.History')
        if( Param%SCF%mix_type /= 'Simple' .and. Param%SCF%mix_type /= 'Anderson' ) then
           read(buf,*) tag, Param%SCF%mix_history
        end if
     case('scf.Mixing.Start')
        if( Param%SCF%mix_type /= 'Simple' .and. Param%SCF%mix_type /= 'Anderson' ) then
           read(buf,*) tag, Param%SCF%mix_start
        end if

     case('scf.criterion.Type')
        read(buf,*) tag, str
        select case(str)
        case('fermi')
           Param%SCF%cri_type = 'fermi'
        case('orbital')
           Param%SCF%cri_type = 'orbital'
        case('total')
           Param%SCF%cri_type = 'total'
        case('density')
           Param%SCF%cri_type = 'density'
        case default
           write(*,'(a,a)') '# Error!: scf.criterion.Type is broken in file ', trim(fname)
           go to 1111
        end select

     case('scf.criterion')
        read(buf,*) tag, Param%SCF%criterion

     case('scf.maxIter')
        read(buf,*) tag, Param%SCF%iter_max

     case('1DFFT.NumGridK')
        read(buf,*) tag, Param%Integral1D%Nk

     case('1DFFT.NumGridR')
        read(buf,*) tag, Param%Integral1D%Nr

     case('1DFFT.EnergyCutoff')
        read(buf,*) tag, Param%Integral1D%Ecutoff
        Param%Integral1D%Ecutoff = Param%Integral1D%Ecutoff * RY_TO_AU

     case('Band.dispersion')
        read(buf,*) tag, str
        select case(str)
        case('on','On','ON')
           Param%Band%fname = trim(Param%name) // ".band.dat"
        case('off','Off','OFF')
           Param%Band%fname = ""
        case default
           write(*,'(a,a)') '# Error!: Band.dispersion is broken in file ', trim(fname)
           go to 1111

        end select

     case('<Band.KPath.UnitCell')
        read(iunit,'(a)') buf
        read(buf,*) Param%Band%La(:)

        read(iunit,'(a)') buf
        read(buf,*) Param%Band%Lb(:)

        read(iunit,'(a)') buf
        read(buf,*) Param%Band%Lc(:)

        Param%Band%La = Param%Band%La * CEL_TO_AU
        Param%Band%Lb = Param%Band%Lb * CEL_TO_AU
        Param%Band%Lc = Param%Band%Lc * CEL_TO_AU

        read(iunit,'(a)') buf

     case('Band.Nkpath')
        read(buf,*) tag, Param%Band%nKpath
        allocate( Param%Band%vKpath(Param%Band%nKpath) )

     case('<Band.kpath')

        do i=1, Param%Band%nKpath
           read(iunit,'(a)') buf
           read(buf,*) mesh, ks(:), ke(:)

           Param%Band%vKpath(i)%ks = ks(:)
           Param%Band%vKpath(i)%ke = ke(:)
           Param%Band%vKpath(i)%mesh = mesh
        end do
        read(iunit,'(a)') buf

     case('Dos.fileout')
        read(buf,*) tag, str
        select case(str)
        case('on','On','ON')
           Param%DOS%fname = trim(Param%name) // ".dos.dat"
        case('off','Off','OFF')
           Param%DOS%fname = ""

        case default
           write(*,'(a,a)') '# Error!: Dos.fileout is broken in file ', trim(fname)
           go to 1111

        end select


     case('Dos.Erange')
        read(buf,*) tag, Param%DOS%Emin, Param%DOS%Emax
        Param%DOS%Emin = Param%DOS%Emin * RY_TO_AU
        Param%DOS%Emax = Param%DOS%Emax * RY_TO_AU

     case('Dos.Egrid')
        read(buf,*) tag, Param%DOS%Ne

     case('Dos.Kgrid')
        read(buf,*) tag, Param%DOS%Nka, Param%DOS%Nkb, Param%DOS%Nkc

     case('Dos.method')
        read(buf,*) tag, str
        select case(str)
        case('boxes','histogram')
           Param%DOS%method = 'histogram'
        case('gaussian')
           Param%DOS%method = 'gaussian'
        case('tetrahedron')
           Param%DOS%method = 'tetrahedron'
        case default 
           write(*,'(a,a)') '# Error!: Dos.method is broken in file ', trim(fname)
           go to 1111
        end select

     case('Vh.fileout')
        read(buf,*) tag, str
        select case(str)
        case('on','On','ON')
           Param%Option%fname_rhoscf   = trim(Param%name) // ".density.scf" // trim(Param%Option%field_format)
        case('off','Off','OFF')
           Param%Option%fname_rhoscf   = ""
        case default
           write(*,'(a,a)') &
                '# Error!: Vh.fileout is broken in file ', trim(fname)
           go to 1111
        end select

     end select
  end do
100 continue

  close(iunit)

  return

1111 continue ! error_block

  close(iunit)
  stop

end subroutine Param__readMX


subroutine Element__readPAO_adpack( elem, name, fname, mode, mode2 )
  use ac_misc_module

  implicit none
  type(Element_type), intent(out)   :: elem
  character(len=*), intent(in) :: name
  character(len=*), intent(in) :: fname
  character(len=*), intent(in) :: mode
  character(len=*), intent(in) :: mode2

  integer        :: iunit
  logical        :: ex
  character(256) :: buf, tag

  real(8)  :: Rc
  integer        :: nr
  real(8), allocatable :: vr(:)
  integer, parameter :: npaoLmax=3 ! F orbital
  integer, parameter :: npao2Lmax=6 ! I orbital
  integer        :: npaoL (0:npaoLmax)
  integer        :: ipaoL (0:npaoLmax)
  integer        :: npao2L(0:npao2Lmax)
  integer        :: ipao2L(0:npao2Lmax)
  real(8)  :: logr
  real(8)  :: R(10)
  character(32) :: dummy
  character(1024) :: msg
  integer        :: i, l, n
  integer        :: maxLpao, numpao

  elem%name = name

  inquire( file=fname, exist=ex )
  if( .not. ex ) then
     open(unit=16,file=Param%Option%file_ac_tempout,position='append')
     write(16,999) trim(fname)
999  format('      ++++++ Error! readPAO/ can not open file: ',a)
     close(16)
     !!     write(*,'(a,a)') '# Error!: Element::readPAO : can not open file ', fname 
     stop
  end if

  iunit=2
  open(iunit,file=fname)

  Rc = 0.d0
  nr = 0

  do 
     read(iunit,'(a)',end=100) buf
     if( buf=='' ) cycle
     read(buf,*) tag

     select case(tag)
     case('#')
     case('grid.num.output')
        read(buf,*) tag, nr
     case('maxL.pao')
        read(buf,*) tag, maxLpao
     case('num.pao')
        read(buf,*) tag, numpao

     case('radial.cutoff.pao')
        read(buf,*) tag, Rc
     end select

     if( nr /= 0 .and. Rc /= 0.d0 ) exit
  end do
100 continue

  if( nr == 0 ) then
     msg = "grid.num.output is not given"
     goto 1111
  end if
  if( Rc == 0.d0 ) then
     msg = "radial.cutoff is not given"
     goto 1111
  end if

  allocate( vr(nr) )

  do l=0, npaoLmax
     npaoL(l) = 0
  end do

  if( mode == "" ) then
     do l = 0, maxLpao
        npaoL(l) = numpao
     end do
  else if( mode(1:1) /= 's' ) then
     if( len_trim(mode) == 1 ) then
        npaoL(0) = numpao
     else
        read(mode(2:2),*) npao2L(0)
     end if

     select case( mode(1:1) )
     case('p')
        npaoL(1:1) = npaoL(0)
     case('d')
        npaoL(1:2) = npaoL(0)
     case('f')
        npaoL(1:3) = npaoL(0)
     end select
  else
     do i=1, len_trim(mode), 2
        select case( mode(i:i) )
        case('s')
           read( mode(i+1:i+1), * ) npaoL(0)
        case('p')
           read( mode(i+1:i+1), * ) npaoL(1)
        case('d')
           read( mode(i+1:i+1), * ) npaoL(2)
        case('f')
           read( mode(i+1:i+1), * ) npaoL(3)
        end select
     end do
  end if

  do l=0, npaoLmax
     if( npaoL(l) > numpao ) then
        open(unit=16,file=Param%Option%file_ac_tempout,position='append')
        write(16,*) '      ++++++ Warning!: too many radial PAO bases requested for band calculations. Reduced to', numpao
        close(16)
        !    write(*,'(a,i2)') '# Warning!: too many radial PAO bases requested for band calculations. Reduced to', numpao
        npaoL(l) = numpao
     end if
  end do

  do l=0, npao2Lmax
     npao2L(l)=0
  end do

  if( mode2 == "" ) then
     do l = 0, npao2Lmax
        npao2L(l) = numpao
     end do
  else if( mode2(1:1) /= 's' ) then
     if( len_trim(mode2) == 1 ) then
        npao2L(0) = numpao
     else
        read(mode2(2:2),*) npao2L(0)
     end if

     select case( mode2(1:1) )
     case('p')
        npao2L(1:1) = npao2L(0)
     case('d')
        npao2L(1:2) = npao2L(0)
     case('f')
        npao2L(1:3) = npao2L(0)
     case('g')
        npao2L(1:4) = npao2L(0)
     case('h')
        npao2L(1:5) = npao2L(0)
     case('i')
        npao2L(1:6) = npao2L(0)
     end select
  else
     do i=1, len_trim(mode2), 2
        select case( mode2(i:i) )
        case('s')
           read( mode2(i+1:i+1), * ) npao2L(0)
        case('p')
           read( mode2(i+1:i+1), * ) npao2L(1)
        case('d')
           read( mode2(i+1:i+1), * ) npao2L(2)
        case('f')
           read( mode2(i+1:i+1), * ) npao2L(3)
        case('g')
           read( mode2(i+1:i+1), * ) npao2L(4)
        case('h')
           read( mode2(i+1:i+1), * ) npao2L(5)
        case('i')
           read( mode2(i+1:i+1), * ) npao2L(6)
        end select
     end do
  end if

  do l=0, npao2Lmax
     if( npao2L(l) > numpao ) then
        open(unit=16,file=Param%Option%file_ac_tempout,position='append')
        write(16,*) '      ++++++ Warning!: too many radial PAO bases requested for projection. Reduced to', numpao
        close(16)
        ! write(*,'(a,i2)') '# Warning!: too many radial PAO bases requested for projection. Reduced to', numpao
        npao2L(l) = numpao
     end if
  end do

  elem%npao=0
  do l=0, npaoLmax
     ipaoL(l) = elem%npao+1
     elem%npao = elem%npao + npaoL(l)
  end do
  elem%npao2=0
  do l=0, npao2Lmax
     ipao2L(l) = elem%npao2+1
     elem%npao2 = elem%npao2 + npao2L(l)
  end do

  allocate(elem%vpao(elem%npao))

  if( Param%Option%projection ) then
     allocate(elem%vpao2(elem%npao2))
     allocate(elem%vpao2bar(elem%npao2))
  end if

  do
     read(iunit,'(a)',end=200) buf

     if(buf=='') cycle
     if(buf=='#') cycle
     read(buf,*) tag

     select case(tag)
     case('<valence.charge.density')
        elem%rhoval%l  = 0
        elem%rhoval%Rc = Rc
        allocate( elem%rhoval%vR(nr) )

        do i=1, nr
           read(iunit,'(a)') buf
           read(buf,*) logr, dummy, elem%rhoval%vR(i)
           if( dummy == dummy ) then ! to suppress a warning
           endif

           vr(i) = exp(logr)
        end do
        read(iunit,'(a)') buf

        call RadialFunc__set(elem%rhoval, vr, nr)

     case('<pseudo.atomic.orbitals.L=0', '<pseudo.atomic.orbitals.L=1', &
          '<pseudo.atomic.orbitals.L=2', '<pseudo.atomic.orbitals.L=3')
        select case(tag)
        case('<pseudo.atomic.orbitals.L=0')
           l = 0
        case('<pseudo.atomic.orbitals.L=1')
           l = 1
        case('<pseudo.atomic.orbitals.L=2')
           l = 2
        case('<pseudo.atomic.orbitals.L=3')
           l = 3
        end select

        if( npaoL(l)>0 ) then
           do n=1, npaoL(l)
              elem%vpao(ipaoL(l)+n-1)%l  = l
              elem%vpao(ipaoL(l)+n-1)%Rc = Rc
              allocate( elem%vpao(ipaoL(l)+n-1)%vR(nr) )
           end do
        end if

        if( npao2L(l)>0 .and. Param%Option%projection ) then
           do n=1, npao2L(l)
              elem%vpao2(ipao2L(l)+n-1)%l  = l
              elem%vpao2(ipao2L(l)+n-1)%Rc = Rc
              allocate( elem%vpao2(ipao2L(l)+n-1)%vR(nr) )

              elem%vpao2bar(ipao2L(l)+n-1)%l  = l
              elem%vpao2bar(ipao2L(l)+n-1)%Rc = Rc
              allocate( elem%vpao2bar(ipao2L(l)+n-1)%vR(nr) )
           end do
        end if

        if( npaoL(l)>0 .or. npao2L(l)>0 ) then
           do i=1, nr
              read(iunit,'(a)') buf
              read(buf,*) dummy, dummy, R(1:max(npaoL(l),npao2L(l)))

              do n=1, npaoL(l)
                 elem%vpao(ipaoL(l)+n-1)%vR(i) = R(n)
              end do

              if( Param%Option%projection ) then
                 do n=1, npao2L(l)
                    elem%vpao2(ipao2L(l)+n-1)%vR(i) = R(n)
                 end do
              end if
           end do

           read(iunit,'(a)') buf
        end if

        if( npaoL(l)>0 ) then
           do n=1, npaoL(l)
              call RadialFunc__set(elem%vpao(ipaoL(l)+n-1), vr, nr)
           end do
        end if

        if( npao2L(l)>0 .and. Param%Option%projection ) then
           do n=1, npao2L(l)
              call RadialFunc__set(elem%vpao2(ipao2L(l)+n-1), vr, nr)
           end do
        end if

     end select
  end do

200 continue


  if( Param%Option%projection ) then
     do l = maxLpao+1, npao2Lmax
        if( npao2L(l) == 0 ) cycle

        do n=1, npao2L(l)
           elem%vpao2(ipao2L(l)+n-1)%l  = l
           elem%vpao2(ipao2L(l)+n-1)%Rc = Rc
           allocate( elem%vpao2(ipao2L(l)+n-1)%vR(nr) )

           elem%vpao2bar(ipao2L(l)+n-1)%l  = l
           elem%vpao2bar(ipao2L(l)+n-1)%Rc = Rc
           allocate( elem%vpao2bar(ipao2L(l)+n-1)%vR(nr) )
        end do

        do n=1, npao2L(l)
           do i=1, nr
              elem%vpao2(ipao2L(l)+n-1)%vR(i) = &
                   vr(i)**(l-maxLpao) * elem%vpao2(ipao2L(maxLpao)+n-1)%vR(i)
           end do
        end do

        do n=1, npao2L(l)
           call RadialFunc__set(elem%vpao2(ipao2L(l)+n-1), vr, nr)
        end do
     end do
  end if

  if(allocated(vr)) deallocate(vr)

  if( .not. associated(elem%rhoval%vR) ) then
     msg = "valence.charge.density is not given"
     goto 1111
  end if

  do n=1, elem%npao
     if( .not. associated(elem%vpao(n)%vR) ) then
        msg = "pseudo.atomic.orbitals is not given"
        goto 1111
     endif
  end do

  close(iunit)
  return

1111 continue ! error_block
  close(iunit)

  write(*,'(a,a,a)') '# Error! : PAO data ', msg, fname
  !  write(*,'(a,a,a)') '# Error! : PAO data ', msg, fname
  open(unit=16,file=Param%Option%file_ac_tempout,position='append')
  write(16,998) msg,fname
998 format('      ++++++ Error! PAO data: ',a,a)
  close(16)
  stop

end subroutine Element__readPAO_adpack


subroutine Element__readVPS_adpack( elem, name, fname )
  use ac_misc_module

  implicit none
  type(Element_type), intent(out)   :: elem
  character(len=*), intent(in) :: name
  character(len=*), intent(in) :: fname

  integer         :: iunit
  logical         :: ex
  character(1024) :: buf
  character(32)   :: tag

  real(8)  :: Q
  real(8)  :: Rc
  integer        :: nr
  real(8), allocatable :: vr(:)
  real(8)  :: logr
  real(8)  :: vnon(2,12)
  character(8)   :: str
  character(32) :: dummy
  character(1024) :: msg
  integer        :: i, n

  elem%name = name

  inquire(file=fname,exist=ex)
  if( .not. ex ) then
     open(unit=16,file=Param%Option%file_ac_tempout,position='append')
     write(16,999) trim(fname)
999  format('      ++++++ Error! readVPS/ can not open file: ',a)
     close(16)
     !!     write(*,'(a,a)') '# Error!: Element::readVPS : can not open file ', fname 
     stop
  end if

  iunit = 3
  open(iunit,file=fname)

  Q  = 0.d0
  Rc = 0.d0
  nr = 0

  elem%pcc = .false.
  elem%nVnon = -1

  do 
     read(iunit,'(a)',end=100) buf
     if( buf=='') cycle
     if( buf=='#') cycle
     read(buf,*) tag

     select case(tag)
     case('eq.type')
        read(buf,*) tag, str
        select case(str)
        case('dirac2')
           elem%dirac = .true.
        case('sch')
           elem%dirac = .false.
        case default
           elem%dirac = .false.
        end select
     case('AtomSpecies')
        read(buf,*) tag, elem%atomic_number
     case('valence.electron')
        read(buf,*) tag, Q
     case('grid.num.output')
        read(buf,*) tag, nr
     case('local.cutoff')
        read(buf,*) tag, Rc
     case('charge.pcc.calc')
        read(buf,*) tag, str
        if( str == 'on' .or. str == 'On' .or. str == 'ON' ) then
           elem%pcc = .true.
        else
           elem%pcc = .false.
        end if

        if( .not. Rc == 0.d0 ) exit
     case('radial.cutoff.pao')
        if( Rc == 0.d0 ) then
           read(buf,*) tag, Rc
        end if
        exit
     end select

  end do
100 continue

  if( nr == 0 ) then
     msg = 'Parameter grid.num.output is not given'
     go to 1111
  end if
  if( Rc == 0.d0 ) then
     msg = 'Parameter local.cutoff is not given'
     go to 1111
  end if
  if( Q  == 0.d0 ) then
     msg = 'Parameter valence.electron is not given'
     go to 1111
  end if

  allocate( vr(nr) )

  do 
     read(iunit,'(a)',end=200) buf

     if( buf=='') cycle
     if( buf=='#') cycle
     read(buf,*) tag

     select case(tag)
     case('num.projector')
        read(buf,*) tag, elem%nVnon

     case('<project.energies','<projection.energies')
        select case(tag)
        case('<project.energies')
           if( elem%nVnon == -1 ) then
              read(iunit,'(a)',end=200) buf
              read(buf,*) elem%nVnon
           end if
           if( elem%nVnon == -1 ) then
              msg = 'project.energies is broken or num.projector is not given'
              go to 1111
           end if

        case('<projection.energies')
           if( elem%nVnon == -1 ) then
              msg = 'Parameter num.projector is not given'
              go to 1111
           end if

        end select

        if( elem%nVnon>0 ) then
           if( elem%dirac ) then
              allocate(elem%vVnon(elem%nVnon,2))
           else
              allocate(elem%vVnon(elem%nVnon,1))
           end if

           elem%vVnon(:,:)%l = 0
           elem%vVnon(:,:)%Q = 0.0
        end if

        if( elem%nVnon>0 ) then
           do n=1, elem%nVnon
              read(iunit,'(a)') buf
              if( elem%dirac ) then
                 read(buf,*) elem%vVnon(n,1)%l, elem%vVnon(n,1:2)%Q
                 elem%vVnon(n,2)%l = elem%vVnon(n,1)%l
              else
                 read(buf,*) elem%vVnon(n,1)%l, elem%vVnon(n,1)%Q
              end if
           end do
        end if
        read(iunit,'(a)') buf

     case('<Pseudo.Potentials')
        elem%Vloc%l  = 0
        elem%Vloc%Q  = -Q
        elem%Vloc%Rc = Rc
        allocate( elem%Vloc%vR(nr) )

        do n=1, elem%nVnon
           if( elem%dirac ) then
              elem%vVnon(n,1)%Rc = Rc
              allocate(elem%vVnon(n,1)%vR(nr))
              elem%vVnon(n,2)%Rc = Rc
              allocate(elem%vVnon(n,2)%vR(nr))
           else
              elem%vVnon(n,1)%Rc = Rc
              allocate(elem%vVnon(n,1)%vR(nr))
           end if
        end do

        do i=1, nr
           read(iunit,'(a)') buf

           if( elem%dirac ) then
              read(buf,*) logr, dummy, elem%Vloc%vR(i), vnon(1:2,1:elem%nVnon)
              do n=1, elem%nVnon
                 elem%vVnon(n,1)%vR(i) = vnon(1,n)
                 elem%vVnon(n,2)%vR(i) = vnon(2,n)
              end do
           else
              read(buf,*) logr, dummy, elem%Vloc%vR(i), vnon(1,1:elem%nVnon)
              do n=1, elem%nVnon
                 elem%vVnon(n,1)%vR(i) = vnon(1,n)
              end do
           end if

           vr(i) = exp(logr)
           if( i<4 ) then
              write(*,*) i, vr(i), elem%Vloc%vR(i)
           end if

           if( dummy == dummy ) then ! to suppress a warning
           endif
        end do

        read(iunit,'(a)') buf

        call RadialFunc__set( elem%Vloc, vr, nr )
        do n=1, elem%nVnon
           if( elem%dirac ) then
              call RadialFunc__set( elem%vVnon(n,1), vr, nr )
              call RadialFunc__set( elem%vVnon(n,2), vr, nr )
           else
              call RadialFunc__set( elem%vVnon(n,1), vr, nr )
           end if
        end do

     case('<density.PCC')
        if( elem%pcc ) then
           elem%rhopcc%l  = 0
           elem%rhopcc%Rc = elem%vpao(1)%Rc ! use PAO's cutoff instead
           allocate( elem%rhopcc%vR(nr) )

           do i=1, nr
              read(iunit,'(a)') buf
              read(buf,*) dummy, dummy, elem%rhopcc%vR(i) 
           end do
           read(iunit,'(a)') buf

           call RadialFunc__set( elem%rhopcc, vr, nr )
        end if
     end select
  end do
200 continue

  if(allocated(vr)) deallocate(vr)

  if( .not. associated(elem%Vloc%vR) ) then
     msg = "Pseudo.Potentials is not given"
     goto 1111
  end if

  do n=1, elem%nVnon
     if( .not. associated(elem%vVnon(n,1)%vR) ) then
        msg = "Pseudo.Potentials is not given"
        goto 1111
     end if
  end do

  if( elem%pcc .and. (.not. associated(elem%rhopcc%vR)) ) then
     msg = "density.PCC not given"
     goto 1111
  end if

  close(iunit)
  return

1111 continue ! error_block
  close(iunit)

  open(unit=16,file=Param%Option%file_ac_tempout,position='append')
  write(16,998) msg,fname 
998 format(' +++++++ Error! VPS data: ',a,a)
  close(16)
  !  write(*,'(a,a,a)') '# Error! : VPS data ', msg, fname
  stop

end subroutine Element__readVPS_adpack
