! @@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@ !
! @@                                                                @@ !
! @@       PROGRAM  ASCOT 2014.440 (ver.4.40)                       @@ !
! @@     "Abinitio Simulation Code for Quantum Transport"           @@ !
! @@                                                                @@ !
! @@                                                                @@ !
! @@  AUTHOR(S): Naoki WATANABE, Nobutaka NISHIKAWA (Mizuho I.R.)   @@ !
! @@             Hisashi KONDO (Univ. Tokyo)                        @@ !
! @@                                                09/May/2014     @@ !
! @@                                                                @@ !
! @@  Contact address: Phase System Consortium                      @@ !
! @@                                                                @@ !
! @@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@ !

subroutine FFT__forward( nx, ny, nz, data_in, data_out )
  use ac_misc_module
  implicit none

  integer, intent(in)  :: nx, ny, nz
  real(8), intent(in)  :: data_in (nx,ny,nz)
  real(8), intent(out) :: data_out(2*(nx/2+1),ny,nz)

  integer(8)           :: pf
  integer, parameter   :: FFTW_ESTIMATE = 64 

  call dfftw_plan_dft_r2c_3d( pf, &
       nx, ny, nz, data_in, data_out, FFTW_ESTIMATE )
  call dfftw_execute( pf )
  call dfftw_destroy_plan( pf )

  return
end subroutine FFT__forward

subroutine FFT__backward( nx, ny, nz, data_in, data_out )
  use ac_misc_module

  implicit none
  integer, intent(in)    :: nx, ny, nz
  real(8), intent(inout) :: data_in (2*(nx/2+1),ny,nz)
  real(8), intent(out)   :: data_out(nx,ny,nz)

  integer(8)             :: pb
  integer, parameter :: FFTW_ESTIMATE = 64 

  call dfftw_plan_dft_c2r_3d( pb, &
       nx, ny, nz, data_in, data_out, FFTW_ESTIMATE )
  call dfftw_execute( pb )
  call dfftw_destroy_plan( pb )

  return
end subroutine FFT__backward
