! @@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@ !
! @@                                                                @@ !
! @@       PROGRAM  ASCOT 2014.440 (ver.4.53)                       @@ !
! @@     "Abinitio Simulation Code for Quantum Transport"           @@ !
! @@                                                                @@ !
! @@                                                                @@ !
! @@  AUTHOR(S): Hisashi KONDO (Univ. Tokyo)                        @@ !
! @@             Naoki WATANABE (Mizuho I.R.)                       @@ !
! @@             Nobutaka NISHIKAWA (Mizuho I.R.)                   @@ !
! @@                                                09/May/2014     @@ !
! @@                                                                @@ !
! @@  Contact address: Phase System Consortium                      @@ !
! @@                                                                @@ !
! @@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@ !

subroutine set_hamiltonian_l(descLL,qx,qy,ispin)
  use condition
  use hamiltonian_e
  use hamiltonian_sgf
  use ac_mpi_module

  implicit none
  type(MPI_MatDesc), intent(in) :: descLL
  integer, intent(in) :: qx,qy,ispin
  integer :: i1_do,i2_do,ier
  complex(8), allocatable :: temp(:,:)

  if( ham_model == 'input' .or. ham_model == 'scf_accel' ) then
     call set_hamiltonian_input_l(descLL,ispin)
     return
  end if

  if( p_or_f == 'free' ) then
     call set_hamiltonian_free(descLL)
  else
     if( p_or_f == 'periodic' ) then
        call set_hamiltonian_periodic(descLL,qx,qy)
     else
        write(6,*) 'error: set_hamiltonian_l'
        stop
     end if
  end if

  allocate(temp(descLL%nrow, descLL%scol:descLL%ecol),stat=ier)
  if( ier /= 0 ) then
     write(6,*) 'error allocate: set_hamiltonian_l'
     stop
  end if

  temp(:,:) = h01_mat(:,:) 
  h01_mat(:,:) = h10_mat(:,:) 
  h10_mat(:,:) = temp(:,:) 

  temp(:,:) = s01_mat(:,:) 
  s01_mat(:,:) = s10_mat(:,:) 
  s10_mat(:,:) = temp(:,:) 

  deallocate(temp,stat=ier)
  if( ier /= 0 ) then
     write(6,*) 'error deallocate: set_hamiltonian_l'
     stop
  end if

  return
end subroutine set_hamiltonian_l
subroutine set_hamiltonian_r(descRR,qx,qy,ispin)
  use condition
  use hamiltonian_e
  use hamiltonian_sgf
  use ac_mpi_module

  implicit none
  type(MPI_MatDesc), intent(in) :: descRR
  integer, intent(in) :: qx,qy,ispin

  if( ham_model == 'input' .or. ham_model == 'scf_accel' ) then
     call set_hamiltonian_input_r(descRR,ispin)
  else
     if( p_or_f == 'free' ) then
        call set_hamiltonian_free(descRR)
     else
        if( p_or_f == 'periodic' ) then
           call set_hamiltonian_periodic(descRR,qx,qy)
        else
           write(6,*) 'error: set_hamiltonian_r'
           stop
        end if
     end if
  end if

  return
end subroutine set_hamiltonian_r
subroutine unset_hamiltonian

  use condition
  use hamiltonian_e

  implicit none

  if( ham_model == 'input' .or. ham_model == 'scf_accel' ) then
     call unset_hamiltonian_input
  else
     if( p_or_f == 'free' ) then
        call unset_hamiltonian_free
     end if
     if( p_or_f == 'periodic' .or.  p_or_f == 'periodic-1d' ) then
        call unset_hamiltonian_periodic
     end if
  end if

  return
end subroutine unset_hamiltonian
subroutine set_hamiltonian_input_l(descLL,ispin)

  use condition
  use hamiltonian_e
  use hamiltonian_sgf
  use hamiltonian_c
  use hamiltonian_temp
  use scf_negf
  use constant
  use ac_mpi_module

  implicit none
  type(MPI_MatDesc), intent(in) :: descLL
  integer, intent(in) :: ispin

  call alo_hamiltonian_input(descLL)

  h00_mat(:,:) = h00_l_t(:,:,ispin) 
  h01_mat(:,:) = h01_l_t(:,:,ispin) 
  h10_mat(:,:) = h10_l_t(:,:,ispin) 

  s00_mat(:,:) = s00_l_t(:,:) 
  s01_mat(:,:) = s01_l_t(:,:) 
  s10_mat(:,:) = s10_l_t(:,:) 

  return
end subroutine set_hamiltonian_input_l
subroutine set_hamiltonian_input_r(descRR,ispin)
  use condition
  use hamiltonian_sgf
  use hamiltonian_c
  use hamiltonian_e
  use hamiltonian_temp
  use scf_negf
  use constant
  use ac_mpi_module

  implicit none
  type(MPI_MatDesc), intent(in) :: descRR
  integer, intent(in) :: ispin

  call alo_hamiltonian_input(descRR)

  h00_mat(:,:) = h00_r_t(:,:,ispin) 
  h01_mat(:,:) = h01_r_t(:,:,ispin) 
  h10_mat(:,:) = h10_r_t(:,:,ispin) 

  s00_mat(:,:) = s00_r_t(:,:) 
  s01_mat(:,:) = s01_r_t(:,:) 
  s10_mat(:,:) = s10_r_t(:,:) 

  return
end subroutine set_hamiltonian_input_r
subroutine set_hamiltonian_free(desc)

  use condition
  use hamiltonian_e
  use ac_mpi_module

  implicit none
  type(MPI_MatDesc), intent(in) :: desc 

  integer :: max_atom_orbital
  integer :: kx,ky,lx,ly,iz
  integer :: i1_do,i2_do,i3_do,i4_do,i1_count,i2_count,ier
  complex(8), allocatable :: h_ijmn(:,:),s_ijmn(:,:)
  integer :: i, j

  max_atom_orbital=0
  do i1_do=1,num_atom_kind
     if( max_atom_orbital < atom_orbital(i1_do) ) then
        max_atom_orbital=atom_orbital(i1_do)
     end if
  end do

  call alo_hamiltonian_free(desc,num_atom,num_unit)

  allocate(h_ijmn(max_atom_orbital,max_atom_orbital),stat=ier)
  allocate(s_ijmn(max_atom_orbital,max_atom_orbital),stat=ier)
  if( ier /= 0 ) then
     write(6,*) 'error allocate: set_hamiltonian_free'
     stop
  end if


  i1_count=0
  do kx=1,num_unit(1)
     do ky=1,num_unit(2)
        do i1_do=1,num_atom
           itemp(kx,ky,i1_do)=i1_count
           i1_count=i1_count+atom_orbital(atom_kindn(i1_do))
        end do
     end do
  end do

  do kx=0,num_unit(1)-1
     do ky=0,num_unit(2)-1
        do i1_do=1,num_atom
           i1_count=itemp(kx+1,ky+1,i1_do)
           do lx=0,num_unit(1)-1
              do ly=0,num_unit(2)-1
                 do i2_do=1,num_atom
                    i2_count=itemp(lx+1,ly+1,i2_do)
                    if( i1_count == i2_count ) then
                       if( ham_model .eq. 'gsp' ) then
                          call onsite_gsp_hamiltonian(max_atom_orbital,i1_do,i2_do     &
                               ,h_ijmn,s_ijmn)
                       else
                          if( ham_model .eq. 'rtb_h' ) then
                             call onsite_rtbh_hamiltonian(max_atom_orbital,i1_do        &
                                  ,h_ijmn,s_ijmn)
                          else
                             write(6,*) 'error - ham_model: set_hamiltonian_free 1'
                             stop
                          end if
                       end if
                    else
                       iz=0
                       if( ham_model .eq. 'gsp' ) then
                          call off_gsp_hamiltonian(iz,kx,ky,lx,ly,i1_do,i2_do          &
                               ,max_atom_orbital,h_ijmn,s_ijmn)
                       else
                          if( ham_model .eq. 'rtb_h' ) then
                             call off_rtbh_hamiltonian(iz,kx,ky,lx,ly,i1_do,i2_do       &
                                  ,max_atom_orbital,h_ijmn,s_ijmn)
                          else
                             write(6,*) 'error - ham_model: set_hamiltonian_free 2'
                             stop
                          end if
                       end if
                    end if
                    do i3_do=1,atom_orbital(atom_kindn(i1_do))
                       do i4_do=1,atom_orbital(atom_kindn(i2_do))
                          i = i1_count+i3_do
                          j = i2_count+i4_do
                          if( i<desc%srow .or. desc%erow<i ) cycle
                          if( j<desc%scol .or. desc%ecol<j ) cycle

                          h00_mat(i,j) = h_ijmn(i3_do,i4_do) 
                          s00_mat(i,j) = s_ijmn(i3_do,i4_do) 
                       end do
                    end do
                    iz=l_or_r
                    if( ham_model .eq. 'gsp' ) then
                       call off_gsp_hamiltonian(iz,kx,ky,lx,ly,i1_do,i2_do            &
                            ,max_atom_orbital,h_ijmn,s_ijmn)
                    else
                       if( ham_model .eq. 'rtb_h' ) then
                          call off_rtbh_hamiltonian(iz,kx,ky,lx,ly,i1_do,i2_do         &
                               ,max_atom_orbital,h_ijmn,s_ijmn)
                       else
                          write(6,*) 'error - ham_model: set_hamiltonian_free 3'
                          stop
                       end if
                    end if
                    do i3_do=1,atom_orbital(atom_kindn(i1_do))
                       do i4_do=1,atom_orbital(atom_kindn(i2_do))
                          i = i1_count+i3_do
                          j = i2_count+i4_do
                          if( i<desc%srow .or. desc%erow<i ) cycle
                          if( j<desc%scol .or. desc%ecol<j ) cycle

                          h10_mat(i,j) = h_ijmn(i3_do,i4_do) 
                          s10_mat(i,j) = s_ijmn(i3_do,i4_do) 

                       end do
                    end do
                 end do
              end do
           end do
        end do
     end do
  end do

  call MPI__ZTRANC_ASCOT( desc, C0, h01_mat, C1, h10_mat )  
  call MPI__ZTRANC_ASCOT( desc, C0, s01_mat, C1, s10_mat )  



  deallocate(h_ijmn,s_ijmn,stat=ier)
  if( ier /= 0 ) then
     write(6,*) 'error deallocate: set_hamiltonian_free'
     stop
  end if

  return
end subroutine set_hamiltonian_free
subroutine set_hamiltonian_periodic(desc,qx,qy)

  use condition
  use hamiltonian_e
  use ac_mpi_module

  implicit none
  type(MPI_MatDesc), intent(in) :: desc 
  integer, intent(in) :: qx,qy

  integer :: max_atom_orbital
  integer :: kx,ky,lx,ly,iz
  integer :: i1_do,i2_do,i3_do,i4_do,i1_count,i2_count,ier
  real(8) :: pai,cs,sn
  complex(8), allocatable :: h_ijmn(:,:),s_ijmn(:,:)
  integer :: i, j

  pai=datan(1.d0)*4.d0

  max_atom_orbital=0
  do i1_do=1,num_atom_kind
     if( max_atom_orbital < atom_orbital(i1_do) ) then
        max_atom_orbital=atom_orbital(i1_do)
     end if
  end do

  call alo_hamiltonian_periodic(desc,num_atom)

  allocate(h_ijmn(max_atom_orbital,max_atom_orbital)                           &
       ,s_ijmn(max_atom_orbital,max_atom_orbital),stat=ier)
  if( ier /= 0 ) then
     write(6,*) 'error allocate: set_hamiltonian_periodic'
     stop
  end if


  i1_count=0
  do i1_do=1,num_atom
     jtemp(i1_do)=i1_count
     i1_count=i1_count+atom_orbital(atom_kindn(i1_do))
  end do

  kx=qx
  ky=qy
  do i1_do=1,num_atom
     i1_count=jtemp(i1_do)
     do i2_do=1,num_atom
        i2_count=jtemp(i2_do)
        do lx=-neighbor_x_max,neighbor_x_max
           do ly=-neighbor_y_max,neighbor_y_max
              if( i1_do == i2_do .and. lx == 0 .and. ly == 0 ) then
                 if( ham_model .eq. 'gsp' ) then
                    call onsite_gsp_hamiltonian(max_atom_orbital,i1_do,i2_do         &
                         ,h_ijmn,s_ijmn)
                 else
                    if( ham_model .eq. 'rtb_h' ) then
                       call onsite_rtbh_hamiltonian(max_atom_orbital,i1_do            &
                            ,h_ijmn,s_ijmn)
                    else
                       write(6,*) 'error - ham_model: set_hamiltonian_periodic 1'
                       stop
                    end if
                 end if
                 cs=1.d0
                 sn=0.d0
              else
                 iz=0
                 if( ham_model .eq. 'gsp' ) then
                    call off_gsp_hamiltonian(iz,lx,ly,0,0,i1_do,i2_do                &
                         ,max_atom_orbital,h_ijmn,s_ijmn)
                 else
                    if( ham_model .eq. 'rtb_h' ) then
                       call off_rtbh_hamiltonian(iz,lx,ly,0,0,i1_do,i2_do             &
                            ,max_atom_orbital,h_ijmn,s_ijmn)
                    else
                       write(6,*) 'error - ham_model: set_hamiltonian_periodic 2'
                       stop
                    end if
                 end if
                 cs=dcos(2.d0*pai*(dfloat((kx-1)*lx)/dfloat(kx_max)                 &
                      +dfloat((ky-1)*ly)/dfloat(ky_max)))
                 sn=dsin(2.d0*pai*(dfloat((kx-1)*lx)/dfloat(kx_max)                 &
                      +dfloat((ky-1)*ly)/dfloat(ky_max)))
              end if
              do i3_do=1,atom_orbital(atom_kindn(i1_do))
                 do i4_do=1,atom_orbital(atom_kindn(i2_do))
                    i = i1_count+i3_do
                    j = i2_count+i4_do
                    if( i<desc%srow .or. desc%erow<i ) cycle
                    if( j<desc%scol .or. desc%ecol<j ) cycle

                    h00_mat(i,j) = h00_mat(i,j) + h_ijmn(i3_do,i4_do)*dcmplx(cs,sn) 
                    s00_mat(i,j) = s00_mat(i,j) + s_ijmn(i3_do,i4_do)*dcmplx(cs,sn) 
                 end do
              end do
              iz=l_or_r
              if( ham_model .eq. 'gsp' ) then
                 call off_gsp_hamiltonian(iz,lx,ly,0,0,i1_do,i2_do                  &
                      ,max_atom_orbital,h_ijmn,s_ijmn)
              else
                 if( ham_model .eq. 'rtb_h' ) then
                    call off_rtbh_hamiltonian(iz,lx,ly,0,0,i1_do,i2_do               &
                         ,max_atom_orbital,h_ijmn,s_ijmn)
                 else
                    write(6,*) 'error - ham_model: set_hamiltonian_periodic 3'
                    stop
                 end if
              end if
              do i3_do=1,atom_orbital(atom_kindn(i1_do))
                 do i4_do=1,atom_orbital(atom_kindn(i2_do))
                    i = i1_count+i3_do
                    j = i2_count+i4_do
                    if( i<desc%srow .or. desc%erow<i ) cycle
                    if( j<desc%scol .or. desc%ecol<j ) cycle

                    h10_mat(i,j) = h10_mat(i,j) + h_ijmn(i3_do,i4_do)*dcmplx(cs,sn) 
                    s10_mat(i,j) = s10_mat(i,j) + s_ijmn(i3_do,i4_do)*dcmplx(cs,sn) 

                 end do
              end do
           end do
        end do
     end do
  end do

  call MPI__ZTRANC_ASCOT( desc, C0, h01_mat, C1, h10_mat )  
  call MPI__ZTRANC_ASCOT( desc, C0, s01_mat, C1, s10_mat )  

  deallocate(h_ijmn,s_ijmn,stat=ier)
  if( ier /= 0 ) then
     write(6,*) 'error deallocate: set_hamiltonian_periodic'
     stop
  end if

  return
end subroutine set_hamiltonian_periodic
