! @@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@ !
! @@                                                                @@ !
! @@       PROGRAM  ASCOT 2014.440 (ver.4.53)                       @@ !
! @@     "Abinitio Simulation Code for Quantum Transport"           @@ !
! @@                                                                @@ !
! @@                                                                @@ !
! @@  AUTHOR(S): Hisashi KONDO (Univ. Tokyo)                        @@ !
! @@             Naoki WATANABE (Mizuho I.R.)                       @@ !
! @@             Nobutaka NISHIKAWA (Mizuho I.R.)                   @@ !
! @@                                                09/May/2014     @@ !
! @@                                                                @@ !
! @@  Contact address: Phase System Consortium                      @@ !
! @@                                                                @@ !
! @@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@ !

subroutine set_condition_l

  use condition_ini
  use condition
  use hamiltonian_sgf
  use hamiltonian_temp
  use ac_mpi_module

  implicit none

  integer :: i_w_num,i_w_num1,i1_do,i2_do
  complex(8) :: w,w_int

  ham_model=ham_model_ini
  sgf_method=sgf_method_ini
  iteration_max=iteration_max_ini
  eps=eps_ini
  num_atom_kind=num_atom_kind_ini

  p_or_f=p_or_f_l
  num_unit=num_unit_l
  neighbor_x_max=neighbor_x_max_l
  neighbor_y_max=neighbor_y_max_l
  kx_max=kx_max_l
  ky_max=ky_max_l
  neighbor_z_max=neighbor_z_max_l
  kz_max=kz_max_l
  num_atom=num_atom_l
  v_lr=v_l

  call alo_condition(num_atom_kind,num_atom)

  if( ham_model_ini == 'rtb_h' .or. ham_model_ini == 'gsp' ) then
     atom_sign=atom_sign_ini
     atom_num=atom_num_ini
     atom_mass=atom_mass_ini
     atom_electron=atom_electron_ini
     atom_orbital=atom_orbital_ini

     unit_block=unit_block_l
     atom_kind=atom_kind_l
     ra=ra_l
     atom_kindn=atom_kindn_l
  end if

  if( ham_model == 'gsp' ) then
     pair_num=pair_num_l
  end if

  l_or_r=1
  calc_type_c=calc_type

  dos_on_off=dos_on_off_ini_l
  eigen_s_as=eigen_s_as_ini

  if( ham_model_ini == 'gsp' .or. ham_model_ini == 'rtb_h' ) then
     spin_switch_temp=1
  else
     if( spin_ll == 2 ) then
        spin_switch_temp=2
     else
        spin_switch_temp=1
     end if
  end if


  num_gra_te=num_gra

  i_w_num=0
  do i1_do=1,om_block_num
     i_w_num=i_w_num+num_om_par(i1_do)
  end do

  call alo_condition_omega(i_w_num,om_block_num)
  i_w_num1=0
  do i1_do=1,om_block_num
     omega_par(i1_do)=i_w_num1
     i_w_num1=i_w_num1+num_om_par(i1_do)
     omega_par_num(i1_do)=i_w_num1
     if( om_con_method(i1_do) == 'linear' ) then
        i_w_num=num_om_par(i1_do)
        w_int=(omega_if(i1_do,2)-omega_if(i1_do,1))/dfloat(i_w_num)
        w=omega_if(i1_do,1)-w_int*.5d0
        do i2_do=1,i_w_num
           w=w+w_int
           omega(i2_do)=w
        end do
     end if
  end do


  if( ham_model_ini == 'input' .or. ham_model_ini == 'scf_accel' ) then
     mat_max_eigen=mat_max_ll
  else
     mat_max_eigen=0
     do i1_do=1,num_atom
        mat_max_eigen=mat_max_eigen+atom_orbital(atom_kindn(i1_do))
     end do
     if( p_or_f == 'free' ) then
        mat_max_eigen=mat_max_eigen*num_unit(1)*num_unit(2)
     end if
  end if

  call alo_condition_dos(ka_tr*kb_tr)


  if( spin_ll < 4 ) then
     ele_num_temp=ele_num_ll
  else
     ele_num_temp=ele_num_ll*2
  end if
  lr_switch=-1

  return
end subroutine set_condition_l

subroutine unset_condition_l

  use condition_ini
  use condition

  implicit none

  call unset_condition
  call unset_condition_omega
  call unset_condition_dos

  return
end subroutine unset_condition_l

subroutine set_condition_r
  use condition_ini
  use condition
  use hamiltonian_sgf
  use hamiltonian_temp
  use ac_mpi_module

  implicit none

  integer :: i_w_num,i_w_num1,i1_do,i2_do
  complex(8) :: w,w_int

  ham_model=ham_model_ini
  sgf_method=sgf_method_ini
  iteration_max=iteration_max_ini
  eps=eps_ini
  num_atom_kind=num_atom_kind_ini

  p_or_f=p_or_f_r
  num_unit=num_unit_r
  neighbor_x_max=neighbor_x_max_r
  neighbor_y_max=neighbor_y_max_r
  kx_max=kx_max_r
  ky_max=ky_max_r
  neighbor_z_max=neighbor_z_max_r
  kz_max=kz_max_r
  num_atom=num_atom_r
  v_lr=v_r

  call alo_condition(num_atom_kind,num_atom)

  if( ham_model_ini == 'rtb_h' .or. ham_model_ini == 'gsp' ) then
     atom_sign=atom_sign_ini
     atom_num=atom_num_ini
     atom_mass=atom_mass_ini
     atom_electron=atom_electron_ini
     atom_orbital=atom_orbital_ini

     unit_block=unit_block_r
     atom_kind=atom_kind_r
     ra=ra_r
     atom_kindn=atom_kindn_r
  end if

  if( ham_model == 'gsp' ) then
     pair_num=pair_num_r
  end if

  l_or_r=1
  calc_type_c=calc_type

  dos_on_off=dos_on_off_ini_r
  eigen_s_as=eigen_s_as_ini

  if( ham_model_ini == 'gsp' .or. ham_model_ini == 'rtb_h' ) then
     spin_switch_temp=1
  else
     if( spin_rr == 2 ) then
        spin_switch_temp=2
     else
        spin_switch_temp=1
     end if
  end if


  num_gra_te=num_gra

  i_w_num=0
  do i1_do=1,om_block_num
     i_w_num=i_w_num+num_om_par(i1_do)
  end do

  call alo_condition_omega(i_w_num,om_block_num)
  i_w_num1=0
  do i1_do=1,om_block_num
     omega_par(i1_do)=i_w_num1
     i_w_num1=i_w_num1+num_om_par(i1_do)
     omega_par_num(i1_do)=i_w_num1
     if( om_con_method(i1_do) == 'linear' ) then
        i_w_num=num_om_par(i1_do)
        w_int=(omega_if(i1_do,2)-omega_if(i1_do,1))/dfloat(i_w_num)
        w=omega_if(i1_do,1)-w_int*.5d0
        do i2_do=1,i_w_num
           w=w+w_int
           omega(i2_do)=w
        end do
     end if
  end do


  if( ham_model_ini == 'input' .or. ham_model_ini == 'scf_accel' ) then
     mat_max_eigen=mat_max_rr
  else
     mat_max_eigen=0
     do i1_do=1,num_atom
        mat_max_eigen=mat_max_eigen+atom_orbital(atom_kindn(i1_do))
     end do
     if( p_or_f == 'free' ) then
        mat_max_eigen=mat_max_eigen*num_unit(1)*num_unit(2)
     end if
  end if

  call alo_condition_dos(ka_tr*kb_tr)


  if( spin_rr < 4 ) then
     ele_num_temp=ele_num_rr
  else
     ele_num_temp=ele_num_rr*2
  end if
  lr_switch=1

  return
end subroutine set_condition_r

subroutine unset_condition_r

  use condition_ini
  use condition

  implicit none

  call unset_condition
  call unset_condition_omega
  call unset_condition_dos

  return
end subroutine unset_condition_r
