! @@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@ !
! @@                                                                @@ !
! @@       PROGRAM  ASCOT 2014.440 (ver.4.53)                       @@ !
! @@     "Abinitio Simulation Code for Quantum Transport"           @@ !
! @@                                                                @@ !
! @@                                                                @@ !
! @@  AUTHOR(S): Hisashi KONDO (Univ. Tokyo)                        @@ !
! @@                                                09/May/2014     @@ !
! @@                                                                @@ !
! @@  Contact address: Phase System Consortium                      @@ !
! @@                                                                @@ !
! @@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@ !

module eigen_values

  implicit none
  integer :: mat_ev_max

  integer, pointer :: i_num(:)

  real(8), pointer :: a(:,:),d(:)

  real(8), pointer :: e_temp(:)
  complex(8), pointer :: ev_vec_temp(:,:)

  real(8), pointer :: s_ev(:)
  complex(8), pointer :: ev_vec(:,:)

  real(8), pointer :: a_as(:,:)
  complex(8), pointer :: d_as(:)

contains
  subroutine alo_eigen_values_1

    implicit none
    integer :: ier

    allocate(a(mat_ev_max,mat_ev_max),d(mat_ev_max),i_num(mat_ev_max),stat=ier)
    if( ier /= 0 ) then
       write(6,*) 'error allocate: alo_eigen_values_1'
       stop
    end if

    return
  end subroutine alo_eigen_values_1

  subroutine unset_eigen_values_1

    implicit none
    integer :: ier

    deallocate(a,d,i_num,stat=ier)
    if( ier /= 0 ) then
       write(6,*) 'error deallocate: unset_eigen_values_1'
       stop
    end if

    return
  end subroutine unset_eigen_values_1

  subroutine alo_eigen_values_2

    implicit none
    integer :: ier

    allocate(e_temp(mat_ev_max),ev_vec_temp(mat_ev_max/2,mat_ev_max),stat=ier)
    if( ier /= 0 ) then
       write(6,*) 'error allocate: alo_eigen_values_2'
       stop
    end if

    return
  end subroutine alo_eigen_values_2

  subroutine unset_eigen_values_2

    implicit none
    integer :: ier

    deallocate(e_temp,ev_vec_temp,stat=ier)
    if( ier /= 0 ) then
       write(6,*) 'error deallocate: unset_eigen_values_2'
       stop
    end if

    return
  end subroutine unset_eigen_values_2

  subroutine alo_eigen_values_3

    implicit none
    integer :: ier

    allocate(s_ev(mat_ev_max/2),ev_vec(mat_ev_max/2,mat_ev_max/2),stat=ier)
    if( ier /= 0 ) then
       write(6,*) 'error allocate: alo_eigen_values_3'
       stop
    end if

    return
  end subroutine alo_eigen_values_3

  subroutine unset_eigen_values_3

    implicit none
    integer :: ier

    deallocate(s_ev,ev_vec,stat=ier)
    if( ier /= 0 ) then
       write(6,*) 'error deallocate: unset_eigen_values_3'
       stop
    end if

    return
  end subroutine unset_eigen_values_3

  subroutine alo_eigen_values_as

    implicit none
    integer :: ier

    allocate(a_as(mat_ev_max,mat_ev_max),d_as(mat_ev_max),i_num(mat_ev_max)      &
         ,stat=ier)
    if( ier /= 0 ) then
       write(6,*) 'error allocate: alo_eigen_values_as'
       stop
    end if

    return
  end subroutine alo_eigen_values_as

  subroutine unset_eigen_values_as

    implicit none
    integer :: ier

    deallocate(a_as,d_as,i_num,stat=ier)
    if( ier /= 0 ) then
       write(6,*) 'error deallocate: unset_eigen_values_as'
       stop
    end if

    return
  end subroutine unset_eigen_values_as

end module eigen_values
