! @@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@ !
! @@                                                                @@ !
! @@       PROGRAM  ASCOT 2014.440 (ver.4.40)                       @@ !
! @@     "Abinitio Simulation Code for Quantum Transport"           @@ !
! @@                                                                @@ !
! @@                                                                @@ !
! @@  AUTHOR(S): Hisashi KONDO (Univ. Tokyo)                        @@ !
! @@                                                09/May/2014     @@ !
! @@                                                                @@ !
! @@  Contact address: Phase System Consortium                      @@ !
! @@                                                                @@ !
! @@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@ !

subroutine set_scf_general(i_omega_switch,i_omega_switch2,omega_del_temp           &
     ,omega_ef_temp)

  use condition_ini
  use scf_negf
  use constant
  use mod_mpi

  implicit none
  integer, intent(inout) :: i_omega_switch,i_omega_switch2
  real(8), intent(inout) :: omega_del_temp,omega_ef_temp

  integer :: i_do

  character(50) :: temp_chara,temp_chara1
  integer :: i_check,j_check
  character(256) :: buf
  character(50) :: dummy1,dummy2
  character(50) :: tag1,tag2,tag3

  open(unit=16,file=file_tempout,position='append')
  write(16,*)
  write(16,*)
  write(16,*) '********************** **************** **********************'
  write(16,*) '*                 input  condition  ! f_scf !                *'
  write(16,*) '********************** **************** **********************'
  write(16,*)
  close(16)

  !                       ------------------------------------                       !

  restart_onoff=''
  file_selfenergy_onoff=''
  ft_switch='f_2_ft'
  method_sum_om_scf=1
  i_gzero_method=0
  hartree_switch=0
  gzero_gamma=0.d0
  force_calc_onoff=''
  open(unit=19,file=file_parameter,status='old')
  do 
     read(19,'(a)',end=110) buf
     if( buf == '' ) then
        cycle
     end if
     read(buf,*) tag1
     if( tag1(1:1) == '#' ) then
        cycle
     end if
     select case(tag1)
     case('negf_scf_general{')
        do 
           read(19,'(a)',end=110) buf
           if( buf == '' ) then
              cycle
           end if
           read(buf,*) tag2
           if( tag2(1:1) == '#' ) then
              cycle
           end if
           select case(tag2)
           case('read_self_file')
              read(buf,*) dummy1,dummy2,file_selfenergy_onoff
           case('calc_start')
              read(buf,*) dummy1,dummy2,restart_onoff
           case('fft_type')
              read(buf,*) dummy1,dummy2,ft_switch
           case('method_charge_sum')
              read(buf,*) dummy1,dummy2,temp_chara
              if( temp_chara == 'square' ) then
                 method_sum_om_scf=1
              end if
              if( temp_chara == 'u_temp' ) then
                 method_sum_om_scf=2
              end if
           case('poisson_mathod','poisson_method')
              read(buf,*) dummy1,dummy2,temp_chara
              if( temp_chara == 'ft' ) then
                 hartree_switch=0
              end if
              if( temp_chara == 'gf' ) then
                 hartree_switch=1
                 i_gzero_method=1
              end if
           case('poisson_K_value')
              read(buf,*) dummy1,dummy2,gzero_gamma
           case('calc_force')
              read(buf,*) dummy1,dummy2,force_calc_onoff
           case('}negf_scf_general')
              go to 110
           end select
        end do
     end select
  end do
110 continue
  close(19)
  if( method_sum_om_scf == 0 ) then
     open(unit=17,file=file_tempout,position='append')
     write(17,*)                                                              &
          '??? broken ??? //negf_scf_general/method_charge_sum// => def'
     method_sum_om_scf=1
     close(17)
  end if
  if( file_selfenergy_onoff == '' ) then
     file_selfenergy_onoff='none'
     open(unit=17,file=file_tempout,position='append')
     write(17,*) '??? broken ??? //negf_scf_general/read_self_file// => def'
     close(17)
  end if
  if( restart_onoff == '' ) then
     restart_onoff='f_density'
     open(unit=17,file=file_tempout,position='append')
     write(17,*) '??? broken ??? //negf_scf_general/calc_start// => def'
     close(17)
  end if
  if( ft_switch == '' ) then
     ft_switch='f_2_ft'
     open(unit=17,file=file_tempout,position='append')
     write(17,*) '??? broken ??? //negf_scf_general/fft_type// => def'
     close(17)
  end if
  if( gzero_gamma == 0.d0 .and. i_gzero_method == 1 ) then
     gzero_gamma=0.1d-05
     open(unit=17,file=file_tempout,position='append')
     write(17,*) '??? broken ??? //negf_scf_general/poisson_K_value// => def'
     close(17)
  end if
  if( force_calc_onoff == '' ) then
     force_calc_onoff='off'
     open(unit=17,file=file_tempout,position='append')
     write(17,*) '??? broken ??? //negf_scf_general/calc_force// => off'
     close(17)
  end if

  !                       ------------------------------------                       !

  file_parameter_hc_scf=''
  file_parameter_hl_scf=''
  file_parameter_hr_scf=''
  file_parameter_cv1_pot=''
  file_parameter_ham_pot=''
  file_parameter_lv1_scf=''
  file_parameter_rv1_scf=''
  file_parameter_out_pot=''
  file_parameter_out_vh0=''
  file_selfenergy_scf=''
  open(unit=19,file=file_parameter,status='old')
  do 
     read(19,'(a)',end=100) buf
     if( buf == '' ) then
        cycle
     end if
     read(buf,*) tag1
     if( tag1(1:1) == '#' ) then
        cycle
     end if
     select case(tag1)
     case('negf_scf_file{')
        do 
           read(19,'(a)',end=100) buf
           if( buf == '' ) then
              cycle
           end if
           read(buf,*) tag2
           if( tag2(1:1) == '#' ) then
              cycle
           end if
           select case(tag2)
           case('input_hs_central')
              read(buf,*) dummy1,dummy2,file_parameter_hc_scf
           case('input_hs_junc')
              read(buf,*) dummy1,dummy2,file_parameter_hc_scf
           case('input_hs_left')
              read(buf,*) dummy1,dummy2,file_parameter_hl_scf
           case('input_hs_right')
              read(buf,*) dummy1,dummy2,file_parameter_hr_scf
           case('input_accel_cond')
              read(buf,*) dummy1,dummy2,file_parameter_ham_pot
           case('input_junc_cond')
              read(buf,*) dummy1,dummy2,file_parameter_ham_pot
           case('input_pr_central')
              read(buf,*) dummy1,dummy2,file_parameter_cv1_pot
           case('input_pr_junc')
              read(buf,*) dummy1,dummy2,file_parameter_cv1_pot
           case('input_pr_left')
              read(buf,*) dummy1,dummy2,file_parameter_lv1_scf
           case('input_pr_right')
              read(buf,*) dummy1,dummy2,file_parameter_rv1_scf
           case('input_pp_central')
              read(buf,*) dummy1,dummy2,file_parameter_cv1_pot
           case('input_pp_junc')
              read(buf,*) dummy1,dummy2,file_parameter_cv1_pot
           case('input_pp_left')
              read(buf,*) dummy1,dummy2,file_parameter_lv1_scf
           case('input_pp_right')
              read(buf,*) dummy1,dummy2,file_parameter_rv1_scf
           case('output_pr_central')
              read(buf,*) dummy1,dummy2,file_parameter_out_pot
           case('output_pr_junc')
              read(buf,*) dummy1,dummy2,file_parameter_out_pot
           case('output_pp_central')
              read(buf,*) dummy1,dummy2,file_parameter_out_pot
           case('output_hs_junc')
              read(buf,*) dummy1,dummy2,file_parameter_out_vh0
           case('output_junc_vh0')
              read(buf,*) dummy1,dummy2,file_parameter_out_vh0
           case('output_accel_vh0')
              read(buf,*) dummy1,dummy2,file_parameter_out_vh0
           case('self_e_file')
              read(buf,*) dummy1,dummy2,file_selfenergy_scf
           case('}negf_scf_file')
              go to 100
           end select
        end do
     end select
  end do
100 continue
  close(19)
  if( file_parameter_hc_scf == '' ) then
     open(unit=17,file=file_tempout,position='append')
     write(17,*) '??? broken ??? //negf_scf_file/input_hs_junc// => stop'
     close(17)
     stop
  end if
  if( file_parameter_hl_scf == '' ) then
     open(unit=17,file=file_tempout,position='append')
     write(17,*) '??? broken ??? //negf_scf_file/input_hs_left// => stop'
     close(17)
     stop
  end if
  if( file_parameter_hr_scf == '' ) then
     open(unit=17,file=file_tempout,position='append')
     write(17,*) '??? broken ??? //negf_scf_file/input_hs_right// => stop'
     close(17)
     stop
  end if
  if( file_parameter_ham_pot == '' .and. ham_model_ini == 'scf_accel' ) then
     open(unit=17,file=file_tempout,position='append')
     write(17,*) '??? broken ??? //negf_scf_file/input_accel_cond// => stop'
     close(17)
     stop
  end if
  if( file_parameter_cv1_pot == '' ) then
     open(unit=17,file=file_tempout,position='append')
     write(17,*) '??? broken ??? //negf_scf_file/input_pr_junc// => stop'
     close(17)
     stop
  end if
  if( file_parameter_lv1_scf == '' ) then
     open(unit=17,file=file_tempout,position='append')
     write(17,*) '??? broken ??? //negf_scf_file/input_pr_left// => stop'
     close(17)
     stop
  end if
  if( file_parameter_rv1_scf == '' ) then
     open(unit=17,file=file_tempout,position='append')
     write(17,*) '??? broken ??? //negf_scf_file/input_pr_right// => stop'
     close(17)
     stop
  end if
  if( file_selfenergy_scf == '' .and. file_selfenergy_onoff == 'exist' ) then
     open(unit=17,file=file_tempout,position='append')
     write(17,*) '??? broken ??? //negf_scf_file/self_e_file// => stop'
     close(17)
     stop
  end if
  if( file_parameter_out_pot == '' ) then
     file_parameter_out_pot='ascot_pot.output'
     open(unit=17,file=file_tempout,position='append')
     write(17,*) '??? broken ??? //negf_scf_file/output_pr_junc// => def'
     close(17)
  end if
  if( file_parameter_out_vh0 == '' ) then
     file_parameter_out_vh0='ascot_vh0.output'
     open(unit=17,file=file_tempout,position='append')
     write(17,*) '??? broken ??? //negf_scf_file/output_hs_junc// => def'
     close(17)
  end if

  !                       ------------------------------------                       !

  max_num_scf=-1
  eps_scf=0.d0
  ka_scf=0
  kb_scf=0
  sw_shift_chem='off'
  open(unit=19,file=file_parameter,status='old')
  do 
     read(19,'(a)',end=120) buf
     if( buf == '' ) then
        cycle
     end if
     read(buf,*) tag1
     if( tag1(1:1) == '#' ) then
        cycle
     end if
     select case(tag1)
     case('negf_scf_accuracy{')
        do 
           read(19,'(a)',end=120) buf
           if( buf == '' ) then
              cycle
           end if
           read(buf,*) tag2
           if( tag2(1:1) == '#' ) then
              cycle
           end if
           select case(tag2)
           case('num_max_iteration')
              read(buf,*) dummy1,dummy2,max_num_scf
           case('scf_convergence')
              read(buf,*) dummy1,dummy2,eps_scf
           case('ksampling')
              read(buf,*) dummy1,dummy2,tag3
              if( tag3 == 'gamma' ) then
                 ka_scf=1
                 kb_scf=1
              else
                 read(buf,*) dummy1,dummy2,ka_scf,kb_scf
              end if
           case('sw_shift_chem')
              read(buf,*) dummy1,dummy2,sw_shift_chem
           case('}negf_scf_accuracy')
              go to 120
           end select
        end do
     end select
  end do
120 continue
  close(19)
  if( max_num_scf < 0 ) then
     max_num_scf=0
     open(unit=17,file=file_tempout,position='append')
     write(17,*) '??? broken ??? //negf_scf_accuracy/num_max_iteration// => 0'
     close(17)
  end if
  if( eps_scf == 0.d0 ) then
     eps_scf=1.d-2
     open(unit=17,file=file_tempout,position='append')
     write(17,*) '??? broken ??? //negf_scf_accuracy/scf_convergence// => def'
     close(17)
  end if
  if( ka_scf*kb_scf == 0 ) then
     open(unit=17,file=file_tempout,position='append')
     write(17,*) '???     ??? //negf_scf_accuracy/ksampling//',ka_scf,kb_scf
     close(17)
  end if

  !                       ------------------------------------                       !

  scf_bias=''
  v_scf_l=0.d0
  v_scf_r=0.d0
  om_im_bias=0.d0
  num_om_bias=0
  i_check=0
  open(unit=19,file=file_parameter,status='old')
  do 
     read(19,'(a)',end=130) buf
     if( buf == '' ) then
        cycle
     end if
     read(buf,*) tag1
     if( tag1(1:1) == '#' ) then
        cycle
     end if
     select case(tag1)
     case('negf_scf_bias{')
        do 
           read(19,'(a)',end=130) buf
           if( buf == '' ) then
              cycle
           end if
           read(buf,*) tag2
           if( tag2(1:1) == '#' ) then
              cycle
           end if
           select case(tag2)
           case('switch')
              read(buf,*) dummy1,dummy2,scf_bias
           case('v_left')
              read(buf,*) dummy1,dummy2,v_scf_l
           case('v_right')
              read(buf,*) dummy1,dummy2,v_scf_r
           case('cdm_mesh_num')
              read(buf,*) dummy1,dummy2,num_om_bias
           case('cdm_im_energy')
              read(buf,*) dummy1,dummy2,om_im_bias
           case('cdm_om_del_energy')
              read(buf,*) dummy1,dummy2,om_del_bias
              i_check=1
           case('}negf_scf_bias')
              go to 130
           end select
        end do
     end select
  end do
130 continue
  close(19)
  if( scf_bias == 'on' .and. om_im_bias == 0.d0 ) then
     open(unit=17,file=file_tempout,position='append')
     write(17,*) '??? broken ??? //negf_scf_bias/cdm_im_energy// => stop'
     close(17)
     stop
  end if
  if( scf_bias == 'on' .and. num_om_bias == 0 ) then
     open(unit=17,file=file_tempout,position='append')
     write(17,*) '??? broken ??? //negf_scf_bias/cdm_mesh_num// => stop'
     close(17)
     stop
  end if
  if( scf_bias == '' ) then
     scf_bias='off'
     open(unit=17,file=file_tempout,position='append')
     write(17,*) '??? broken ??? //negf_scf_bias/switch// => off'
     close(17)
  end if
  if( scf_bias /= 'off' .and. dabs(v_scf_r)+dabs(v_scf_l) == 0.d0 ) then
     scf_bias='off'
     open(unit=17,file=file_tempout,position='append')
     write(17,*) '??? broken ??? //negf_scf_bias/v// switch => off'
     close(17)
  end if
  if( scf_bias == 'on' .and. i_check == 0 ) then
     om_del_bias=0.d0
     open(unit=17,file=file_tempout,position='append')
     write(17,*) '??? broken ??? //negf_scf_bias/cdm_om_del_energy// => def'
     close(17)
  end if
  if( scf_bias /= 'on' ) then
     v_scf_l=0.d0
     v_scf_r=0.d0
  end if

  !                       ------------------------------------                       !

  i_rotspin_l=0
  i_rotspin_r=0
  i_check=0
  j_check=0
  shift_cell_l1=100000.d0
  shift_cell_l2=100000.d0
  open(unit=19,file=file_parameter,status='old')
  do 
     read(19,'(a)',end=140) buf
     if( buf == '' ) then
        cycle
     end if
     read(buf,*) tag1
     if( tag1(1:1) == '#' ) then
        cycle
     end if
     select case(tag1)
     case('negf_spin_rot{')
        do 
           read(19,'(a)',end=140) buf
           if( buf == '' ) then
              cycle
           end if
           read(buf,*) tag2
           if( tag2(1:1) == '#' ) then
              cycle
           end if
           select case(tag2)
           case('switch_left')
              read(buf,*) dummy1,dummy2,temp_chara
              if( temp_chara == 'on' ) then
                 i_rotspin_l=1
              end if
              if( temp_chara == 'off' ) then
                 i_rotspin_l=0
              end if
           case('switch_right')
              read(buf,*) dummy1,dummy2,temp_chara
              if( temp_chara == 'on' ) then
                 i_rotspin_r=1
              end if
              if( temp_chara == 'off' ) then
                 i_rotspin_r=0
              end if
           case('boundary_g_num')
              read(buf,*) dummy1,dummy2,shift_cell_l1
           case('boundary_g_den')
              read(buf,*) dummy1,dummy2,shift_cell_l2
              i_check=1
           case('}negf_spin_rot')
              go to 140
           end select
        end do
     end select
  end do
140 continue
  close(19)
  if( i_rotspin_l < 0 ) then
     i_rotspin_l=0
     open(unit=17,file=file_tempout,position='append')
     write(17,*) '??? broken ??? //negf_spin_rot/switch_left// => off'
     close(17)
  end if
  if( i_rotspin_r < 0 ) then
     i_rotspin_r=0
     open(unit=17,file=file_tempout,position='append')
     write(17,*) '??? broken ??? //negf_spin_rot/switch_right// => off'
     close(17)
  end if
  if( shift_cell_l2 == 0) then
     shift_cell_l1=0
     shift_cell_l2=1
     open(unit=17,file=file_tempout,position='append')
     write(17,*) '       changed: shift_cell_l2 == 0'
     close(17)
  end if

  !                       ------------------------------------                       !

  dis_chara='def'
  res_bound_l=0.d0
  res_bound_r=0.d0
  lay_chara='def'
  atom_parlay_l=0
  atom_parlay_r=0
  i_check=0
  j_check=0
  open(unit=19,file=file_parameter,status='old')
  do 
     read(19,'(a)',end=150) buf
     if( buf == '' ) then
        cycle
     end if
     read(buf,*) tag1
     if( tag1(1:1) == '#' ) then
        cycle
     end if
     select case(tag1)
     case('negf_to_manually{')
        do 
           read(19,'(a)',end=150) buf
           if( buf == '' ) then
              cycle
           end if
           read(buf,*) tag2
           if( tag2(1:1) == '#' ) then
              cycle
           end if
           select case(tag2)
           case('switch_fix_boundary')
              read(buf,*) dummy1,dummy2,dis_chara
           case('fix_boundary_left')
              read(buf,*) dummy1,dummy2,res_bound_l
           case('fix_boundary_right')
              read(buf,*) dummy1,dummy2,res_bound_r
           case('switch_fix_atom_num')
              read(buf,*) dummy1,dummy2,lay_chara
           case('fix_atom_num_left')
              read(buf,*) dummy1,dummy2,atom_parlay_l
           case('fix_atom_num_right')
              read(buf,*) dummy1,dummy2,atom_parlay_r
           case('}negf_to_manually')
              go to 150
           end select
        end do
     end select
  end do
150 continue
  close(19)
  if( dis_chara == 'on' .and. dabs(res_bound_l)+dabs(res_bound_r) == 0.d0 ) then
     dis_chara='def'
     open(unit=17,file=file_tempout,position='append')
     write(17,*) '??? broken ??? //negf_to_manually/fix_boundary// => off'
     close(17)
  end if
  if( lay_chara == 'on'                                                        &
       .and. iabs(atom_parlay_l)+iabs(atom_parlay_r) == 0.d0 ) then
     lay_chara='def'
     open(unit=17,file=file_tempout,position='append')
     write(17,*) '??? broken ??? //negf_to_manually/fix_atom_num// => off'
     close(17)
  end if

  lay_shift_l=1
  lay_shift_r=1
  res_bound_l=res_bound_l/dis_scale
  res_bound_r=res_bound_r/dis_scale

  !                       ------------------------------------                       !

  iter_conv=-100
  mixing=0.d0
  mixing_rho=0.d0
  mixing_vto=0.d0
  mixing_max=0.d0
  mixing_dm=0.d0
  mixing_dm_s=0.d0
  negf_mix_history=0
  negf_mix_start=0
  iter_mm=0
  i_check=0
  open(unit=19,file=file_parameter,status='old')
  do 
     read(19,'(a)',end=160) buf
     if( buf == '' ) then
        cycle
     end if
     read(buf,*) tag1
     if( tag1(1:1) == '#' ) then
        cycle
     end if
     select case(tag1)
     case('negf_scf_mixing{')
        do 
           read(19,'(a)',end=160) buf
           if( buf == '' ) then
              cycle
           end if
           read(buf,*) tag2
           if( tag2(1:1) == '#' ) then
              cycle
           end if
           select case(tag2)
           case('mixing_methods')
              read(buf,*) dummy1,dummy2,temp_chara
              i_check=1
              if( temp_chara == 'ham' ) then
                 iter_conv=0
              end if
              if( temp_chara == 'rho' ) then
                 iter_conv=1
              end if
              if( temp_chara == 'vtot' ) then
                 iter_conv=-1
              end if
              if( temp_chara == 'u_ma' ) then
                 iter_conv=2
              end if
              if( temp_chara == 's_nu' ) then
                 iter_conv=3
              end if
              if( temp_chara == 'anderson_ham' ) then
                 iter_conv=4
              end if
              if( temp_chara == 'simple_dm' ) then
                 iter_conv=11
              end if
              if( temp_chara == 'pulay_dm' ) then
                 iter_conv=12
              end if
              if( temp_chara == 'anderson_dm' ) then
                 iter_conv=13
              end if
              if( temp_chara == 'simple_rho'                                 &
                   .or. temp_chara == 'simple_density' ) then
                 iter_conv=21
              end if
              if( temp_chara == 'pulay_rho'                                  &
                   .or. temp_chara == 'pulay_density' ) then
                 iter_conv=22
              end if
              if( temp_chara == 'anderson_rho'                               &
                   .or. temp_chara == 'anderson_density' ) then
                 iter_conv=23
              end if
           case('mixing_ham_weight')
              read(buf,*) dummy1,dummy2,mixing
           case('mixing_ham_w_max')
              read(buf,*) dummy1,dummy2,mixing_max
           case('mixing_rho_weight')
              read(buf,*) dummy1,dummy2,mixing_rho
           case('mixing_vto_weight')
              read(buf,*) dummy1,dummy2,mixing_vto
           case('switch_num_mw')
              read(buf,*) dummy1,dummy2,iter_mm
           case('mixing_dm_weight')
              read(buf,*) dummy1,dummy2,mixing_dm
           case('mixing_dm_s_weight')
              read(buf,*) dummy1,dummy2,mixing_dm_s
           case('pulay_mix_history')
              read(buf,*) dummy1,dummy2,negf_mix_history
           case('pulay_mix_start')
              read(buf,*) dummy1,dummy2,negf_mix_start
           case('}negf_scf_mixing')
              go to 160
           end select
        end do
     end select
  end do
160 continue
  close(19)
  if( iter_conv < 10 ) then
     iter_conv=12
     open(unit=17,file=file_tempout,position='append')
     write(17,*)                                                              &
          '??? broken ??? //negf_scf_mixing/mixing_methods// => pulay_dm'
     close(17)
  end if
  if( mixing_dm == 0.d0 .and. ( iter_conv > 10 .and. iter_conv < 30 ) ) then
     mixing_dm=0.1d0
     open(unit=17,file=file_tempout,position='append')
     write(17,*) '??? broken ??? //negf_scf_mixing/mixing_dm_weight// => 0.1'
     close(17)
  end if
  if( mixing_dm_s == 0.d0 .and. ( iter_conv > 10 .and. iter_conv < 30 ) ) then
     mixing_dm_s=0.01d0
     open(unit=17,file=file_tempout,position='append')
     write(17,*) '??? broken ??? //negf_scf_mixing/mixing_dm_s_weight// => 0.01'
     close(17)
  end if
  if( negf_mix_history == 0 .and. ( iter_conv > 10 .and. iter_conv < 30 ) ) then
     negf_mix_history=4
     open(unit=17,file=file_tempout,position='append')
     write(17,*) '??? broken ??? //negf_scf_mixing/pulay_mix_history// => 4'
     close(17)
  end if
  if( negf_mix_start == 0 .and. ( iter_conv > 10 .and. iter_conv < 30 ) ) then
     negf_mix_start=10
     open(unit=17,file=file_tempout,position='append')
     write(17,*) '??? broken ??? //negf_scf_mixing/pulay_mix_start// => 10'
     close(17)
  end if

  if( iter_conv == 1 ) then
     mixing=1.d0
     mixing_vto=1.d0
     mixing_dm=1.d0
     mixing_dm_s=1.d0
  else
     if( iter_conv == -1 ) then
        mixing=1.d0
        mixing_rho=1.d0
        mixing_dm=1.d0
        mixing_dm_s=1.d0
     else
        if( iter_conv < 10 ) then
           mixing_rho=1.d0
           mixing_vto=1.d0
           mixing_dm=1.d0
           mixing_dm_s=1.d0
        else
           mixing=1.d0
           mixing_rho=1.d0
           mixing_vto=1.d0
        end if
     end if
  end if

  !                       ------------------------------------                       !

  if( method_sum_om_scf == 1 ) then
     om_block_num_scf=0
     open(unit=19,file=file_parameter,status='old')
     do 
        read(19,'(a)',end=170) buf
        if( buf == '' ) then
           cycle
        end if
        read(buf,*) tag1
        if( tag1(1:1) == '#' ) then
           cycle
        end if
        select case(tag1)
        case('negf_scf_energy_m1{')
           do 
              read(19,'(a)',end=170) buf
              if( buf == '' ) then
                 cycle
              end if
              read(buf,*) tag2
              if( tag2(1:1) == '#' ) then
                 cycle
              end if
              select case(tag2)
              case('block_num')
                 read(buf,*) dummy1,dummy2,om_block_num_scf
              case('}negf_scf_energy_m1')
                 go to 170
              end select
           end do
        end select
     end do
170  continue
     close(19)
  end if
  if( method_sum_om_scf == 2 ) then
     om_block_num_scf=1
     open(unit=19,file=file_parameter,status='old')
     do 
        read(19,'(a)',end=175) buf
        if( buf == '' ) then
           cycle
        end if
        read(buf,*) tag1
        if( tag1(1:1) == '#' ) then
           cycle
        end if
        select case(tag1)
        case('negf_scf_energy_m2{')
           do 
              read(19,'(a)',end=175) buf
              if( buf == '' ) then
                 cycle
              end if
              read(buf,*) tag2
              if( tag2(1:1) == '#' ) then
                 cycle
              end if
              select case(tag2)
              case('block_num')
                 read(buf,*) dummy1,dummy2,om_block_num_scf
              case('}negf_scf_energy_m2')
                 go to 175
              end select
           end do
        end select
     end do
175  continue
     close(19)
  end if
  if( om_block_num_scf == 0 .and. method_sum_om_scf == 1 ) then
     om_block_num_scf=1
  end if
  if( om_block_num_scf /= 1 .and. method_sum_om_scf == 2 ) then
     om_block_num_scf=1
  end if
  call alo_scf_negf_omega1

  if( method_sum_om_scf == 1 ) then
     i_omega_switch=-1
     omega_del_temp=0.d0
     i_check=0
     j_check=0
     do i_do=1,om_block_num_scf
        num_om_par_scf(i_do,1)=0
        num_om_par_scf(i_do,2)=0
        num_om_par_scf(i_do,3)=0
        omega_if_scf(i_do,3)=0.d0
        omega_if_scf(i_do,4)=0.d0
        om_con_method_scf(i_do)=''
     end do
     open(unit=19,file=file_parameter,status='old')
     do 
        read(19,'(a)',end=180) buf
        if( buf == '' ) then
           cycle
        end if
        read(buf,*) tag1
        if( tag1(1:1) == '#' ) then
           cycle
        end if
        select case(tag1)
        case('negf_scf_energy_m1{')
           do 
              read(19,'(a)',end=180) buf
              if( buf == '' ) then
                 cycle
              end if
              read(buf,*) tag2
              if( tag2(1:1) == '#' ) then
                 cycle
              end if
              select case(tag2)
              case('min_energy_pos')
                 read(buf,*) dummy1,dummy2,omega_del_temp
                 i_check=1
              case('m_v_min_energy_pos')
                 read(buf,*) dummy1,dummy2,temp_chara
                 if( temp_chara == 'real' ) then
                    i_omega_switch=0
                 end if
                 if( temp_chara == 'relative' ) then
                    i_omega_switch=1
                 end if
              case('block_cond_add{')
                 read(buf,*) dummy1,i_do
                 if( i_do >= om_block_num_scf .or. i_do < 1 ) then
                    cycle
                 end if
                 do 
                    read(19,'(a)',end=180) buf
                    if( buf == '' ) then
                       cycle
                    end if
                    read(buf,*) tag3
                    if( tag3(1:1) == '#' ) then
                       cycle
                    end if
                    select case(tag3)
                    case('blank_min_energy')
                       read(buf,*) dummy1,dummy2,omega_if_scf(i_do,2)
                       j_check=j_check+1
                    case('blank_max_energy')
                       read(buf,*) dummy1,dummy2,omega_if_scf(i_do+1,1)
                       j_check=j_check+1
                    case('im_energy')
                       read(buf,*) dummy1,dummy2,omega_if_scf(i_do,4)
                    case('mesh_num_min')
                       read(buf,*) dummy1,dummy2,num_om_par_scf(i_do,1)
                    case('mesh_num_ima')
                       read(buf,*) dummy1,dummy2,num_om_par_scf(i_do,2)
                    case('mesh_num_max')
                       read(buf,*) dummy1,dummy2,num_om_par_scf(i_do,3)
                    case('mesh_method_ef')
                       read(buf,*) dummy1,dummy2,om_con_method_scf(i_do)
                    case('}block_cond_add')
                       exit
                    end select
                 end do
              case('block_cond0{')
                 i_do=om_block_num_scf
                 do 
                    read(19,'(a)',end=180) buf
                    if( buf == '' ) then
                       cycle
                    end if
                    read(buf,*) tag3
                    if( tag3(1:1) == '#' ) then
                       cycle
                    end if
                    select case(tag3)
                    case('im_energy')
                       read(buf,*) dummy1,dummy2,omega_if_scf(i_do,4)
                    case('mesh_num_min')
                       read(buf,*) dummy1,dummy2,num_om_par_scf(i_do,1)
                    case('mesh_num_ima')
                       read(buf,*) dummy1,dummy2,num_om_par_scf(i_do,2)
                    case('mesh_num_ef')
                       read(buf,*) dummy1,dummy2,num_om_par_scf(i_do,3)
                    case('mesh_method_ef')
                       read(buf,*) dummy1,dummy2,om_con_method_scf(i_do)
                    case('}block_cond0')
                       exit
                    end select
                 end do
              case('}negf_scf_energy_m1')
                 go to 180
              end select
           end do
        end select
     end do
180  continue
     close(19)
     if( j_check /= 2*om_block_num_scf-2 .and. om_block_num_scf > 1 ) then
        open(unit=17,file=file_tempout,position='append')
        write(17,*)                                                            &
             '??? broken ???: //negf_scf_energy_m1/blank_**_energy// => stop'
        close(17)
        stop
     end if
     if( i_check == 0 ) then
        omega_del_temp=5.d0
        i_omega_switch=1
        open(unit=17,file=file_tempout,position='append')
        write(17,*)                                                            &
             '??? broken ???: //negf_scf_energy_m1/min_energy_pos// => def'
        close(17)
     end if
     if( i_omega_switch < 0 ) then
        i_omega_switch=1
        open(unit=17,file=file_tempout,position='append')
        write(17,*)                                                            &
             '??? broken ???: //negf_scf_energy_m1/m_v_min_energy_pos// => def'
        close(17)
     end if
     do i_do=1,om_block_num_scf
        if( num_om_par_scf(i_do,1) == 0 ) then
           num_om_par_scf(i_do,1)=5
           open(unit=17,file=file_tempout,position='append')
           write(17,*)                                                          &
                i_do,'??? broken ???: //negf_scf_energy_m1/mesh_num_min// => def'
           close(17)
        end if
        if( num_om_par_scf(i_do,2) == 0 ) then
           num_om_par_scf(i_do,2)=15
           open(unit=17,file=file_tempout,position='append')
           write(17,*)                                                          &
                i_do,'??? broken ???: //negf_scf_energy_m1/mesh_num_min// => def'
           close(17)
        end if
        if( num_om_par_scf(i_do,3) == 0 ) then
           num_om_par_scf(i_do,3)=10
           open(unit=17,file=file_tempout,position='append')
           write(17,*)                                                          &
                i_do,'??? broken ???: //negf_scf_energy_m1/mesh_num_min// => def'
           close(17)
        end if
        if( omega_if_scf(i_do,4) == 0.d0 ) then
           omega_if_scf(i_do,4)=0.63d0
           open(unit=17,file=file_tempout,position='append')
           write(17,*)                                                          &
                i_do,'??? broken ???: //negf_scf_energy_m1/mesh_num_min// => def'
           close(17)
        end if
        if( om_con_method_scf(i_do) == '' ) then
           om_con_method_scf(i_do)='linear'
           open(unit=17,file=file_tempout,position='append')
           write(17,*)                                                          &
                i_do,'??? broken ???: //negf_scf_energy_m1/mesh_num_min// => def'
           close(17)
        end if
        if( om_con_method_scf(i_do) == 'log' ) then
           omega_if_scf(i_do,3)=1.d-3
        end if
     end do
  end if

  if( method_sum_om_scf == 2 ) then
     i_do=1
     om_con_method_scf(i_do)='linear'
     omega_del_temp=0.d0
     omega_gamm(i_do)=0.d0
     omega_tem(i_do)=0.d0
     omega_if_scf(i_do,3)=0.d0
     omega_if_scf(i_do,4)=0.d0
     omega_ef_temp=0.d0
     num_om_par_scf(i_do,1)=0
     num_om_par_scf(i_do,2)=0
     i_omega_switch=-1
     i_omega_switch2=-1
     i_check=0
     j_check=0
     open(unit=19,file=file_parameter,status='old')
     do 
        read(19,'(a)',end=185) buf
        if( buf == '' ) then
           cycle
        end if
        read(buf,*) tag1
        if( tag1(1:1) == '#' ) then
           cycle
        end if
        select case(tag1)
        case('negf_scf_energy_m2{')
           do 
              read(19,'(a)',end=185) buf
              if( buf == '' ) then
                 cycle
              end if
              read(buf,*) tag2
              if( tag2(1:1) == '#' ) then
                 cycle
              end if
              select case(tag2)
              case('mesh_method_cir')
                 read(buf,*) dummy1,dummy2,om_con_method_scf(i_do)
              case('min_energy_pos')
                 read(buf,*) dummy1,dummy2,omega_del_temp
                 i_check=1
              case('max_energy_pos')
                 read(buf,*) dummy1,dummy2,omega_ef_temp
                 j_check=1
              case('temperature')
                 read(buf,*) dummy1,dummy2,omega_tem(i_do)
              case('im_energy')
                 read(buf,*) dummy1,dummy2,omega_if_scf(i_do,4)
              case('energy_len_ima')
                 read(buf,*) dummy1,dummy2,omega_gamm(i_do)
              case('mesh_num_cir')
                 read(buf,*) dummy1,dummy2,num_om_par_scf(i_do,1)
              case('mesh_num_ima')
                 read(buf,*) dummy1,dummy2,num_om_par_scf(i_do,2)
              case('m_v_min_energy_pos')
                 read(buf,*) dummy1,dummy2,temp_chara
                 if( temp_chara == 'real' ) then
                    i_omega_switch=0
                 end if
                 if( temp_chara == 'relative' ) then
                    i_omega_switch=1
                 end if
              case('m_v_max_energy_pos')
                 read(buf,*) dummy1,dummy2,temp_chara
                 if( temp_chara == 'real' ) then
                    i_omega_switch2=0
                 end if
                 if( temp_chara == 'relative' ) then
                    i_omega_switch2=1
                 end if
              case('}negf_scf_energy_m2')
                 go to 185
              end select
           end do
        end select
     end do
185  continue
     close(19)
     if( num_om_par_scf(i_do,1) == 0 ) then
        num_om_par_scf(i_do,1)=30
        open(unit=17,file=file_tempout,position='append')
        write(17,*) '??? broken ???: //negf_scf_energy_m2/mesh_num_cir// => def'
        close(17)
     end if
     if( num_om_par_scf(i_do,2) == 0 ) then
        num_om_par_scf(i_do,2)=21
        open(unit=17,file=file_tempout,position='append')
        write(17,*) '??? broken ???: //negf_scf_energy_m2/mesh_num_ima// => def'
        close(17)
     end if
     if( omega_if_scf(i_do,4) == 0.d0 ) then
        omega_if_scf(i_do,4)=0.63d0
        open(unit=17,file=file_tempout,position='append')
        write(17,*) '??? broken ???: //negf_scf_energy_m2/im_energy// => def'
        close(17)
     end if
     if( omega_tem(i_do) == 0.d0 ) then
        omega_tem(i_do)=0.008617342
        open(unit=17,file=file_tempout,position='append')
        write(17,*) '??? broken ???: //negf_scf_energy_m2/temperature// => def'
        close(17)
     end if
     if( i_check == 0 ) then
        omega_del_temp=5.d0
        i_omega_switch=1
        open(unit=17,file=file_tempout,position='append')
        write(17,*)                                                            &
             '??? broken ???: //negf_scf_energy_m2/min_energy_pos// => def'
        close(17)
     end if
     if( j_check == 0 ) then
        omega_ef_temp=2.1d0
        i_omega_switch2=1
        open(unit=17,file=file_tempout,position='append')
        write(17,*)                                                            &
             '??? broken ???: //negf_scf_energy_m2/max_energy_pos// => def'
        close(17)
     end if
     if( omega_gamm(i_do) == 0.d0 ) then
        omega_gamm(i_do)=omega_ef_temp+.05d0
        open(unit=17,file=file_tempout,position='append')
        write(17,*)                                                            &
             '??? broken ???: //negf_scf_energy_m2/energy_len_ima// => def'
        close(17)
     end if
     if( omega_gamm(i_do) < omega_ef_temp ) then
        omega_gamm(i_do)=omega_ef_temp+.05d0
        open(unit=17,file=file_tempout,position='append')
        write(17,*)'!!! short !!!: //negf_scf_energy_m2/energy_len_ima// => def'
        close(17)
     end if
     if( om_con_method_scf(i_do) /= 'linear' ) then
        om_con_method_scf(i_do)='linear'
        open(unit=17,file=file_tempout,position='append')
        write(17,*)                                                            &
             '       changed: //negf_scf_energy_m2/mesh_method_cir// -> linear'
        close(17)
     end if
     if( i_omega_switch < 0 ) then
        i_omega_switch=1
        open(unit=17,file=file_tempout,position='append')
        write(17,*)                                                            &
             '??? broken ???: //negf_scf_energy_m2/m_v_min_energy_pos// => def'
        close(17)
     end if
     if( i_omega_switch2 < 0 ) then
        i_omega_switch2=1
        open(unit=17,file=file_tempout,position='append')
        write(17,*)                                                            &
             '??? broken ???: //negf_scf_energy_m2/m_v_max_energy_pos// => def'
        close(17)
     end if
     if( om_con_method_scf(i_do) == 'log' ) then
        omega_if_scf(i_do,3)=1.d-15
     end if
  end if

  !                       ------------------------------------                       !

  open(unit=16,file=file_tempout,position='append')

  write(16,*) 
  write(16,911) file_selfenergy_onoff
911 format('   /switch/  file of self energy: ',a10)
  write(16,917) restart_onoff
917 format('       /switch/  calc start file: ',a15)
  write(16,960) force_calc_onoff
960 format('     /switch/  force calculation: ',a15)

  write(16,*) 
  write(16,913) eps_scf
913 format('                 scf convergence: ',e10.5)
  write(16,914) max_num_scf
914 format('         max number of iteration: ' ,i10)

  if( iter_conv == 0 ) then
     temp_chara='ham'
  end if
  if( iter_conv == 1 ) then
     temp_chara='rho'
  end if
  if( iter_conv == -1 ) then
     temp_chara='vtot'
  end if
  if( iter_conv == 2 ) then
     temp_chara='u_ma'
  end if
  if( iter_conv == 3 ) then
     temp_chara='s_nu'
  end if
  if( iter_conv == 4 ) then
     temp_chara='anderson_ham'
  end if
  if( iter_conv == 11 ) then
     temp_chara='simple_dm'
  end if
  if( iter_conv == 12 ) then
     temp_chara='pulay_dm'
  end if
  if( iter_conv == 13 ) then
     temp_chara='anderson_dm'
  end if
  if( iter_conv == 21 ) then
     temp_chara='simple_rho'
  end if
  if( iter_conv == 22 ) then
     temp_chara='pulay_rho'
  end if
  if( iter_conv == 23 ) then
     temp_chara='anderson_rho'
  end if
  write(16,*) 
  write(16,915) temp_chara
915 format('                   mixing method: ',a15)
  if( iter_conv < 10 ) then
     write(16,916) mixing,mixing_rho,mixing_vto
916  format('   mixing weight (ham, den, vto): ',f9.4,' ',f9.4,' ',f9.4)
     if( iter_conv == 2 .or. iter_conv == 3 ) then
        write(16,940) mixing_max
940     format('       mixing weight (ham_w_max): ',f9.4)
     end if
  end if
  if( iter_conv > 11 .and. iter_conv < 20 ) then
     write(16,950) mixing_dm
950  format('  mixing weight (DM, not simple): ',f9.4)
  end if
  if( iter_conv > 10 .and. iter_conv < 13 ) then
     write(16,951) mixing_dm_s
951  format('      mixing weight (DM, simple): ',f9.4)
  end if
  if( iter_conv == 12 ) then
     write(16,952) negf_mix_start,negf_mix_history
952  format('          pulay (start, history): ',i5,i5)
  end if

  if( method_sum_om_scf == 1 ) then
     temp_chara='square'
  else
     temp_chara='u_temp'
  end if
  write(16,*) 
  write(16,936) temp_chara,om_block_num_scf
936 format(' method of integrate (block num): ',a10,'(',i5,')')

  write(16,918) ft_switch
918 format('                      fft method: ',a10)

  if( hartree_switch == 0 ) then
     temp_chara='ft'
  else
     temp_chara='gf'
  end if
  write(16,919) temp_chara
919 format('        hartree term calc method: ',a10)
  if( temp_chara == 'gf' ) then
     write(16,920) gzero_gamma
920  format('       hartree term normal_1, K=: ',e10.5)
  end if

  if( scf_bias /= 'off' ) then
     write(16,*)
     write(16,*)                                                              &
          '============================ bias ============================'
     write(16,*)

     write(16,921) scf_bias
921  format('                  /switch/  bias: ',a10)
     write(16,922) v_scf_l,v_scf_r
922  format('                     value (l,r): ',f10.5,' ',f10.5,' [V]')

     write(16,*)
     write(16,923) num_om_bias
923  format('  mesh num of charge calc energy: ',i5)
     write(16,924) om_im_bias
924  format('   im part of charge calc energy: ',f15.10,' [eV]')
     if( dabs(om_del_bias) > 1.d-10 ) then
        write(16,925) om_del_bias
925     format('  +re part of charge calc energy: ',f15.10,' [eV]')
     end if
  end if

  if( i_rotspin_l == 1 .or. i_rotspin_r == 1 ) then
     write(16,*)
     write(16,*)                                                              &
          '======================= spin  rotation ======================='
     write(16,*)

     if( i_rotspin_l == 1 ) then
        temp_chara='on'
     else
        temp_chara='off'
     end if
     if( i_rotspin_r == 1 ) then
        temp_chara1='on'
     else
        temp_chara1='off'
     end if
     write(16,927) temp_chara,temp_chara1
927  format('                 /switch/  (l,r): ',a5,a5)
     write(16,928) dfloat(shift_cell_l1)/dfloat(shift_cell_l2)                &
          ,1.d0-dfloat(shift_cell_l1)/dfloat(shift_cell_l2)
928  format('     position of boundary (l,r) : ',f10.5,f10.5)
  end if

  i_check=0
  if( dis_chara /= 'def' ) then
     i_check=1
  end if
  if( lay_chara /= 'def' ) then
     i_check=1
  end if

  if( i_check == 1 ) then
     write(16,*)
     write(16,*)                                                              &
          '===================== manually condition ====================='
     write(16,*)
  end if

  if( dis_chara /= 'def' ) then
     write(16,930) res_bound_l,res_bound_r
930  format('              fix boundary (l,r): ',f10.5,'   ',f10.5,' [au]')
     i_check=1
  end if
  if( lay_chara /= 'def' ) then
     write(16,931) atom_parlay_l,atom_parlay_r
931  format('              fix atom num (l,r): ',i5,i5)
     i_check=1
  end if

  write(16,*)
  write(16,*) '========================= file  name ========================='
  write(16,*)

  write(16,900) file_parameter_hc_scf
900 format(' /input/ file name -      junc_h: ',a29)
  write(16,901) file_parameter_hl_scf
901 format(' /input/ file name -      left_h: ',a29)
  write(16,902) file_parameter_hr_scf
902 format(' /input/ file name -     right_h: ',a29)

  write(16,*)
  if( ham_model_ini == 'scf_accel' ) then
     write(16,906) file_parameter_ham_pot
906  format(' /input/ file name -      junc_c: ',a29)
  end if

  write(16,907) file_parameter_cv1_pot
907 format(' /input/ file name -     junc_vd: ',a29)

  write(16,*)
  write(16,908) file_parameter_lv1_scf
908 format(' /input/ file name -     left_vd: ',a29)
  write(16,909) file_parameter_rv1_scf
909 format(' /input/ file name -    right_vd: ',a29)

  write(16,*)
  write(16,910) file_selfenergy_scf
910 format('             file of self energy: ',a29)

  write(16,*)
  write(16,954) file_parameter_out_vh0
954 format('     /output/ file name - junc_h: ',a29)
  write(16,904) file_parameter_out_pot
904 format('    /output/ file name - junc_vd: ',a29)
  write(16,*)
  write(16,*)

  close(16)


  if( restart_onoff == 'f_CDM' .or. restart_onoff == 'f_DM'                    &
       .or. restart_onoff == 'f_cdm' .or. restart_onoff == 'f_dm' ) then
     restart_onoff='off'
  else
     if(  restart_onoff /= 'f_density' ) then
        open(unit=17,file=file_tempout,position='append')
        write(17,*) '       change //negf_scf_general/calc_start// => f_density'
        close(17)
     end if
     restart_onoff='on'
  end if

  if(  file_selfenergy_onoff == 'exist' ) then
     file_selfenergy_onoff='on'
  else
     file_selfenergy_onoff='off'
  end if

  return
end subroutine set_scf_general
