! @@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@ !
! @@                                                                @@ !
! @@       PROGRAM  ASCOT 2014.440 (ver.4.40)                       @@ !
! @@     "Abinitio Simulation Code for Quantum Transport"           @@ !
! @@                                                                @@ !
! @@                                                                @@ !
! @@  AUTHOR(S): Hisashi KONDO (Univ. Tokyo)                        @@ !
! @@                                                09/May/2014     @@ !
! @@                                                                @@ !
! @@  Contact address: Phase System Consortium                      @@ !
! @@                                                                @@ !
! @@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@ !

subroutine set_hami_c_cc_input(ispin)

  use condition_ini
  use hamiltonian_sgf
  use hamiltonian_c
  use hamiltonian_temp
  use constant
  use mod_mpi

  implicit none
  include 'mpif.h'
  integer, intent(in) :: ispin
  integer :: i2_do,i3_do

  do i3_do=1,m_mat_max_c
     do i2_do=1,m_mat_max_c
        hcc_mat(i2_do,i3_do)=hcc_t(ispin,i2_do,i3_do)
     end do
  end do
  do i3_do=1,m_mat_max_c
     do i2_do=1,m_mat_max_c
        scc_mat(i2_do,i3_do)=scc_t(i2_do,i3_do)
     end do
  end do

  return
end subroutine set_hami_c_cc_input

subroutine set_hami_c_ll_input(ispin)

  use condition_ini
  use hamiltonian_sgf
  use hamiltonian_c
  use hamiltonian_e
  use hamiltonian_temp
  use scf_negf
  use constant
  use mod_mpi

  implicit none
  include 'mpif.h'
  integer, intent(in) :: ispin
  integer :: i_do,j_do,i2_do,i3_do

  do i3_do=1,mat_max_ll
     do i2_do=1,mat_max_ll
        hcl_mat(i3_do,i2_do)=h01_l_t(ispin,i3_do,i2_do)
     end do
  end do

  do i3_do=1,mat_max_ll
     do i2_do=1,mat_max_ll
        scl_mat(i3_do,i2_do)=s01_l_t(i3_do,i2_do)
     end do
  end do

  return
end subroutine set_hami_c_ll_input

subroutine set_hami_c_rr_input(ispin)

  use condition_ini
  use hamiltonian_sgf
  use hamiltonian_c
  use hamiltonian_e
  use hamiltonian_temp
  use scf_negf
  use constant
  use mod_mpi

  implicit none
  include 'mpif.h'
  integer, intent(in) :: ispin
  integer :: i_do,j_do,i2_do,i3_do

  do i3_do=1,mat_max_rr
     do i2_do=1,mat_max_rr
        hcr_mat(m_mat_max_c-m_mat_max_r+i3_do,i2_do)                             &
             =h01_r_t(ispin,i3_do,i2_do)
     end do
  end do

  do i3_do=1,mat_max_rr
     do i2_do=1,mat_max_rr
        scr_mat(m_mat_max_c-m_mat_max_r+i3_do,i2_do)                             &
             =s01_r_t(i3_do,i2_do)
     end do
  end do

  return
end subroutine set_hami_c_rr_input
