! @@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@ !
! @@                                                                @@ !
! @@       PROGRAM  ASCOT 2014.440 (ver.4.40)                       @@ !
! @@     "Abinitio Simulation Code for Quantum Transport"           @@ !
! @@                                                                @@ !
! @@                                                                @@ !
! @@  AUTHOR(S): Hisashi KONDO (Univ. Tokyo)                        @@ !
! @@                                                09/May/2014     @@ !
! @@                                                                @@ !
! @@  Contact address: Phase System Consortium                      @@ !
! @@                                                                @@ !
! @@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@ !

subroutine set_for_gf_se_c

  use condition_ini
  use hamiltonian_sgf
  use hamiltonian_c
  use gf_se_c

  implicit none
  integer :: i_w_num,i1_do,i2_do
  complex(8) :: w,w_int

  if( calc_type == 'trans' ) then
     i_w_num=0
     do i1_do=1,om_block_num
        i_w_num=i_w_num+num_om_par(i1_do)
     end do
     iw_max_gs=i_w_num
     call alo_condition_omega_gs(om_block_num)
     i_w_num=0
     do i1_do=1,om_block_num
        omega_par_gs(i1_do)=i_w_num
        i_w_num=i_w_num+num_om_par(i1_do)
        omega_par_num_gs(i1_do)=i_w_num
        if( om_con_method(i1_do) == 'linear' ) then
           i_w_num=num_om_par(i1_do)
           w_int=(omega_if(i1_do,2)-omega_if(i1_do,1))/dfloat(i_w_num)
           w=omega_if(i1_do,1)-w_int*.5d0
           do i2_do=1,iw_max_gs
              w=w+w_int
              omega_gs(i2_do)=w
           end do
        end if
     end do
  else
     if( calc_type == 'iv' ) then
        if( dabs(cp_l-cp_r) < eps_ini ) then
           open(unit=30,file='iv.dat')
           write(30,*) 'cp_l=',cp_l
           write(30,*) 'cp_r=',cp_r
           write(30,*) 0.d0,0.d0
           close(30)
           stop
        end if
        iw_max_gs=num_iv_mesh
        call alo_condition_omega_gs(1)
        w_int=dcmplx((cp_l-cp_r)/dfloat(num_iv_mesh),0.d0)
        w=dcmplx(cp_r,om_sum)-w_int*.5d0
        do i2_do=1,iw_max_gs
           w=w+w_int
           omega_gs(i2_do)=w
        end do
     else
        if( calc_type /= 'scf_only' ) then
           write(6,*) 'error: gra or iv;; set_for_gf_se_c'
           stop
        end if
     end if
  end if

  !                       ------------------------------------                       !

  num_block_gr=m_num_block_l+m_num_block_m+m_num_block_r

  call alo_gf_se_c(m_mat_max_c,kx_max_ll,ky_max_ll,kx_max_rr,ky_max_rr)
  call alo_gf_se_gra(spin_switch_cc,ka_tr*kb_tr)

  return
end subroutine set_for_gf_se_c

subroutine unset_for_gf_se_c

  use condition_ini
  use gf_se_c
  use scf_negf

  implicit none

  if( calc_type /= 'scf_only' ) then
     call unset_condition_omega_gs
  end if
  call unset_gf_se_c
  call unset_gf_se_gra
  if( ham_model_ini /= 'input' .and. ham_model_ini /= 'scf_accel' ) then
     call unset_c
  end if

  return
end subroutine unset_for_gf_se_c
