! @@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@ !
! @@                                                                @@ !
! @@       PROGRAM  ASCOT 2014.440 (ver.4.40)                       @@ !
! @@     "Abinitio Simulation Code for Quantum Transport"           @@ !
! @@                                                                @@ !
! @@                                                                @@ !
! @@  AUTHOR(S): Hisashi KONDO (Univ. Tokyo)                        @@ !
! @@                                                09/May/2014     @@ !
! @@                                                                @@ !
! @@  Contact address: Phase System Consortium                      @@ !
! @@                                                                @@ !
! @@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@ !

module surface_green_function

  implicit none
  complex(8), pointer :: gr00(:,:),gr01(:,:),gr02(:,:),temp(:,:)
  complex(8), pointer :: tr1(:,:),tr2(:,:),tm(:,:),tm_temp(:,:)
  complex(8), pointer :: es0(:,:),e00(:,:),alp(:,:),bet(:,:)

contains
  subroutine alo_surface_gf_transefer(mat_max)

    implicit none
    integer, intent(in) :: mat_max
    integer :: ier

    allocate(gr00(mat_max,mat_max),gr01(mat_max,mat_max),gr02(mat_max,mat_max)   &
         ,tr1(mat_max,mat_max),tr2(mat_max,mat_max),tm(mat_max,mat_max)       &
         ,tm_temp(mat_max,mat_max),temp(mat_max,mat_max),stat=ier)
    if( ier /= 0 ) then
       write(6,*) 'error allocate: alo_surface_gf_transefer'
       stop
    end if

    return
  end subroutine alo_surface_gf_transefer

  subroutine unset_surface_gf_transefer

    implicit none
    integer :: ier

    deallocate(gr00,gr01,gr02,tr1,tr2,tm,tm_temp,temp,stat=ier)
    if( ier /= 0 ) then
       write(6,*) 'error deallocate: unset_surface_gf_transefer'
       stop
    end if

    return
  end subroutine unset_surface_gf_transefer

  subroutine alo_surface_gf_direct(mat_max)

    implicit none
    integer, intent(in) :: mat_max
    integer :: ier

    allocate(gr00(mat_max,mat_max),gr01(mat_max,mat_max),gr02(mat_max,mat_max)   &
         ,es0(mat_max,mat_max),e00(mat_max,mat_max),alp(mat_max,mat_max)      &
         ,bet(mat_max,mat_max),temp(mat_max,mat_max),stat=ier)
    if( ier /= 0 ) then
       write(6,*) 'error allocate: alo_surface_gf_direct'
       stop
    end if

    return
  end subroutine alo_surface_gf_direct

  subroutine unset_surface_gf_direct

    implicit none
    integer :: ier

    deallocate(gr00,gr01,gr02,es0,e00,alp,bet,temp,stat=ier)
    if( ier /= 0 ) then
       write(6,*) 'error deallocate: unset_surface_gf_direct'
       stop
    end if

    return
  end subroutine unset_surface_gf_direct
end module surface_green_function
