! @@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@ !
! @@                                                                @@ !
! @@       PROGRAM  ASCOT 2014.440 (ver.4.40)                       @@ !
! @@     "Abinitio Simulation Code for Quantum Transport"           @@ !
! @@                                                                @@ !
! @@                                                                @@ !
! @@  AUTHOR(S): Hisashi KONDO (Univ. Tokyo)                        @@ !
! @@                                                09/May/2014     @@ !
! @@                                                                @@ !
! @@  Contact address: Phase System Consortium                      @@ !
! @@                                                                @@ !
! @@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@ !

module locate_atom

  implicit none
  integer :: num_atom_lt,num_atom_ctotal,num_atom_rt
  integer, pointer :: atom_kindn_ccal(:),pair_num_ccal(:,:),i_lmr(:),i_locate(:)
  real(8), pointer :: r_l(:,:),r_c(:,:),r_r(:,:)

contains
  subroutine alo_locate_atom

    implicit none
    integer :: ier

    allocate(r_l(num_atom_lt,3),r_c(num_atom_ctotal,3),r_r(num_atom_rt,3)        &
         ,atom_kindn_ccal(num_atom_ctotal),i_lmr(num_atom_ctotal)             &
         ,i_locate(num_atom_ctotal),stat=ier)
    if( ier /= 0 ) then
       write(6,*) 'error allocate: alo_locate_atom'
       stop
    end if

    return
  end subroutine alo_locate_atom

  subroutine unset_locate_atom

    implicit none
    integer :: ier

    deallocate(r_l,r_c,r_r,atom_kindn_ccal,i_lmr,i_locate,stat=ier)
    if( ier /= 0 ) then
       write(6,*) 'error allocate: unset_locate_atom'
       stop
    end if

    return
  end subroutine unset_locate_atom

  subroutine alo_locate_atom_pair

    implicit none
    integer :: ier

    allocate(pair_num_ccal(num_atom_ctotal,num_atom_ctotal),stat=ier)
    if( ier /= 0 ) then
       write(6,*) 'error allocate: alo_locate_atom_pair'
       stop
    end if

    return
  end subroutine alo_locate_atom_pair

  subroutine unset_locate_atom_pair

    implicit none
    integer :: ier

    deallocate(pair_num_ccal,stat=ier)
    if( ier /= 0 ) then
       write(6,*) 'error allocate: unset_locate_atom_pair'
       stop
    end if

    return
  end subroutine unset_locate_atom_pair
end module locate_atom
