! @@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@ !
! @@                                                                @@ !
! @@       PROGRAM  ASCOT 2014.440 (ver.4.40)                       @@ !
! @@     "Abinitio Simulation Code for Quantum Transport"           @@ !
! @@                                                                @@ !
! @@                                                                @@ !
! @@  AUTHOR(S): Hisashi KONDO (Univ. Tokyo)                        @@ !
! @@                                                09/May/2014     @@ !
! @@                                                                @@ !
! @@  Contact address: Phase System Consortium                      @@ !
! @@                                                                @@ !
! @@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@ !

module hamiltonian_zper

  implicit none
  integer :: mat_max_zper
  integer, pointer :: itemp(:,:,:),jtemp(:)
  complex(8), pointer :: h00_mat(:,:),s00_mat(:,:)

contains
  subroutine alo_hamiltonian_zper_input
    implicit none
    integer :: ier,i1_do,i2_do

    allocate(h00_mat(mat_max_zper,mat_max_zper)                                  &
         ,s00_mat(mat_max_zper,mat_max_zper),stat=ier)
    if( ier /= 0 ) then
       write(6,*) 'error allocate: alo_hamiltonian_zper_input'
       stop
    end if

    do i1_do=1,mat_max_zper
       do i2_do=1,mat_max_zper
          h00_mat(i2_do,i1_do)=dcmplx(0.d0,0.d0)
       end do
    end do
    do i1_do=1,mat_max_zper
       do i2_do=1,mat_max_zper
          s00_mat(i2_do,i1_do)=dcmplx(0.d0,0.d0)
       end do
    end do

    return
  end subroutine alo_hamiltonian_zper_input

  subroutine unset_hamiltonian_zper_input

    implicit none
    integer :: ier

    deallocate(h00_mat,s00_mat,stat=ier)
    if( ier /= 0 ) then
       write(6,*) 'error deallocate: unset_hamiltonian_zper_input'
       stop
    end if

    return
  end subroutine unset_hamiltonian_zper_input

  subroutine alo_hamiltonian_zper_free(num_atom,num_unit)

    implicit none
    integer, intent(in) :: num_atom,num_unit(3)
    integer :: ier,i1_do,i2_do

    allocate(h00_mat(mat_max_zper,mat_max_zper)                                  &
         ,s00_mat(mat_max_zper,mat_max_zper)                                  &
         ,itemp(num_unit(1),num_unit(2),num_atom),stat=ier)
    if( ier /= 0 ) then
       write(6,*) 'error allocate: alo_hamiltonian_zper_free'
       stop
    end if

    do i1_do=1,mat_max_zper
       do i2_do=1,mat_max_zper
          h00_mat(i2_do,i1_do)=dcmplx(0.d0,0.d0)
       end do
    end do
    do i1_do=1,mat_max_zper
       do i2_do=1,mat_max_zper
          s00_mat(i2_do,i1_do)=dcmplx(0.d0,0.d0)
       end do
    end do

    return
  end subroutine alo_hamiltonian_zper_free

  subroutine unset_hamiltonian_zper_free

    implicit none
    integer :: ier

    deallocate(h00_mat,s00_mat,itemp,stat=ier)
    if( ier /= 0 ) then
       write(6,*) 'error deallocate: unset_hamiltonian_zper_free'
       stop
    end if

    return
  end subroutine unset_hamiltonian_zper_free

  subroutine alo_hamiltonian_zper_periodic(num_atom)

    implicit none
    integer, intent(in) :: num_atom
    integer :: ier,i1_do,i2_do

    allocate(h00_mat(mat_max_zper,mat_max_zper)                                  &
         ,s00_mat(mat_max_zper,mat_max_zper)                                  &
         ,jtemp(num_atom),stat=ier)
    if( ier /= 0 ) then
       write(6,*) 'error allocate: alo_hamiltonian_zper_periodic'
       stop
    end if

    do i1_do=1,mat_max_zper
       do i2_do=1,mat_max_zper
          h00_mat(i2_do,i1_do)=dcmplx(0.d0,0.d0)
       end do
    end do
    do i1_do=1,mat_max_zper
       do i2_do=1,mat_max_zper
          s00_mat(i2_do,i1_do)=dcmplx(0.d0,0.d0)
       end do
    end do

    return
  end subroutine alo_hamiltonian_zper_periodic

  subroutine unset_hamiltonian_zper_periodic

    implicit none
    integer :: ier

    deallocate(h00_mat,s00_mat,jtemp,stat=ier)
    if( ier /= 0 ) then
       write(6,*) 'error deallocate: unset_hamiltonian_zper_periodic'
       stop
    end if

    return
  end subroutine unset_hamiltonian_zper_periodic
end module hamiltonian_zper
