! @@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@ !
! @@                                                                @@ !
! @@       PROGRAM  ASCOT 2014.440 (ver.4.40)                       @@ !
! @@     "Abinitio Simulation Code for Quantum Transport"           @@ !
! @@                                                                @@ !
! @@                                                                @@ !
! @@  AUTHOR(S): Hisashi KONDO (Univ. Tokyo)                        @@ !
! @@                                                09/May/2014     @@ !
! @@                                                                @@ !
! @@  Contact address: Phase System Consortium                      @@ !
! @@                                                                @@ !
! @@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@ !

subroutine iteration_ini

  use scf_negf
  use fft
  use dft
  use condition_ini
  use hamiltonian_sgf
  use hamiltonian_c
  use hamiltonian_temp
  use gf_se_c
  use constant
  use mod_mpi

  implicit none
  integer :: i1,i2,i3,ispin,ier,gn
  real(8) :: st1,st2,stdel
  real(8), allocatable :: temp_rho(:,:,:,:)
  complex(8), allocatable :: temp_rhols(:,:,:,:)

  open(unit=16,file=file_tempout,position='append')
  write(16,*) '++++++++++++ DM -> charge ...'
  close(16)

  open(unit=16,file=file_tempout,position='append')
  call myclock(st1)

  if( ispin_pol_scf < 4 ) then
     allocate(temp_rho(n_a,n_b,n_c,ispin_pol_scf),stat=ier)
  else
     allocate(temp_rhols(n_a,n_b,n_c,ispin_pol_scf),stat=ier)
  end if
  if( ier /= 0 ) then
     write(6,*) 'error allocate: dens_atom2cell_lr'
     stop
  end if

  do ispin=1,ispin_pol_scf
     do i1=1,n_a
        do i2=1,n_b
           do i3=1,n_c
              if( ispin_pol_scf < 4 ) then
                 temp_rho(i1,i2,i3,ispin)=0.d0
              else
                 temp_rhols(i1,i2,i3,ispin)=dcmplx(0.d0,0.d0)
              end if
           end do
        end do
     end do
  end do

  call Density__calc
  if( ispin_pol_scf < 4 ) then
     call Hamiltonian__calcD__acbas(temp_rho)
  else
     call Hamiltonian__calcD_ls__acbas(temp_rhols)
  end if

  do ispin=1,ispin_pol_scf
     do i1=0,n_a-1
        do i2=0,n_b-1
           do i3=0,n_c-1
              if( i3+1 > l_cell_l_bound .and. i3+1 < r_cell_l_bound ) then
                 gn=i1*n_b*n_c+i2*n_c+i3+1
                 if( ispin_pol_scf < 4 ) then
                    rho(gn,ispin)=temp_rho(i1+1,i2+1,i3+1,ispin)
                 else
                    rhols(gn,ispin)=temp_rhols(i1+1,i2+1,i3+1,ispin)
                 end if
              end if
           end do
        end do
     end do
  end do

  if( ispin_pol_scf < 4 ) then
     deallocate(temp_rho,stat=ier)
  else
     deallocate(temp_rhols,stat=ier)
  end if
  if( ier /= 0 ) then
     write(6,*) 'error allocate: dens_atom2cell_lr'
     stop
  end if

  call myclock(st2)
  stdel=st2-st1
  close(16)

  return
end subroutine iteration_ini
